/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberJDOMMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.msg.DataXField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class DataXMessage
extends JabberJDOMMessage {
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_CANCEL = "cancel";
    public static final String TYPE_RESULT = "result";
    public static final String TYPE_FORM = "form";
    public static final String EMPTY_STRING = "";
    private String formType;
    private String instructions;
    private String title;
    private ArrayList fields = new ArrayList();
    private ArrayList reportedFields = new ArrayList();
    private ArrayList itemFields = new ArrayList();

    public DataXMessage() {
        this(TYPE_SUBMIT);
    }

    public DataXMessage(String formType) {
        super(new Element("x", JabberCode.XMLNS_X_DATA));
        this.setFormType(formType);
    }

    public String getFormType() {
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public String getInstructions() {
        if (this.instructions == null) {
            return EMPTY_STRING;
        }
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getTitle() {
        if (this.title == null) {
            return EMPTY_STRING;
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List getReportedFields() {
        return Collections.unmodifiableList(this.reportedFields);
    }

    public List getItemFields() {
        return Collections.unmodifiableList(this.itemFields);
    }

    public void addField(DataXField field) {
        if (field == null) {
            throw new IllegalArgumentException("Field to be added cannot be null");
        }
        this.fields.add(field);
    }

    public void addReportedField(DataXField field) {
        if (field == null) {
            throw new IllegalArgumentException("Field to be added cannot be null");
        }
        this.reportedFields.add(field);
    }

    public void addItemField(DataXField field) {
        if (field == null) {
            throw new IllegalArgumentException("Field to be added cannot be null");
        }
        this.itemFields.add(field);
    }

    public int getMessageType() {
        return 107;
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        DataXField field;
        int i;
        int size;
        super.parse(parser, msgTree);
        Namespace ns = JabberCode.XMLNS_X_DATA;
        this.formType = msgTree.getAttributeValue("type");
        this.instructions = msgTree.getChildTextNormalize("instructions", ns);
        this.title = msgTree.getChildTextNormalize("title", ns);
        List list = msgTree.getChildren("field", ns);
        if (!list.isEmpty()) {
            size = list.size();
            for (i = 0; i < size; ++i) {
                field = new DataXField();
                field.parse((Element)list.get(i));
                this.fields.add(field);
            }
        }
        if (msgTree.getChild("reported", ns) != null && !(list = msgTree.getChild("reported", ns).getChildren("field", ns)).isEmpty()) {
            size = list.size();
            for (i = 0; i < size; ++i) {
                field = new DataXField();
                field.parse((Element)list.get(i));
                this.reportedFields.add(field);
            }
        }
        if (msgTree.getChild("item", ns) != null && !(list = msgTree.getChild("item", ns).getChildren("field", ns)).isEmpty()) {
            size = list.size();
            for (i = 0; i < size; ++i) {
                field = new DataXField();
                field.parse((Element)list.get(i));
                this.itemFields.add(field);
            }
        }
        return this;
    }

    public String encode() throws ParseException {
        int i;
        int size;
        Element x = this.getDOM();
        Namespace ns = JabberCode.XMLNS_X_DATA;
        if (!x.getChildren().isEmpty()) {
            x.getChildren().clear();
        }
        if (this.formType != null) {
            x.setAttribute("type", this.formType);
        }
        if (this.instructions != null) {
            x.addContent(new Element("instructions", ns).setText(this.instructions));
        }
        if (this.title != null) {
            x.addContent(new Element("title", ns).setText(this.title));
        }
        if (!this.fields.isEmpty()) {
            size = this.fields.size();
            for (int i2 = 0; i2 < size; ++i2) {
                x.addContent(((DataXField)this.fields.get(i2)).encode());
            }
        }
        if (!this.reportedFields.isEmpty()) {
            size = this.reportedFields.size();
            Element elem = new Element("reported", ns);
            for (i = 0; i < size; ++i) {
                elem.addContent(((DataXField)this.reportedFields.get(i)).encode());
            }
            x.addContent(elem);
        }
        if (!this.itemFields.isEmpty()) {
            size = this.itemFields.size();
            Element elem = new Element("item", ns);
            for (i = 0; i < size; ++i) {
                elem.addContent(((DataXField)this.itemFields.get(i)).encode());
            }
            x.addContent(elem);
        }
        return super.encode();
    }
}

