/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import org.jdom.Element;

public class DataXOption {
    private String label;
    private String value;

    public DataXOption() {
    }

    public DataXOption(String value) {
        this(value, null);
    }

    public DataXOption(String value, String label) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getValue();
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Element encode() throws ParseException {
        if (this.value == null) {
            throw new ParseException("value for the option is required and cannot be null");
        }
        Element opElem = new Element("option", JabberCode.XMLNS_X_DATA);
        if (this.label != null) {
            opElem.setAttribute("label", this.label);
        }
        opElem.addContent(new Element("value", JabberCode.XMLNS_X_DATA).setText(this.value));
        return opElem;
    }

    public void parse(Element opElem) throws ParseException {
        if (!"option".equals(opElem.getName()) && JabberCode.XMLNS_X_DATA != opElem.getNamespace()) {
            throw new ParseException("option must begin with an <option> element and in the proper namespace");
        }
        this.value = opElem.getChildTextNormalize("value", JabberCode.XMLNS_X_DATA);
        this.label = opElem.getAttributeValue("label");
    }
}

