/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberJDOMMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jdom.Element;

public class DelayXMessage
extends JabberJDOMMessage {
    private String text;
    private String from;
    private String time;
    private SimpleDateFormat format;

    public DelayXMessage() {
        super(new Element("x", JabberCode.XMLNS_X_DELAY));
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        this.from = msgTree.getAttributeValue("from");
        this.time = msgTree.getAttributeValue("stamp");
        this.text = msgTree.getText();
        return this;
    }

    public Date getTimeInLocal() {
        if (this.time == null) {
            return null;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        Date date = this.format.parse(this.time, new ParsePosition(0));
        return date;
    }

    public String getTime() {
        return this.time;
    }

    public String getFrom() {
        return this.from;
    }

    public String getText() {
        return this.text;
    }

    public int getMessageType() {
        return 100;
    }
}

