/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberJDOMMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import java.util.List;
import org.jdom.Element;

public class EventXMessage
extends JabberJDOMMessage {
    public static final String EVENT_OFFLINE = "offline";
    public static final String EVENT_DELIVERED = "delivered";
    public static final String EVENT_COMPOSING = "composing";
    public static final String EVENT_DISPLAYED = "displayed";
    private boolean offline;
    private boolean delivered;
    private boolean composing;
    private boolean displayed;
    private String msgID;

    public EventXMessage() {
        super(new Element("x", JabberCode.XMLNS_X_EVENT));
    }

    public void reset() {
        this.displayed = false;
        this.composing = false;
        this.delivered = false;
        this.offline = false;
        this.msgID = null;
    }

    public String getEventMessageID() {
        return this.msgID;
    }

    public void setEventMessageID(String msgID) {
        this.msgID = msgID;
        this.offline = false;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public boolean isComposing() {
        return this.composing;
    }

    public boolean isDelivered() {
        return this.delivered;
    }

    public boolean isAllClear() {
        return !this.offline && !this.delivered && !this.composing && !this.displayed;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
        if (offline) {
            this.msgID = null;
        }
    }

    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    public void setComposing(boolean composing) {
        this.composing = composing;
    }

    public void setDelivered(boolean delivered) {
        this.delivered = delivered;
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        List list = msgTree.getChildren();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            Element event = (Element)list.get(i);
            if (event.getName().equals(EVENT_OFFLINE)) {
                this.offline = true;
                continue;
            }
            if (event.getName().equals(EVENT_DELIVERED)) {
                this.delivered = true;
                continue;
            }
            if (event.getName().equals(EVENT_COMPOSING)) {
                this.composing = true;
                continue;
            }
            if (event.getName().equals(EVENT_DISPLAYED)) {
                this.displayed = true;
                continue;
            }
            if (!event.getName().equals("id")) continue;
            this.msgID = event.getText();
        }
        return this;
    }

    public String encode() throws ParseException {
        Element x = this.getDOM();
        x.getChildren().clear();
        if (this.displayed) {
            x.addContent(new Element(EVENT_DISPLAYED, JabberCode.XMLNS_X_EVENT));
        }
        if (this.delivered) {
            x.addContent(new Element(EVENT_DELIVERED, JabberCode.XMLNS_X_EVENT));
        }
        if (this.composing) {
            x.addContent(new Element(EVENT_COMPOSING, JabberCode.XMLNS_X_EVENT));
        }
        if (this.offline) {
            x.addContent(new Element(EVENT_OFFLINE, JabberCode.XMLNS_X_EVENT));
        }
        if (this.msgID != null) {
            x.addContent(new Element(EVENT_DISPLAYED, JabberCode.XMLNS_X_EVENT).addContent(this.msgID));
        }
        return super.encode();
    }

    public int getMessageType() {
        return 102;
    }
}

