/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberUtil;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class PrivateXmlIQMessage
extends JabberIQMessage {
    public PrivateXmlIQMessage(String type) {
        super(type);
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_PRIVATE));
    }

    public PrivateXmlIQMessage() {
        this("get");
    }

    public Element getPrivateData(String elemName, String ns) {
        Element query = this.getDOM().getChild("query", JabberCode.XMLNS_IQ_PRIVATE);
        if (query != null) {
            return query.getChild(elemName, Namespace.getNamespace((String)ns));
        }
        return null;
    }

    public void setPrivateData(Element pvtdata) {
        if (pvtdata == null) {
            throw new IllegalArgumentException("Private data element cannot be null");
        }
        Element query = this.getDOM().getChild("query", JabberCode.XMLNS_IQ_PRIVATE);
        if (query != null) {
            query.getChildren().clear();
            query.addContent(pvtdata);
        }
    }

    public void setPrivateData(String pvtdata) throws ParseException {
        if (pvtdata == null) {
            throw new IllegalArgumentException("Private data cannot be null");
        }
        try {
            Element elem = JabberUtil.parseXmlStringToDOM(pvtdata);
            elem.detach();
            this.setPrivateData(elem);
        }
        catch (JDOMException ex) {
            throw new ParseException("JDOMException thrown: " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new ParseException("IOException thrown: " + ex.getMessage());
        }
    }

    public void setPrivateDataRequest(String elemName, String ns) {
        Element elem = new Element(elemName, ns);
        this.setPrivateData(elem);
    }

    public int getMessageType() {
        return 23;
    }
}

