/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.msg.SearchItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.jdom.Namespace;

public class SearchIQMessage
extends JabberIQMessage {
    private static Log log = LogFactory.getLog((Class)(class$com$echomine$jabber$msg$SearchIQMessage == null ? (class$com$echomine$jabber$msg$SearchIQMessage = SearchIQMessage.class$("com.echomine.jabber.msg.SearchIQMessage")) : class$com$echomine$jabber$msg$SearchIQMessage));
    static /* synthetic */ Class class$com$echomine$jabber$msg$SearchIQMessage;

    public SearchIQMessage(String type) {
        super(type);
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_SEARCH));
    }

    public SearchIQMessage() {
        this("get");
    }

    public void addField(String name, String value) {
        Element query = this.getDOM().getChild("query", JabberCode.XMLNS_IQ_SEARCH);
        Element field = new Element(name, JabberCode.XMLNS_IQ_SEARCH);
        if (value != null) {
            field.setText(value);
        }
        query.addContent(field);
    }

    public void addFields(HashMap fields) {
        Iterator iter = fields.keySet().iterator();
        if (!iter.hasNext()) {
            return;
        }
        Element query = this.getDOM().getChild("query", JabberCode.XMLNS_IQ_SEARCH);
        do {
            String name = (String)iter.next();
            String value = (String)fields.get(name);
            Element field = new Element(name, JabberCode.XMLNS_IQ_SEARCH);
            if (value != null) {
                field.setText(value);
            }
            query.addContent(field);
        } while (iter.hasNext());
    }

    public HashMap getFields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        Element query = this.getDOM().getChild("query", JabberCode.XMLNS_IQ_SEARCH);
        Iterator iter = query.getChildren().iterator();
        while (iter.hasNext()) {
            Element field = (Element)iter.next();
            String name = field.getName();
            String value = field.getText();
            fields.put(name, value);
        }
        return fields;
    }

    public List getResultItems() {
        if (!"result".equals(this.getType())) {
            throw new IllegalStateException("This method can only be called when the message type is a result type");
        }
        ArrayList<SearchItem> list = new ArrayList<SearchItem>();
        Namespace ns = JabberCode.XMLNS_IQ_SEARCH;
        Element query = this.getDOM().getChild("query", ns);
        Iterator iter = query.getChildren("item", ns).iterator();
        while (iter.hasNext()) {
            Element elem = (Element)iter.next();
            try {
                SearchItem item = new SearchItem(new JID(elem.getAttributeValue("jid")), elem.getChildText("first", ns), elem.getChildText("last", ns), elem.getChildText("nick", ns), elem.getChildText("email", ns));
                list.add(item);
            }
            catch (ParseException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Error parsing JID for the search item.  Ignoring this particular search item.", (Throwable)ex);
            }
        }
        return list;
    }

    public int getMessageType() {
        return 24;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

