/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberCode;
import org.jdom.Element;

public class ServiceItem {
    public static final String ACTION_VIEW = "view";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_REMOVE = "remove";
    JID jid;
    String name;
    String node;
    String action;

    public ServiceItem(JID jid) {
        this(jid, null, null);
    }

    public ServiceItem(JID jid, String name) {
        this(jid, name, null);
    }

    public ServiceItem(JID jid, String name, String node) {
        if (jid == null) {
            throw new IllegalArgumentException("JID cannot be null");
        }
        this.jid = jid;
        this.name = name;
        this.node = node;
    }

    public ServiceItem(Element serviceElem) throws ParseException {
        this.parse(serviceElem);
    }

    public JID getJID() {
        return this.jid;
    }

    public void setJID(JID jid) {
        this.jid = jid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = "".equals(node) ? null : node;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        if (!(action == null || ACTION_VIEW.equals(action) || ACTION_UPDATE.equals(action) || ACTION_REMOVE.equals(action))) {
            throw new IllegalArgumentException("The action can only be of the following values: update, remove (or set to null if none)");
        }
        this.action = action;
    }

    public void parse(Element serviceElem) throws ParseException {
        if (!"item".equals(serviceElem.getName()) && JabberCode.XMLNS_IQ_DISCO_ITEMS != serviceElem.getNamespace()) {
            throw new ParseException("The incoming element is not a recognizable service item XML element");
        }
        this.jid = new JID(serviceElem.getAttributeValue("jid"));
        this.node = serviceElem.getAttributeValue("node");
        this.action = serviceElem.getAttributeValue("action");
        this.name = serviceElem.getAttributeValue("name");
    }

    public Element encode() {
        Element serviceElem = new Element("item", JabberCode.XMLNS_IQ_DISCO_ITEMS);
        serviceElem.setAttribute("jid", this.jid.toString());
        if (this.node != null) {
            serviceElem.setAttribute("node", this.node);
        }
        if (this.action != null) {
            serviceElem.setAttribute("action", this.action);
        }
        if (this.name != null) {
            serviceElem.setAttribute("name", this.name);
        }
        return serviceElem;
    }
}

