/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.msg.ServiceItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.jdom.Namespace;

public class ServiceItemsIQMessage
extends JabberIQMessage {
    private static Log log = LogFactory.getLog((Class)(class$com$echomine$jabber$msg$ServiceItemsIQMessage == null ? (class$com$echomine$jabber$msg$ServiceItemsIQMessage = ServiceItemsIQMessage.class$("com.echomine.jabber.msg.ServiceItemsIQMessage")) : class$com$echomine$jabber$msg$ServiceItemsIQMessage));
    private ArrayList items = new ArrayList();
    private String node;
    static /* synthetic */ Class class$com$echomine$jabber$msg$ServiceItemsIQMessage;

    public ServiceItemsIQMessage(String type) {
        super(type);
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_DISCO_ITEMS));
    }

    public ServiceItemsIQMessage() {
        this("get");
    }

    public int getMessageType() {
        return 27;
    }

    public void addItem(ServiceItem serviceItem) {
        if (serviceItem == null) {
            throw new IllegalArgumentException("service item cannot be null");
        }
        this.items.add(serviceItem);
    }

    public List getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getNode() {
        return this.node;
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        if (!this.items.isEmpty()) {
            this.items.clear();
        }
        Namespace ns = JabberCode.XMLNS_IQ_DISCO_ITEMS;
        Element query = msgTree.getChild("query", ns);
        this.node = query.getAttributeValue("node");
        List list = query.getChildren("item", ns);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            try {
                Element ielem = (Element)list.get(i);
                ServiceItem item = new ServiceItem(ielem);
                this.items.add(item);
                continue;
            }
            catch (ParseException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Error Parsing Service Item. Ignoring this entry and continuing.", (Throwable)ex);
            }
        }
        return this;
    }

    public String encode() throws ParseException {
        Namespace ns = JabberCode.XMLNS_IQ_DISCO_ITEMS;
        Element query = this.getDOM().getChild("query", ns);
        if (this.node == null) {
            query.removeAttribute("node");
        } else {
            query.setAttribute("node", this.node);
        }
        if (!query.getChildren().isEmpty()) {
            query.getChildren().clear();
        }
        if (!this.items.isEmpty()) {
            int size = this.items.size();
            for (int i = 0; i < size; ++i) {
                query.addContent(((ServiceItem)this.items.get(i)).encode());
            }
        }
        return super.encode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

