/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jdom.Element;

public class TimeIQMessage
extends JabberIQMessage {
    private String tz;
    private String disp;
    private String utc;
    private SimpleDateFormat format;

    public TimeIQMessage(String type) {
        super(type);
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_TIME));
    }

    public TimeIQMessage() {
        this("get");
    }

    public Date getTimeInLocal() {
        String tutc = this.getUTC();
        if (tutc == null) {
            return null;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        Date date = this.format.parse(tutc, new ParsePosition(0));
        return date;
    }

    public String getUTC() {
        if (this.utc != null) {
            return this.utc;
        }
        Element query = this.getDOM().getChild("query", JabberCode.XMLNS_IQ_TIME);
        if (query != null) {
            this.utc = query.getChildText("utc", JabberCode.XMLNS_IQ_TIME);
        }
        return this.utc;
    }

    public String getTimeZone() {
        if (this.tz != null) {
            return this.tz;
        }
        Element query = this.getDOM().getChild("query", JabberCode.XMLNS_IQ_TIME);
        if (query != null) {
            this.tz = query.getChildText("tz", JabberCode.XMLNS_IQ_TIME);
        }
        return this.tz;
    }

    public String getDisplay() {
        if (this.disp != null) {
            return this.disp;
        }
        Element query = this.getDOM().getChild("query", JabberCode.XMLNS_IQ_TIME);
        if (query != null) {
            this.disp = query.getChildText("display", JabberCode.XMLNS_IQ_TIME);
        }
        return this.disp;
    }

    public int getMessageType() {
        return 15;
    }
}

