/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.JabberUtil;
import java.util.Calendar;
import org.jdom.Element;

public class VacationIQMessage
extends JabberIQMessage {
    private String vacationMessage = "";
    private Calendar startDate;
    private Calendar endDate;

    public VacationIQMessage(String type) {
        super(type);
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_VACATION));
    }

    public VacationIQMessage() {
        this("get");
    }

    public static VacationIQMessage createRequestVacationMessage() {
        VacationIQMessage msg = new VacationIQMessage();
        return msg;
    }

    public static VacationIQMessage createSetVacationMessage(Calendar startDate, Calendar endDate, String vacationMessage) {
        VacationIQMessage msg = new VacationIQMessage("set");
        msg.setStartDate(startDate);
        msg.setEndDate(endDate);
        msg.setVacationMessage(vacationMessage);
        return msg;
    }

    public static VacationIQMessage createRemoveVacationMessage() {
        VacationIQMessage msg = new VacationIQMessage("set");
        return msg;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public String getVacationMessage() {
        return this.vacationMessage;
    }

    public void setVacationMessage(String vacationMessage) {
        this.vacationMessage = vacationMessage == null ? "" : vacationMessage;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        Element query = msgTree.getChild("query", JabberCode.XMLNS_IQ_VACATION);
        if (query != null) {
            String temp = query.getChildText("start", JabberCode.XMLNS_IQ_VACATION);
            if (temp != null) {
                this.setStartDate(JabberUtil.parseDateTime(temp));
            }
            if ((temp = query.getChildText("end", JabberCode.XMLNS_IQ_VACATION)) != null) {
                this.setEndDate(JabberUtil.parseDateTime(temp));
            }
            temp = query.getChildText("message", JabberCode.XMLNS_IQ_VACATION);
            this.setVacationMessage(temp);
        }
        return this;
    }

    public String encode() throws ParseException {
        Element x = this.getDOM();
        x.getChildren().clear();
        Element query = new Element("query", JabberCode.XMLNS_IQ_VACATION);
        if (this.startDate != null) {
            query.addContent(new Element("start", JabberCode.XMLNS_IQ_VACATION).addContent(JabberUtil.formatDateTime(this.startDate)));
        }
        if (this.endDate != null) {
            query.addContent(new Element("end", JabberCode.XMLNS_IQ_VACATION).addContent(JabberUtil.formatDateTime(this.endDate)));
        }
        if (this.vacationMessage != null) {
            query.addContent(new Element("message", JabberCode.XMLNS_IQ_VACATION).addContent(this.vacationMessage));
        }
        x.addContent(query);
        return super.encode();
    }

    public int getMessageType() {
        return 25;
    }
}

