/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.ErrorMessage;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.xmlrpc.Call;
import com.echomine.xmlrpc.Response;
import com.echomine.xmlrpc.SerializerFactory;
import org.jdom.Element;

public class XMLRPCMessage
extends JabberIQMessage {
    public static final int XMLRPC_CALL = 1;
    public static final int XMLRPC_RESPONSE = 2;
    private int rpcType;
    private Response response;
    private Call call;
    private SerializerFactory factory;

    public XMLRPCMessage() {
        super("set");
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_XMLRPC));
        this.factory = new SerializerFactory();
    }

    public XMLRPCMessage(Response response) {
        this();
        this.setResponse(response);
    }

    public XMLRPCMessage(Call call) {
        this();
        this.setCall(call);
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        Element query = msgTree.getChild("query", JabberCode.XMLNS_IQ_XMLRPC);
        if (query != null) {
            String method = ((Element)query.getChildren().get(0)).getName();
            if (method.equals("methodCall")) {
                this.rpcType = 1;
            } else if (method.equals("methodResponse")) {
                this.rpcType = 2;
            } else {
                throw new ParseException("XMLRPC Message type is not recognized");
            }
        }
        return this;
    }

    public String encode() throws ParseException {
        switch (this.rpcType) {
            case 1: {
                if (this.call != null) break;
                throw new ParseException("XMLRPC Message: No call set for XMLRPC Call Type!");
            }
            case 2: {
                if (this.response != null) break;
                throw new ParseException("XMLRPC Message: No response set for XMLRPC Response Type!");
            }
            default: {
                throw new ParseException("XMLRPC Message: No XMLRPC Type Set!");
            }
        }
        return super.encode();
    }

    public boolean isError() {
        if (super.isError()) {
            return true;
        }
        if (this.isResponse()) {
            Response resp = this.getResponse();
            return resp != null && resp.isFault();
        }
        XMLRPCMessage reply = (XMLRPCMessage)this.getReplyMessage();
        if (reply == null) {
            return false;
        }
        return reply.isError();
    }

    public boolean isResponse() {
        return this.rpcType == 2;
    }

    public boolean isCall() {
        return this.rpcType == 1;
    }

    public Response getResponse() {
        if (this.response != null) {
            return this.response;
        }
        Element elem = this.getDOM().getChild("query", JabberCode.XMLNS_IQ_XMLRPC).getChild("methodResponse", JabberCode.XMLNS_IQ_XMLRPC);
        if (elem == null) {
            return null;
        }
        this.rpcType = 2;
        this.response = new Response(elem);
        return this.response;
    }

    public Call getCall() {
        if (this.call != null) {
            return this.call;
        }
        Element elem = this.getDOM().getChild("query", JabberCode.XMLNS_IQ_XMLRPC).getChild("methodCall", JabberCode.XMLNS_IQ_XMLRPC);
        if (elem == null) {
            return null;
        }
        this.rpcType = 1;
        this.call = new Call(this.factory);
        this.call.parse(elem);
        return this.call;
    }

    public void setResponse(Response response) {
        this.setType("result");
        this.rpcType = 2;
        this.call = null;
        this.response = response;
        Element elemTree = this.getDOM();
        Element query = elemTree.getChild("query", JabberCode.XMLNS_IQ_XMLRPC);
        query.getChildren().clear();
        response.setNamespace(JabberCode.XMLNS_IQ_XMLRPC);
        query.addContent(response.getDOM());
    }

    public void setCall(Call call) {
        this.setType("set");
        this.rpcType = 1;
        this.response = null;
        this.call = call;
        Element elemTree = this.getDOM();
        Element query = elemTree.getChild("query", JabberCode.XMLNS_IQ_XMLRPC);
        query.getChildren().clear();
        call.setNamespace(JabberCode.XMLNS_IQ_XMLRPC);
        query.addContent(call.getDOM());
    }

    public int getXMLRPCType() {
        return this.rpcType;
    }

    public ErrorMessage getErrorMessage() {
        ErrorMessage msg = super.getErrorMessage();
        if (msg != null) {
            return msg;
        }
        if (this.isResponse()) {
            Response resp = this.getResponse();
            msg = resp != null && resp.isFault() ? new ErrorMessage(this.response.getFaultCode(), this.response.getFaultString()) : null;
        } else {
            XMLRPCMessage reply = (XMLRPCMessage)this.getReplyMessage();
            if (reply == null) {
                msg = null;
            }
            msg = reply.getErrorMessage();
        }
        return msg;
    }

    public int getMessageType() {
        return 14;
    }
}

