/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net;

import com.echomine.net.TransferRateThrottler;

public class FileModel {
    String filename = "";
    long filesize;
    String saveLocation = "";
    long currentFilesize;
    long startTime;
    long endTime;
    long bps;
    long startFileSize;
    TransferRateThrottler throttler;

    public FileModel(String filename) {
        this(filename, 0L);
    }

    public FileModel(String filename, long resumeOffset) {
        this(filename, "", resumeOffset, null);
    }

    public FileModel(String filename, String saveLocation) {
        this(filename, saveLocation, 0L, null);
    }

    public FileModel(String filename, String saveLocation, long resumeOffset) {
        this(filename, saveLocation, resumeOffset, null);
    }

    public FileModel(String filename, String saveLocation, long resumeOffset, TransferRateThrottler throttler) {
        this.filename = filename;
        this.saveLocation = saveLocation;
        this.filesize = resumeOffset;
        this.throttler = throttler;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(long filesize) {
        this.filesize = filesize;
    }

    public void setCurrentFilesize(long currentFilesize) {
        this.currentFilesize = currentFilesize;
        if (this.startFileSize == 0L && currentFilesize != 0L) {
            this.startFileSize = currentFilesize;
        }
    }

    public long getCurrentFilesize() {
        return this.currentFilesize;
    }

    public void incrementCurrentFilesize(long increment) {
        this.setCurrentFilesize(this.currentFilesize + increment);
    }

    public String getSaveLocation() {
        return this.saveLocation;
    }

    public void setSaveLocation(String saveLocation) {
        this.saveLocation = saveLocation;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.endTime = 0L;
    }

    public float getTransferKBPS() {
        if (this.endTime > 0L) {
            return 0.0f;
        }
        float kbps = this.getTransferBPS() / 1024L;
        return kbps;
    }

    public long getTransferBPS() {
        if (this.endTime > 0L) {
            return 0L;
        }
        if (this.endTime == 0L) {
            this.bps = (long)((float)(this.currentFilesize - this.startFileSize) / (float)((System.currentTimeMillis() - this.startTime) / 1000L));
        }
        return this.bps;
    }

    public String getTimeLeft() {
        if (this.endTime > 0L) {
            return "00:00:00";
        }
        long left = this.bps == 0L ? 362439L : (this.filesize - this.currentFilesize) / this.bps;
        if (left <= 0L) {
            return "00:00:00";
        }
        int hour = (int)(left / 3600L);
        int min = (int)((left %= 3600L) / 60L);
        int sec = (int)(left % 60L);
        StringBuffer buffer = new StringBuffer(9);
        buffer.append(hour < 10 ? "0" : "").append(hour).append(":");
        buffer.append(min < 10 ? "0" : "").append(min).append(":");
        buffer.append(sec < 10 ? "0" : "").append(sec);
        return buffer.toString();
    }

    public void reset() {
        this.filename = "";
        this.filesize = 0L;
        this.saveLocation = "";
        this.currentFilesize = 0L;
        this.startTime = 0L;
        this.endTime = 0L;
        this.bps = 0L;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileModel)) {
            return false;
        }
        FileModel model = (FileModel)obj;
        return this.filename.equals(model.getFilename()) && this.filesize == model.getFilesize() && this.saveLocation.equals(model.getSaveLocation());
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setThrottler(TransferRateThrottler throttler) {
        this.throttler = throttler;
    }

    public TransferRateThrottler getThrottler() {
        return this.throttler;
    }
}

