/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net;

import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionFailedException;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.SocketHandler;
import com.echomine.net.TimeableConnection;
import com.echomine.util.IOUtil;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketConnector
extends TimeableConnection {
    private static final String KEY_KEYSTORE = "com.echomine.net.keyStorePath";
    private static final String VALUE_KEYSTORE = System.getProperty("user.home") + System.getProperty("file.separator") + ".keystore";
    private static final String KEY_PASSPHRASE = "com.echomine.net.keyStorePassphrase";
    private static final String VALUE_PASSPHRASE = "";
    private static final String KEY_TRUSTMANAGER = "com.echomine.net.trustManager";
    private static final String VALUE_TRUSTMANAGER = "com.echomine.util.SimpleTrustManager";
    private SocketHandler socketHandler;

    public SocketConnector(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
    }

    public SocketConnector() {
    }

    public void connect(ConnectionModel connectionModel) throws ConnectionFailedException {
        this.connect(this.socketHandler, connectionModel);
    }

    private String[] getCiphers(SSLSocket s) {
        int num = 0;
        String[] supported = s.getSupportedCipherSuites();
        int[] cipherIndexes = new int[supported.length];
        for (int i = 0; i < supported.length; ++i) {
            if (supported[i].toLowerCase().indexOf("null") >= 0) continue;
            cipherIndexes[num++] = i;
        }
        String[] wesupport = new String[num];
        for (int i = 0; i < num; ++i) {
            wesupport[i] = supported[cipherIndexes[i]];
        }
        return wesupport;
    }

    private Socket negotiateSSLConnection(ConnectionModel connectionModel) throws IOException {
        InetAddress host = connectionModel.getHost();
        int port = connectionModel.getPort();
        String keyStorePath = System.getProperty(KEY_KEYSTORE, VALUE_KEYSTORE);
        String keyStorePassphrase = System.getProperty(KEY_PASSPHRASE, VALUE_PASSPHRASE);
        char[] keyStorePassword = keyStorePassphrase.toCharArray();
        Security.addProvider((java.security.Provider)new Provider());
        FileInputStream keyStoreIStream = null;
        try {
            keyStoreIStream = new FileInputStream(keyStorePath);
        }
        catch (FileNotFoundException e) {
            keyStoreIStream = null;
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new IOException("Unable to get a keystore of type " + KeyStore.getDefaultType());
        }
        try {
            keyStore.load(keyStoreIStream, keyStorePassword);
        }
        catch (NoSuchAlgorithmException nsa) {
            nsa.printStackTrace();
            throw new IOException("No such algorithm - keystore load");
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
            throw new IOException("Certificate exception - keystore load");
        }
        if (keyStoreIStream != null) {
            keyStoreIStream.close();
            keyStoreIStream = null;
        }
        SSLContext context = null;
        try {
            context = SSLContext.getInstance((String)"TLS");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IOException("No such algorithm - getting ssl context");
        }
        KeyManagerFactory keyManagerFactory = null;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance((String)"SunX509");
        }
        catch (NoSuchAlgorithmException nsa) {
            nsa.printStackTrace();
            throw new IOException("No such algorithm - getting keymgr. factory");
        }
        try {
            keyManagerFactory.init(keyStore, keyStorePassword);
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
            throw new IOException("Key store exception - keystore init");
        }
        catch (NoSuchAlgorithmException nsa) {
            nsa.printStackTrace();
            throw new IOException("No such algorithm - keystore init");
        }
        catch (UnrecoverableKeyException uke) {
            uke.printStackTrace();
            throw new IOException("Unrecoverable key exception - keystore init");
        }
        String trustManager = System.getProperty(KEY_TRUSTMANAGER, VALUE_TRUSTMANAGER);
        Class<?> tmClass = null;
        try {
            tmClass = Class.forName(trustManager, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException chfe) {
            chfe.printStackTrace();
            System.exit(3);
        }
        Constructor<?>[] constrs = tmClass.getConstructors();
        Object[] args = new Object[]{keyStore, keyStorePath, keyStorePassword};
        TrustManager tm = null;
        try {
            tm = (TrustManager)constrs[0].newInstance(args);
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            System.exit(4);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            System.exit(5);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            System.exit(6);
        }
        TrustManager[] trustManagers = new TrustManager[]{tm};
        try {
            context.init(keyManagerFactory.getKeyManagers(), trustManagers, null);
        }
        catch (KeyManagementException e) {
            throw new IOException("Unable to initiaize SSL context");
        }
        SSLSocketFactory sslSocketfactory = context.getSocketFactory();
        SSLSocket socket = null;
        try {
            socket = (SSLSocket)sslSocketfactory.createSocket(host, port);
        }
        catch (UnknownHostException uhe) {
            throw new IOException("Unknown host exception");
        }
        socket.setUseClientMode(true);
        socket.setEnabledCipherSuites(this.getCiphers(socket));
        socket.startHandshake();
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketHandler socketHandler, ConnectionModel connectionModel) throws ConnectionFailedException {
        Socket socket = null;
        try {
            ConnectionEvent event = new ConnectionEvent(connectionModel, 4);
            ConnectionEvent vetoEvent = new ConnectionEvent(connectionModel, 5);
            this.fireConnectionStarting(event, vetoEvent);
            socketHandler.start();
            socket = connectionModel.isSSL() ? this.negotiateSSLConnection(connectionModel) : new Socket(connectionModel.getHost(), connectionModel.getPort());
            try {
                event = new ConnectionEvent(connectionModel, 1);
                this.fireConnectionEstablished(event);
                socketHandler.handle(socket);
                event = new ConnectionEvent(connectionModel, 2);
                this.fireConnectionClosed(event);
            }
            catch (IOException ex) {
                event = new ConnectionEvent(connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                this.fireConnectionClosed(event);
            }
            finally {
                IOUtil.closeSocket(socket);
            }
        }
        catch (IOException ex) {
            ConnectionEvent event = new ConnectionEvent(connectionModel, 3, "Error connecting to host: " + ex.getMessage());
            this.fireConnectionClosed(event);
            throw new ConnectionFailedException("Cannot Connect to remote host");
        }
        catch (ConnectionVetoException ex) {
            // empty catch block
        }
    }

    public void aconnect(ConnectionModel connectionModel) {
        this.aconnect(this.socketHandler, connectionModel);
    }

    public void aconnect(final SocketHandler socketHandler, final ConnectionModel connectionModel) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Socket socket = null;
                try {
                    ConnectionEvent event = new ConnectionEvent(connectionModel, 4);
                    ConnectionEvent vetoEvent = new ConnectionEvent(connectionModel, 5);
                    SocketConnector.this.fireConnectionStarting(event, vetoEvent);
                    socketHandler.start();
                    socket = connectionModel.isSSL() ? SocketConnector.this.negotiateSSLConnection(connectionModel) : new Socket(connectionModel.getHost(), connectionModel.getPort());
                    try {
                        event = new ConnectionEvent(connectionModel, 1);
                        SocketConnector.this.fireConnectionEstablished(event);
                        socketHandler.handle(socket);
                        event = new ConnectionEvent(connectionModel, 2);
                        SocketConnector.this.fireConnectionClosed(event);
                    }
                    catch (IOException ex) {
                        event = new ConnectionEvent(connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                        SocketConnector.this.fireConnectionClosed(event);
                    }
                    finally {
                        IOUtil.closeSocket(socket);
                    }
                }
                catch (IOException ex) {
                    ConnectionEvent event = new ConnectionEvent(connectionModel, 3, "Error..." + ex.getMessage());
                    SocketConnector.this.fireConnectionClosed(event);
                }
                catch (ConnectionVetoException connectionVetoException) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public SocketHandler getSocketHandler() {
        return this.socketHandler;
    }

    public void setSocketHandler(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
    }
}

