/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util;

import com.echomine.util.HexDec;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class RandomGUID {
    public String valueBeforeMD5 = "";
    public String valueAfterMD5 = "";
    private static Random myRand;
    private static SecureRandom mySecureRand;

    public RandomGUID() {
        this.getRandomGUID(false);
    }

    public RandomGUID(boolean secure) {
        this.getRandomGUID(secure);
    }

    private void getRandomGUID(boolean secure) {
        MessageDigest md5 = null;
        StringBuffer sbValueBeforeMD5 = new StringBuffer();
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error: " + e);
        }
        try {
            InetAddress id = InetAddress.getLocalHost();
            long time = System.currentTimeMillis();
            long rand = 0L;
            rand = secure ? mySecureRand.nextLong() : myRand.nextLong();
            sbValueBeforeMD5.append(id.toString());
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(Long.toString(time));
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(Long.toString(rand));
            this.valueBeforeMD5 = sbValueBeforeMD5.toString();
            md5.update(this.valueBeforeMD5.getBytes());
            byte[] array = md5.digest();
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < array.length; ++j) {
                int b = array[j] & 0xFF;
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
            }
            this.valueAfterMD5 = sb.toString().toUpperCase();
        }
        catch (UnknownHostException e) {
            System.out.println("Error:" + e);
        }
    }

    public String getHexString() {
        return this.valueAfterMD5;
    }

    public byte[] getGUIDBytes() {
        return HexDec.convertHexStringToBytes(this.valueAfterMD5);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RandomGUID)) {
            return false;
        }
        return this.valueAfterMD5.equals(((RandomGUID)obj).getHexString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.valueAfterMD5.substring(0, 8));
        sb.append("-");
        sb.append(this.valueAfterMD5.substring(8, 12));
        sb.append("-");
        sb.append(this.valueAfterMD5.substring(12, 16));
        sb.append("-");
        sb.append(this.valueAfterMD5.substring(16, 20));
        sb.append("-");
        sb.append(this.valueAfterMD5.substring(20));
        return sb.toString();
    }

    static {
        mySecureRand = new SecureRandom();
        long secureInitializer = mySecureRand.nextLong();
        myRand = new Random(secureInitializer);
    }
}

