/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util;

import com.sun.net.ssl.X509TrustManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class SimpleTrustManager
implements X509TrustManager {
    private static final String KEY_PROMPT = "com.echomine.util.SimpleTrustManager.prompt";
    private static final String VALUE_PROMPT = "false";
    private KeyStore keyStore;
    private String keyStorePath;
    private char[] keyStorePassword;

    public SimpleTrustManager(KeyStore keyStore, String keyStorePath, char[] keyStorePassword) {
        this.keyStore = keyStore;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
    }

    public boolean isClientTrusted(X509Certificate[] chain) {
        return this.isChainTrusted(chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isServerTrusted(X509Certificate[] chain) {
        boolean trusted;
        block29: {
            String promptVal = System.getProperty(KEY_PROMPT, VALUE_PROMPT);
            boolean prompt = true;
            if (promptVal.compareToIgnoreCase(VALUE_PROMPT) == 0 || promptVal.compareToIgnoreCase("no") == 0) {
                prompt = false;
            }
            trusted = false;
            trusted = this.isChainTrusted(chain);
            if (!trusted) {
                if (prompt) {
                    System.out.println("Untrusted Certificate chain:");
                }
                for (int i = 0; i < chain.length; ++i) {
                    if (prompt) {
                        System.out.println("Certificate chain[" + i + "]:");
                    }
                    if (prompt) {
                        System.out.println("Subject: " + ((Object)chain[i].getSubjectDN()).toString());
                    }
                    if (!prompt) continue;
                    System.out.println("Issuer: " + ((Object)chain[i].getIssuerDN()).toString());
                }
                if (prompt) {
                    System.out.println("Trust this certificate chain and add it to the keystore? (y or n) ");
                }
                String s = new String("y");
                if (prompt) {
                    try {
                        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                        s = in.readLine();
                    }
                    catch (IOException ioe) {
                        System.err.println("Unable to read input - assuming affirmative response");
                    }
                }
                if (s.compareToIgnoreCase("y") == 0) {
                    trusted = true;
                    try {
                        for (int i = 0; i < chain.length; ++i) {
                            this.keyStore.setCertificateEntry(((Object)chain[i].getIssuerDN()).toString(), chain[i]);
                        }
                    }
                    catch (KeyStoreException kse) {
                        System.err.println("Unable to add a certificate to the keystore");
                    }
                    if (prompt) {
                        System.out.println("Saving the certificate chain to the keystore.");
                    }
                    FileOutputStream keyStoreOStream = null;
                    keyStoreOStream = new FileOutputStream(this.keyStorePath);
                    try {
                        this.keyStore.store(keyStoreOStream, this.keyStorePassword);
                    }
                    catch (CertificateException ce) {
                        System.err.println("Certificate exception when trying to store the key in the keystore");
                    }
                    catch (KeyStoreException kse) {
                        System.err.println("Key store exception when trying to store the key in the keystore");
                    }
                    catch (IOException ioe) {
                        System.err.println("Io exception when trying to store the key in the keystore");
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        System.err.println("No such algorithm exception when trying to store the key in the keystore");
                    }
                    Object var9_17 = null;
                    if (keyStoreOStream == null) break block29;
                    try {
                        keyStoreOStream.close();
                        System.out.println("Keystore saved in " + this.keyStorePath);
                    }
                    catch (IOException ioe) {
                        System.err.println("Unable to close the key store file");
                    }
                    keyStoreOStream = null;
                    {
                        break block29;
                        catch (FileNotFoundException fnfe) {
                            System.err.println("Keystore file: " + this.keyStorePath + " not found - key not saved");
                            Object var9_18 = null;
                            if (keyStoreOStream == null) break block29;
                            try {
                                keyStoreOStream.close();
                                System.out.println("Keystore saved in " + this.keyStorePath);
                            }
                            catch (IOException ioe) {
                                System.err.println("Unable to close the key store file");
                            }
                            keyStoreOStream = null;
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_19 = null;
                        if (keyStoreOStream != null) {
                            try {
                                keyStoreOStream.close();
                                System.out.println("Keystore saved in " + this.keyStorePath);
                            }
                            catch (IOException ioe) {
                                System.err.println("Unable to close the key store file");
                            }
                            keyStoreOStream = null;
                        }
                        throw throwable;
                    }
                }
                trusted = false;
            }
        }
        return trusted;
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] X509Certs = null;
        try {
            int numberOfEntry = this.keyStore.size();
            if (numberOfEntry > 0) {
                X509Certs = new X509Certificate[numberOfEntry];
                Enumeration<String> aliases = this.keyStore.aliases();
                int i = 0;
                while (aliases.hasMoreElements()) {
                    X509Certs[i] = (X509Certificate)this.keyStore.getCertificate(aliases.nextElement());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.out.println("getAcceptedIssuers Exception: " + e.toString());
            X509Certs = null;
        }
        return X509Certs;
    }

    private boolean isChainTrusted(X509Certificate[] chain) {
        boolean trusted = false;
        try {
            for (int i = chain.length - 1; i >= 0; --i) {
                if (this.keyStore.getCertificateAlias(chain[i]) == null) continue;
                trusted = true;
                break;
            }
        }
        catch (Exception e) {
            System.out.println("isChainTrusted Exception: " + e.toString());
            trusted = false;
        }
        return trusted;
    }
}

