/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.Deserializer;
import com.echomine.xmlrpc.Serializer;
import org.jdom.Element;
import org.jdom.Namespace;

public class BooleanSerializer
implements Serializer,
Deserializer {
    public static final String NAME = "boolean";

    public Element serialize(Object data, Namespace ns) {
        if (!(data instanceof Boolean)) {
            throw new IllegalArgumentException("Object must be of type Boolean");
        }
        Element root = new Element(NAME, ns);
        boolean bool = (Boolean)data;
        if (bool) {
            root.setText("1");
        } else {
            root.setText("0");
        }
        return root;
    }

    public Object deserialize(Element elem) {
        String text = elem.getTextTrim();
        if (text == null) {
            return null;
        }
        Boolean value = text.equals("1") ? new Boolean(true) : new Boolean(false);
        return value;
    }
}

