/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.SerializerFactory;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class Call {
    private String methodName;
    private Namespace ns;
    private ArrayList params = new ArrayList();
    private SerializerFactory factory;

    public Call(SerializerFactory factory) {
        this.factory = factory;
    }

    public Call(String methodName, SerializerFactory factory) {
        this(methodName, null, factory);
    }

    public Call(String methodName, Namespace ns, SerializerFactory factory) {
        this.methodName = methodName;
        this.ns = ns;
        this.factory = factory;
    }

    public void setNamespace(Namespace ns) {
        this.ns = ns;
    }

    public Namespace getNamespace() {
        return this.ns;
    }

    public void setMethodName(String name) {
        this.methodName = name;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void addParameter(Object param) {
        this.params.add(param);
    }

    public void addParameters(Object[] param) {
        for (int i = 0; i < param.length; ++i) {
            this.params.add(param[i]);
        }
    }

    public Object getParameter(int idx) {
        return this.params.get(idx);
    }

    public Object[] getParameters() {
        return this.params.toArray();
    }

    public Element getDOM() {
        Element root = new Element("methodCall", this.ns);
        Element method = new Element("methodName", this.ns);
        method.setText(this.methodName);
        root.addContent(method);
        if (this.params.size() == 0) {
            return root;
        }
        Element paramsElem = new Element("params", this.ns);
        root.addContent(paramsElem);
        int length = this.params.size();
        for (int i = 0; i < length; ++i) {
            Object obj = this.params.get(i);
            Element valueData = this.factory.serialize(obj, this.ns);
            if (valueData == null) continue;
            Element param = new Element("param", this.ns);
            Element paramValue = new Element("value", this.ns);
            paramValue.addContent(valueData);
            param.addContent(paramValue);
            paramsElem.addContent(param);
        }
        return root;
    }

    public void parse(Element elem) {
        this.params.clear();
        this.methodName = null;
        this.ns = elem.getNamespace();
        this.methodName = elem.getChildText("methodName", this.ns);
        List paramList = elem.getChild("params", this.ns).getChildren();
        int len = paramList.size();
        for (int i = 0; i < len; ++i) {
            Element data = (Element)paramList.get(i);
            Element value = (Element)data.getChild("value", this.ns).getChildren().get(0);
            Object paramVal = this.factory.deserialize(value);
            this.params.add(paramVal);
        }
    }

    public String toString() {
        Element dom = this.getDOM();
        XMLOutputter xos = new XMLOutputter();
        return xos.outputString(dom);
    }
}

