/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.Deserializer;
import com.echomine.xmlrpc.Serializer;
import org.jdom.Element;
import org.jdom.Namespace;

public class DoubleSerializer
implements Serializer,
Deserializer {
    public static final String NAME = "double";

    public Element serialize(Object data, Namespace ns) {
        if (!(data instanceof Number)) {
            throw new IllegalArgumentException("Object must be of type Number or its subclass");
        }
        Element root = new Element(NAME, ns);
        root.setText(String.valueOf(((Number)data).doubleValue()));
        return root;
    }

    public Object deserialize(Element elem) {
        String text = elem.getTextTrim();
        if (text == null) {
            return null;
        }
        Double value = new Double(text);
        return value;
    }
}

