/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.ArraySerializer;
import com.echomine.xmlrpc.Base64Serializer;
import com.echomine.xmlrpc.BooleanSerializer;
import com.echomine.xmlrpc.DateSerializer;
import com.echomine.xmlrpc.Deserializer;
import com.echomine.xmlrpc.DoubleSerializer;
import com.echomine.xmlrpc.IntSerializer;
import com.echomine.xmlrpc.Serializer;
import com.echomine.xmlrpc.SerializerFactoryAware;
import com.echomine.xmlrpc.StringSerializer;
import com.echomine.xmlrpc.StructSerializer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jdom.Element;
import org.jdom.Namespace;

public class SerializerFactory {
    private HashMap serializers;
    private HashMap deserializers;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;

    public Element serialize(Object object, Namespace ns) {
        Serializer serializer;
        if (this.serializers == null) {
            this.init();
        }
        if ((serializer = object instanceof List ? (Serializer)this.serializers.get(class$java$util$List == null ? (class$java$util$List = SerializerFactory.class$("java.util.List")) : class$java$util$List) : (object instanceof Map ? (Serializer)this.serializers.get(class$java$util$Map == null ? (class$java$util$Map = SerializerFactory.class$("java.util.Map")) : class$java$util$Map) : (Serializer)this.serializers.get(object.getClass()))) == null) {
            return null;
        }
        return serializer.serialize(object, ns);
    }

    public Object deserialize(Element elem) {
        Deserializer serializer;
        if (this.deserializers == null) {
            this.init();
        }
        if ((serializer = (Deserializer)this.deserializers.get(elem.getName())) == null) {
            return null;
        }
        return serializer.deserialize(elem);
    }

    public void setTimeZone(TimeZone tz) {
        DateSerializer serializer;
        if (this.serializers == null) {
            this.init();
        }
        if ((serializer = (DateSerializer)this.serializers.get(class$java$util$Date == null ? (class$java$util$Date = SerializerFactory.class$("java.util.Date")) : class$java$util$Date)) != null) {
            serializer.setTimeZone(tz);
        }
    }

    public boolean isSerializerRegisteredFor(Class classType) {
        if (this.serializers == null) {
            this.init();
        }
        if ((class$java$util$List == null ? (class$java$util$List = SerializerFactory.class$("java.util.List")) : class$java$util$List).isAssignableFrom(classType)) {
            classType = class$java$util$List == null ? (class$java$util$List = SerializerFactory.class$("java.util.List")) : class$java$util$List;
        } else if ((class$java$util$Map == null ? (class$java$util$Map = SerializerFactory.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(classType)) {
            classType = class$java$util$Map == null ? (class$java$util$Map = SerializerFactory.class$("java.util.Map")) : class$java$util$Map;
        }
        return this.serializers.containsKey(classType);
    }

    public boolean isDeserializerRegisteredFor(String name) {
        if (this.deserializers == null) {
            this.init();
        }
        return this.deserializers.containsKey(name);
    }

    public void addSerializer(Class classType, Serializer serializer) {
        if (this.serializers == null) {
            this.init();
        }
        if (serializer instanceof SerializerFactoryAware) {
            ((SerializerFactoryAware)((Object)serializer)).setSerializerFactory(this);
        }
        this.serializers.put(classType, serializer);
    }

    public void addDeserializer(String name, Deserializer deserializer) {
        if (this.serializers == null) {
            this.init();
        }
        if (deserializer instanceof SerializerFactoryAware) {
            ((SerializerFactoryAware)((Object)deserializer)).setSerializerFactory(this);
        }
        this.deserializers.put(name, deserializer);
    }

    protected void init() {
        this.serializers = new HashMap();
        this.deserializers = new HashMap();
        this.initStruct();
        this.initArray();
        this.initInt();
        this.initBoolean();
        this.initBase64();
        this.initDate();
        this.initDouble();
        this.initString();
    }

    protected void initString() {
        StringSerializer serializer = new StringSerializer();
        this.addSerializer(class$java$lang$String == null ? (class$java$lang$String = SerializerFactory.class$("java.lang.String")) : class$java$lang$String, serializer);
        this.addDeserializer("string", serializer);
    }

    protected void initDouble() {
        DoubleSerializer serializer = new DoubleSerializer();
        this.addSerializer(class$java$lang$Double == null ? (class$java$lang$Double = SerializerFactory.class$("java.lang.Double")) : class$java$lang$Double, serializer);
        this.addDeserializer("double", serializer);
    }

    protected void initDate() {
        DateSerializer serializer = new DateSerializer();
        this.addSerializer(class$java$util$Date == null ? (class$java$util$Date = SerializerFactory.class$("java.util.Date")) : class$java$util$Date, serializer);
        this.addDeserializer("dateTime.iso8601", serializer);
    }

    protected void initBase64() {
        Base64Serializer serializer = new Base64Serializer();
        this.addSerializer(array$B == null ? (array$B = SerializerFactory.class$("[B")) : array$B, serializer);
        this.addDeserializer("base64", serializer);
    }

    protected void initBoolean() {
        BooleanSerializer serializer = new BooleanSerializer();
        this.addSerializer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializerFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean, serializer);
        this.addDeserializer("boolean", serializer);
    }

    protected void initInt() {
        IntSerializer serializer = new IntSerializer("int");
        this.addSerializer(class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerFactory.class$("java.lang.Integer")) : class$java$lang$Integer, serializer);
        this.addDeserializer(serializer.getName(), serializer);
        serializer = new IntSerializer("i4");
        this.addDeserializer(serializer.getName(), serializer);
    }

    protected void initArray() {
        ArraySerializer serializer = new ArraySerializer();
        this.addSerializer(class$java$util$List == null ? (class$java$util$List = SerializerFactory.class$("java.util.List")) : class$java$util$List, serializer);
        this.addDeserializer("array", serializer);
    }

    protected void initStruct() {
        StructSerializer serializer = new StructSerializer();
        this.addSerializer(class$java$util$Map == null ? (class$java$util$Map = SerializerFactory.class$("java.util.Map")) : class$java$util$Map, serializer);
        this.addDeserializer("struct", serializer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

