/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.Deserializer;
import com.echomine.xmlrpc.Serializer;
import com.echomine.xmlrpc.SerializerFactory;
import com.echomine.xmlrpc.SerializerFactoryAware;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;

public class StructSerializer
implements Serializer,
Deserializer,
SerializerFactoryAware {
    public static final String NAME = "struct";
    private SerializerFactory factory;

    public void setSerializerFactory(SerializerFactory factory) {
        this.factory = factory;
    }

    public Element serialize(Object data, Namespace ns) {
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("object must be of type Map or its subclass");
        }
        Map params = (Map)data;
        Element root = new Element(NAME, ns);
        Iterator iter = params.keySet().iterator();
        while (iter.hasNext()) {
            Element member = new Element("member", ns);
            String name = (String)iter.next();
            Element value = this.factory.serialize(params.get(name), ns);
            if (value == null) continue;
            Element memberName = new Element("name", ns);
            memberName.addContent(name);
            Element memberValue = new Element("value", ns);
            memberValue.addContent(value);
            member.addContent(memberName);
            member.addContent(memberValue);
            root.addContent(member);
        }
        return root;
    }

    public Object deserialize(Element elem) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Namespace ns = elem.getNamespace();
        Iterator iter = elem.getChildren("member", ns).iterator();
        Object value = null;
        Element valElem = null;
        while (iter.hasNext()) {
            value = null;
            valElem = null;
            Element member = (Element)iter.next();
            String name = member.getChildText("name", ns);
            List valChilds = member.getChild("value", ns).getChildren();
            if (valChilds.size() > 0) {
                valElem = (Element)valChilds.get(0);
            }
            if (valElem != null) {
                value = this.factory.deserialize(valElem);
            }
            if (value == null) continue;
            data.put(name, value);
        }
        return data;
    }
}

