/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.TransactionManager;
import javax.xml.transform.Templates;
import net.sf.cglib.core.KeyFactory;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.Databinder;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cache.QueryCache;
import net.sf.hibernate.cache.UpdateTimestampsCache;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.cfg.Settings;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.hql.FilterTranslator;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.id.UUIDHexGenerator;
import net.sf.hibernate.impl.MessageHelper;
import net.sf.hibernate.impl.SessionFactoryObjectFactory;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.mapping.NamedSQLQuery;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.metadata.CollectionMetadata;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.PersisterFactory;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.tool.hbm2ddl.SchemaExport;
import net.sf.hibernate.tool.hbm2ddl.SchemaUpdate;
import net.sf.hibernate.transaction.TransactionFactory;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.xml.XMLDatabinder;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SessionFactoryImpl
implements SessionFactory,
SessionFactoryImplementor {
    private final String name;
    private final String uuid;
    private final transient Map classPersisters;
    private final transient Map classPersistersByName;
    private final transient Map classMetadata;
    private final transient Map collectionPersisters;
    private final transient Map collectionMetadata;
    private final transient Map namedQueries;
    private final transient Map namedSqlQueries;
    private final transient Map imports;
    private final transient Templates templates;
    private final transient Interceptor interceptor;
    private final transient Settings settings;
    private final transient Properties properties;
    private transient SchemaExport schemaExport;
    private final transient TransactionManager transactionManager;
    private final transient QueryCache queryCache;
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient Map queryCaches;
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDHexGenerator();
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$impl$SessionFactoryImpl == null ? (class$net$sf$hibernate$impl$SessionFactoryImpl = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryImpl")) : class$net$sf$hibernate$impl$SessionFactoryImpl));
    private static final int MAX_STRONG_REF_COUNT = 128;
    private final transient Object[] strongRefs = new Object[128];
    private transient int strongRefIndex = 0;
    private final transient Map softQueryCache = new ReferenceMap(1, 1);
    private static final QueryCacheKeyFactory QUERY_KEY_FACTORY = (QueryCacheKeyFactory)KeyFactory.create((Class)(class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory == null ? (class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryImpl$QueryCacheKeyFactory")) : class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory));
    private static final FilterCacheKeyFactory FILTER_KEY_FACTORY = (FilterCacheKeyFactory)KeyFactory.create((Class)(class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory == null ? (class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryImpl$FilterCacheKeyFactory")) : class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory));
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionFactoryImpl;
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory;
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory;
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionFactoryObjectFactory;

    public SessionFactoryImpl(Configuration cfg, Settings settings) throws HibernateException {
        log.info((Object)"building session factory");
        this.properties = cfg.getProperties();
        this.interceptor = cfg.getInterceptor();
        this.settings = settings;
        if (log.isDebugEnabled()) {
            log.debug((Object)("instantiating session factory with properties: " + this.properties));
        }
        this.classPersisters = new HashMap();
        this.classPersistersByName = new HashMap();
        HashMap<Class, ClassMetadata> classMeta = new HashMap<Class, ClassMetadata>();
        Iterator classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass model = (PersistentClass)classes.next();
            ClassPersister cp = PersisterFactory.createClassPersister(model, this);
            this.classPersisters.put(model.getMappedClass(), cp);
            this.classPersistersByName.put(model.getName(), cp);
            classMeta.put(model.getMappedClass(), cp.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(classMeta);
        this.collectionPersisters = new HashMap();
        Iterator collections = cfg.getCollectionMappings();
        while (collections.hasNext()) {
            net.sf.hibernate.mapping.Collection map = (net.sf.hibernate.mapping.Collection)collections.next();
            CollectionPersister persister = PersisterFactory.createCollectionPersister(cfg, map, this);
            this.collectionPersisters.put(map.getRole(), persister.getCollectionMetadata());
        }
        this.collectionMetadata = Collections.unmodifiableMap(this.collectionPersisters);
        Iterator iter = this.classPersisters.values().iterator();
        while (iter.hasNext()) {
            ((ClassPersister)iter.next()).postInstantiate();
        }
        this.templates = XMLDatabinder.getOutputStyleSheetTemplates(this.properties);
        this.name = settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, this.properties);
        this.namedQueries = new HashMap(cfg.getNamedQueries());
        this.namedSqlQueries = new HashMap(cfg.getNamedSQLQueries().size());
        Iterator namedIter = cfg.getNamedSQLQueries().entrySet().iterator();
        while (namedIter.hasNext()) {
            Map.Entry entry = namedIter.next();
            NamedSQLQuery nsq = (NamedSQLQuery)entry.getValue();
            this.namedSqlQueries.put(entry.getKey(), new InternalNamedSQLQuery(nsq.getQueryString(), nsq.getReturnAliases(), nsq.getReturnClasses(), nsq.getSynchronizedTables()));
        }
        this.imports = new HashMap(cfg.getImports());
        log.debug((Object)"instantiated session factory");
        if (settings.isAutoCreateSchema()) {
            new SchemaExport(cfg).create(false, true);
        }
        if (settings.isAutoUpdateSchema()) {
            new SchemaUpdate(cfg).execute(false, true);
        }
        if (settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(cfg);
        }
        if (settings.getTransactionManagerLookup() != null) {
            log.debug((Object)"obtaining JTA TransactionManager");
            this.transactionManager = settings.getTransactionManagerLookup().getTransactionManager(this.properties);
        } else {
            this.transactionManager = null;
        }
        if (settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(settings.getCacheProvider(), this.properties);
            this.queryCache = new QueryCache(settings.getCacheProvider(), this.properties, this.updateTimestampsCache, null);
            this.queryCaches = Collections.synchronizedMap(new HashMap());
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
    }

    private synchronized Object get(Object key) {
        Object result = this.softQueryCache.get(key);
        if (result != null) {
            this.strongRefs[++this.strongRefIndex % 128] = result;
        }
        return result;
    }

    private void put(Object key, Object value) {
        this.softQueryCache.put(key, value);
        this.strongRefs[++this.strongRefIndex % 128] = value;
    }

    private synchronized QueryTranslator[] createQueryTranslators(String[] concreteQueryStrings, Object cacheKey) {
        int length = concreteQueryStrings.length;
        QueryTranslator[] queries = new QueryTranslator[length];
        for (int i = 0; i < length; ++i) {
            queries[i] = new QueryTranslator(concreteQueryStrings[i]);
        }
        this.put(cacheKey, queries);
        return queries;
    }

    private synchronized FilterTranslator createFilterTranslator(String filterString, Object cacheKey) {
        FilterTranslator filter = new FilterTranslator(filterString);
        this.put(cacheKey, filter);
        return filter;
    }

    public QueryTranslator[] getQuery(String queryString, boolean shallow) throws QueryException, MappingException {
        Object cacheKey = QUERY_KEY_FACTORY.newInstance(queryString, shallow);
        QueryTranslator[] queries = (QueryTranslator[])this.get(cacheKey);
        if (queries == null) {
            String[] concreteQueryStrings = QueryTranslator.concreteQueries(queryString, this);
            queries = this.createQueryTranslators(concreteQueryStrings, cacheKey);
        }
        for (int i = 0; i < queries.length; ++i) {
            queries[i].compile(this, this.settings.getQuerySubstitutions(), shallow);
        }
        return queries;
    }

    public FilterTranslator getFilter(String filterString, String collectionRole, boolean scalar) throws QueryException, MappingException {
        Object cacheKey = FILTER_KEY_FACTORY.newInstance(collectionRole, filterString, scalar);
        FilterTranslator filter = (FilterTranslator)this.get(cacheKey);
        if (filter == null) {
            filter = this.createFilterTranslator(filterString, cacheKey);
        }
        filter.compile(collectionRole, this, this.settings.getQuerySubstitutions(), scalar);
        return filter;
    }

    private Session openSession(Connection connection, boolean autoClose, long timestamp, Interceptor interceptor) {
        return new SessionImpl(connection, this, autoClose, timestamp, interceptor);
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.openSession(connection, false, Long.MIN_VALUE, interceptor);
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        long timestamp = this.settings.getCacheProvider().nextTimestamp();
        return this.openSession(null, true, timestamp, interceptor);
    }

    public Session openSession(Connection connection) {
        return this.openSession(connection, this.interceptor);
    }

    public Session openSession() throws HibernateException {
        return this.openSession(this.interceptor);
    }

    public ClassPersister getPersister(String className) throws MappingException {
        ClassPersister result = (ClassPersister)this.classPersistersByName.get(className);
        if (result == null) {
            throw new MappingException("No persister for: " + className);
        }
        return result;
    }

    public ClassPersister getPersister(Class theClass) throws MappingException {
        ClassPersister result = (ClassPersister)this.classPersisters.get(theClass);
        if (result == null) {
            throw new MappingException("No persister for: " + theClass.getName());
        }
        return result;
    }

    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        CollectionPersister result = (CollectionPersister)this.collectionPersisters.get(role);
        if (result == null) {
            throw new MappingException("No persister for collection role: " + role);
        }
        return result;
    }

    public Databinder openDatabinder() throws HibernateException {
        if (this.templates == null) {
            throw new HibernateException("No output stylesheet configured. Use the property hibernate.output_stylesheet and ensure xalan.jar is in classpath");
        }
        try {
            return new XMLDatabinder(this, this.templates.newTransformer());
        }
        catch (Exception e) {
            log.error((Object)"Could not open Databinder", (Throwable)e);
            throw new HibernateException("Could not open Databinder", e);
        }
    }

    public Dialect getDialect() {
        return this.settings.getDialect();
    }

    public TransactionFactory getTransactionFactory() {
        return this.settings.getTransactionFactory();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Reference getReference() throws NamingException {
        log.debug((Object)"Returning a Reference to the SessionFactory");
        return new Reference((class$net$sf$hibernate$impl$SessionFactoryImpl == null ? (class$net$sf$hibernate$impl$SessionFactoryImpl = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryImpl")) : class$net$sf$hibernate$impl$SessionFactoryImpl).getName(), new StringRefAddr("uuid", this.uuid), (class$net$sf$hibernate$impl$SessionFactoryObjectFactory == null ? (class$net$sf$hibernate$impl$SessionFactoryObjectFactory = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryObjectFactory")) : class$net$sf$hibernate$impl$SessionFactoryObjectFactory).getName(), null);
    }

    private Object readResolve() throws ObjectStreamException {
        log.trace((Object)"Resolving serialized SessionFactory");
        Object result = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (result == null) {
            result = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a SessionFactory named: " + this.name);
            }
            log.debug((Object)"resolved SessionFactory by name");
        } else {
            log.debug((Object)"resolved SessionFactory by uid");
        }
        return result;
    }

    public boolean isJdbcBatchUpdateEnabled() {
        return this.settings.getJdbcBatchSize() > 0;
    }

    public int getJdbcBatchSize() {
        return this.settings.getJdbcBatchSize();
    }

    public boolean isScrollableResultSetsEnabled() {
        return this.settings.isScrollableResultSetsEnabled();
    }

    public boolean isGetGeneratedKeysEnabled() {
        return this.settings.isGetGeneratedKeysEnabled();
    }

    public boolean isOuterJoinedFetchEnabled() {
        return this.settings.isOuterJoinFetchEnabled();
    }

    public String getNamedQuery(String queryName) {
        String queryString = (String)this.namedQueries.get(queryName);
        return queryString;
    }

    public InternalNamedSQLQuery getNamedSQLQuery(String queryName) {
        return (InternalNamedSQLQuery)this.namedSqlQueries.get(queryName);
    }

    public Type getIdentifierType(Class ObjectClass) throws MappingException {
        return this.getPersister(ObjectClass).getIdentifierType();
    }

    public String getIdentifierPropertyName(Class ObjectClass) throws MappingException {
        return this.getPersister(ObjectClass).getIdentifierPropertyName();
    }

    private final void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        log.trace((Object)"deserializing");
        in.defaultReadObject();
        log.debug((Object)("deserialized: " + this.uuid));
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        log.debug((Object)("serializing: " + this.uuid));
        out.defaultWriteObject();
        log.trace((Object)"serialized");
    }

    public Type[] getReturnTypes(String queryString) throws HibernateException {
        String[] queries = QueryTranslator.concreteQueries(queryString, this);
        if (queries.length == 0) {
            throw new HibernateException("Query does not refer to any persistent classes: " + queryString);
        }
        return this.getQuery(queries[0], true)[0].getReturnTypes();
    }

    public String getDefaultSchema() {
        return this.settings.getDefaultSchemaName();
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return (ClassMetadata)this.classMetadata.get(persistentClass);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return (CollectionMetadata)this.collectionMetadata.get(roleName);
    }

    public String[] getImplementors(Class clazz) {
        ArrayList<String> results = new ArrayList<String>();
        Iterator iter = this.classPersisters.values().iterator();
        while (iter.hasNext()) {
            ClassPersister p = (ClassPersister)iter.next();
            if (!(p instanceof Queryable)) continue;
            Queryable q = (Queryable)p;
            String className = q.getClassName();
            boolean isMappedClass = clazz.equals(q.getMappedClass());
            if (q.isExplicitPolymorphism()) {
                if (!isMappedClass) continue;
                return new String[]{className};
            }
            if (isMappedClass) {
                results.add(className);
                continue;
            }
            if (!clazz.isAssignableFrom(q.getMappedClass()) || q.isInherited() && clazz.isAssignableFrom(q.getMappedSuperclass())) continue;
            results.add(className);
        }
        return results.toArray(new String[results.size()]);
    }

    public String getImportedClassName(String className) {
        String result = (String)this.imports.get(className);
        return result == null ? className : result;
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.classMetadata;
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.collectionMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HibernateException {
        Object p;
        log.info((Object)"closing");
        Iterator iter = this.classPersisters.values().iterator();
        while (iter.hasNext()) {
            p = (ClassPersister)iter.next();
            if (!p.hasCache()) continue;
            p.getCache().destroy();
        }
        iter = this.collectionPersisters.values().iterator();
        while (iter.hasNext()) {
            p = (CollectionPersister)iter.next();
            if (!p.hasCache()) continue;
            p.getCache().destroy();
        }
        try {
            this.settings.getConnectionProvider().close();
        }
        finally {
            SessionFactoryObjectFactory.removeInstance(this.uuid, this.name, this.properties);
        }
        if (this.isQueryCacheEnabled()) {
            this.queryCache.destroy();
            iter = this.queryCaches.values().iterator();
            while (iter.hasNext()) {
                QueryCache cache = (QueryCache)iter.next();
                cache.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport.drop(false, true);
        }
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        ClassPersister p = this.getPersister(persistentClass);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evicting second-level cache: " + MessageHelper.infoString(p, id)));
            }
            p.getCache().remove(id);
        }
    }

    public void evict(Class persistentClass) throws HibernateException {
        ClassPersister p = this.getPersister(persistentClass);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evicting second-level cache: " + p.getClassName()));
            }
            p.getCache().clear();
        }
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        CollectionPersister p = this.getCollectionPersister(roleName);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evicting second-level cache: " + MessageHelper.infoString(p, id)));
            }
            p.getCache().remove(id);
        }
    }

    public void evictCollection(String roleName) throws HibernateException {
        CollectionPersister p = this.getCollectionPersister(roleName);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evicting second-level cache: " + p.getRole()));
            }
            p.getCache().clear();
        }
    }

    public Integer getMaximumFetchDepth() {
        return this.settings.getMaximumFetchDepth();
    }

    public Type getPropertyType(Class persistentClass, String propertyName) throws MappingException {
        return this.getPersister(persistentClass).getPropertyType(propertyName);
    }

    public boolean isShowSqlEnabled() {
        return this.settings.isShowSqlEnabled();
    }

    public Integer getJdbcFetchSize() {
        return this.settings.getStatementFetchSize();
    }

    public ConnectionProvider getConnectionProvider() {
        return this.settings.getConnectionProvider();
    }

    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public QueryCache getQueryCache(String cacheRegion) throws HibernateException {
        if (cacheRegion == null) {
            return this.getQueryCache();
        }
        QueryCache currentQueryCache = (QueryCache)this.queryCaches.get(cacheRegion);
        if (currentQueryCache == null) {
            currentQueryCache = new QueryCache(this.settings.getCacheProvider(), this.properties, this.updateTimestampsCache, cacheRegion);
            this.queryCaches.put(cacheRegion, currentQueryCache);
        }
        return currentQueryCache;
    }

    public boolean isQueryCacheEnabled() {
        return this.settings.isQueryCacheEnabled();
    }

    public void evictQueries() throws HibernateException {
        if (this.queryCache != null) {
            this.queryCache.clear();
            if (this.queryCaches.size() == 0) {
                this.updateTimestampsCache.clear();
            }
        }
    }

    public void evictQueries(String cacheRegion) throws HibernateException {
        QueryCache currentQueryCache;
        if (cacheRegion == null) {
            throw new NullPointerException("use the zero-argument form to evict the default query cache");
        }
        if (this.queryCaches != null && (currentQueryCache = (QueryCache)this.queryCaches.get(cacheRegion)) != null) {
            currentQueryCache.clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class InternalNamedSQLQuery {
        private String query;
        private String[] returnAliases;
        private Class[] returnClasses;
        private List querySpaces;

        public InternalNamedSQLQuery(String query, String[] aliases, Class[] clazz, List querySpaces) {
            this.returnClasses = clazz;
            this.returnAliases = aliases;
            this.query = query;
            this.querySpaces = querySpaces;
        }

        public String[] getReturnAliases() {
            return this.returnAliases;
        }

        public Class[] getReturnClasses() {
            return this.returnClasses;
        }

        public String getQueryString() {
            return this.query;
        }

        public Collection getQuerySpaces() {
            return this.querySpaces;
        }
    }

    static interface FilterCacheKeyFactory {
        public Object newInstance(String var1, String var2, boolean var3);
    }

    static interface QueryCacheKeyFactory {
        public Object newInstance(String var1, boolean var2);
    }
}

