/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.QueryableCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.loader.OuterJoinLoader;
import net.sf.hibernate.persister.Joinable;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.persister.OuterJoinLoadable;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.Select;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;

public abstract class AbstractEntityLoader
extends OuterJoinLoader {
    private final OuterJoinLoadable persister;
    private CollectionPersister collectionPersister;
    private int collectionOwner;
    private String alias;

    public AbstractEntityLoader(OuterJoinLoadable persister, SessionFactoryImplementor factory) {
        super(factory.getDialect());
        this.persister = persister;
        this.alias = this.generateRootAlias(persister.getClassName());
    }

    protected final void renderStatement(List associations, String condition, SessionFactoryImplementor factory) throws MappingException {
        this.initStatementString(associations, condition, "", factory);
    }

    protected final void addAllToPropertySpaces(Serializable[] spaces) {
        for (int i = 0; i < spaces.length; ++i) {
            this.addToPropertySpaces(spaces[i]);
        }
    }

    protected void addToPropertySpaces(Serializable space) {
        throw new AssertionFailure("only criteria queries need to autoflush");
    }

    protected final void initClassPersisters(List associations) {
        int joins = AbstractEntityLoader.countClassPersisters(associations);
        this.collectionOwner = -1;
        this.classPersisters = new Loadable[joins + 1];
        this.owners = new int[joins + 1];
        this.lockModeArray = this.createLockModeArray(joins + 1, LockMode.NONE);
        int i = 0;
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinLoader.OuterJoinableAssociation oj = (OuterJoinLoader.OuterJoinableAssociation)iter.next();
            Joinable subpersister = oj.joinable;
            if (subpersister instanceof Loadable) {
                this.classPersisters[i] = (Loadable)((Object)subpersister);
                this.owners[i] = this.toOwner(oj, joins, oj.isOneToOne);
                if (oj.joinType == 0) {
                    this.addAllToPropertySpaces(this.classPersisters[i].getPropertySpaces());
                }
                ++i;
                continue;
            }
            QueryableCollection collPersister = (QueryableCollection)subpersister;
            if (oj.joinType == 1) {
                this.collectionPersister = collPersister;
                this.collectionOwner = this.toOwner(oj, joins, true);
            } else {
                this.addToPropertySpaces(collPersister.getCollectionSpace());
            }
            if (!collPersister.isOneToMany()) continue;
            this.classPersisters[i++] = (Loadable)collPersister.getElementPersister();
        }
        this.classPersisters[joins] = this.persister;
        this.owners[joins] = -1;
        if (ArrayHelper.isAllNegative(this.owners)) {
            this.owners = null;
        }
    }

    protected final void initStatementString(List associations, String condition, String orderBy, SessionFactoryImplementor factory) throws MappingException {
        int joins = AbstractEntityLoader.countClassPersisters(associations);
        this.suffixes = AbstractEntityLoader.generateSuffixes(joins + 1);
        JoinFragment ojf = this.mergeOuterJoins(associations);
        this.sql = new Select().setSelectClause(this.persister.selectFragment(this.alias, this.suffixes[joins]) + this.selectString(associations, factory)).setFromClause(this.persister.fromTableFragment(this.alias) + this.persister.fromJoinFragment(this.alias, true, true)).setWhereClause(condition).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + this.getWhereFragment()).setOrderByClause(orderBy).toStatementString();
    }

    protected String getWhereFragment() throws MappingException {
        return this.persister.whereJoinFragment(this.alias, true, true);
    }

    protected final Loadable getPersister() {
        return this.persister;
    }

    protected final void setAlias(String alias) {
        this.alias = alias;
    }

    protected final String getAlias() {
        return this.alias;
    }

    protected final CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    protected final int getCollectionOwner() {
        return this.collectionOwner;
    }

    protected boolean isJoinedFetchEnabled(Type type, boolean mappingDefault, String path, String table, String[] foreignKeyColumns) {
        return mappingDefault;
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.getPersister().getClassName();
    }
}

