/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.reflect.FastClass;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.InstantiationException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.PropertyAccessException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.property.Getter;
import net.sf.hibernate.property.PropertyAccessor;
import net.sf.hibernate.property.PropertyAccessorFactory;
import net.sf.hibernate.property.Setter;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;

public class ComponentType
extends AbstractType
implements AbstractComponentType {
    private final Class componentClass;
    private final Constructor constructor;
    private final Type[] propertyTypes;
    private final Getter[] getters;
    private final Setter[] setters;
    private final String[] propertyNames;
    private final int propertySpan;
    private final Cascades.CascadeStyle[] cascade;
    private final int[] joinedFetch;
    private final Setter parentSetter;
    private final Getter parentGetter;
    private final BulkBean optimizer;
    private final FastClass fastClass;

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        int[] sqlTypes = new int[this.getColumnSpan(mapping)];
        int n = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            int[] subtypes = this.propertyTypes[i].sqlTypes(mapping);
            for (int j = 0; j < subtypes.length; ++j) {
                sqlTypes[n++] = subtypes[j];
            }
        }
        return sqlTypes;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        int span = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            span += this.propertyTypes[i].getColumnSpan(mapping);
        }
        return span;
    }

    public ComponentType(Class componentClass, String[] propertyNames, Getter[] propertyGetters, Setter[] propertySetters, boolean foundCustomAccessor, Type[] propertyTypes, int[] joinedFetch, Cascades.CascadeStyle[] cascade, String parentProperty) throws MappingException {
        this.componentClass = componentClass;
        this.propertyTypes = propertyTypes;
        this.getters = propertyGetters;
        this.setters = propertySetters;
        this.propertySpan = propertyNames.length;
        String[] getterNames = new String[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        Class[] propTypes = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            propTypes[i] = this.getters[i].getReturnType();
        }
        if (parentProperty == null) {
            this.parentSetter = null;
            this.parentGetter = null;
        } else {
            PropertyAccessor pa = PropertyAccessorFactory.getPropertyAccessor(null);
            this.parentSetter = pa.getSetter(componentClass, parentProperty);
            this.parentGetter = pa.getGetter(componentClass, parentProperty);
        }
        this.propertyNames = propertyNames;
        this.cascade = cascade;
        this.joinedFetch = joinedFetch;
        this.constructor = ReflectHelper.getDefaultConstructor(componentClass);
        this.optimizer = !foundCustomAccessor && Environment.useReflectionOptimizer() ? ReflectHelper.getBulkBean(componentClass, getterNames, setterNames, propTypes) : null;
        this.fastClass = FastClass.create((Class)componentClass);
    }

    public final boolean isComponentType() {
        return true;
    }

    public Class getReturnedClass() {
        return this.componentClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        for (int i = 0; i < this.propertySpan; ++i) {
            if (this.propertyTypes[i].equals(this.getters[i].get(x), this.getters[i].get(y))) continue;
            return false;
        }
        return true;
    }

    public boolean isDirty(Object x, Object y, SessionImplementor session) throws HibernateException {
        if (x == y) {
            return false;
        }
        if (x == null || y == null) {
            return true;
        }
        for (int i = 0; i < this.getters.length; ++i) {
            if (!this.propertyTypes[i].isDirty(this.getters[i].get(x), this.getters[i].get(y), session)) continue;
            return true;
        }
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolveIdentifier(this.hydrate(rs, names, session, owner), session, owner);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int begin, SessionImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value);
        for (int i = 0; i < this.propertySpan; ++i) {
            this.propertyTypes[i].nullSafeSet(st, subvalues[i], begin, session);
            begin += this.propertyTypes[i].getColumnSpan(session.getFactory());
        }
    }

    private Object[] nullSafeGetValues(Object value) throws HibernateException {
        if (value == null) {
            return new Object[this.propertySpan];
        }
        return this.getPropertyValues(value);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public Object getPropertyValue(Object component, int i, SessionImplementor session) throws HibernateException {
        return this.getPropertyValue(component, i);
    }

    public Object getPropertyValue(Object component, int i) throws HibernateException {
        return this.getters[i].get(component);
    }

    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        return this.getPropertyValues(component);
    }

    public Object[] getPropertyValues(Object component) throws HibernateException {
        if (this.optimizer != null) {
            try {
                return this.optimizer.getPropertyValues(component);
            }
            catch (Throwable t) {
                throw new PropertyAccessException(t, "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", false, this.componentClass, ReflectHelper.getPropertyName(t, this.optimizer));
            }
        }
        Object[] values = new Object[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            values[i] = this.getPropertyValue(component, i);
        }
        return values;
    }

    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        if (this.optimizer != null) {
            try {
                this.optimizer.setPropertyValues(component, values);
                return;
            }
            catch (Throwable t) {
                throw new PropertyAccessException(t, "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", true, this.componentClass, ReflectHelper.getPropertyName(t, this.optimizer));
            }
        }
        for (int i = 0; i < this.propertySpan; ++i) {
            this.setters[i].set(component, values[i]);
        }
    }

    public Type[] getSubtypes() {
        return this.propertyTypes;
    }

    public String getName() {
        return this.componentClass.getName();
    }

    public String toString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return "null";
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Object[] values = this.getPropertyValues(value);
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            result.put(this.propertyNames[i], this.propertyTypes[i].toString(values[i], factory));
        }
        return StringHelper.unqualify(this.getName()) + ((Object)result).toString();
    }

    public Object fromString(String xml) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object deepCopy(Object component) throws HibernateException {
        if (component == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(component);
        for (int i = 0; i < this.propertySpan; ++i) {
            values[i] = this.propertyTypes[i].deepCopy(values[i]);
        }
        Object result = this.instantiate();
        this.setPropertyValues(result, values);
        if (this.parentGetter != null) {
            this.parentSetter.set(result, this.parentGetter.get(component));
        }
        return result;
    }

    public Object copy(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        if (original == null) {
            return null;
        }
        if (original == target) {
            return target;
        }
        Object result = target == null ? this.instantiate(owner, session) : target;
        Object[] values = TypeFactory.copy(this.getPropertyValues(original), this.getPropertyValues(result), this.propertyTypes, session, owner);
        this.setPropertyValues(result, values);
        return result;
    }

    private Object instantiate() throws HibernateException {
        if (this.optimizer != null) {
            try {
                return this.fastClass.newInstance();
            }
            catch (Throwable t) {
                throw new InstantiationException("Could not instantiate component with CGLIB: ", this.componentClass, t);
            }
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate component: ", this.componentClass, e);
        }
    }

    public Object instantiate(Object parent, SessionImplementor session) throws HibernateException {
        Object result = this.instantiate();
        if (this.parentSetter != null && parent != null) {
            this.parentSetter.set(result, session.proxyFor(parent));
        }
        return result;
    }

    public Cascades.CascadeStyle cascade(int i) {
        return this.cascade[i];
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(value);
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            values[i] = this.propertyTypes[i].disassemble(values[i], session);
        }
        return values;
    }

    public Object assemble(Serializable object, SessionImplementor session, Object owner) throws HibernateException {
        if (object == null) {
            return null;
        }
        Object[] values = (Object[])object;
        Object[] assembled = new Object[values.length];
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            assembled[i] = this.propertyTypes[i].assemble((Serializable)values[i], session, owner);
        }
        Object result = this.instantiate(owner, session);
        this.setPropertyValues(result, assembled);
        return result;
    }

    public boolean hasNiceEquals() {
        return false;
    }

    public int enableJoinedFetch(int i) {
        return this.joinedFetch[i];
    }

    public Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        int begin = 0;
        boolean notNull = false;
        Object[] values = new Object[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            int length = this.propertyTypes[i].getColumnSpan(session.getFactory());
            String[] range = ArrayHelper.slice(names, begin, length);
            Object val = this.propertyTypes[i].hydrate(rs, range, session, owner);
            if (val != null) {
                notNull = true;
            }
            values[i] = val;
            begin += length;
        }
        return notNull ? values : null;
    }

    public Object resolveIdentifier(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (value != null) {
            Object result = this.instantiate(owner, session);
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.propertyTypes[i].resolveIdentifier(values[i], session, owner);
            }
            this.setPropertyValues(result, values);
            return result;
        }
        return null;
    }

    public boolean isModified(Object old, Object current, SessionImplementor session) throws HibernateException {
        if (current == null) {
            return old != null;
        }
        if (old == null) {
            return current != null;
        }
        Object[] currentValues = this.getPropertyValues(current, session);
        Object[] oldValues = (Object[])old;
        for (int i = 0; i < currentValues.length; ++i) {
            if (!this.propertyTypes[i].isModified(oldValues[i], currentValues[i], session)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }
}

