/*
 * Decompiled with CFR 0.152.
 */
package OperationsEditor.dialog;

import OperationsEditor.DefaultOperation;
import OperationsEditor.dialog.SpringLayoutHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public final class OperationsDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -238767483230471330L;
    private static final String okayCommand = "okay";
    private static final String cancelCommand = "cancel";
    private static final String windowName = "MekWars Operations Editor";
    private static final int SHORT_OP = 0;
    private static final int LONG_OP = 0;
    private static final int SPECIAL_OP = 0;
    private int currentOpType = 0;
    private boolean shortOpScreenCreated = false;
    private String taskName = "";
    private DefaultOperation defaultOperationInfo = new DefaultOperation();
    private BackedTreeMap opValues;
    private final JTextField OperationColorText = new JTextField(10);
    private final JTextField OperationRangeText = new JTextField(10);
    private final JTextField PercentageToAttackOnWorldText = new JTextField(10);
    private final JTextField PercentageToAttackOffWorldText = new JTextField(10);
    private final JCheckBox OnlyAgainstFactoryWorldsCBox = new JCheckBox();
    private final JCheckBox OnlyAgainstNonFactoryWorldsCBox = new JCheckBox();
    private final JTextField MaxAttackerBVText = new JTextField(10);
    private final JTextField MinAttackerBVText = new JTextField(10);
    private final JTextField MaxDefenderBVText = new JTextField(10);
    private final JTextField MinDefenderBVText = new JTextField(10);
    private final JTextField MaxAttackerUnitsText = new JTextField(10);
    private final JTextField MinAttackerUnitsText = new JTextField(10);
    private final JTextField MaxDefenderUnitsText = new JTextField(10);
    private final JTextField MinDefenderUnitsText = new JTextField(10);
    private final JTextField MinAttackerWalkText = new JTextField(10);
    private final JTextField MinDefenderWalkText = new JTextField(10);
    private final JTextField MinAttackerJumpText = new JTextField(10);
    private final JTextField MinDefenderJumpText = new JTextField(10);
    private final JTextField MaxAttackerUnitTonnageText = new JTextField(10);
    private final JTextField MaxDefenderUnitTonnageText = new JTextField(10);
    private final JTextField MinAttackerUnitTonnageText = new JTextField(10);
    private final JTextField MinDefenderUnitTonnageText = new JTextField(10);
    private final JTextField MaxTotalAttackerTonnageText = new JTextField(10);
    private final JTextField MaxTotalDefenderTonnageText = new JTextField(10);
    private final JTextField MinTotalAttackerTonnageText = new JTextField(10);
    private final JTextField MinTotalDefenderTonnageText = new JTextField(10);
    private final JCheckBox AttackerAllowedMeksCBox = new JCheckBox();
    private final JCheckBox AttackerAllowedVehsCBox = new JCheckBox();
    private final JCheckBox AttackerAllowedInfCBox = new JCheckBox();
    private final JCheckBox DefenderAllowedMeksCBox = new JCheckBox();
    private final JCheckBox DefenderAllowedVehsCBox = new JCheckBox();
    private final JCheckBox DefenderAllowedInfCBox = new JCheckBox();
    private final JCheckBox PoweredInfAllowedCBox = new JCheckBox();
    private final JTextField AttackerCostMoneyText = new JTextField(10);
    private final JTextField AttackerCostInfluenceText = new JTextField(10);
    private final JTextField AttackerCostRewardText = new JTextField(10);
    private final JTextField DefenderCostMoneyText = new JTextField(10);
    private final JTextField DefenderCostInfluenceText = new JTextField(10);
    private final JTextField DefenderCostRewardText = new JTextField(10);
    private final JTextField MinAttackerRatingText = new JTextField(10);
    private final JTextField MaxAttackerRatingText = new JTextField(10);
    private final JTextField MinDefenderRatingText = new JTextField(10);
    private final JTextField MaxDefenderRatingText = new JTextField(10);
    private final JTextField MinAttackerXPText = new JTextField(10);
    private final JTextField MaxAttackerXPText = new JTextField(10);
    private final JTextField MinDefenderXPText = new JTextField(10);
    private final JTextField MaxDefenderXPText = new JTextField(10);
    private final JTextField MinAttackerGamesPlayedText = new JTextField(10);
    private final JTextField MaxAttackerGamesPlayedText = new JTextField(10);
    private final JTextField MinDefenderGamesPlayedText = new JTextField(10);
    private final JTextField MaxDefenderGamesPlayedText = new JTextField(10);
    private final JCheckBox DefenderReceivesAutoArtilleryCBox = new JCheckBox();
    private final JCheckBox AttackerReceivesAutoArtilleryCBox = new JCheckBox();
    private final JTextField DefenderFlatArtilleryModifierText = new JTextField(10);
    private final JTextField AttackerFlatArtilleryModifierText = new JTextField(10);
    private final JTextField DefenderPercentArtilleryModifierText = new JTextField(10);
    private final JTextField AttackerPercentArtilleryModifierText = new JTextField(10);
    private final JTextField MinDefenderArtilleryBVText = new JTextField(10);
    private final JTextField MinAttackerArtilleryBVText = new JTextField(10);
    private final JTextField MaxDefenderArtilleryBVText = new JTextField(10);
    private final JTextField MaxAttackerArtilleryBVText = new JTextField(10);
    private final JTextField BaseAttackerPayCBillsText = new JTextField(10);
    private final JTextField BaseDefenderPayCBillsText = new JTextField(10);
    private final JTextField BaseAttackerPayInfluenceText = new JTextField(10);
    private final JTextField BaseDefenderPayInfluenceText = new JTextField(10);
    private final JTextField BaseAttackerPayExperienceText = new JTextField(10);
    private final JTextField BaseDefenderPayExperienceText = new JTextField(10);
    private final JTextField AttackerPayBVforCBillText = new JTextField(10);
    private final JTextField DefenderPayBVforCBillText = new JTextField(10);
    private final JTextField AttackerPayBVforInfluenceText = new JTextField(10);
    private final JTextField DefenderPayBVforInfluenceText = new JTextField(10);
    private final JTextField AttackerPayBVforExperienceText = new JTextField(10);
    private final JTextField DefenderPayBVforExperienceText = new JTextField(10);
    private final JTextField AttackerWinModifierCBillsFlatText = new JTextField(10);
    private final JTextField DefenderWinModifierCBillsFlatText = new JTextField(10);
    private final JTextField AttackerLossModifierCBillsFlatText = new JTextField(10);
    private final JTextField DefenderLossModifierCBillsFlatText = new JTextField(10);
    private final JTextField AttackerWinModifierCBillsPercentText = new JTextField(10);
    private final JTextField DefenderWinModifierCBillsPercentText = new JTextField(10);
    private final JTextField AttackerLossModifierCBillsPercentText = new JTextField(10);
    private final JTextField DefenderLossModifierCBillsPercentText = new JTextField(10);
    private final JTextField AttackerWinModifierInfluenceFlatText = new JTextField(10);
    private final JTextField DefenderWinModifierInfluenceFlatText = new JTextField(10);
    private final JTextField AttackerLossModifierInfluenceFlatText = new JTextField(10);
    private final JTextField DefenderLossModifierInfluenceFlatText = new JTextField(10);
    private final JTextField AttackerWinModifierInfluencePercentText = new JTextField(10);
    private final JTextField DefenderWinModifierInfluencePercentText = new JTextField(10);
    private final JTextField AttackerLossModifierInfluencePercentText = new JTextField(10);
    private final JTextField DefenderLossModifierInfluencePercentText = new JTextField(10);
    private final JTextField AttackerWinModifierExperienceFlatText = new JTextField(10);
    private final JTextField DefenderWinModifierExperienceFlatText = new JTextField(10);
    private final JTextField AttackerLossModifierExperienceFlatText = new JTextField(10);
    private final JTextField DefenderLossModifierExperienceFlatText = new JTextField(10);
    private final JTextField AttackerWinModifierExperiencePercentText = new JTextField(10);
    private final JTextField DefenderWinModifierExperiencePercentText = new JTextField(10);
    private final JTextField AttackerLossModifierExperiencePercentText = new JTextField(10);
    private final JTextField DefenderLossModifierExperiencePercentText = new JTextField(10);
    private final JTextField RPForLoserText = new JTextField(0);
    private final JTextField RPForDefenderText = new JTextField(10);
    private final JTextField RPForAttackerText = new JTextField(10);
    private final JTextField RPForWinnerText = new JTextField(0);
    private final JCheckBox OnlyGiveRPtoWinnersCBox = new JCheckBox();
    private final JCheckBox WinnerAlwaysSalvagesOwnUnitsCBox = new JCheckBox();
    private final JTextField BaseAttackerSalvagePercentText = new JTextField(10);
    private final JTextField BaseDefenderSalvagePercentText = new JTextField(10);
    private final JTextField AttackerSalvageAdjustmentText = new JTextField(10);
    private final JTextField DefenderSalvageAdjustmentText = new JTextField(10);
    private final JTextField BVToBoostAttackerSalvageCostText = new JTextField(10);
    private final JTextField BVToBoostDefenderSalvageCostText = new JTextField(10);
    private final JTextField AttackerSalvageCostModifierText = new JTextField(10);
    private final JTextField DefenderSalvageCostModifierText = new JTextField(10);
    private final JCheckBox AllowSOLToUseCBox = new JCheckBox();
    private final JCheckBox AllowAgainstSOLCBox = new JCheckBox();
    private final JCheckBox AllowAgainstNonConqCBox = new JCheckBox();
    private final JCheckBox AllowNonConqToUseCBox = new JCheckBox();
    private final JCheckBox SOLPilotsGainXPCBox = new JCheckBox();
    private final JCheckBox HousePilotsGainXPCBox = new JCheckBox();
    private final JCheckBox SOLPilotsCheckLevelUpCBox = new JCheckBox();
    private final JCheckBox HousePilotsCheckLevelUpCBox = new JCheckBox();
    private final JCheckBox PayAllAsWinnersCBox = new JCheckBox();
    private final JCheckBox CountGameForRankingCBox = new JCheckBox();
    private final JTextField CountGameForProductionText = new JTextField(10);
    private final JCheckBox PayTechsForGameCBox = new JCheckBox();
    private final JCheckBox NoStatisticsModeCBox = new JCheckBox();
    private final JCheckBox NoDestructionModeCBox = new JCheckBox();
    private final JTextField AttackerBaseConquestAmountText = new JTextField(10);
    private final JTextField AttackerConquestBVAdjustmentText = new JTextField(10);
    private final JTextField AttackerConquestUnitAdjustmentText = new JTextField(10);
    private final JTextField DefenderBaseConquestAmountText = new JTextField(10);
    private final JTextField DefenderConquestBVAdjustmentText = new JTextField(10);
    private final JTextField DefenderConquestUnitAdjustmentText = new JTextField(10);
    private final JTextField AttackerBaseDelayAmountText = new JTextField(10);
    private final JTextField AttackerDelayBVAdjustmentText = new JTextField(10);
    private final JTextField AttackerDelayUnitAdjustmentText = new JTextField(10);
    private final JTextField DefenderBaseDelayAmountText = new JTextField(10);
    private final JTextField DefenderDelayBVAdjustmentText = new JTextField(10);
    private final JTextField DefenderDelayUnitAdjustmentText = new JTextField(10);
    private final JTextField AttackerBasePPAmountText = new JTextField(10);
    private final JTextField AttackerPPBVAdjustmentText = new JTextField(10);
    private final JTextField AttackerPPUnitAdjustmentText = new JTextField(10);
    private final JTextField DefenderBasePPAmountText = new JTextField(10);
    private final JTextField DefenderPPBVAdjustmentText = new JTextField(10);
    private final JTextField DefenderPPUnitAdjustmentText = new JTextField(10);
    private final JTextField AttackerBaseUnitsTakenText = new JTextField(10);
    private final JTextField AttackerUnitsBVAdjustmentText = new JTextField(10);
    private final JTextField AttackerUnitsUnitAdjustmentText = new JTextField(10);
    private final JTextField AttackerTargetOpAdjustmentText = new JTextField(10);
    private final JTextField DefenderTargetOpAdjustmentText = new JTextField(10);
    private final JTextField ConquestAmountCapText = new JTextField(10);
    private final JTextField DelayAmountCapText = new JTextField(10);
    private final JTextField PPCapptureCapText = new JTextField(10);
    private final JTextField UnitCaptureCapText = new JTextField(10);
    private final JTextField TimeToNondefensePenaltyText = new JTextField(10);
    private final JTextField LeechesToDeactivateText = new JTextField(10);
    private final JTextField FlatRPChickenPenaltyText = new JTextField(10);
    private final JTextField FlatExpChickenPenaltyText = new JTextField(10);
    private final JTextField FlatInfluenceChickenPenaltyText = new JTextField(10);
    private final JTextField FlatCBillChickenPenaltyText = new JTextField(10);
    private final JTextField PercentRPChickenPenaltyText = new JTextField(10);
    private final JTextField PercentExpChickenPenaltyText = new JTextField(10);
    private final JTextField PercentInfluenceChickenPenaltyText = new JTextField(10);
    private final JTextField PercentCBillChickenPenaltyText = new JTextField(10);
    private final JTextField ConquestPerLeechText = new JTextField(10);
    private final JTextField DelayPerLeechText = new JTextField(10);
    private final JTextField ProdPointsPerLeechText = new JTextField(10);
    private final JTextField UnitsPerLeechText = new JTextField(10);
    private final JTextField FailurePenaltyText = new JTextField(10);
    private final JTextField BaseUnitXPText = new JTextField(10);
    private final JTextField UnitXPUnitsAdjustmentText = new JTextField(10);
    private final JTextField UnitXPBVAdjustmentText = new JTextField(10);
    private final JTextField WinnerBonusUnitXPText = new JTextField(10);
    private final JTextField DefenderBonusUnitXPText = new JTextField(10);
    private final JTextField KillBonusUnitXPText = new JTextField(10);
    private final JTextField KillBonusXPforBVText = new JTextField(10);
    private final JTextField TotalBuildingsText = new JTextField(10);
    private final JTextField MinBuildingsForOpText = new JTextField(10);
    private final JTextField MinFloorsText = new JTextField(10);
    private final JTextField MaxFloorsText = new JTextField(10);
    private final JTextField MinCFText = new JTextField(10);
    private final JTextField MaxCFText = new JTextField(10);
    private final JTextField BuildingTypeText = new JTextField(10);
    private final JCheckBox BuildingsStartOnMapEdgeCBox = new JCheckBox();
    private final JTextField DelayPerBuildingText = new JTextField(10);
    private final JTextField AttackerExpPerBuildingText = new JTextField(10);
    private final JTextField AttackerFluPerBuildingText = new JTextField(10);
    private final JTextField AttackerRPPerBuildingText = new JTextField(10);
    private final JTextField AttackerMoneyPerBuildingText = new JTextField(10);
    private final JTextField AttackerMinBuildingsIfAttackerWinsText = new JTextField(10);
    private final JTextField DefenderExpPerBuildingText = new JTextField(10);
    private final JTextField DefenderFluPerBuildingText = new JTextField(10);
    private final JTextField DefenderRPPerBuildingText = new JTextField(10);
    private final JTextField DefenderMoneyPerBuildingText = new JTextField(10);
    private final JButton okayButton = new JButton("Save");
    private final JButton cancelButton = new JButton("Cancel");
    private String filePathName = "./data/operations";
    private JOptionPane pane;
    private JScrollPane scrollPane;
    JPanel contentPane;
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public OperationsDialog() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenu createMenu = new JMenu();
        JMenu loadMenu = new JMenu();
        fileMenu.setText("File");
        fileMenu.setMnemonic('F');
        createMenu.setText("New");
        createMenu.setMnemonic('N');
        loadMenu.setText("Load");
        loadMenu.setMnemonic('L');
        fileMenu.add(createMenu);
        fileMenu.add(loadMenu);
        menuBar.add(fileMenu);
        menuBar.setVisible(true);
        JMenuItem item = new JMenuItem("Short Operation");
        item.setMnemonic('S');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuLoadShortOp_actionPerformed(e);
            }
        });
        loadMenu.add(item);
        item = new JMenuItem("Long Operation");
        item.setMnemonic('L');
        item.setEnabled(false);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuLoadLongOp_actionPerformed(e);
            }
        });
        loadMenu.add(item);
        item = new JMenuItem("Special Operation");
        item.setMnemonic('p');
        item.setEnabled(false);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuLoadSpecialOp_actionPerformed(e);
            }
        });
        loadMenu.add(item);
        item = new JMenuItem("Short Operation");
        item.setMnemonic('S');
        item.setEnabled(true);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuCreateShortOp_actionPerformed(e);
            }
        });
        createMenu.add(item);
        item = new JMenuItem("Long Operation");
        item.setMnemonic('L');
        item.setEnabled(false);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuCreateLongOp_actionPerformed(e);
            }
        });
        createMenu.add(item);
        item = new JMenuItem("Special Operation");
        item.setMnemonic('p');
        item.setEnabled(false);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationsDialog.this.jMenuCreateSpecialOp_actionPerformed(e);
            }
        });
        createMenu.add(item);
        createMenu.add(item);
        this.setResizable(true);
        this.setSize(new Dimension(640, 480));
        this.setExtendedState(0);
        this.setTitle(windowName);
        File shortDir = new File("./data/operations/short/");
        File longDir = new File("./data/operations/long/");
        File modDir = new File("./data/operations/modifiers/");
        try {
            if (!shortDir.exists()) {
                shortDir.mkdirs();
            }
            if (!longDir.exists()) {
                longDir.mkdir();
            }
            if (!modDir.exists()) {
                modDir.mkdir();
            }
        }
        catch (Exception e) {
            System.err.println("Error while creating operations directories.");
            System.exit(1);
        }
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save Options");
        this.cancelButton.setToolTipText("Exit without saving options");
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.setJMenuBar(menuBar);
        this.pane = new JOptionPane(this.ConfigPane, -1, -1, null, options, null);
        this.pane.setVisible(false);
        this.scrollPane = new JScrollPane(this.pane, 20, 30);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.scrollPane, "Center");
        this.repaint();
        this.setLocation(this.getLocation().x + 10, this.getLocation().y);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            if (this.currentOpType == 0) {
                this.saveShortOperations();
            }
        } else if (command.equals(cancelCommand)) {
            System.exit(0);
        }
    }

    public void jMenuLoadShortOp_actionPerformed(ActionEvent e) {
        this.currentOpType = 0;
        this.initShortOpVars();
        this.loadShortOp();
        if (!this.shortOpScreenCreated) {
            this.createShortOpPanel();
        }
    }

    public void jMenuLoadLongOp_actionPerformed(ActionEvent e) {
        this.currentOpType = 0;
    }

    public void jMenuLoadSpecialOp_actionPerformed(ActionEvent e) {
        this.currentOpType = 0;
    }

    public void jMenuCreateShortOp_actionPerformed(ActionEvent e) {
        this.taskName = JOptionPane.showInputDialog(null, "Operation Name", "New Operation Name", 2);
        if (this.taskName.length() == 0 || this.taskName == null) {
            return;
        }
        this.defaultOperationInfo = new DefaultOperation();
        this.initShortOpVars();
        this.currentOpType = 0;
        this.setTitle("MekWars Operations Editor (" + this.taskName + ")");
        this.filePathName = "./data/operations/short/" + this.taskName + ".txt";
        if (!this.shortOpScreenCreated) {
            this.createShortOpPanel();
        }
    }

    public void jMenuCreateLongOp_actionPerformed(ActionEvent e) {
        this.currentOpType = 0;
    }

    public void jMenuCreateSpecialOp_actionPerformed(ActionEvent e) {
        this.currentOpType = 0;
    }

    public void createShortOpPanel() {
        JPanel rangePanel = new JPanel();
        JPanel unitsPanel = new JPanel();
        JPanel costsPanel = new JPanel();
        JPanel playerPropertiesPanel = new JPanel();
        JPanel scenarioPanel = new JPanel();
        JPanel opresultsPanel = new JPanel();
        JPanel salvagePanel = new JPanel();
        JPanel newbieOpsPanel = new JPanel();
        JPanel metaSetupPanel = new JPanel();
        JPanel chickenLeechPanel = new JPanel();
        JPanel pilotExpPanel = new JPanel();
        JPanel buildingsPanel = new JPanel();
        this.ConfigPane = new JTabbedPane();
        this.shortOpScreenCreated = true;
        JPanel rangesBox = new JPanel(new SpringLayout());
        rangesBox.add(new JLabel("Operation Color:", 11));
        this.OperationColorText.setToolTipText("html or hex color for an op");
        rangesBox.add(this.OperationColorText);
        rangesBox.add(new JLabel("Operation Range:", 11));
        this.OperationRangeText.setToolTipText("One Jump");
        rangesBox.add(this.OperationRangeText);
        rangesBox.add(new JLabel("% To Attack On World:", 11));
        this.PercentageToAttackOnWorldText.setToolTipText("<Html>Min Percent needed by a faction to launch this operation aginst<br>this world from on the world itself.</html>");
        rangesBox.add(this.PercentageToAttackOnWorldText);
        rangesBox.add(new JLabel("% to Attack Off World:", 11));
        this.PercentageToAttackOffWorldText.setToolTipText("<Html>Min Percent needed by a faction to launch this operation aginst<br>another world from this world.</html>");
        rangesBox.add(this.PercentageToAttackOffWorldText);
        this.OnlyAgainstFactoryWorldsCBox.setText("Must Have Fac");
        this.OnlyAgainstFactoryWorldsCBox.setToolTipText("<html>If checked, attack type may only be used against<br>a world which has a production facility.</html>");
        rangesBox.add(this.OnlyAgainstFactoryWorldsCBox);
        this.OnlyAgainstNonFactoryWorldsCBox.setText("May Not Have Fac");
        this.OnlyAgainstNonFactoryWorldsCBox.setToolTipText("<html>If checked, attack type may only be used against<br>a world which has NO production facilities.</html>");
        rangesBox.add(this.OnlyAgainstNonFactoryWorldsCBox);
        SpringLayoutHelper.setupSpringGrid(rangesBox, 5, 2);
        rangePanel.add(rangesBox);
        JPanel unitBox = new JPanel();
        JPanel masterBox = new JPanel();
        unitBox.setLayout(new BoxLayout(unitBox, 0));
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        JPanel attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        JPanel defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        JPanel poweredInfPanel = new JPanel();
        JPanel attackerPanel = new JPanel(new SpringLayout());
        JPanel attackerCBoxPanel = new JPanel(new SpringLayout());
        JPanel defenderPanel = new JPanel(new SpringLayout());
        JPanel defenderCBoxPanel = new JPanel(new SpringLayout());
        this.PoweredInfAllowedCBox.setText("Allow Powered Infantry Only");
        this.PoweredInfAllowedCBox.setToolTipText("<html>Overrides Attacker Allowed Infantry and<br> Defender Allowed Infantry for BA and Protos.<br>Set the inf allows to False and this to True to ban<br>foot/jump/moto inf but allow BA and Protos.<br>This is ignored if attacker/defender has allows is set to true.</html>");
        poweredInfPanel.add(this.PoweredInfAllowedCBox);
        this.AttackerAllowedMeksCBox.setText("Allow Meks");
        this.AttackerAllowedMeksCBox.setToolTipText("Allow meks in this operation for the attacker");
        attackerCBoxPanel.add(this.AttackerAllowedMeksCBox);
        this.AttackerAllowedVehsCBox.setText("Allow Veh");
        this.AttackerAllowedVehsCBox.setToolTipText("Allow Vehciles in this operation for the attacker");
        attackerCBoxPanel.add(this.AttackerAllowedVehsCBox);
        this.AttackerAllowedInfCBox.setText("Allow Inf");
        this.AttackerAllowedInfCBox.setToolTipText("Allow Infantry in this operation for the attacker");
        attackerCBoxPanel.add(this.AttackerAllowedInfCBox);
        SpringLayoutHelper.setupSpringGrid(attackerCBoxPanel, 1, 3);
        attackerPanel.add(new JLabel("Max BV:", 11));
        this.MaxAttackerBVText.setToolTipText("Max BV for the Attackers Army");
        attackerPanel.add(this.MaxAttackerBVText);
        attackerPanel.add(new JLabel("Min BV:", 11));
        this.MinAttackerBVText.setToolTipText("Min BV for the Attackers Army");
        attackerPanel.add(this.MinAttackerBVText);
        attackerPanel.add(new JLabel("Max Units:", 11));
        this.MaxAttackerUnitsText.setToolTipText("Max number of units in the attackers army");
        attackerPanel.add(this.MaxAttackerUnitsText);
        attackerPanel.add(new JLabel("Min Units:", 11));
        this.MinAttackerUnitsText.setToolTipText("Min number of units in the attackers army");
        attackerPanel.add(this.MinAttackerUnitsText);
        attackerPanel.add(new JLabel("Min Walk:", 11));
        this.MinAttackerWalkText.setToolTipText("<html>Min number of movement points, i.e. Walking,<br>that any unit in the attackers army can have<br>to participate in this operation</html>");
        attackerPanel.add(this.MinAttackerWalkText);
        attackerPanel.add(new JLabel("Min Jump:", 11));
        this.MinAttackerJumpText.setToolTipText("<html>Min number of jump points<br>that any unit in the attackers army can have<br>to participate in this operation</html>");
        attackerPanel.add(this.MinAttackerJumpText);
        attackerPanel.add(new JLabel("Max Unit Tons:", 11));
        this.MaxAttackerUnitTonnageText.setToolTipText("Max Tons any unit in the attackers army can have for this op");
        attackerPanel.add(this.MaxAttackerUnitTonnageText);
        attackerPanel.add(new JLabel("Min Unit Tons:", 11));
        this.MinAttackerUnitTonnageText.setToolTipText("Min Tons any unit in the attackers army maybe for this op");
        attackerPanel.add(this.MinAttackerUnitTonnageText);
        attackerPanel.add(new JLabel("Max Total Tons:", 11));
        this.MaxTotalAttackerTonnageText.setToolTipText("Max Total Tonnage for an army to run this op");
        attackerPanel.add(this.MaxTotalAttackerTonnageText);
        attackerPanel.add(new JLabel("Min Total Tons:", 11));
        this.MinTotalAttackerTonnageText.setToolTipText("Min Total Tonnage for an army to run this op");
        attackerPanel.add(this.MinTotalAttackerTonnageText);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 5, 4);
        this.DefenderAllowedMeksCBox.setToolTipText("Allow Defender to use Meks in this op");
        this.DefenderAllowedMeksCBox.setText("Allow Meks");
        defenderCBoxPanel.add(this.DefenderAllowedMeksCBox);
        this.DefenderAllowedVehsCBox.setToolTipText("Allow Defender to use Vehicles in this Op");
        this.DefenderAllowedVehsCBox.setText("Allow Veh");
        defenderCBoxPanel.add(this.DefenderAllowedVehsCBox);
        this.DefenderAllowedInfCBox.setToolTipText("Allow Defender to use infantry in this Op");
        this.DefenderAllowedInfCBox.setText("Allow Inf");
        defenderCBoxPanel.add(this.DefenderAllowedInfCBox);
        SpringLayoutHelper.setupSpringGrid(defenderCBoxPanel, 1, 3);
        defenderPanel.add(new JLabel("Max BV:", 11));
        this.MaxDefenderBVText.setToolTipText("Max BV the defenders army can be for this Op");
        defenderPanel.add(this.MaxDefenderBVText);
        defenderPanel.add(new JLabel("Min BV:", 11));
        this.MinDefenderBVText.setToolTipText("Min BV the defenders army can be for this Op");
        defenderPanel.add(this.MinDefenderBVText);
        defenderPanel.add(new JLabel("Max Units:", 11));
        this.MaxDefenderUnitsText.setToolTipText("Max Number of Units a Defender my use in this op");
        defenderPanel.add(this.MaxDefenderUnitsText);
        defenderPanel.add(new JLabel("Min Units:", 11));
        this.MinDefenderUnitsText.setToolTipText("Min number of units a defender must use in this op");
        defenderPanel.add(this.MinDefenderUnitsText);
        defenderPanel.add(new JLabel("Min Walk:", 11));
        this.MinDefenderWalkText.setToolTipText("<html>Min number of movement points, i.e. Walking,<br>that any unit in the defenders army can have<br>to participate in this operation</html>");
        defenderPanel.add(this.MinDefenderWalkText);
        defenderPanel.add(new JLabel("Min Jump:", 11));
        this.MinDefenderJumpText.setToolTipText("<html>Min number of jump points<br>that any unit in the defenders army can have<br>to participate in this operation</html>");
        defenderPanel.add(this.MinDefenderJumpText);
        defenderPanel.add(new JLabel("Max Unit Tons:", 11));
        this.MaxDefenderUnitTonnageText.setToolTipText("Max Tonnage any unit in the defenders army may have for this op");
        defenderPanel.add(this.MaxDefenderUnitTonnageText);
        defenderPanel.add(new JLabel("Min Unit Tons", 11));
        this.MinDefenderUnitTonnageText.setToolTipText("Min tonnage any unit in the defeneders army may have for this op");
        defenderPanel.add(this.MinDefenderUnitTonnageText);
        defenderPanel.add(new JLabel("Max Total Tons", 11));
        this.MaxTotalDefenderTonnageText.setToolTipText("Max Tonnage for the defenders army for this op");
        defenderPanel.add(this.MaxTotalDefenderTonnageText);
        defenderPanel.add(new JLabel("Min Total Tons", 11));
        this.MinTotalDefenderTonnageText.setToolTipText("Min Total the defenders army may have for this op");
        defenderPanel.add(this.MinTotalDefenderTonnageText);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 5, 4);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerCBoxPanel);
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderCBoxPanel);
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        unitBox.add(attackerBox);
        unitBox.add(defenderBox);
        masterBox.add(poweredInfPanel);
        masterBox.add(unitBox);
        unitsPanel.add(masterBox);
        JPanel costBox = new JPanel();
        costBox.setLayout(new BoxLayout(costBox, 0));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        attackerPanel.add(new JLabel("Cost Money:", 11));
        this.AttackerCostMoneyText.setToolTipText("What it costs the attacker, in money, to preform this op");
        attackerPanel.add(this.AttackerCostMoneyText);
        attackerPanel.add(new JLabel("Cost Flu:", 11));
        this.AttackerCostInfluenceText.setToolTipText("What it costs the attacker, in flu, to preform this op");
        attackerPanel.add(this.AttackerCostInfluenceText);
        attackerPanel.add(new JLabel("Cost Rewards:", 11));
        this.AttackerCostRewardText.setToolTipText("What it costs the attacker, in reward points, to preform this op");
        attackerPanel.add(this.AttackerCostRewardText);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 3, 2);
        defenderPanel.add(new JLabel("Cost Money:", 11));
        this.DefenderCostMoneyText.setToolTipText("What it costs the defender, in money, to preform this op");
        defenderPanel.add(this.DefenderCostMoneyText);
        defenderPanel.add(new JLabel("Cost Flu:", 11));
        this.DefenderCostInfluenceText.setToolTipText("What it costs the defender, in flu, to preform this op");
        defenderPanel.add(this.DefenderCostInfluenceText);
        defenderPanel.add(new JLabel("Cost Rewards:", 11));
        this.DefenderCostRewardText.setToolTipText("What it costs the defender, in reward points, to preform this op");
        defenderPanel.add(this.DefenderCostRewardText);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 3, 2);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        costBox.add(attackerBox);
        costBox.add(defenderBox);
        costsPanel.add(costBox);
        JPanel playerPropertiesBox = new JPanel();
        playerPropertiesBox.setLayout(new BoxLayout(playerPropertiesBox, 0));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        attackerPanel.add(new JLabel("Min Rating:", 11));
        this.MinAttackerRatingText.setToolTipText("Min Rating Attacker must have for this op");
        attackerPanel.add(this.MinAttackerRatingText);
        attackerPanel.add(new JLabel("Max Rating:", 11));
        this.MaxAttackerRatingText.setToolTipText("Max Rating Attacker must have for this op");
        attackerPanel.add(this.MaxAttackerRatingText);
        attackerPanel.add(new JLabel("Min Exp:", 11));
        this.MinAttackerXPText.setToolTipText("Min Exp Attacker must have for this op");
        attackerPanel.add(this.MinAttackerXPText);
        attackerPanel.add(new JLabel("Max Exp:", 11));
        this.MaxAttackerXPText.setToolTipText("Max Exp Attacker must have for this op");
        attackerPanel.add(this.MaxAttackerXPText);
        attackerPanel.add(new JLabel("Min Games:", 11));
        this.MinAttackerGamesPlayedText.setToolTipText("Min Games Attacker must have played for this op");
        attackerPanel.add(this.MinAttackerGamesPlayedText);
        attackerPanel.add(new JLabel("Max Games:", 11));
        this.MaxAttackerGamesPlayedText.setToolTipText("Max Games Attacker must have played for this op");
        attackerPanel.add(this.MaxAttackerGamesPlayedText);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 6, 2);
        defenderPanel.add(new JLabel("Min Rating:", 11));
        this.MinDefenderRatingText.setToolTipText("Min Rating Defender must have for this op");
        defenderPanel.add(this.MinDefenderRatingText);
        defenderPanel.add(new JLabel("Max Rating:", 11));
        this.MaxDefenderRatingText.setToolTipText("Max Rating Defender must have for this op");
        defenderPanel.add(this.MaxDefenderRatingText);
        defenderPanel.add(new JLabel("Min Exp:", 11));
        this.MinDefenderXPText.setToolTipText("Min Exp Defender must have for this op");
        defenderPanel.add(this.MinDefenderXPText);
        defenderPanel.add(new JLabel("Max Exp:", 11));
        this.MaxDefenderXPText.setToolTipText("Max Exp Defender must have for this op");
        defenderPanel.add(this.MaxDefenderXPText);
        defenderPanel.add(new JLabel("Min Games:", 11));
        this.MinDefenderGamesPlayedText.setToolTipText("Min Games Defender must have played for this op");
        defenderPanel.add(this.MinDefenderGamesPlayedText);
        defenderPanel.add(new JLabel("Max Games:", 11));
        this.MaxDefenderGamesPlayedText.setToolTipText("Max Games Defender must have played for this op");
        defenderPanel.add(this.MaxDefenderGamesPlayedText);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 6, 2);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        playerPropertiesBox.add(attackerBox);
        playerPropertiesBox.add(defenderBox);
        playerPropertiesPanel.add(playerPropertiesBox);
        JPanel scenarioBox = new JPanel();
        scenarioBox.setLayout(new BoxLayout(scenarioBox, 0));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        attackerPanel.add(new JLabel("Flat Artillery:", 11));
        this.AttackerFlatArtilleryModifierText.setToolTipText("Amount of BV to shift attacker");
        attackerPanel.add(this.AttackerFlatArtilleryModifierText);
        attackerPanel.add(new JLabel("Perecent Artillery:", 11));
        this.AttackerPercentArtilleryModifierText.setToolTipText("% adjustment to relative assignment BV");
        attackerPanel.add(this.AttackerPercentArtilleryModifierText);
        attackerPanel.add(new JLabel("Min BV Artillery:", 11));
        this.MinAttackerArtilleryBVText.setToolTipText("<html>Min BV to be presumed for attack/defender player<br>hen assigning autoartillery. Floor for modifiers.</html>");
        attackerPanel.add(this.MinAttackerArtilleryBVText);
        attackerPanel.add(new JLabel("Max BV Artillery:", 11));
        this.MaxAttackerArtilleryBVText.setToolTipText("<html>Max BV to be presumed for attack/def player when<br>assigning artillery. Ceiling for modifiers.</html>");
        attackerPanel.add(this.MaxAttackerArtilleryBVText);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 4, 2);
        defenderPanel.add(new JLabel("Flat Artillery:", 11));
        this.DefenderFlatArtilleryModifierText.setToolTipText("Amount of BV to shift defender");
        defenderPanel.add(this.DefenderFlatArtilleryModifierText);
        defenderPanel.add(new JLabel("Perecent Artillery:", 11));
        this.DefenderPercentArtilleryModifierText.setToolTipText("% adjustment to relative assignment BV");
        defenderPanel.add(this.DefenderPercentArtilleryModifierText);
        defenderPanel.add(new JLabel("Min BV Artillery:", 11));
        this.MinDefenderArtilleryBVText.setToolTipText("<html>Min BV to be presumed for defend/defender player<br>hen assigning autoartillery. Floor for modifiers.</html>");
        defenderPanel.add(this.MinDefenderArtilleryBVText);
        defenderPanel.add(new JLabel("Max BV Artillery:", 11));
        this.MaxDefenderArtilleryBVText.setToolTipText("<html>Max BV to be presumed for defend/def player when<br>assigning artillery. Ceiling for modifiers.</html>");
        defenderPanel.add(this.MaxDefenderArtilleryBVText);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 4, 2);
        attackerBox.add(new JLabel("Attacker"));
        this.AttackerReceivesAutoArtilleryCBox.setText("Recieves Artillery");
        this.AttackerReceivesAutoArtilleryCBox.setToolTipText("<html>If true, attack players will receive<br>normal autoartillery. Set false to make the<br>grant lopsided.</html>");
        attackerBox.add(this.AttackerReceivesAutoArtilleryCBox);
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        this.DefenderReceivesAutoArtilleryCBox.setText("Recieves Artillery");
        this.DefenderReceivesAutoArtilleryCBox.setToolTipText("<html>If true, defend players will receive<br>normal autoartillery. Set false to make the<br>grant lopsided.</html>");
        defenderBox.add(this.DefenderReceivesAutoArtilleryCBox);
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        scenarioBox.add(attackerBox);
        scenarioBox.add(defenderBox);
        scenarioPanel.add(scenarioBox);
        JPanel opResultsBox = new JPanel();
        opResultsBox.setLayout(new BoxLayout(opResultsBox, 0));
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        JPanel outcomeBox = new JPanel();
        outcomeBox.setLayout(new BoxLayout(outcomeBox, 1));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        JPanel outcomePanel = new JPanel(new SpringLayout());
        attackerPanel.add(new JLabel("Money Paid:", 11));
        this.BaseAttackerPayCBillsText.setToolTipText("flat amount attacker is paid for participating");
        attackerPanel.add(this.BaseAttackerPayCBillsText);
        attackerPanel.add(new JLabel("Flu Paid:", 11));
        this.BaseAttackerPayInfluenceText.setToolTipText("flat amount attacker is paid for participating");
        attackerPanel.add(this.BaseAttackerPayInfluenceText);
        attackerPanel.add(new JLabel("Exp Paid:", 11));
        this.BaseAttackerPayExperienceText.setToolTipText("flat amount attacker is paid for participating");
        attackerPanel.add(this.BaseAttackerPayExperienceText);
        attackerPanel.add(new JLabel("Money per BV:", 11));
        this.AttackerPayBVforCBillText.setToolTipText("<html>1 CBill added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 Cbills to pay</html>");
        attackerPanel.add(this.AttackerPayBVforCBillText);
        attackerPanel.add(new JLabel("Flu per BV:", 11));
        this.AttackerPayBVforInfluenceText.setToolTipText("<html>1 flu added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 flu to pay</html>");
        attackerPanel.add(this.AttackerPayBVforInfluenceText);
        attackerPanel.add(new JLabel("Exp per BV:", 11));
        this.AttackerPayBVforExperienceText.setToolTipText("<html>1 Exp added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 Exp to pay</html>");
        attackerPanel.add(this.AttackerPayBVforExperienceText);
        attackerPanel.add(new JLabel("Win Money:", 11));
        this.AttackerWinModifierCBillsFlatText.setToolTipText("flat boost to pay for winning attack");
        attackerPanel.add(this.AttackerWinModifierCBillsFlatText);
        attackerPanel.add(new JLabel("Loss Money:", 11));
        this.AttackerLossModifierCBillsFlatText.setToolTipText("flat drop in pay for losing attack");
        attackerPanel.add(this.AttackerLossModifierCBillsFlatText);
        attackerPanel.add(new JLabel("Win %Mod Money:", 11));
        this.AttackerWinModifierCBillsPercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        attackerPanel.add(this.AttackerWinModifierCBillsPercentText);
        attackerPanel.add(new JLabel("Loss %Mod Money:", 11));
        this.AttackerLossModifierCBillsPercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        attackerPanel.add(this.AttackerLossModifierCBillsPercentText);
        attackerPanel.add(new JLabel("Win Flu:", 11));
        this.AttackerWinModifierInfluenceFlatText.setToolTipText("flat boost to pay for winning attack");
        attackerPanel.add(this.AttackerWinModifierInfluenceFlatText);
        attackerPanel.add(new JLabel("Loss Flu:", 11));
        this.AttackerLossModifierInfluenceFlatText.setToolTipText("flat drop in pay for losing attack");
        attackerPanel.add(this.AttackerLossModifierInfluenceFlatText);
        attackerPanel.add(new JLabel("Win %Mod Flu:", 11));
        this.AttackerWinModifierInfluencePercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        attackerPanel.add(this.AttackerWinModifierInfluencePercentText);
        attackerPanel.add(new JLabel("Loss %Mod Flu:", 11));
        this.AttackerLossModifierInfluencePercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        attackerPanel.add(this.AttackerLossModifierInfluencePercentText);
        attackerPanel.add(new JLabel("Win Exp:", 11));
        this.AttackerWinModifierExperienceFlatText.setToolTipText("flat boost to pay for winning attack");
        attackerPanel.add(this.AttackerWinModifierExperienceFlatText);
        attackerPanel.add(new JLabel("Loss Exp:", 11));
        this.AttackerLossModifierExperienceFlatText.setToolTipText("flat drop in pay for losing attack");
        attackerPanel.add(this.AttackerLossModifierExperienceFlatText);
        attackerPanel.add(new JLabel("Win %Mod Exp:", 11));
        this.AttackerWinModifierExperiencePercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        attackerPanel.add(this.AttackerWinModifierExperiencePercentText);
        attackerPanel.add(new JLabel("Loss %Mod Exp:", 11));
        this.AttackerLossModifierExperiencePercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        attackerPanel.add(this.AttackerLossModifierExperiencePercentText);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 9, 4);
        defenderPanel.add(new JLabel("Money Paid:", 11));
        this.BaseDefenderPayCBillsText.setToolTipText("flat amount defender is paid for participating");
        defenderPanel.add(this.BaseDefenderPayCBillsText);
        defenderPanel.add(new JLabel("Flu Paid:", 11));
        this.BaseDefenderPayInfluenceText.setToolTipText("flat amount defender is paid for participating");
        defenderPanel.add(this.BaseDefenderPayInfluenceText);
        defenderPanel.add(new JLabel("Exp Paid:", 11));
        this.BaseDefenderPayExperienceText.setToolTipText("flat amount defender is paid for participating");
        defenderPanel.add(this.BaseDefenderPayExperienceText);
        defenderPanel.add(new JLabel("Money per BV:", 11));
        this.DefenderPayBVforCBillText.setToolTipText("<html>1 CBill added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 Cbills to pay</html>");
        defenderPanel.add(this.DefenderPayBVforCBillText);
        defenderPanel.add(new JLabel("Flu per BV:", 11));
        this.DefenderPayBVforInfluenceText.setToolTipText("<html>1 flu added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 flu to pay</html>");
        defenderPanel.add(this.DefenderPayBVforInfluenceText);
        defenderPanel.add(new JLabel("Exp per BV:", 11));
        this.DefenderPayBVforExperienceText.setToolTipText("<html>1 Exp added to Base pay for every complete<br>increment. ie - if 2, will add BV/2 Exp to pay</html>");
        defenderPanel.add(this.DefenderPayBVforExperienceText);
        defenderPanel.add(new JLabel("Win Money:", 11));
        this.DefenderWinModifierCBillsFlatText.setToolTipText("flat boost to pay for winning defend");
        defenderPanel.add(this.DefenderWinModifierCBillsFlatText);
        defenderPanel.add(new JLabel("Loss Money:", 11));
        this.DefenderLossModifierCBillsFlatText.setToolTipText("flat drop in pay for losing defend");
        defenderPanel.add(this.DefenderLossModifierCBillsFlatText);
        defenderPanel.add(new JLabel("Win %Mod Money:", 11));
        this.DefenderWinModifierCBillsPercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        defenderPanel.add(this.DefenderWinModifierCBillsPercentText);
        defenderPanel.add(new JLabel("Loss %Mod Money:", 11));
        this.DefenderLossModifierCBillsPercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        defenderPanel.add(this.DefenderLossModifierCBillsPercentText);
        defenderPanel.add(new JLabel("Win Flu:", 11));
        this.DefenderWinModifierInfluenceFlatText.setToolTipText("flat boost to pay for winning defend");
        defenderPanel.add(this.DefenderWinModifierInfluenceFlatText);
        defenderPanel.add(new JLabel("Loss Flu:", 11));
        this.DefenderLossModifierInfluenceFlatText.setToolTipText("flat drop in pay for losing defend");
        defenderPanel.add(this.DefenderLossModifierInfluenceFlatText);
        defenderPanel.add(new JLabel("Win %Mod Flu:", 11));
        this.DefenderWinModifierInfluencePercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        defenderPanel.add(this.DefenderWinModifierInfluencePercentText);
        defenderPanel.add(new JLabel("Loss %Mod Flu:", 11));
        this.DefenderLossModifierInfluencePercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        defenderPanel.add(this.DefenderLossModifierInfluencePercentText);
        defenderPanel.add(new JLabel("Win Exp:", 11));
        this.DefenderWinModifierExperienceFlatText.setToolTipText("flat boost to pay for winning defend");
        defenderPanel.add(this.DefenderWinModifierExperienceFlatText);
        defenderPanel.add(new JLabel("Loss Exp:", 11));
        this.DefenderLossModifierExperienceFlatText.setToolTipText("flat drop in pay for losing defend");
        defenderPanel.add(this.DefenderLossModifierExperienceFlatText);
        defenderPanel.add(new JLabel("Win %Mod Exp:", 11));
        this.DefenderWinModifierExperiencePercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        defenderPanel.add(this.DefenderWinModifierExperiencePercentText);
        defenderPanel.add(new JLabel("Loss %Mod Exp:", 11));
        this.DefenderLossModifierExperiencePercentText.setToolTipText("<html>double multipliers. the base amounts + bv adjustments +<br>flat adjustments are multiplied by these numbers. A Win<br>Modifier of 2.0 would double pay. A LosseModifier of .50 <br>would reduce payments by half.</html>");
        defenderPanel.add(this.DefenderLossModifierExperiencePercentText);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 9, 4);
        outcomePanel.add(new JLabel("Attacker RP:", 11));
        this.RPForAttackerText.setToolTipText("number of RP to give Attacker(s)");
        outcomePanel.add(this.RPForAttackerText);
        outcomePanel.add(new JLabel("Defender RP:", 11));
        this.RPForDefenderText.setToolTipText("num RP to give Defender(s)");
        outcomePanel.add(this.RPForDefenderText);
        outcomePanel.add(new JLabel("Winner RP:", 11));
        this.RPForWinnerText.setToolTipText("num RP to give Winner");
        outcomePanel.add(this.RPForWinnerText);
        outcomePanel.add(new JLabel("Loser RP:", 11));
        this.RPForLoserText.setToolTipText("num RP to give Loser");
        outcomePanel.add(this.RPForLoserText);
        SpringLayoutHelper.setupSpringGrid(outcomePanel, 2, 4);
        outcomeBox.add(new JLabel("Reward Points."));
        this.OnlyGiveRPtoWinnersCBox.setText("Winner Only Gets RP");
        this.OnlyGiveRPtoWinnersCBox.setToolTipText("use to restrict attack/def RP to winning players");
        outcomeBox.add(this.OnlyGiveRPtoWinnersCBox);
        outcomeBox.add(outcomePanel);
        outcomeBox.setBorder(BorderFactory.createLineBorder(Color.black));
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        opResultsBox.add(attackerBox);
        opResultsBox.add(defenderBox);
        masterBox.add(opResultsBox);
        masterBox.add(outcomeBox);
        opresultsPanel.add(masterBox);
        JPanel salvageBox = new JPanel();
        salvageBox.setLayout(new BoxLayout(salvageBox, 0));
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        attackerPanel.add(new JLabel("Base Salvage%:", 11));
        this.BaseAttackerSalvagePercentText.setToolTipText(" attacker starting salvage rate if he wins");
        attackerPanel.add(this.BaseAttackerSalvagePercentText);
        attackerPanel.add(new JLabel("Salvage Adjustment:", 11));
        this.AttackerSalvageAdjustmentText.setToolTipText("<html>Adjustment after each salvage attempt. IE - if base<br>is 50, and adjust is 20, 2nd attempt will be 30 or 70<br>30 if salvage attempt was successful 70 if not.</html>");
        attackerPanel.add(this.AttackerSalvageAdjustmentText);
        attackerPanel.add(new JLabel("BV To Boost Salvage:", 11));
        this.BVToBoostAttackerSalvageCostText.setToolTipText("<html>UnitBV/BVToBoost is the starting cost of salvage. If<br>set to 0, salvage will be *FREE*. IMPORTANT!</html>");
        attackerPanel.add(this.BVToBoostAttackerSalvageCostText);
        attackerPanel.add(new JLabel("Salvage Cost Mod:", 11));
        this.AttackerSalvageCostModifierText.setToolTipText("<html>salvage cost multiplier. is a double. entry of .75 will<br>reduct cost by 25%, entry of 2.00 will double the cost<br>to salvage a unit.</html>");
        attackerPanel.add(this.AttackerSalvageCostModifierText);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 4, 2);
        defenderPanel.add(new JLabel("Base Salvage%:", 11));
        this.BaseDefenderSalvagePercentText.setToolTipText(" defender starting salvage rate if he wins");
        defenderPanel.add(this.BaseDefenderSalvagePercentText);
        defenderPanel.add(new JLabel("Salvage Adjustment:", 11));
        this.DefenderSalvageAdjustmentText.setToolTipText("<html>Adjustment after each salvage attempt. IE - if base<br>is 50, and adjust is 20, 2nd attempt will be 30 or 70<br>30 if salvage attempt was successful 70 if not.</html>");
        defenderPanel.add(this.DefenderSalvageAdjustmentText);
        defenderPanel.add(new JLabel("BV To Boost Salvage:", 11));
        this.BVToBoostDefenderSalvageCostText.setToolTipText("<html>UnitBV/BVToBoost is the starting cost of salvage. If<br>set to 0, salvage will be *FREE*. IMPORTANT!</html>");
        defenderPanel.add(this.BVToBoostDefenderSalvageCostText);
        defenderPanel.add(new JLabel("Salvage Cost Mod:", 11));
        this.DefenderSalvageCostModifierText.setToolTipText("<html>salvage cost multiplier. is a double. entry of .75 will<br>reduct cost by 25%, entry of 2.00 will double the cost<br>to salvage a unit.</html>");
        defenderPanel.add(this.DefenderSalvageCostModifierText);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 4, 2);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        salvageBox.add(attackerBox);
        salvageBox.add(defenderBox);
        this.WinnerAlwaysSalvagesOwnUnitsCBox.setText("Winner Salvages Own Units");
        this.WinnerAlwaysSalvagesOwnUnitsCBox.setToolTipText("if true winner gets all his salvageables");
        masterBox.add(this.WinnerAlwaysSalvagesOwnUnitsCBox);
        masterBox.add(salvageBox);
        salvagePanel.add(masterBox);
        JPanel newbieBox = new JPanel();
        newbieBox.setLayout(new BoxLayout(newbieBox, 1));
        JPanel newbiePanel1 = new JPanel(new SpringLayout());
        JPanel newbiePanel2 = new JPanel(new SpringLayout());
        JPanel newbiePanel3 = new JPanel(new SpringLayout());
        JPanel newbiePanel4 = new JPanel(new SpringLayout());
        this.AllowSOLToUseCBox.setText("Allow SOL To Use");
        this.AllowSOLToUseCBox.setToolTipText("set true to allow a newbie to initiate");
        newbiePanel1.add(this.AllowSOLToUseCBox);
        this.AllowAgainstSOLCBox.setText("Allow Against SOL");
        this.AllowAgainstSOLCBox.setToolTipText("set true to allow a player to launch this task against SOL");
        newbiePanel1.add(this.AllowAgainstSOLCBox);
        this.AllowNonConqToUseCBox.setText("Allow NonConquer To Use");
        this.AllowNonConqToUseCBox.setToolTipText("set false to forbid non-conquer players from using this attack");
        newbiePanel1.add(this.AllowNonConqToUseCBox);
        this.AllowAgainstNonConqCBox.setText("Allow Against NonConquer");
        this.AllowAgainstNonConqCBox.setToolTipText("set false to forbid players from using this attack against a non-conq player");
        newbiePanel1.add(this.AllowAgainstNonConqCBox);
        SpringLayoutHelper.setupSpringGrid(newbiePanel1, 1, 4);
        this.SOLPilotsGainXPCBox.setText("SOL Pilots Gain XP");
        this.SOLPilotsGainXPCBox.setToolTipText("set true to allow SOL player's units to gain XP");
        newbiePanel2.add(this.SOLPilotsGainXPCBox);
        this.HousePilotsGainXPCBox.setText("House Pilots Gain XP");
        this.HousePilotsGainXPCBox.setToolTipText("set true to allow faction units to gain XP vs SOL");
        newbiePanel2.add(this.HousePilotsGainXPCBox);
        this.SOLPilotsCheckLevelUpCBox.setText("SOL Pilots Can Level");
        this.SOLPilotsCheckLevelUpCBox.setToolTipText("set true to allow SOL player's units to level after game");
        newbiePanel2.add(this.SOLPilotsCheckLevelUpCBox);
        this.HousePilotsCheckLevelUpCBox.setText("House Pilots Can Level");
        this.HousePilotsCheckLevelUpCBox.setToolTipText("set true to allow faction units to level after game vs SOL");
        newbiePanel2.add(this.HousePilotsCheckLevelUpCBox);
        SpringLayoutHelper.setupSpringGrid(newbiePanel2, 1, 4);
        this.PayAllAsWinnersCBox.setText("Pay all As Winners");
        this.PayAllAsWinnersCBox.setToolTipText("<html>enable to play all players in a task involving a SOL as game <br> winners, regardless of outcome. <br><br> NOTEs: for a training task, AllowSOLtoUse and AllowAgainstSOL should be <br> set true simultaneously, otherwise player would be able to LAUNCH <br> attack, but other SOLs would not be able to defend. <br> It is NOT recommended that PayAllAsWinners be used unless NoStats <br> and NoDestruction are also enabled.</html>");
        newbiePanel3.add(this.PayAllAsWinnersCBox);
        this.CountGameForRankingCBox.setText("Count Game For Ranking");
        this.CountGameForRankingCBox.setToolTipText("<html>set to true in order to stop ELO changes.</html>");
        newbiePanel3.add(this.CountGameForRankingCBox);
        this.NoStatisticsModeCBox.setText("No Statisitcs Mode");
        this.NoStatisticsModeCBox.setToolTipText("<html>if enabled, stats will not be kept in games involving SOLs. <br> Pilot/Unit kills will not be counted or published.</html>");
        newbiePanel3.add(this.NoStatisticsModeCBox);
        this.NoDestructionModeCBox.setText("No Destruction Mode");
        this.NoDestructionModeCBox.setToolTipText("<html>if enabled, no units will be destroyed and no units will<br>be salvaged (essentially sets up a sim-task).</html>");
        newbiePanel3.add(this.NoDestructionModeCBox);
        this.PayTechsForGameCBox.setText("Pay Techs:");
        this.PayTechsForGameCBox.setToolTipText("set false to turn off technician payments.");
        newbiePanel3.add(this.PayTechsForGameCBox);
        SpringLayoutHelper.setupSpringGrid(newbiePanel3, 1, 5);
        newbiePanel4.add(new JLabel("Count Game For Production:", 11));
        this.CountGameForProductionText.setToolTipText("<html>Double. Controls amount of production players generate<br>Set to 0 to disable production. Defaults to 1.0, the<br>same amount that a solitary army would generate.</html>");
        newbiePanel4.add(this.CountGameForProductionText);
        SpringLayoutHelper.setupSpringGrid(newbiePanel4, 1, 2);
        newbieBox.add(newbiePanel1);
        newbieBox.add(newbiePanel2);
        newbieBox.add(newbiePanel3);
        newbieBox.add(newbiePanel4);
        newbieOpsPanel.add(newbieBox);
        JPanel metaBox = new JPanel();
        metaBox.setLayout(new BoxLayout(metaBox, 0));
        JPanel capsBox = new JPanel();
        capsBox.setLayout(new BoxLayout(capsBox, 1));
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        JPanel capsPanel = new JPanel(new SpringLayout());
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        attackerPanel.add(new JLabel("Base Conquer:", 11));
        this.AttackerBaseConquestAmountText.setToolTipText("Base % of a planet taken for winning attacker");
        attackerPanel.add(this.AttackerBaseConquestAmountText);
        attackerPanel.add(new JLabel("Conquer BV Mod:", 11));
        this.AttackerConquestBVAdjustmentText.setToolTipText("Amount of BV needed for extra % point");
        attackerPanel.add(this.AttackerConquestBVAdjustmentText);
        attackerPanel.add(new JLabel("Conquer Unit Mod:", 11));
        this.AttackerConquestUnitAdjustmentText.setToolTipText("Number of units needed for extra % point");
        attackerPanel.add(this.AttackerConquestUnitAdjustmentText);
        attackerPanel.add(new JLabel("Base Delay Amount:", 11));
        this.AttackerBaseDelayAmountText.setToolTipText("Base miniticks delay caused by winning attacker");
        attackerPanel.add(this.AttackerBaseDelayAmountText);
        attackerPanel.add(new JLabel("Delay BV Mod:", 11));
        this.AttackerDelayBVAdjustmentText.setToolTipText("Amount of BV needed for extra minitick of delay");
        attackerPanel.add(this.AttackerDelayBVAdjustmentText);
        attackerPanel.add(new JLabel("Delay Unit Mod:", 11));
        this.AttackerDelayUnitAdjustmentText.setToolTipText("Number of units needed for extra minitick of delay");
        attackerPanel.add(this.AttackerDelayUnitAdjustmentText);
        attackerPanel.add(new JLabel("Base Components:", 11));
        this.AttackerBasePPAmountText.setToolTipText("Base components taken by winning attacker");
        attackerPanel.add(this.AttackerBasePPAmountText);
        attackerPanel.add(new JLabel("Component BV Mod:", 11));
        this.AttackerPPBVAdjustmentText.setToolTipText("Amount of BV needed for extra batch of components");
        attackerPanel.add(this.AttackerPPBVAdjustmentText);
        attackerPanel.add(new JLabel("Component Unit Mod:", 11));
        this.AttackerPPUnitAdjustmentText.setToolTipText("Number of units needed for extra batch of components");
        attackerPanel.add(this.AttackerPPUnitAdjustmentText);
        attackerPanel.add(new JLabel("Units Taken:", 11));
        this.AttackerBaseUnitsTakenText.setToolTipText("base number of units taken by winning attacker");
        attackerPanel.add(this.AttackerBaseUnitsTakenText);
        attackerPanel.add(new JLabel("Units BV Mod:", 11));
        this.AttackerUnitsBVAdjustmentText.setToolTipText("BV to take an additonal unit");
        attackerPanel.add(this.AttackerUnitsBVAdjustmentText);
        attackerPanel.add(new JLabel("Units Unit Mod:", 11));
        this.AttackerUnitsUnitAdjustmentText.setToolTipText("units to take an additional unit (confusing!)");
        attackerPanel.add(this.AttackerUnitsUnitAdjustmentText);
        attackerPanel.add(new JLabel("Target Op Mod:", 11));
        this.AttackerTargetOpAdjustmentText.setToolTipText("<html>Op Adjustments are used to increase or decrease victory THRESHOLDS for<br>targetted long-ops. Not recommended for individual games. Generlly, better<br>for use as a long-op (w/ fewer games than target) set up as a counter-assault<br>or spoling attack.</html>");
        attackerPanel.add(this.AttackerTargetOpAdjustmentText);
        attackerPanel.add(new JLabel("  ", 11));
        attackerPanel.add(new JLabel("  ", 11));
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 7, 4);
        defenderPanel.add(new JLabel("Base Conquer:", 11));
        this.DefenderBaseConquestAmountText.setToolTipText("Base % of a planet taken for winning defender");
        defenderPanel.add(this.DefenderBaseConquestAmountText);
        defenderPanel.add(new JLabel("Conquer BV Mod:", 11));
        this.DefenderConquestBVAdjustmentText.setToolTipText("Amount of BV needed for extra % point");
        defenderPanel.add(this.DefenderConquestBVAdjustmentText);
        defenderPanel.add(new JLabel("Conquer Unit Mod:", 11));
        this.DefenderConquestUnitAdjustmentText.setToolTipText("Number of units needed for extra % point");
        defenderPanel.add(this.DefenderConquestUnitAdjustmentText);
        defenderPanel.add(new JLabel("Base Delay Amount:", 11));
        this.DefenderBaseDelayAmountText.setToolTipText("Base miniticks REPAIR caused by winning defender");
        defenderPanel.add(this.DefenderBaseDelayAmountText);
        defenderPanel.add(new JLabel("Delay BV Mod:", 11));
        this.DefenderDelayBVAdjustmentText.setToolTipText("Amount of BV needed for extra minitick of REPAIR");
        defenderPanel.add(this.DefenderDelayBVAdjustmentText);
        defenderPanel.add(new JLabel("Delay Unit Mod:", 11));
        this.DefenderDelayUnitAdjustmentText.setToolTipText("Number of units needed for extra minitick of REPAIR");
        defenderPanel.add(this.DefenderDelayUnitAdjustmentText);
        defenderPanel.add(new JLabel("Base Components:", 11));
        this.DefenderBasePPAmountText.setToolTipText("Base components taken by winning defender");
        defenderPanel.add(this.DefenderBasePPAmountText);
        defenderPanel.add(new JLabel("Component BV Mod:", 11));
        this.DefenderPPBVAdjustmentText.setToolTipText("Amount of BV needed for extra batch of components");
        defenderPanel.add(this.DefenderPPBVAdjustmentText);
        defenderPanel.add(new JLabel("Component Unit Mod:", 11));
        this.DefenderPPUnitAdjustmentText.setToolTipText("Number of units needed for extra batch of components");
        defenderPanel.add(this.DefenderPPUnitAdjustmentText);
        defenderPanel.add(new JLabel("Target Op Mod:", 11));
        this.DefenderTargetOpAdjustmentText.setToolTipText("<html>Op Adjustments are used to increase or decrease victory THRESHOLDS for<br>targetted long-ops. Not recommended for individual games. Generlly, better<br>for use as a long-op (w/ fewer games than target) set up as a counter-assault<br>or spoling defend.</html>");
        defenderPanel.add(this.DefenderTargetOpAdjustmentText);
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 7, 4);
        capsPanel.add(new JLabel("Conqer Cap:", 11));
        this.ConquestAmountCapText.setToolTipText("Max amount of % to take, regardless of BV/units involved.");
        capsPanel.add(this.ConquestAmountCapText);
        capsPanel.add(new JLabel("Delay Cap:", 11));
        this.DelayAmountCapText.setToolTipText("Max amount of delay to apply, regardless of BV/units involved.");
        capsPanel.add(this.DelayAmountCapText);
        capsPanel.add(new JLabel("Component Cap:", 11));
        this.PPCapptureCapText.setToolTipText("Max # of PP to take/generate");
        capsPanel.add(this.PPCapptureCapText);
        capsPanel.add(new JLabel("Unit Cap:", 11));
        this.UnitCaptureCapText.setToolTipText("Ceiling on number of units which may be raided");
        capsPanel.add(this.UnitCaptureCapText);
        SpringLayoutHelper.setupSpringGrid(capsPanel, 1, 8);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        capsBox.add(new JLabel("Max Operation Winnings"));
        capsBox.add(capsPanel);
        metaBox.add(attackerBox);
        metaBox.add(defenderBox);
        masterBox.add(capsBox);
        masterBox.add(metaBox);
        metaSetupPanel.add(masterBox);
        JPanel chickenLeechBox = new JPanel();
        chickenLeechBox.setLayout(new BoxLayout(metaBox, 0));
        JPanel leechBox1 = new JPanel();
        leechBox1.setLayout(new BoxLayout(leechBox1, 1));
        JPanel leechPanel1 = new JPanel(new SpringLayout());
        JPanel leechPanel2 = new JPanel(new SpringLayout());
        JPanel leechPanel3 = new JPanel(new SpringLayout());
        JPanel leechPanel4 = new JPanel(new SpringLayout());
        leechPanel1.add(new JLabel("Chicken Time:", 11));
        this.TimeToNondefensePenaltyText.setToolTipText("time, in SECONDS, from attack init to penalty.");
        leechPanel1.add(this.TimeToNondefensePenaltyText);
        leechPanel1.add(new JLabel("Total Allowed Leeches:", 11));
        this.LeechesToDeactivateText.setToolTipText("num leeches before a player is moved into reserve.");
        leechPanel1.add(this.LeechesToDeactivateText);
        SpringLayoutHelper.setupSpringGrid(leechPanel1, 1, 4);
        leechPanel2.add(new JLabel("RP Penalty:", 11));
        this.FlatRPChickenPenaltyText.setToolTipText("# of RP to take.");
        leechPanel2.add(this.FlatRPChickenPenaltyText);
        leechPanel2.add(new JLabel("Exp Penalty:", 11));
        this.FlatExpChickenPenaltyText.setToolTipText("# of EXP to take.");
        leechPanel2.add(this.FlatExpChickenPenaltyText);
        leechPanel2.add(new JLabel("Flu Penalty:", 11));
        this.FlatInfluenceChickenPenaltyText.setToolTipText("# of Inf to take.");
        leechPanel2.add(this.FlatInfluenceChickenPenaltyText);
        leechPanel2.add(new JLabel("Money Penalty:", 11));
        this.FlatCBillChickenPenaltyText.setToolTipText("# of CBills to take.");
        leechPanel2.add(this.FlatCBillChickenPenaltyText);
        SpringLayoutHelper.setupSpringGrid(leechPanel2, 2, 4);
        leechPanel3.add(new JLabel("% RP Penalty:", 11));
        this.PercentRPChickenPenaltyText.setToolTipText("% of RP to take. i.e. .10 for 10%");
        leechPanel3.add(this.PercentRPChickenPenaltyText);
        leechPanel3.add(new JLabel("% Exp Penalty:", 11));
        this.PercentExpChickenPenaltyText.setToolTipText("% of EXP to take. i.e. .10 for 10%");
        leechPanel3.add(this.PercentExpChickenPenaltyText);
        leechPanel3.add(new JLabel("% Flu Penalty:", 11));
        this.PercentInfluenceChickenPenaltyText.setToolTipText("% of Flu to take. i.e. .10 for 10%");
        leechPanel3.add(this.PercentInfluenceChickenPenaltyText);
        leechPanel3.add(new JLabel("% Money Penalty:", 11));
        this.PercentCBillChickenPenaltyText.setToolTipText("% of Money to take. i.e. .10 for 10%");
        leechPanel3.add(this.PercentCBillChickenPenaltyText);
        SpringLayoutHelper.setupSpringGrid(leechPanel3, 2, 4);
        leechPanel4.add(new JLabel("Land Taken:", 11));
        this.ConquestPerLeechText.setToolTipText("% control transferred on each leech");
        leechPanel4.add(this.ConquestPerLeechText);
        leechPanel4.add(new JLabel("Factory Delays (Ticks):", 11));
        this.DelayPerLeechText.setToolTipText("delay to on-target facilities w/ each leech");
        leechPanel4.add(this.DelayPerLeechText);
        leechPanel4.add(new JLabel("Components Taken:", 11));
        this.ProdPointsPerLeechText.setToolTipText("Components taken with each leech");
        leechPanel4.add(this.ProdPointsPerLeechText);
        leechPanel4.add(new JLabel("Units Taken:", 11));
        this.UnitsPerLeechText.setToolTipText("Units taken with each leech");
        leechPanel4.add(this.UnitsPerLeechText);
        leechPanel4.add(new JLabel("Failure Penalty:", 11));
        this.FailurePenaltyText.setToolTipText("<html>Components taken if no other penalty is applied. Use it<br>to ensure that a penalty is always given, even<br>if there is no % to yeild or factory to delay.</html>");
        leechPanel4.add(this.FailurePenaltyText);
        leechPanel4.add(new JLabel("", 11));
        leechPanel4.add(new JLabel("", 11));
        SpringLayoutHelper.setupSpringGrid(leechPanel4, 3, 4);
        leechBox1.add(leechPanel1);
        leechBox1.add(leechPanel2);
        leechBox1.add(leechPanel3);
        leechBox1.add(leechPanel4);
        chickenLeechPanel.add(leechBox1);
        JPanel pilotExpBox = new JPanel();
        pilotExpBox.setLayout(new BoxLayout(pilotExpBox, 0));
        JPanel pilotPanel = new JPanel(new SpringLayout());
        pilotPanel.add(new JLabel("Base Unit Exp:", 11));
        this.BaseUnitXPText.setToolTipText("XP earned by all surviving units for playing the game");
        pilotPanel.add(this.BaseUnitXPText);
        pilotPanel.add(new JLabel("Surviving Unit Adjustment:", 11));
        this.UnitXPUnitsAdjustmentText.setToolTipText("<html>bonus XP given to all surviving units, based on the starting size of the game<br>if there are 10 units in game, and Adjust is set to 10, all units will get +1<br>XP. if there are 10 in game and Adjust is 5, all units will get +2 XP, etc.</html>");
        pilotPanel.add(this.UnitXPUnitsAdjustmentText);
        pilotPanel.add(new JLabel("BV Adjustment:", 11));
        this.UnitXPBVAdjustmentText.setToolTipText("<html>bonus XP given to all surviving units, based on the starting size of the game. if<br>total BV in game is 30,000 and Adjust is 10,000, all units will get +3 XP.</html>");
        pilotPanel.add(this.UnitXPBVAdjustmentText);
        pilotPanel.add(new JLabel("Winner Bonus:", 11));
        this.WinnerBonusUnitXPText.setToolTipText("<html>bonux XP given to all surviving units owned by a winning player</html>");
        pilotPanel.add(this.WinnerBonusUnitXPText);
        pilotPanel.add(new JLabel("Defender Bonus:", 11));
        this.DefenderBonusUnitXPText.setToolTipText("bonus XP given to all surviving units owned by a defending player");
        pilotPanel.add(this.DefenderBonusUnitXPText);
        pilotPanel.add(new JLabel("Units Killed Bonus:", 11));
        this.KillBonusUnitXPText.setToolTipText("<html>flat amount of XP given to a unit for each kill it earned. this is granted only<br>to the killing unit, and only if it survives or is salvaged by original owner<br>with original pilot.</html>");
        pilotPanel.add(this.KillBonusUnitXPText);
        pilotPanel.add(new JLabel("BV Killed Bonus:", 11));
        this.KillBonusXPforBVText.setToolTipText("<html>KilledUnitsBV/KillBonusXPforBV. bonus XP based on the BV of units killed. added<br>only to the killing unit, and only if the unit survives or is salvaged by its<br>original owner with original pilot.</html>");
        pilotPanel.add(this.KillBonusXPforBVText);
        SpringLayoutHelper.setupSpringGrid(pilotPanel, 7, 2);
        pilotExpBox.add(pilotPanel);
        pilotExpPanel.add(pilotExpBox);
        JPanel buildingsBox = new JPanel();
        buildingsBox.setLayout(new BoxLayout(buildingsBox, 0));
        JPanel constructionPanel = new JPanel(new SpringLayout());
        masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 1));
        attackerBox = new JPanel();
        attackerBox.setLayout(new BoxLayout(attackerBox, 1));
        defenderBox = new JPanel();
        defenderBox.setLayout(new BoxLayout(defenderBox, 1));
        attackerPanel = new JPanel(new SpringLayout());
        defenderPanel = new JPanel(new SpringLayout());
        constructionPanel.add(new JLabel("Total Buildings:", 11));
        this.TotalBuildingsText.setToolTipText("Total number of buildings to place on the map");
        constructionPanel.add(this.TotalBuildingsText);
        constructionPanel.add(new JLabel("Min Buildings:", 11));
        this.MinBuildingsForOpText.setToolTipText("<html>Minimum number of buildings the Attack needs to destory for the op to be a sucess<br>I.E. 10 buildings 5 min. if the attacker kills only 4 they don't get any of the b</html>");
        constructionPanel.add(this.MinBuildingsForOpText);
        constructionPanel.add(new JLabel("Min Floors:", 11));
        this.MinFloorsText.setToolTipText("Minimum number of floors in each building.");
        constructionPanel.add(this.MinFloorsText);
        constructionPanel.add(new JLabel("Max Floors:", 11));
        this.MaxFloorsText.setToolTipText("Maximum number of floors in each building.");
        constructionPanel.add(this.MaxFloorsText);
        constructionPanel.add(new JLabel("Min CF:", 11));
        this.MinCFText.setToolTipText("Minimum Construction Factor each building can have (How many points of damage it'll take)");
        constructionPanel.add(this.MinCFText);
        constructionPanel.add(new JLabel("Max CF:", 11));
        this.MaxCFText.setToolTipText("Maximum Construction Factor each building can have (How many points of damage it'll take)");
        constructionPanel.add(this.MaxCFText);
        constructionPanel.add(new JLabel("Building Type:", 11));
        this.BuildingTypeText.setToolTipText("1: Light, 2: Medium, 3: Heavy, 4: Hardend");
        constructionPanel.add(this.BuildingTypeText);
        constructionPanel.add(new JLabel("", 11));
        this.BuildingsStartOnMapEdgeCBox.setText("Buildings Start on map edge");
        this.BuildingsStartOnMapEdgeCBox.setToolTipText("<html>defaults to true.<br>If selected a random edge is selected<br>and the defender is set to that<br>and the attacker to the opposite edge.<br>If not selected the buildings<br>will be placed randomly around the map.</html>");
        constructionPanel.add(this.BuildingsStartOnMapEdgeCBox);
        SpringLayoutHelper.setupSpringGrid(constructionPanel, 4, 4);
        attackerPanel.add(new JLabel("Min Buildings if Attacker wins:", 11));
        this.AttackerMinBuildingsIfAttackerWinsText.setToolTipText("<html>If The attacket wins the ops and the number of buildings destroyed is blow this it gets set to this.<br>I.E. Keep the defender from screwing the Attacker by quiting early.</html>");
        attackerPanel.add(this.AttackerMinBuildingsIfAttackerWinsText);
        attackerPanel.add(new JLabel("Delay Per Building:", 11));
        this.DelayPerBuildingText.setToolTipText("<html>Number of Delay ticks set to the planet factories for each building destroyed,<br>if they meet the min amount of buildings destroyed.</html>");
        attackerPanel.add(this.DelayPerBuildingText);
        attackerPanel.add(new JLabel("Money Per Building:", 11));
        this.AttackerMoneyPerBuildingText.setToolTipText("<html>Amount of Money the attacker gets for each building destroyed,<br>if they meet the min amount of buildings destroyed.</html>");
        attackerPanel.add(this.AttackerMoneyPerBuildingText);
        attackerPanel.add(new JLabel("Exp Per Building:", 11));
        this.AttackerExpPerBuildingText.setToolTipText("<html>Amount of Exp the attacker gets for each building destroyed,<br>if they meet the min amount of buildings destroyed.</html>");
        attackerPanel.add(this.AttackerExpPerBuildingText);
        attackerPanel.add(new JLabel("Flu Per Building:", 11));
        this.AttackerFluPerBuildingText.setToolTipText("<html>Amount of Flu the attacker gets for each building destroyed,<br>if they meet the min amount of buildings destroyed.</html>");
        attackerPanel.add(this.AttackerFluPerBuildingText);
        attackerPanel.add(new JLabel("RP Per Building:", 11));
        this.AttackerRPPerBuildingText.setToolTipText("<html>Amount of RP the attacker gets for each building destroyed,<br>if they meet the min amount of buildings destroyed.</html>");
        attackerPanel.add(this.AttackerRPPerBuildingText);
        SpringLayoutHelper.setupSpringGrid(attackerPanel, 6, 2);
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("  ", 11));
        defenderPanel.add(new JLabel("Money Per Building:", 11));
        this.DefenderMoneyPerBuildingText.setToolTipText("Amount of Money the defender gets for each building left standing.");
        defenderPanel.add(this.DefenderMoneyPerBuildingText);
        defenderPanel.add(new JLabel("Exp Per Building:", 11));
        this.DefenderExpPerBuildingText.setToolTipText("Amount of Exp the defender gets for each building left standing.");
        defenderPanel.add(this.DefenderExpPerBuildingText);
        defenderPanel.add(new JLabel("Flu Per Building:", 11));
        this.DefenderFluPerBuildingText.setToolTipText("Amount of Flu the defender gets for each building left standing.");
        defenderPanel.add(this.DefenderFluPerBuildingText);
        defenderPanel.add(new JLabel("RP Per Building:", 11));
        this.DefenderRPPerBuildingText.setToolTipText("Amount of RP the defender gets for each building left standing.");
        defenderPanel.add(this.DefenderRPPerBuildingText);
        SpringLayoutHelper.setupSpringGrid(defenderPanel, 6, 2);
        attackerBox.add(new JLabel("Attacker"));
        attackerBox.add(attackerPanel);
        attackerBox.setBorder(BorderFactory.createLineBorder(Color.black));
        defenderBox.add(new JLabel("Defender"));
        defenderBox.add(defenderPanel);
        defenderBox.setBorder(BorderFactory.createLineBorder(Color.black));
        buildingsBox.add(attackerBox);
        buildingsBox.add(defenderBox);
        masterBox.add(constructionPanel);
        masterBox.add(buildingsBox);
        buildingsPanel.add(masterBox);
        this.ConfigPane.addTab("Operation Range", null, rangePanel, "Ranges for the Op");
        this.ConfigPane.addTab("Units", null, unitsPanel, "Unit mins and maxes for the op");
        this.ConfigPane.addTab("Operation Costs", null, costsPanel, "Cost to attack or defend an op");
        this.ConfigPane.addTab("Player Properties", null, playerPropertiesPanel, "<html>mins/maxes for players if<br>they can attack/defend an op</html>");
        this.ConfigPane.addTab("Scenario Addons", null, scenarioPanel, "<html>Arty/mines anything given to an attacker/<br>defender besides their own units</HTML>");
        this.ConfigPane.addTab("Operation Results", null, opresultsPanel, "who gets payed what and how much");
        this.ConfigPane.addTab("Salvage", null, salvagePanel, "how the units are divied up");
        this.ConfigPane.addTab("Newbie Ops", null, newbieOpsPanel, "how to treat the new player in your life");
        this.ConfigPane.addTab("Meta Awards", null, metaSetupPanel, "<html>Set what your faction gets for this op.<br>Land, Units, Components</html>");
        this.ConfigPane.addTab("Chicken/Leech", null, chickenLeechPanel, "<html>Set up what happens to those that flee and<br>those that don't pay attention to an attack.</html>");
        this.ConfigPane.addTab("Pilot Exp", null, pilotExpPanel, "Set up how unit pilots will be reward for surviving.");
        this.ConfigPane.addTab("Buildings", null, buildingsPanel, "Set up buildings for operations.");
        this.pane.remove(0);
        this.pane.add((Component)this.ConfigPane, 0);
        this.pane.setVisible(true);
        this.repaint();
    }

    public void initShortOpVars() {
        this.OperationColorText.setText(this.defaultOperationInfo.getDefault("OperationColor"));
        this.OperationRangeText.setText(this.defaultOperationInfo.getDefault("OperationRange"));
        this.PercentageToAttackOnWorldText.setText(this.defaultOperationInfo.getDefault("PercentageToAttackOnWorld"));
        this.PercentageToAttackOffWorldText.setText(this.defaultOperationInfo.getDefault("PercentageToAttackOffWorld"));
        this.OnlyAgainstFactoryWorldsCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("OnlyAgainstFactoryWorlds")));
        this.OnlyAgainstNonFactoryWorldsCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("OnlyAgainstNonFactoryWorlds")));
        this.MaxAttackerBVText.setText(this.defaultOperationInfo.getDefault("MaxAttackerBV"));
        this.MinAttackerBVText.setText(this.defaultOperationInfo.getDefault("MinAttackerBV"));
        this.MaxDefenderBVText.setText(this.defaultOperationInfo.getDefault("MaxDefenderBV"));
        this.MinDefenderBVText.setText(this.defaultOperationInfo.getDefault("MinDefenderBV"));
        this.MaxAttackerUnitsText.setText(this.defaultOperationInfo.getDefault("MaxAttackerUnits"));
        this.MinAttackerUnitsText.setText(this.defaultOperationInfo.getDefault("MinAttackerUnits"));
        this.MaxDefenderUnitsText.setText(this.defaultOperationInfo.getDefault("MaxDefenderUnits"));
        this.MinDefenderUnitsText.setText(this.defaultOperationInfo.getDefault("MinDefenderUnits"));
        this.MinAttackerWalkText.setText(this.defaultOperationInfo.getDefault("MinAttackerWalk"));
        this.MinDefenderWalkText.setText(this.defaultOperationInfo.getDefault("MinDefenderWalk"));
        this.MinAttackerJumpText.setText(this.defaultOperationInfo.getDefault("MinAttackerJump"));
        this.MinDefenderJumpText.setText(this.defaultOperationInfo.getDefault("MinDefenderJump"));
        this.MaxAttackerUnitTonnageText.setText(this.defaultOperationInfo.getDefault("MaxAttackerUnitTonnage"));
        this.MaxDefenderUnitTonnageText.setText(this.defaultOperationInfo.getDefault("MaxDefenderUnitTonnage"));
        this.MinAttackerUnitTonnageText.setText(this.defaultOperationInfo.getDefault("MinAttackerUnitTonnage"));
        this.MinDefenderUnitTonnageText.setText(this.defaultOperationInfo.getDefault("MinDefenderUnitTonnage"));
        this.MaxTotalAttackerTonnageText.setText(this.defaultOperationInfo.getDefault("MaxTotalAttackerTonnage"));
        this.MaxTotalDefenderTonnageText.setText(this.defaultOperationInfo.getDefault("MaxTotalDefenderTonnage"));
        this.MinTotalAttackerTonnageText.setText(this.defaultOperationInfo.getDefault("MinTotalAttackerTonnage"));
        this.MinTotalDefenderTonnageText.setText(this.defaultOperationInfo.getDefault("MinTotalDefenderTonnage"));
        this.AttackerAllowedMeksCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("AttackerAllowedMeks")));
        this.AttackerAllowedVehsCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("AttackerAllowedVehs")));
        this.AttackerAllowedInfCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("AttackerAllowedInf")));
        this.DefenderAllowedMeksCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("DefenderAllowedMeks")));
        this.DefenderAllowedVehsCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("DefenderAllowedVehs")));
        this.DefenderAllowedInfCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("DefenderAllowedInf")));
        this.PoweredInfAllowedCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("PoweredInfAllowed")));
        this.AttackerCostMoneyText.setText(this.defaultOperationInfo.getDefault("AttackerCostMoney"));
        this.AttackerCostInfluenceText.setText(this.defaultOperationInfo.getDefault("AttackerCostInfluence"));
        this.AttackerCostRewardText.setText(this.defaultOperationInfo.getDefault("AttackerCostReward"));
        this.DefenderCostMoneyText.setText(this.defaultOperationInfo.getDefault("DefenderCostMoney"));
        this.DefenderCostInfluenceText.setText(this.defaultOperationInfo.getDefault("DefenderCostInfluence"));
        this.DefenderCostRewardText.setText(this.defaultOperationInfo.getDefault("DefenderCostReward"));
        this.MinAttackerRatingText.setText(this.defaultOperationInfo.getDefault("MinAttackerRating"));
        this.MaxAttackerRatingText.setText(this.defaultOperationInfo.getDefault("MaxAttackerRating"));
        this.MinDefenderRatingText.setText(this.defaultOperationInfo.getDefault("MinDefenderRating"));
        this.MaxDefenderRatingText.setText(this.defaultOperationInfo.getDefault("MaxDefenderRating"));
        this.MinAttackerXPText.setText(this.defaultOperationInfo.getDefault("MinAttackerXP"));
        this.MaxAttackerXPText.setText(this.defaultOperationInfo.getDefault("MaxAttackerXP"));
        this.MinDefenderXPText.setText(this.defaultOperationInfo.getDefault("MinDefenderXP"));
        this.MaxDefenderXPText.setText(this.defaultOperationInfo.getDefault("MaxDefenderXP"));
        this.MinAttackerGamesPlayedText.setText(this.defaultOperationInfo.getDefault("MinAttackerGamesPlayed"));
        this.MaxAttackerGamesPlayedText.setText(this.defaultOperationInfo.getDefault("MaxAttackerGamesPlayed"));
        this.MinDefenderGamesPlayedText.setText(this.defaultOperationInfo.getDefault("MinDefenderGamesPlayed"));
        this.MaxDefenderGamesPlayedText.setText(this.defaultOperationInfo.getDefault("MaxDefenderGamesPlayed"));
        this.DefenderReceivesAutoArtilleryCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("DefenderReceivesAutoArtillery")));
        this.AttackerReceivesAutoArtilleryCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("AttackerReceivesAutoArtillery")));
        this.DefenderFlatArtilleryModifierText.setText(this.defaultOperationInfo.getDefault("DefenderFlatArtilleryModifier"));
        this.AttackerFlatArtilleryModifierText.setText(this.defaultOperationInfo.getDefault("AttackerFlatArtilleryModifier"));
        this.DefenderPercentArtilleryModifierText.setText(this.defaultOperationInfo.getDefault("DefenderPercentArtilleryModifier"));
        this.AttackerPercentArtilleryModifierText.setText(this.defaultOperationInfo.getDefault("AttackerPercentArtilleryModifier"));
        this.MinDefenderArtilleryBVText.setText(this.defaultOperationInfo.getDefault("MinDefenderArtilleryBV"));
        this.MinAttackerArtilleryBVText.setText(this.defaultOperationInfo.getDefault("MinAttackerArtilleryBV"));
        this.MaxDefenderArtilleryBVText.setText(this.defaultOperationInfo.getDefault("MaxDefenderArtilleryBV"));
        this.MaxAttackerArtilleryBVText.setText(this.defaultOperationInfo.getDefault("MaxAttackerArtilleryBV"));
        this.BaseAttackerPayCBillsText.setText(this.defaultOperationInfo.getDefault("BaseAttackerPayCBills"));
        this.BaseDefenderPayCBillsText.setText(this.defaultOperationInfo.getDefault("BaseDefenderPayCBills"));
        this.BaseAttackerPayInfluenceText.setText(this.defaultOperationInfo.getDefault("BaseAttackerPayInfluence"));
        this.BaseDefenderPayInfluenceText.setText(this.defaultOperationInfo.getDefault("BaseDefenderPayInfluence"));
        this.BaseAttackerPayExperienceText.setText(this.defaultOperationInfo.getDefault("BaseAttackerPayExperience"));
        this.BaseDefenderPayExperienceText.setText(this.defaultOperationInfo.getDefault("BaseDefenderPayExperience"));
        this.AttackerPayBVforCBillText.setText(this.defaultOperationInfo.getDefault("AttackerPayBVforCBill"));
        this.DefenderPayBVforCBillText.setText(this.defaultOperationInfo.getDefault("DefenderPayBVforCBill"));
        this.AttackerPayBVforInfluenceText.setText(this.defaultOperationInfo.getDefault("AttackerPayBVforInfluence"));
        this.DefenderPayBVforInfluenceText.setText(this.defaultOperationInfo.getDefault("DefenderPayBVforInfluence"));
        this.AttackerPayBVforExperienceText.setText(this.defaultOperationInfo.getDefault("AttackerPayBVforExperience"));
        this.DefenderPayBVforExperienceText.setText(this.defaultOperationInfo.getDefault("DefenderPayBVforExperience"));
        this.AttackerWinModifierCBillsFlatText.setText(this.defaultOperationInfo.getDefault("AttackerWinModifierCBillsFlat"));
        this.DefenderWinModifierCBillsFlatText.setText(this.defaultOperationInfo.getDefault("DefenderWinModifierCBillsFlat"));
        this.AttackerLossModifierCBillsFlatText.setText(this.defaultOperationInfo.getDefault("AttackerLossModifierCBillsFlat"));
        this.DefenderLossModifierCBillsFlatText.setText(this.defaultOperationInfo.getDefault("DefenderLossModifierCBillsFlat"));
        this.AttackerWinModifierCBillsPercentText.setText(this.defaultOperationInfo.getDefault("AttackerWinModifierCBillsPercent"));
        this.DefenderWinModifierCBillsPercentText.setText(this.defaultOperationInfo.getDefault("DefenderWinModifierCBillsPercent"));
        this.AttackerLossModifierCBillsPercentText.setText(this.defaultOperationInfo.getDefault("AttackerLossModifierCBillsPercent"));
        this.DefenderLossModifierCBillsPercentText.setText(this.defaultOperationInfo.getDefault("DefenderLossModifierCBillsPercent"));
        this.AttackerWinModifierInfluenceFlatText.setText(this.defaultOperationInfo.getDefault("AttackerWinModifierInfluenceFlat"));
        this.DefenderWinModifierInfluenceFlatText.setText(this.defaultOperationInfo.getDefault("DefenderWinModifierInfluenceFlat"));
        this.AttackerLossModifierInfluenceFlatText.setText(this.defaultOperationInfo.getDefault("AttackerLossModifierInfluenceFlat"));
        this.DefenderLossModifierInfluenceFlatText.setText(this.defaultOperationInfo.getDefault("DefenderLossModifierInfluenceFlat"));
        this.AttackerWinModifierInfluencePercentText.setText(this.defaultOperationInfo.getDefault("AttackerWinModifierInfluencePercent"));
        this.DefenderWinModifierInfluencePercentText.setText(this.defaultOperationInfo.getDefault("DefenderWinModifierInfluencePercent"));
        this.AttackerLossModifierInfluencePercentText.setText(this.defaultOperationInfo.getDefault("AttackerLossModifierInfluencePercent"));
        this.DefenderLossModifierInfluencePercentText.setText(this.defaultOperationInfo.getDefault("DefenderLossModifierInfluencePercent"));
        this.AttackerWinModifierExperienceFlatText.setText(this.defaultOperationInfo.getDefault("AttackerWinModifierExperienceFlat"));
        this.DefenderWinModifierExperienceFlatText.setText(this.defaultOperationInfo.getDefault("DefenderWinModifierExperienceFlat"));
        this.AttackerLossModifierExperienceFlatText.setText(this.defaultOperationInfo.getDefault("AttackerLossModifierExperienceFlat"));
        this.DefenderLossModifierExperienceFlatText.setText(this.defaultOperationInfo.getDefault("DefenderLossModifierExperienceFlat"));
        this.AttackerWinModifierExperiencePercentText.setText(this.defaultOperationInfo.getDefault("AttackerWinModifierExperiencePercent"));
        this.DefenderWinModifierExperiencePercentText.setText(this.defaultOperationInfo.getDefault("DefenderWinModifierExperiencePercent"));
        this.AttackerLossModifierExperiencePercentText.setText(this.defaultOperationInfo.getDefault("AttackerLossModifierExperiencePercent"));
        this.DefenderLossModifierExperiencePercentText.setText(this.defaultOperationInfo.getDefault("DefenderLossModifierExperiencePercent"));
        this.RPForLoserText.setText(this.defaultOperationInfo.getDefault("RPForLoser"));
        this.RPForDefenderText.setText(this.defaultOperationInfo.getDefault("RPForDefender"));
        this.RPForAttackerText.setText(this.defaultOperationInfo.getDefault("RPForAttacker"));
        this.RPForWinnerText.setText(this.defaultOperationInfo.getDefault("RPForWinner"));
        this.OnlyGiveRPtoWinnersCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("OnlyGiveRPtoWinners")));
        this.WinnerAlwaysSalvagesOwnUnitsCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("WinnerAlwaysSalvagesOwnUnits")));
        this.BaseAttackerSalvagePercentText.setText(this.defaultOperationInfo.getDefault("BaseAttackerSalvagePercent"));
        this.BaseDefenderSalvagePercentText.setText(this.defaultOperationInfo.getDefault("BaseDefenderSalvagePercent"));
        this.AttackerSalvageAdjustmentText.setText(this.defaultOperationInfo.getDefault("AttackerSalvageAdjustment"));
        this.DefenderSalvageAdjustmentText.setText(this.defaultOperationInfo.getDefault("DefenderSalvageAdjustment"));
        this.BVToBoostAttackerSalvageCostText.setText(this.defaultOperationInfo.getDefault("BVToBoostAttackerSalvageCost"));
        this.BVToBoostDefenderSalvageCostText.setText(this.defaultOperationInfo.getDefault("BVToBoostDefenderSalvageCost"));
        this.AttackerSalvageCostModifierText.setText(this.defaultOperationInfo.getDefault("AttackerSalvageCostModifier"));
        this.DefenderSalvageCostModifierText.setText(this.defaultOperationInfo.getDefault("DefenderSalvageCostModifier"));
        this.AllowSOLToUseCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("AllowSOLToUse")));
        this.AllowAgainstSOLCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("AllowAgainstSOL")));
        this.AllowNonConqToUseCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("AllowNonConqToUse")));
        this.AllowAgainstNonConqCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("AllowAgainstNonConq")));
        this.SOLPilotsGainXPCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("SOLPilotsGainXP")));
        this.HousePilotsGainXPCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("HousePilotsGainXP")));
        this.SOLPilotsCheckLevelUpCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("SOLPilotsCheckLevelUp")));
        this.HousePilotsCheckLevelUpCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("HousePilotsCheckLevelUp")));
        this.PayAllAsWinnersCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("PayAllAsWinners")));
        this.NoStatisticsModeCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("NoStatisticsMode")));
        this.NoDestructionModeCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("NoDestructionMode")));
        this.PayTechsForGameCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("PayTechsForGame")));
        this.CountGameForRankingCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("CountGameForRanking")));
        this.CountGameForProductionText.setText(this.defaultOperationInfo.getDefault("CountGameForProduction"));
        this.AttackerBaseConquestAmountText.setText(this.defaultOperationInfo.getDefault("AttackerBaseConquestAmount"));
        this.AttackerConquestBVAdjustmentText.setText(this.defaultOperationInfo.getDefault("AttackerConquestBVAdjustment"));
        this.AttackerConquestUnitAdjustmentText.setText(this.defaultOperationInfo.getDefault("AttackerConquestUnitAdjustment"));
        this.DefenderBaseConquestAmountText.setText(this.defaultOperationInfo.getDefault("DefenderBaseConquestAmount"));
        this.DefenderConquestBVAdjustmentText.setText(this.defaultOperationInfo.getDefault("DefenderConquestBVAdjustment"));
        this.DefenderConquestUnitAdjustmentText.setText(this.defaultOperationInfo.getDefault("DefenderConquestUnitAdjustment"));
        this.AttackerBaseDelayAmountText.setText(this.defaultOperationInfo.getDefault("AttackerBaseDelayAmount"));
        this.AttackerDelayBVAdjustmentText.setText(this.defaultOperationInfo.getDefault("AttackerDelayBVAdjustment"));
        this.AttackerDelayUnitAdjustmentText.setText(this.defaultOperationInfo.getDefault("AttackerDelayUnitAdjustment"));
        this.DefenderBaseDelayAmountText.setText(this.defaultOperationInfo.getDefault("DefenderBaseDelayAmount"));
        this.DefenderDelayBVAdjustmentText.setText(this.defaultOperationInfo.getDefault("DefenderDelayBVAdjustment"));
        this.DefenderDelayUnitAdjustmentText.setText(this.defaultOperationInfo.getDefault("DefenderDelayUnitAdjustment"));
        this.AttackerBasePPAmountText.setText(this.defaultOperationInfo.getDefault("AttackerBasePPAmount"));
        this.AttackerPPBVAdjustmentText.setText(this.defaultOperationInfo.getDefault("AttackerPPBVAdjustment"));
        this.AttackerPPUnitAdjustmentText.setText(this.defaultOperationInfo.getDefault("AttackerPPUnitAdjustment"));
        this.DefenderBasePPAmountText.setText(this.defaultOperationInfo.getDefault("DefenderBasePPAmount"));
        this.DefenderPPBVAdjustmentText.setText(this.defaultOperationInfo.getDefault("DefenderPPBVAdjustment"));
        this.DefenderPPUnitAdjustmentText.setText(this.defaultOperationInfo.getDefault("DefenderPPUnitAdjustment"));
        this.AttackerBaseUnitsTakenText.setText(this.defaultOperationInfo.getDefault("AttackerBaseUnitsTaken"));
        this.AttackerUnitsBVAdjustmentText.setText(this.defaultOperationInfo.getDefault("AttackerUnitsBVAdjustment"));
        this.AttackerUnitsUnitAdjustmentText.setText(this.defaultOperationInfo.getDefault("AttackerUnitsUnitAdjustment"));
        this.AttackerTargetOpAdjustmentText.setText(this.defaultOperationInfo.getDefault("AttackerTargetOpAdjustment"));
        this.DefenderTargetOpAdjustmentText.setText(this.defaultOperationInfo.getDefault("DefenderTargetOpAdjustment"));
        this.ConquestAmountCapText.setText(this.defaultOperationInfo.getDefault("ConquestAmountCap"));
        this.DelayAmountCapText.setText(this.defaultOperationInfo.getDefault("DelayAmountCap"));
        this.PPCapptureCapText.setText(this.defaultOperationInfo.getDefault("PPCapptureCap"));
        this.UnitCaptureCapText.setText(this.defaultOperationInfo.getDefault("UnitCaptureCap"));
        this.TimeToNondefensePenaltyText.setText(this.defaultOperationInfo.getDefault("TimeToNondefensePenalty"));
        this.LeechesToDeactivateText.setText(this.defaultOperationInfo.getDefault("LeechesToDeactivate"));
        this.FlatRPChickenPenaltyText.setText(this.defaultOperationInfo.getDefault("FlatRPChickenPenalty"));
        this.FlatExpChickenPenaltyText.setText(this.defaultOperationInfo.getDefault("FlatExpChickenPenalty"));
        this.FlatInfluenceChickenPenaltyText.setText(this.defaultOperationInfo.getDefault("FlatInfluenceChickenPenalty"));
        this.FlatCBillChickenPenaltyText.setText(this.defaultOperationInfo.getDefault("FlatCBillChickenPenalty"));
        this.PercentRPChickenPenaltyText.setText(this.defaultOperationInfo.getDefault("PercentRPChickenPenalty"));
        this.PercentExpChickenPenaltyText.setText(this.defaultOperationInfo.getDefault("PercentExpChickenPenalty"));
        this.PercentInfluenceChickenPenaltyText.setText(this.defaultOperationInfo.getDefault("PercentInfluenceChickenPenalty"));
        this.PercentCBillChickenPenaltyText.setText(this.defaultOperationInfo.getDefault("PercentCBillChickenPenalty"));
        this.ConquestPerLeechText.setText(this.defaultOperationInfo.getDefault("ConquestPerLeech"));
        this.DelayPerLeechText.setText(this.defaultOperationInfo.getDefault("DelayPerLeech"));
        this.ProdPointsPerLeechText.setText(this.defaultOperationInfo.getDefault("ProdPointsPerLeech"));
        this.UnitsPerLeechText.setText(this.defaultOperationInfo.getDefault("UnitsPerLeech"));
        this.FailurePenaltyText.setText(this.defaultOperationInfo.getDefault("FailurePenalty"));
        this.BaseUnitXPText.setText(this.defaultOperationInfo.getDefault("BaseUnitXP"));
        this.UnitXPUnitsAdjustmentText.setText(this.defaultOperationInfo.getDefault("UnitXPUnitsAdjustment"));
        this.UnitXPBVAdjustmentText.setText(this.defaultOperationInfo.getDefault("UnitXPBVAdjustment"));
        this.WinnerBonusUnitXPText.setText(this.defaultOperationInfo.getDefault("WinnerBonusUnitXP"));
        this.DefenderBonusUnitXPText.setText(this.defaultOperationInfo.getDefault("DefenderBonusUnitXP"));
        this.KillBonusUnitXPText.setText(this.defaultOperationInfo.getDefault("KillBonusUnitXP"));
        this.KillBonusXPforBVText.setText(this.defaultOperationInfo.getDefault("KillBonusXPforBV"));
        this.TotalBuildingsText.setText(this.defaultOperationInfo.getDefault("TotalBuildings"));
        this.MinBuildingsForOpText.setText(this.defaultOperationInfo.getDefault("MinBuildingsForOp"));
        this.MinFloorsText.setText(this.defaultOperationInfo.getDefault("MinFloors"));
        this.MaxFloorsText.setText(this.defaultOperationInfo.getDefault("MaxFloors"));
        this.MinCFText.setText(this.defaultOperationInfo.getDefault("MinCF"));
        this.MaxCFText.setText(this.defaultOperationInfo.getDefault("MaxCF"));
        this.BuildingTypeText.setText(this.defaultOperationInfo.getDefault("BuildingType"));
        this.BuildingsStartOnMapEdgeCBox.setSelected(Boolean.valueOf(this.defaultOperationInfo.getDefault("BuildingsStartOnMapEdge")));
        this.DelayPerBuildingText.setText(this.defaultOperationInfo.getDefault("DelayPerBuilding"));
        this.AttackerExpPerBuildingText.setText(this.defaultOperationInfo.getDefault("AttackerExpPerBuilding"));
        this.AttackerFluPerBuildingText.setText(this.defaultOperationInfo.getDefault("AttackerFluPerBuilding"));
        this.AttackerRPPerBuildingText.setText(this.defaultOperationInfo.getDefault("AttackerRPPerBuilding"));
        this.AttackerMoneyPerBuildingText.setText(this.defaultOperationInfo.getDefault("AttackerMoneyPerBuilding"));
        this.AttackerMinBuildingsIfAttackerWinsText.setText(this.defaultOperationInfo.getDefault("AttackerMinBuildingsIfAttackerWins"));
        this.DefenderExpPerBuildingText.setText(this.defaultOperationInfo.getDefault("DefenderExpPerBuilding"));
        this.DefenderFluPerBuildingText.setText(this.defaultOperationInfo.getDefault("DefenderFluPerBuilding"));
        this.DefenderRPPerBuildingText.setText(this.defaultOperationInfo.getDefault("DefenderRPPerBuilding"));
        this.DefenderMoneyPerBuildingText.setText(this.defaultOperationInfo.getDefault("DefenderMoneyPerBuilding"));
    }

    public void saveShortOperations() {
        try {
            FileOutputStream out = new FileOutputStream(this.filePathName);
            PrintStream p = new PrintStream(out);
            if (!this.OperationColorText.getText().equals(this.defaultOperationInfo.getDefault("OperationColor"))) {
                p.println("OperationColor=" + this.OperationColorText.getText());
            }
            if (!this.OperationRangeText.getText().equals(this.defaultOperationInfo.getDefault("OperationRange"))) {
                p.println("OperationRange=" + this.OperationRangeText.getText());
            }
            if (!this.PercentageToAttackOnWorldText.getText().equals(this.defaultOperationInfo.getDefault("PercentageToAttackOnWorld"))) {
                p.println("PercentageToAttackOnWorld=" + this.PercentageToAttackOnWorldText.getText());
            }
            if (!this.PercentageToAttackOffWorldText.getText().equals(this.defaultOperationInfo.getDefault("PercentageToAttackOffWorld"))) {
                p.println("PercentageToAttackOffWorld=" + this.PercentageToAttackOffWorldText.getText());
            }
            if (this.OnlyAgainstFactoryWorldsCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("OnlyAgainstFactoryWorlds")).booleanValue()) {
                p.println("OnlyAgainstFactoryWorlds=" + this.OnlyAgainstFactoryWorldsCBox.isSelected());
            }
            if (this.OnlyAgainstNonFactoryWorldsCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("OnlyAgainstNonFactoryWorlds")).booleanValue()) {
                p.println("OnlyAgainstNonFactoryWorlds=" + this.OnlyAgainstNonFactoryWorldsCBox.isSelected());
            }
            if (!this.MaxAttackerBVText.getText().equals(this.defaultOperationInfo.getDefault("MaxAttackerBV"))) {
                p.println("MaxAttackerBV=" + this.MaxAttackerBVText.getText());
            }
            if (!this.MinAttackerBVText.getText().equals(this.defaultOperationInfo.getDefault("MinAttackerBV"))) {
                p.println("MinAttackerBV=" + this.MinAttackerBVText.getText());
            }
            if (!this.MaxDefenderBVText.getText().equals(this.defaultOperationInfo.getDefault("MaxDefenderBV"))) {
                p.println("MaxDefenderBV=" + this.MaxDefenderBVText.getText());
            }
            if (!this.MinDefenderBVText.getText().equals(this.defaultOperationInfo.getDefault("MinDefenderBV"))) {
                p.println("MinDefenderBV=" + this.MinDefenderBVText.getText());
            }
            if (!this.MaxAttackerUnitsText.getText().equals(this.defaultOperationInfo.getDefault("MaxAttackerUnits"))) {
                p.println("MaxAttackerUnits=" + this.MaxAttackerUnitsText.getText());
            }
            if (!this.MinAttackerUnitsText.getText().equals(this.defaultOperationInfo.getDefault("MinAttackerUnits"))) {
                p.println("MinAttackerUnits=" + this.MinAttackerUnitsText.getText());
            }
            if (!this.MaxDefenderUnitsText.getText().equals(this.defaultOperationInfo.getDefault("MaxDefenderUnits"))) {
                p.println("MaxDefenderUnits=" + this.MaxDefenderUnitsText.getText());
            }
            if (!this.MinDefenderUnitsText.getText().equals(this.defaultOperationInfo.getDefault("MinDefenderUnits"))) {
                p.println("MinDefenderUnits=" + this.MinDefenderUnitsText.getText());
            }
            if (!this.MinAttackerWalkText.getText().equals(this.defaultOperationInfo.getDefault("MinAttackerWalk"))) {
                p.println("MinAttackerWalk=" + this.MinAttackerWalkText.getText());
            }
            if (!this.MinDefenderWalkText.getText().equals(this.defaultOperationInfo.getDefault("MinDefenderWalk"))) {
                p.println("MinDefenderWalk=" + this.MinDefenderWalkText.getText());
            }
            if (!this.MinAttackerJumpText.getText().equals(this.defaultOperationInfo.getDefault("MinAttackerJump"))) {
                p.println("MinAttackerJump=" + this.MinAttackerJumpText.getText());
            }
            if (!this.MinDefenderJumpText.getText().equals(this.defaultOperationInfo.getDefault("MinDefenderJump"))) {
                p.println("MinDefenderJump=" + this.MinDefenderJumpText.getText());
            }
            if (!this.MaxAttackerUnitTonnageText.getText().equals(this.defaultOperationInfo.getDefault("MaxAttackerUnitTonnage"))) {
                p.println("MaxAttackerUnitTonnage=" + this.MaxAttackerUnitTonnageText.getText());
            }
            if (!this.MaxDefenderUnitTonnageText.getText().equals(this.defaultOperationInfo.getDefault("MaxDefenderUnitTonnage"))) {
                p.println("MaxDefenderUnitTonnage=" + this.MaxDefenderUnitTonnageText.getText());
            }
            if (!this.MinAttackerUnitTonnageText.getText().equals(this.defaultOperationInfo.getDefault("MinAttackerUnitTonnage"))) {
                p.println("MinAttackerUnitTonnage=" + this.MinAttackerUnitTonnageText.getText());
            }
            if (!this.MinDefenderUnitTonnageText.getText().equals(this.defaultOperationInfo.getDefault("MinDefenderUnitTonnage"))) {
                p.println("MinDefenderUnitTonnage=" + this.MinDefenderUnitTonnageText.getText());
            }
            if (!this.MaxTotalAttackerTonnageText.getText().equals(this.defaultOperationInfo.getDefault("MaxTotalAttackerTonnage"))) {
                p.println("MaxTotalAttackerTonnage=" + this.MaxTotalAttackerTonnageText.getText());
            }
            if (!this.MaxTotalDefenderTonnageText.getText().equals(this.defaultOperationInfo.getDefault("MaxTotalDefenderTonnage"))) {
                p.println("MaxTotalDefenderTonnage=" + this.MaxTotalDefenderTonnageText.getText());
            }
            if (!this.MinTotalAttackerTonnageText.getText().equals(this.defaultOperationInfo.getDefault("MinTotalAttackerTonnage"))) {
                p.println("MinTotalAttackerTonnage=" + this.MinTotalAttackerTonnageText.getText());
            }
            if (!this.MinTotalDefenderTonnageText.getText().equals(this.defaultOperationInfo.getDefault("MinTotalDefenderTonnage"))) {
                p.println("MinTotalDefenderTonnage=" + this.MinTotalDefenderTonnageText.getText());
            }
            if (this.AttackerAllowedMeksCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("AttackerAllowedMeks")).booleanValue()) {
                p.println("AttackerAllowedMeks=" + this.AttackerAllowedMeksCBox.isSelected());
            }
            if (this.AttackerAllowedVehsCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("AttackerAllowedVehs")).booleanValue()) {
                p.println("AttackerAllowedVehs=" + this.AttackerAllowedVehsCBox.isSelected());
            }
            if (this.AttackerAllowedInfCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("AttackerAllowedInf")).booleanValue()) {
                p.println("AttackerAllowedInf=" + this.AttackerAllowedInfCBox.isSelected());
            }
            if (this.DefenderAllowedMeksCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("DefenderAllowedMeks")).booleanValue()) {
                p.println("DefenderAllowedMeks=" + this.DefenderAllowedMeksCBox.isSelected());
            }
            if (this.DefenderAllowedVehsCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("DefenderAllowedVehs")).booleanValue()) {
                p.println("DefenderAllowedVehs=" + this.DefenderAllowedVehsCBox.isSelected());
            }
            if (this.DefenderAllowedInfCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("DefenderAllowedInf")).booleanValue()) {
                p.println("DefenderAllowedInf=" + this.DefenderAllowedInfCBox.isSelected());
            }
            if (this.PoweredInfAllowedCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("PoweredInfAllowed")).booleanValue()) {
                p.println("PoweredInfAllowed=" + this.PoweredInfAllowedCBox.isSelected());
            }
            if (!this.AttackerCostMoneyText.getText().equals(this.defaultOperationInfo.getDefault("AttackerCostMoney"))) {
                p.println("AttackerCostMoney=" + this.AttackerCostMoneyText.getText());
            }
            if (!this.AttackerCostInfluenceText.getText().equals(this.defaultOperationInfo.getDefault("AttackerCostInfluence"))) {
                p.println("AttackerCostInfluence=" + this.AttackerCostInfluenceText.getText());
            }
            if (!this.AttackerCostRewardText.getText().equals(this.defaultOperationInfo.getDefault("AttackerCostReward"))) {
                p.println("AttackerCostReward=" + this.AttackerCostRewardText.getText());
            }
            if (!this.DefenderCostMoneyText.getText().equals(this.defaultOperationInfo.getDefault("DefenderCostMoney"))) {
                p.println("DefenderCostMoney=" + this.DefenderCostMoneyText.getText());
            }
            if (!this.DefenderCostInfluenceText.getText().equals(this.defaultOperationInfo.getDefault("DefenderCostInfluence"))) {
                p.println("DefenderCostInfluence=" + this.DefenderCostInfluenceText.getText());
            }
            if (!this.DefenderCostRewardText.getText().equals(this.defaultOperationInfo.getDefault("DefenderCostReward"))) {
                p.println("DefenderCostReward=" + this.DefenderCostRewardText.getText());
            }
            if (!this.MinAttackerRatingText.getText().equals(this.defaultOperationInfo.getDefault("MinAttackerRating"))) {
                p.println("MinAttackerRating=" + this.MinAttackerRatingText.getText());
            }
            if (!this.MaxAttackerRatingText.getText().equals(this.defaultOperationInfo.getDefault("MaxAttackerRating"))) {
                p.println("MaxAttackerRating=" + this.MaxAttackerRatingText.getText());
            }
            if (!this.MinDefenderRatingText.getText().equals(this.defaultOperationInfo.getDefault("MinDefenderRating"))) {
                p.println("MinDefenderRating=" + this.MinDefenderRatingText.getText());
            }
            if (!this.MaxDefenderRatingText.getText().equals(this.defaultOperationInfo.getDefault("MaxDefenderRating"))) {
                p.println("MaxDefenderRating=" + this.MaxDefenderRatingText.getText());
            }
            if (!this.MinAttackerXPText.getText().equals(this.defaultOperationInfo.getDefault("MinAttackerXP"))) {
                p.println("MinAttackerXP=" + this.MinAttackerXPText.getText());
            }
            if (!this.MaxAttackerXPText.getText().equals(this.defaultOperationInfo.getDefault("MaxAttackerXP"))) {
                p.println("MaxAttackerXP=" + this.MaxAttackerXPText.getText());
            }
            if (!this.MinDefenderXPText.getText().equals(this.defaultOperationInfo.getDefault("MinDefenderXP"))) {
                p.println("MinDefenderXP=" + this.MinDefenderXPText.getText());
            }
            if (!this.MaxDefenderXPText.getText().equals(this.defaultOperationInfo.getDefault("MaxDefenderXP"))) {
                p.println("MaxDefenderXP=" + this.MaxDefenderXPText.getText());
            }
            if (!this.MinAttackerGamesPlayedText.getText().equals(this.defaultOperationInfo.getDefault("MinAttackerGamesPlayed"))) {
                p.println("MinAttackerGamesPlayed=" + this.MinAttackerGamesPlayedText.getText());
            }
            if (!this.MaxAttackerGamesPlayedText.getText().equals(this.defaultOperationInfo.getDefault("MaxAttackerGamesPlayed"))) {
                p.println("MaxAttackerGamesPlayed=" + this.MaxAttackerGamesPlayedText.getText());
            }
            if (!this.MinDefenderGamesPlayedText.getText().equals(this.defaultOperationInfo.getDefault("MinDefenderGamesPlayed"))) {
                p.println("MinDefenderGamesPlayed=" + this.MinDefenderGamesPlayedText.getText());
            }
            if (!this.MaxDefenderGamesPlayedText.getText().equals(this.defaultOperationInfo.getDefault("MaxDefenderGamesPlayed"))) {
                p.println("MaxDefenderGamesPlayed=" + this.MaxDefenderGamesPlayedText.getText());
            }
            if (this.DefenderReceivesAutoArtilleryCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("DefenderReceivesAutoArtillery")).booleanValue()) {
                p.println("DefenderReceivesAutoArtillery=" + this.DefenderReceivesAutoArtilleryCBox.isSelected());
            }
            if (this.AttackerReceivesAutoArtilleryCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("AttackerReceivesAutoArtillery")).booleanValue()) {
                p.println("AttackerReceivesAutoArtillery=" + this.AttackerReceivesAutoArtilleryCBox.isSelected());
            }
            if (!this.DefenderFlatArtilleryModifierText.getText().equals(this.defaultOperationInfo.getDefault("DefenderFlatArtilleryModifier"))) {
                p.println("DefenderFlatArtilleryModifier=" + this.DefenderFlatArtilleryModifierText.getText());
            }
            if (!this.AttackerFlatArtilleryModifierText.getText().equals(this.defaultOperationInfo.getDefault("AttackerFlatArtilleryModifier"))) {
                p.println("AttackerFlatArtilleryModifier=" + this.AttackerFlatArtilleryModifierText.getText());
            }
            if (!this.DefenderPercentArtilleryModifierText.getText().equals(this.defaultOperationInfo.getDefault("DefenderPercentArtilleryModifier"))) {
                p.println("DefenderPercentArtilleryModifier=" + this.DefenderPercentArtilleryModifierText.getText());
            }
            if (!this.AttackerPercentArtilleryModifierText.getText().equals(this.defaultOperationInfo.getDefault("AttackerPercentArtilleryModifier"))) {
                p.println("AttackerPercentArtilleryModifier=" + this.AttackerPercentArtilleryModifierText.getText());
            }
            if (!this.MinDefenderArtilleryBVText.getText().equals(this.defaultOperationInfo.getDefault("MinDefenderArtilleryBV"))) {
                p.println("MinDefenderArtilleryBV=" + this.MinDefenderArtilleryBVText.getText());
            }
            if (!this.MinAttackerArtilleryBVText.getText().equals(this.defaultOperationInfo.getDefault("MinAttackerArtilleryBV"))) {
                p.println("MinAttackerArtilleryBV=" + this.MinAttackerArtilleryBVText.getText());
            }
            if (!this.MaxDefenderArtilleryBVText.getText().equals(this.defaultOperationInfo.getDefault("MaxDefenderArtilleryBV"))) {
                p.println("MaxDefenderArtilleryBV=" + this.MaxDefenderArtilleryBVText.getText());
            }
            if (!this.MaxAttackerArtilleryBVText.getText().equals(this.defaultOperationInfo.getDefault("MaxAttackerArtilleryBV"))) {
                p.println("MaxAttackerArtilleryBV=" + this.MaxAttackerArtilleryBVText.getText());
            }
            if (!this.BaseAttackerPayCBillsText.getText().equals(this.defaultOperationInfo.getDefault("BaseAttackerPayCBills"))) {
                p.println("BaseAttackerPayCBills=" + this.BaseAttackerPayCBillsText.getText());
            }
            if (!this.BaseDefenderPayCBillsText.getText().equals(this.defaultOperationInfo.getDefault("BaseDefenderPayCBills"))) {
                p.println("BaseDefenderPayCBills=" + this.BaseDefenderPayCBillsText.getText());
            }
            if (!this.BaseAttackerPayInfluenceText.getText().equals(this.defaultOperationInfo.getDefault("BaseAttackerPayInfluence"))) {
                p.println("BaseAttackerPayInfluence=" + this.BaseAttackerPayInfluenceText.getText());
            }
            if (!this.BaseDefenderPayInfluenceText.getText().equals(this.defaultOperationInfo.getDefault("BaseDefenderPayInfluence"))) {
                p.println("BaseDefenderPayInfluence=" + this.BaseDefenderPayInfluenceText.getText());
            }
            if (!this.BaseAttackerPayExperienceText.getText().equals(this.defaultOperationInfo.getDefault("BaseAttackerPayExperience"))) {
                p.println("BaseAttackerPayExperience=" + this.BaseAttackerPayExperienceText.getText());
            }
            if (!this.BaseDefenderPayExperienceText.getText().equals(this.defaultOperationInfo.getDefault("BaseDefenderPayExperience"))) {
                p.println("BaseDefenderPayExperience=" + this.BaseDefenderPayExperienceText.getText());
            }
            if (!this.AttackerPayBVforCBillText.getText().equals(this.defaultOperationInfo.getDefault("AttackerPayBVforCBill"))) {
                p.println("AttackerPayBVforCBill=" + this.AttackerPayBVforCBillText.getText());
            }
            if (!this.DefenderPayBVforCBillText.getText().equals(this.defaultOperationInfo.getDefault("DefenderPayBVforCBill"))) {
                p.println("DefenderPayBVforCBill=" + this.DefenderPayBVforCBillText.getText());
            }
            if (!this.AttackerPayBVforInfluenceText.getText().equals(this.defaultOperationInfo.getDefault("AttackerPayBVforInfluence"))) {
                p.println("AttackerPayBVforInfluence=" + this.AttackerPayBVforInfluenceText.getText());
            }
            if (!this.DefenderPayBVforInfluenceText.getText().equals(this.defaultOperationInfo.getDefault("DefenderPayBVforInfluence"))) {
                p.println("DefenderPayBVforInfluence=" + this.DefenderPayBVforInfluenceText.getText());
            }
            if (!this.AttackerPayBVforExperienceText.getText().equals(this.defaultOperationInfo.getDefault("AttackerPayBVforExperience"))) {
                p.println("AttackerPayBVforExperience=" + this.AttackerPayBVforExperienceText.getText());
            }
            if (!this.DefenderPayBVforExperienceText.getText().equals(this.defaultOperationInfo.getDefault("DefenderPayBVforExperience"))) {
                p.println("DefenderPayBVforExperience=" + this.DefenderPayBVforExperienceText.getText());
            }
            if (!this.AttackerWinModifierCBillsFlatText.getText().equals(this.defaultOperationInfo.getDefault("AttackerWinModifierCBillsFlat"))) {
                p.println("AttackerWinModifierCBillsFlat=" + this.AttackerWinModifierCBillsFlatText.getText());
            }
            if (!this.DefenderWinModifierCBillsFlatText.getText().equals(this.defaultOperationInfo.getDefault("DefenderWinModifierCBillsFlat"))) {
                p.println("DefenderWinModifierCBillsFlat=" + this.DefenderWinModifierCBillsFlatText.getText());
            }
            if (!this.AttackerLossModifierCBillsFlatText.getText().equals(this.defaultOperationInfo.getDefault("AttackerLossModifierCBillsFlat"))) {
                p.println("AttackerLossModifierCBillsFlat=" + this.AttackerLossModifierCBillsFlatText.getText());
            }
            if (!this.DefenderLossModifierCBillsFlatText.getText().equals(this.defaultOperationInfo.getDefault("DefenderLossModifierCBillsFlat"))) {
                p.println("DefenderLossModifierCBillsFlat=" + this.DefenderLossModifierCBillsFlatText.getText());
            }
            if (!this.AttackerWinModifierCBillsPercentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerWinModifierCBillsPercent"))) {
                p.println("AttackerWinModifierCBillsPercent=" + this.AttackerWinModifierCBillsPercentText.getText());
            }
            if (!this.DefenderWinModifierCBillsPercentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderWinModifierCBillsPercent"))) {
                p.println("DefenderWinModifierCBillsPercent=" + this.DefenderWinModifierCBillsPercentText.getText());
            }
            if (!this.AttackerLossModifierCBillsPercentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerLossModifierCBillsPercent"))) {
                p.println("AttackerLossModifierCBillsPercent=" + this.AttackerLossModifierCBillsPercentText.getText());
            }
            if (!this.DefenderLossModifierCBillsPercentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderLossModifierCBillsPercent"))) {
                p.println("DefenderLossModifierCBillsPercent=" + this.DefenderLossModifierCBillsPercentText.getText());
            }
            if (!this.AttackerWinModifierInfluenceFlatText.getText().equals(this.defaultOperationInfo.getDefault("AttackerWinModifierInfluenceFlat"))) {
                p.println("AttackerWinModifierInfluenceFlat=" + this.AttackerWinModifierInfluenceFlatText.getText());
            }
            if (!this.DefenderWinModifierInfluenceFlatText.getText().equals(this.defaultOperationInfo.getDefault("DefenderWinModifierInfluenceFlat"))) {
                p.println("DefenderWinModifierInfluenceFlat=" + this.DefenderWinModifierInfluenceFlatText.getText());
            }
            if (!this.AttackerLossModifierInfluenceFlatText.getText().equals(this.defaultOperationInfo.getDefault("AttackerLossModifierInfluenceFlat"))) {
                p.println("AttackerLossModifierInfluenceFlat=" + this.AttackerLossModifierInfluenceFlatText.getText());
            }
            if (!this.DefenderLossModifierInfluenceFlatText.getText().equals(this.defaultOperationInfo.getDefault("DefenderLossModifierInfluenceFlat"))) {
                p.println("DefenderLossModifierInfluenceFlat=" + this.DefenderLossModifierInfluenceFlatText.getText());
            }
            if (!this.AttackerWinModifierInfluencePercentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerWinModifierInfluencePercent"))) {
                p.println("AttackerWinModifierInfluencePercent=" + this.AttackerWinModifierInfluencePercentText.getText());
            }
            if (!this.DefenderWinModifierInfluencePercentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderWinModifierInfluencePercent"))) {
                p.println("DefenderWinModifierInfluencePercent=" + this.DefenderWinModifierInfluencePercentText.getText());
            }
            if (!this.AttackerLossModifierInfluencePercentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerLossModifierInfluencePercent"))) {
                p.println("AttackerLossModifierInfluencePercent=" + this.AttackerLossModifierInfluencePercentText.getText());
            }
            if (!this.DefenderLossModifierInfluencePercentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderLossModifierInfluencePercent"))) {
                p.println("DefenderLossModifierInfluencePercent=" + this.DefenderLossModifierInfluencePercentText.getText());
            }
            if (!this.AttackerWinModifierExperienceFlatText.getText().equals(this.defaultOperationInfo.getDefault("AttackerWinModifierExperienceFlat"))) {
                p.println("AttackerWinModifierExperienceFlat=" + this.AttackerWinModifierExperienceFlatText.getText());
            }
            if (!this.DefenderWinModifierExperienceFlatText.getText().equals(this.defaultOperationInfo.getDefault("DefenderWinModifierExperienceFlat"))) {
                p.println("DefenderWinModifierExperienceFlat=" + this.DefenderWinModifierExperienceFlatText.getText());
            }
            if (!this.AttackerLossModifierExperienceFlatText.getText().equals(this.defaultOperationInfo.getDefault("AttackerLossModifierExperienceFlat"))) {
                p.println("AttackerLossModifierExperienceFlat=" + this.AttackerLossModifierExperienceFlatText.getText());
            }
            if (!this.DefenderLossModifierExperienceFlatText.getText().equals(this.defaultOperationInfo.getDefault("DefenderLossModifierExperienceFlat"))) {
                p.println("DefenderLossModifierExperienceFlat=" + this.DefenderLossModifierExperienceFlatText.getText());
            }
            if (!this.AttackerWinModifierExperiencePercentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerWinModifierExperiencePercent"))) {
                p.println("AttackerWinModifierExperiencePercent=" + this.AttackerWinModifierExperiencePercentText.getText());
            }
            if (!this.DefenderWinModifierExperiencePercentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderWinModifierExperiencePercent"))) {
                p.println("DefenderWinModifierExperiencePercent=" + this.DefenderWinModifierExperiencePercentText.getText());
            }
            if (!this.AttackerLossModifierExperiencePercentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerLossModifierExperiencePercent"))) {
                p.println("AttackerLossModifierExperiencePercent=" + this.AttackerLossModifierExperiencePercentText.getText());
            }
            if (!this.DefenderLossModifierExperiencePercentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderLossModifierExperiencePercent"))) {
                p.println("DefenderLossModifierExperiencePercent=" + this.DefenderLossModifierExperiencePercentText.getText());
            }
            if (!this.RPForLoserText.getText().equals(this.defaultOperationInfo.getDefault("RPForLoser"))) {
                p.println("RPForLoser=" + this.RPForLoserText.getText());
            }
            if (!this.RPForDefenderText.getText().equals(this.defaultOperationInfo.getDefault("RPForDefender"))) {
                p.println("RPForDefender=" + this.RPForDefenderText.getText());
            }
            if (!this.RPForAttackerText.getText().equals(this.defaultOperationInfo.getDefault("RPForAttacker"))) {
                p.println("RPForAttacker=" + this.RPForAttackerText.getText());
            }
            if (!this.RPForWinnerText.getText().equals(this.defaultOperationInfo.getDefault("RPForWinner"))) {
                p.println("RPForWinner=" + this.RPForWinnerText.getText());
            }
            if (this.OnlyGiveRPtoWinnersCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("OnlyGiveRPtoWinners")).booleanValue()) {
                p.println("OnlyGiveRPtoWinners=" + this.OnlyGiveRPtoWinnersCBox.isSelected());
            }
            if (this.WinnerAlwaysSalvagesOwnUnitsCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("WinnerAlwaysSalvagesOwnUnits")).booleanValue()) {
                p.println("WinnerAlwaysSalvagesOwnUnits=" + this.WinnerAlwaysSalvagesOwnUnitsCBox.isSelected());
            }
            if (!this.BaseAttackerSalvagePercentText.getText().equals(this.defaultOperationInfo.getDefault("BaseAttackerSalvagePercent"))) {
                p.println("BaseAttackerSalvagePercent=" + this.BaseAttackerSalvagePercentText.getText());
            }
            if (!this.BaseDefenderSalvagePercentText.getText().equals(this.defaultOperationInfo.getDefault("BaseDefenderSalvagePercent"))) {
                p.println("BaseDefenderSalvagePercent=" + this.BaseDefenderSalvagePercentText.getText());
            }
            if (!this.AttackerSalvageAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerSalvageAdjustment"))) {
                p.println("AttackerSalvageAdjustment=" + this.AttackerSalvageAdjustmentText.getText());
            }
            if (!this.DefenderSalvageAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderSalvageAdjustment"))) {
                p.println("DefenderSalvageAdjustment=" + this.DefenderSalvageAdjustmentText.getText());
            }
            if (!this.BVToBoostAttackerSalvageCostText.getText().equals(this.defaultOperationInfo.getDefault("BVToBoostAttackerSalvageCost"))) {
                p.println("BVToBoostAttackerSalvageCost=" + this.BVToBoostAttackerSalvageCostText.getText());
            }
            if (!this.BVToBoostDefenderSalvageCostText.getText().equals(this.defaultOperationInfo.getDefault("BVToBoostDefenderSalvageCost"))) {
                p.println("BVToBoostDefenderSalvageCost=" + this.BVToBoostDefenderSalvageCostText.getText());
            }
            if (!this.AttackerSalvageCostModifierText.getText().equals(this.defaultOperationInfo.getDefault("AttackerSalvageCostModifier"))) {
                p.println("AttackerSalvageCostModifier=" + this.AttackerSalvageCostModifierText.getText());
            }
            if (!this.DefenderSalvageCostModifierText.getText().equals(this.defaultOperationInfo.getDefault("DefenderSalvageCostModifier"))) {
                p.println("DefenderSalvageCostModifier=" + this.DefenderSalvageCostModifierText.getText());
            }
            if (this.AllowSOLToUseCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("AllowSOLToUse")).booleanValue()) {
                p.println("AllowSOLToUse=" + this.AllowSOLToUseCBox.isSelected());
            }
            if (this.AllowAgainstSOLCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("AllowAgainstSOL")).booleanValue()) {
                p.println("AllowAgainstSOL=" + this.AllowAgainstSOLCBox.isSelected());
            }
            if (this.AllowNonConqToUseCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("AllowNonConqToUse")).booleanValue()) {
                p.println("AllowNonConqToUse=" + this.AllowNonConqToUseCBox.isSelected());
            }
            if (this.AllowAgainstNonConqCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("AllowAgainstNonConq")).booleanValue()) {
                p.println("AllowAgainstNonConq=" + this.AllowAgainstNonConqCBox.isSelected());
            }
            if (this.SOLPilotsGainXPCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("SOLPilotsGainXP")).booleanValue()) {
                p.println("SOLPilotsGainXP=" + this.SOLPilotsGainXPCBox.isSelected());
            }
            if (this.HousePilotsGainXPCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("HousePilotsGainXP")).booleanValue()) {
                p.println("HousePilotsGainXP=" + this.HousePilotsGainXPCBox.isSelected());
            }
            if (this.SOLPilotsCheckLevelUpCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("SOLPilotsCheckLevelUp")).booleanValue()) {
                p.println("SOLPilotsCheckLevelUp=" + this.SOLPilotsCheckLevelUpCBox.isSelected());
            }
            if (this.HousePilotsCheckLevelUpCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("HousePilotsCheckLevelUp")).booleanValue()) {
                p.println("HousePilotsCheckLevelUp=" + this.HousePilotsCheckLevelUpCBox.isSelected());
            }
            if (this.PayAllAsWinnersCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("PayAllAsWinners")).booleanValue()) {
                p.println("PayAllAsWinners=" + this.PayAllAsWinnersCBox.isSelected());
            }
            if (this.NoStatisticsModeCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("NoStatisticsMode")).booleanValue()) {
                p.println("NoStatisticsMode=" + this.NoStatisticsModeCBox.isSelected());
            }
            if (this.NoDestructionModeCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("NoDestructionMode")).booleanValue()) {
                p.println("NoDestructionMode=" + this.NoDestructionModeCBox.isSelected());
            }
            if (this.CountGameForRankingCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("CountGameForRanking")).booleanValue()) {
                p.println("CountGameForRanking=" + this.CountGameForRankingCBox.isSelected());
            }
            if (!this.CountGameForProductionText.getText().equals(this.defaultOperationInfo.getDefault("CountGameForProduction"))) {
                p.println("CountGameForProduction=" + this.CountGameForProductionText.getText());
            }
            if (this.PayTechsForGameCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("PayTechsForGame")).booleanValue()) {
                p.println("PayTechsForGame=" + this.PayTechsForGameCBox.isSelected());
            }
            if (!this.AttackerBaseConquestAmountText.getText().equals(this.defaultOperationInfo.getDefault("AttackerBaseConquestAmount"))) {
                p.println("AttackerBaseConquestAmount=" + this.AttackerBaseConquestAmountText.getText());
            }
            if (!this.AttackerConquestBVAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerConquestBVAdjustment"))) {
                p.println("AttackerConquestBVAdjustment=" + this.AttackerConquestBVAdjustmentText.getText());
            }
            if (!this.AttackerConquestUnitAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerConquestUnitAdjustment"))) {
                p.println("AttackerConquestUnitAdjustment=" + this.AttackerConquestUnitAdjustmentText.getText());
            }
            if (!this.DefenderBaseConquestAmountText.getText().equals(this.defaultOperationInfo.getDefault("DefenderBaseConquestAmount"))) {
                p.println("DefenderBaseConquestAmount=" + this.DefenderBaseConquestAmountText.getText());
            }
            if (!this.DefenderConquestBVAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderConquestBVAdjustment"))) {
                p.println("DefenderConquestBVAdjustment=" + this.DefenderConquestBVAdjustmentText.getText());
            }
            if (!this.DefenderConquestUnitAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderConquestUnitAdjustment"))) {
                p.println("DefenderConquestUnitAdjustment=" + this.DefenderConquestUnitAdjustmentText.getText());
            }
            if (!this.AttackerBaseDelayAmountText.getText().equals(this.defaultOperationInfo.getDefault("AttackerBaseDelayAmount"))) {
                p.println("AttackerBaseDelayAmount=" + this.AttackerBaseDelayAmountText.getText());
            }
            if (!this.AttackerDelayBVAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerDelayBVAdjustment"))) {
                p.println("AttackerDelayBVAdjustment=" + this.AttackerDelayBVAdjustmentText.getText());
            }
            if (!this.AttackerDelayUnitAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerDelayUnitAdjustment"))) {
                p.println("AttackerDelayUnitAdjustment=" + this.AttackerDelayUnitAdjustmentText.getText());
            }
            if (!this.DefenderBaseDelayAmountText.getText().equals(this.defaultOperationInfo.getDefault("DefenderBaseDelayAmount"))) {
                p.println("DefenderBaseDelayAmount=" + this.DefenderBaseDelayAmountText.getText());
            }
            if (!this.DefenderDelayBVAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderDelayBVAdjustment"))) {
                p.println("DefenderDelayBVAdjustment=" + this.DefenderDelayBVAdjustmentText.getText());
            }
            if (!this.DefenderDelayUnitAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderDelayUnitAdjustment"))) {
                p.println("DefenderDelayUnitAdjustment=" + this.DefenderDelayUnitAdjustmentText.getText());
            }
            if (!this.AttackerBasePPAmountText.getText().equals(this.defaultOperationInfo.getDefault("AttackerBasePPAmount"))) {
                p.println("AttackerBasePPAmount=" + this.AttackerBasePPAmountText.getText());
            }
            if (!this.AttackerPPBVAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerPPBVAdjustment"))) {
                p.println("AttackerPPBVAdjustment=" + this.AttackerPPBVAdjustmentText.getText());
            }
            if (!this.AttackerPPUnitAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerPPUnitAdjustment"))) {
                p.println("AttackerPPUnitAdjustment=" + this.AttackerPPUnitAdjustmentText.getText());
            }
            if (!this.DefenderBasePPAmountText.getText().equals(this.defaultOperationInfo.getDefault("DefenderBasePPAmount"))) {
                p.println("DefenderBasePPAmount=" + this.DefenderBasePPAmountText.getText());
            }
            if (!this.DefenderPPBVAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderPPBVAdjustment"))) {
                p.println("DefenderPPBVAdjustment=" + this.DefenderPPBVAdjustmentText.getText());
            }
            if (!this.DefenderPPUnitAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderPPUnitAdjustment"))) {
                p.println("DefenderPPUnitAdjustment=" + this.DefenderPPUnitAdjustmentText.getText());
            }
            if (!this.AttackerBaseUnitsTakenText.getText().equals(this.defaultOperationInfo.getDefault("AttackerBaseUnitsTaken"))) {
                p.println("AttackerBaseUnitsTaken=" + this.AttackerBaseUnitsTakenText.getText());
            }
            if (!this.AttackerUnitsBVAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerUnitsBVAdjustment"))) {
                p.println("AttackerUnitsBVAdjustment=" + this.AttackerUnitsBVAdjustmentText.getText());
            }
            if (!this.AttackerUnitsUnitAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerUnitsUnitAdjustment"))) {
                p.println("AttackerUnitsUnitAdjustment=" + this.AttackerUnitsUnitAdjustmentText.getText());
            }
            if (!this.AttackerTargetOpAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("AttackerTargetOpAdjustment"))) {
                p.println("AttackerTargetOpAdjustment=" + this.AttackerTargetOpAdjustmentText.getText());
            }
            if (!this.DefenderTargetOpAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("DefenderTargetOpAdjustment"))) {
                p.println("DefenderTargetOpAdjustment=" + this.DefenderTargetOpAdjustmentText.getText());
            }
            if (!this.ConquestAmountCapText.getText().equals(this.defaultOperationInfo.getDefault("ConquestAmountCap"))) {
                p.println("ConquestAmountCap=" + this.ConquestAmountCapText.getText());
            }
            if (!this.DelayAmountCapText.getText().equals(this.defaultOperationInfo.getDefault("DelayAmountCap"))) {
                p.println("DelayAmountCap=" + this.DelayAmountCapText.getText());
            }
            if (!this.PPCapptureCapText.getText().equals(this.defaultOperationInfo.getDefault("PPCapptureCap"))) {
                p.println("PPCapptureCap=" + this.PPCapptureCapText.getText());
            }
            if (!this.UnitCaptureCapText.getText().equals(this.defaultOperationInfo.getDefault("UnitCaptureCap"))) {
                p.println("UnitCaptureCap=" + this.UnitCaptureCapText.getText());
            }
            if (!this.TimeToNondefensePenaltyText.getText().equals(this.defaultOperationInfo.getDefault("TimeToNondefensePenalty"))) {
                p.println("TimeToNondefensePenalty=" + this.TimeToNondefensePenaltyText.getText());
            }
            if (!this.LeechesToDeactivateText.getText().equals(this.defaultOperationInfo.getDefault("LeechesToDeactivate"))) {
                p.println("LeechesToDeactivate=" + this.LeechesToDeactivateText.getText());
            }
            if (!this.FlatRPChickenPenaltyText.getText().equals(this.defaultOperationInfo.getDefault("FlatRPChickenPenalty"))) {
                p.println("FlatRPChickenPenalty=" + this.FlatRPChickenPenaltyText.getText());
            }
            if (!this.FlatExpChickenPenaltyText.getText().equals(this.defaultOperationInfo.getDefault("FlatExpChickenPenalty"))) {
                p.println("FlatExpChickenPenalty=" + this.FlatExpChickenPenaltyText.getText());
            }
            if (!this.FlatInfluenceChickenPenaltyText.getText().equals(this.defaultOperationInfo.getDefault("FlatInfluenceChickenPenalty"))) {
                p.println("FlatInfluenceChickenPenalty=" + this.FlatInfluenceChickenPenaltyText.getText());
            }
            if (!this.FlatCBillChickenPenaltyText.getText().equals(this.defaultOperationInfo.getDefault("FlatCBillChickenPenalty"))) {
                p.println("FlatCBillChickenPenalty=" + this.FlatCBillChickenPenaltyText.getText());
            }
            if (!this.PercentRPChickenPenaltyText.getText().equals(this.defaultOperationInfo.getDefault("PercentRPChickenPenalty"))) {
                p.println("PercentRPChickenPenalty=" + this.PercentRPChickenPenaltyText.getText());
            }
            if (!this.PercentExpChickenPenaltyText.getText().equals(this.defaultOperationInfo.getDefault("PercentExpChickenPenalty"))) {
                p.println("PercentExpChickenPenalty=" + this.PercentExpChickenPenaltyText.getText());
            }
            if (!this.PercentInfluenceChickenPenaltyText.getText().equals(this.defaultOperationInfo.getDefault("PercentInfluenceChickenPenalty"))) {
                p.println("PercentInfluenceChickenPenalty=" + this.PercentInfluenceChickenPenaltyText.getText());
            }
            if (!this.PercentCBillChickenPenaltyText.getText().equals(this.defaultOperationInfo.getDefault("PercentCBillChickenPenalty"))) {
                p.println("PercentCBillChickenPenalty=" + this.PercentCBillChickenPenaltyText.getText());
            }
            if (!this.ConquestPerLeechText.getText().equals(this.defaultOperationInfo.getDefault("ConquestPerLeech"))) {
                p.println("ConquestPerLeech=" + this.ConquestPerLeechText.getText());
            }
            if (!this.DelayPerLeechText.getText().equals(this.defaultOperationInfo.getDefault("DelayPerLeech"))) {
                p.println("DelayPerLeech=" + this.DelayPerLeechText.getText());
            }
            if (!this.ProdPointsPerLeechText.getText().equals(this.defaultOperationInfo.getDefault("ProdPointsPerLeech"))) {
                p.println("ProdPointsPerLeech=" + this.ProdPointsPerLeechText.getText());
            }
            if (!this.UnitsPerLeechText.getText().equals(this.defaultOperationInfo.getDefault("UnitsPerLeech"))) {
                p.println("UnitsPerLeech=" + this.UnitsPerLeechText.getText());
            }
            if (!this.FailurePenaltyText.getText().equals(this.defaultOperationInfo.getDefault("FailurePenalty"))) {
                p.println("FailurePenalty=" + this.FailurePenaltyText.getText());
            }
            if (!this.BaseUnitXPText.getText().equals(this.defaultOperationInfo.getDefault("BaseUnitXP"))) {
                p.println("BaseUnitXP=" + this.BaseUnitXPText.getText());
            }
            if (!this.UnitXPUnitsAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("UnitXPUnitsAdjustment"))) {
                p.println("UnitXPUnitsAdjustment=" + this.UnitXPUnitsAdjustmentText.getText());
            }
            if (!this.UnitXPBVAdjustmentText.getText().equals(this.defaultOperationInfo.getDefault("UnitXPBVAdjustment"))) {
                p.println("UnitXPBVAdjustment=" + this.UnitXPBVAdjustmentText.getText());
            }
            if (!this.WinnerBonusUnitXPText.getText().equals(this.defaultOperationInfo.getDefault("WinnerBonusUnitXP"))) {
                p.println("WinnerBonusUnitXP=" + this.WinnerBonusUnitXPText.getText());
            }
            if (!this.DefenderBonusUnitXPText.getText().equals(this.defaultOperationInfo.getDefault("DefenderBonusUnitXP"))) {
                p.println("DefenderBonusUnitXP=" + this.DefenderBonusUnitXPText.getText());
            }
            if (!this.KillBonusUnitXPText.getText().equals(this.defaultOperationInfo.getDefault("KillBonusUnitXP"))) {
                p.println("KillBonusUnitXP=" + this.KillBonusUnitXPText.getText());
            }
            if (!this.KillBonusXPforBVText.getText().equals(this.defaultOperationInfo.getDefault("KillBonusXPforBV"))) {
                p.println("KillBonusXPforBV=" + this.KillBonusXPforBVText.getText());
            }
            if (!this.TotalBuildingsText.getText().equals(this.defaultOperationInfo.getDefault("TotalBuildings"))) {
                p.println("TotalBuildings=" + this.TotalBuildingsText.getText());
            }
            if (!this.MinBuildingsForOpText.getText().equals(this.defaultOperationInfo.getDefault("MinBuildingsForOp"))) {
                p.println("MinBuildingsForOp=" + this.MinBuildingsForOpText.getText());
            }
            if (!this.MinFloorsText.getText().equals(this.defaultOperationInfo.getDefault("MinFloors"))) {
                p.println("MinFloors=" + this.MinFloorsText.getText());
            }
            if (!this.MaxFloorsText.getText().equals(this.defaultOperationInfo.getDefault("MaxFloors"))) {
                p.println("MaxFloors=" + this.MaxFloorsText.getText());
            }
            if (!this.MinCFText.getText().equals(this.defaultOperationInfo.getDefault("MinCF"))) {
                p.println("MinCF=" + this.MinCFText.getText());
            }
            if (!this.MaxCFText.getText().equals(this.defaultOperationInfo.getDefault("MaxCF"))) {
                p.println("MaxCF=" + this.MaxCFText.getText());
            }
            if (!this.BuildingTypeText.getText().equals(this.defaultOperationInfo.getDefault("BuildingType"))) {
                p.println("BuildingType=" + this.BuildingTypeText.getText());
            }
            if (this.BuildingsStartOnMapEdgeCBox.isSelected() != Boolean.valueOf(this.defaultOperationInfo.getDefault("BuildingsStartOnMapEdge")).booleanValue()) {
                p.println("BuildingsStartOnMapEdge=" + this.BuildingsStartOnMapEdgeCBox.isSelected());
            }
            if (!this.DelayPerBuildingText.getText().equals(this.defaultOperationInfo.getDefault("DelayPerBuilding"))) {
                p.println("DelayPerBuilding=" + this.DelayPerBuildingText.getText());
            }
            if (!this.AttackerExpPerBuildingText.getText().equals(this.defaultOperationInfo.getDefault("AttackerExpPerBuilding"))) {
                p.println("AttackerExpPerBuilding=" + this.AttackerExpPerBuildingText.getText());
            }
            if (!this.AttackerFluPerBuildingText.getText().equals(this.defaultOperationInfo.getDefault("AttackerFluPerBuilding"))) {
                p.println("AttackerFluPerBuilding=" + this.AttackerFluPerBuildingText.getText());
            }
            if (!this.AttackerRPPerBuildingText.getText().equals(this.defaultOperationInfo.getDefault("AttackerRPPerBuilding"))) {
                p.println("AttackerRPPerBuilding=" + this.AttackerRPPerBuildingText.getText());
            }
            if (!this.AttackerMoneyPerBuildingText.getText().equals(this.defaultOperationInfo.getDefault("AttackerMoneyPerBuilding"))) {
                p.println("AttackerMoneyPerBuilding=" + this.AttackerMoneyPerBuildingText.getText());
            }
            if (!this.AttackerMinBuildingsIfAttackerWinsText.getText().equals(this.defaultOperationInfo.getDefault("AttackerMinBuildingsIfAttackerWins"))) {
                p.println("AttackerMinBuildingsIfAttackerWins=" + this.AttackerMinBuildingsIfAttackerWinsText.getText());
            }
            if (!this.DefenderExpPerBuildingText.getText().equals(this.defaultOperationInfo.getDefault("DefenderExpPerBuilding"))) {
                p.println("DefenderExpPerBuilding=" + this.DefenderExpPerBuildingText.getText());
            }
            if (!this.DefenderFluPerBuildingText.getText().equals(this.defaultOperationInfo.getDefault("DefenderFluPerBuilding"))) {
                p.println("DefenderFluPerBuilding=" + this.DefenderFluPerBuildingText.getText());
            }
            if (!this.DefenderRPPerBuildingText.getText().equals(this.defaultOperationInfo.getDefault("DefenderRPPerBuilding"))) {
                p.println("DefenderRPPerBuilding=" + this.DefenderRPPerBuildingText.getText());
            }
            if (!this.DefenderMoneyPerBuildingText.getText().equals(this.defaultOperationInfo.getDefault("DefenderMoneyPerBuilding"))) {
                p.println("DefenderMoneyPerBuilding=" + this.DefenderMoneyPerBuildingText.getText());
            }
            p.close();
            out.close();
            JOptionPane.showMessageDialog(null, this.taskName + " saved to " + this.filePathName, "File Saved", 1);
        }
        catch (Exception ex) {
            System.err.println("Unable to save file");
        }
    }

    public void loadShortOp() {
        this.opValues = new BackedTreeMap(this.defaultOperationInfo);
        FileDialog fDialog = new FileDialog((Frame)this, "Load Short Op File", 0);
        fDialog.setDirectory(System.getProperty("user.dir") + "/data/operations/short");
        fDialog.setVisible(true);
        File shortOP = new File(fDialog.getDirectory(), fDialog.getFile());
        this.filePathName = fDialog.getDirectory() + fDialog.getFile();
        this.taskName = fDialog.getFile().substring(0, fDialog.getFile().indexOf(".txt"));
        this.setTitle("MekWars Operations Editor (" + this.taskName + ")");
        try {
            FileInputStream fis = new FileInputStream(shortOP);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                String values = "";
                try {
                    values = dis.readLine();
                    StringTokenizer OperationOption = new StringTokenizer(values, "=");
                    String opVar = OperationOption.nextToken();
                    String value = OperationOption.nextToken();
                    this.opValues.put(opVar, value);
                }
                catch (Exception ex) {
                    System.err.println("Error reading file " + this.filePathName);
                    System.err.println("Bad value " + values);
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Error loading file " + this.filePathName);
            ex.printStackTrace();
        }
        this.OperationColorText.setText(this.opValues.getV("OperationColor"));
        this.OperationRangeText.setText(this.opValues.getV("OperationRange"));
        this.PercentageToAttackOnWorldText.setText(this.opValues.getV("PercentageToAttackOnWorld"));
        this.PercentageToAttackOffWorldText.setText(this.opValues.getV("PercentageToAttackOffWorld"));
        this.OnlyAgainstFactoryWorldsCBox.setSelected(Boolean.valueOf(this.opValues.getV("OnlyAgainstFactoryWorlds")));
        this.OnlyAgainstNonFactoryWorldsCBox.setSelected(Boolean.valueOf(this.opValues.getV("OnlyAgainstNonFactoryWorlds")));
        this.MaxAttackerBVText.setText(this.opValues.getV("MaxAttackerBV"));
        this.MinAttackerBVText.setText(this.opValues.getV("MinAttackerBV"));
        this.MaxDefenderBVText.setText(this.opValues.getV("MaxDefenderBV"));
        this.MinDefenderBVText.setText(this.opValues.getV("MinDefenderBV"));
        this.MaxAttackerUnitsText.setText(this.opValues.getV("MaxAttackerUnits"));
        this.MinAttackerUnitsText.setText(this.opValues.getV("MinAttackerUnits"));
        this.MaxDefenderUnitsText.setText(this.opValues.getV("MaxDefenderUnits"));
        this.MinDefenderUnitsText.setText(this.opValues.getV("MinDefenderUnits"));
        this.MinAttackerWalkText.setText(this.opValues.getV("MinAttackerWalk"));
        this.MinDefenderWalkText.setText(this.opValues.getV("MinDefenderWalk"));
        this.MinAttackerJumpText.setText(this.opValues.getV("MinAttackerJump"));
        this.MinDefenderJumpText.setText(this.opValues.getV("MinDefenderJump"));
        this.MaxAttackerUnitTonnageText.setText(this.opValues.getV("MaxAttackerUnitTonnage"));
        this.MaxDefenderUnitTonnageText.setText(this.opValues.getV("MaxDefenderUnitTonnage"));
        this.MinAttackerUnitTonnageText.setText(this.opValues.getV("MinAttackerUnitTonnage"));
        this.MinDefenderUnitTonnageText.setText(this.opValues.getV("MinDefenderUnitTonnage"));
        this.MaxTotalAttackerTonnageText.setText(this.opValues.getV("MaxTotalAttackerTonnage"));
        this.MaxTotalDefenderTonnageText.setText(this.opValues.getV("MaxTotalDefenderTonnage"));
        this.MinTotalAttackerTonnageText.setText(this.opValues.getV("MinTotalAttackerTonnage"));
        this.MinTotalDefenderTonnageText.setText(this.opValues.getV("MinTotalDefenderTonnage"));
        this.AttackerAllowedMeksCBox.setSelected(Boolean.valueOf(this.opValues.getV("AttackerAllowedMeks")));
        this.AttackerAllowedVehsCBox.setSelected(Boolean.valueOf(this.opValues.getV("AttackerAllowedVehs")));
        this.AttackerAllowedInfCBox.setSelected(Boolean.valueOf(this.opValues.getV("AttackerAllowedInf")));
        this.DefenderAllowedMeksCBox.setSelected(Boolean.valueOf(this.opValues.getV("DefenderAllowedMeks")));
        this.DefenderAllowedVehsCBox.setSelected(Boolean.valueOf(this.opValues.getV("DefenderAllowedVehs")));
        this.DefenderAllowedInfCBox.setSelected(Boolean.valueOf(this.opValues.getV("DefenderAllowedInf")));
        this.PoweredInfAllowedCBox.setSelected(Boolean.valueOf(this.opValues.getV("PoweredInfAllowed")));
        this.AttackerCostMoneyText.setText(this.opValues.getV("AttackerCostMoney"));
        this.AttackerCostInfluenceText.setText(this.opValues.getV("AttackerCostInfluence"));
        this.AttackerCostRewardText.setText(this.opValues.getV("AttackerCostReward"));
        this.DefenderCostMoneyText.setText(this.opValues.getV("DefenderCostMoney"));
        this.DefenderCostInfluenceText.setText(this.opValues.getV("DefenderCostInfluence"));
        this.DefenderCostRewardText.setText(this.opValues.getV("DefenderCostReward"));
        this.MinAttackerRatingText.setText(this.opValues.getV("MinAttackerRating"));
        this.MaxAttackerRatingText.setText(this.opValues.getV("MaxAttackerRating"));
        this.MinDefenderRatingText.setText(this.opValues.getV("MinDefenderRating"));
        this.MaxDefenderRatingText.setText(this.opValues.getV("MaxDefenderRating"));
        this.MinAttackerXPText.setText(this.opValues.getV("MinAttackerXP"));
        this.MaxAttackerXPText.setText(this.opValues.getV("MaxAttackerXP"));
        this.MinDefenderXPText.setText(this.opValues.getV("MinDefenderXP"));
        this.MaxDefenderXPText.setText(this.opValues.getV("MaxDefenderXP"));
        this.MinAttackerGamesPlayedText.setText(this.opValues.getV("MinAttackerGamesPlayed"));
        this.MaxAttackerGamesPlayedText.setText(this.opValues.getV("MaxAttackerGamesPlayed"));
        this.MinDefenderGamesPlayedText.setText(this.opValues.getV("MinDefenderGamesPlayed"));
        this.MaxDefenderGamesPlayedText.setText(this.opValues.getV("MaxDefenderGamesPlayed"));
        this.DefenderReceivesAutoArtilleryCBox.setSelected(Boolean.valueOf(this.opValues.getV("DefenderReceivesAutoArtillery")));
        this.AttackerReceivesAutoArtilleryCBox.setSelected(Boolean.valueOf(this.opValues.getV("AttackerReceivesAutoArtillery")));
        this.DefenderFlatArtilleryModifierText.setText(this.opValues.getV("DefenderFlatArtilleryModifier"));
        this.AttackerFlatArtilleryModifierText.setText(this.opValues.getV("AttackerFlatArtilleryModifier"));
        this.DefenderPercentArtilleryModifierText.setText(this.opValues.getV("DefenderPercentArtilleryModifier"));
        this.AttackerPercentArtilleryModifierText.setText(this.opValues.getV("AttackerPercentArtilleryModifier"));
        this.MinDefenderArtilleryBVText.setText(this.opValues.getV("MinDefenderArtilleryBV"));
        this.MinAttackerArtilleryBVText.setText(this.opValues.getV("MinAttackerArtilleryBV"));
        this.MaxDefenderArtilleryBVText.setText(this.opValues.getV("MaxDefenderArtilleryBV"));
        this.MaxAttackerArtilleryBVText.setText(this.opValues.getV("MaxAttackerArtilleryBV"));
        this.BaseAttackerPayCBillsText.setText(this.opValues.getV("BaseAttackerPayCBills"));
        this.BaseDefenderPayCBillsText.setText(this.opValues.getV("BaseDefenderPayCBills"));
        this.BaseAttackerPayInfluenceText.setText(this.opValues.getV("BaseAttackerPayInfluence"));
        this.BaseDefenderPayInfluenceText.setText(this.opValues.getV("BaseDefenderPayInfluence"));
        this.BaseAttackerPayExperienceText.setText(this.opValues.getV("BaseAttackerPayExperience"));
        this.BaseDefenderPayExperienceText.setText(this.opValues.getV("BaseDefenderPayExperience"));
        this.AttackerPayBVforCBillText.setText(this.opValues.getV("AttackerPayBVforCBill"));
        this.DefenderPayBVforCBillText.setText(this.opValues.getV("DefenderPayBVforCBill"));
        this.AttackerPayBVforInfluenceText.setText(this.opValues.getV("AttackerPayBVforInfluence"));
        this.DefenderPayBVforInfluenceText.setText(this.opValues.getV("DefenderPayBVforInfluence"));
        this.AttackerPayBVforExperienceText.setText(this.opValues.getV("AttackerPayBVforExperience"));
        this.DefenderPayBVforExperienceText.setText(this.opValues.getV("DefenderPayBVforExperience"));
        this.AttackerWinModifierCBillsFlatText.setText(this.opValues.getV("AttackerWinModifierCBillsFlat"));
        this.DefenderWinModifierCBillsFlatText.setText(this.opValues.getV("DefenderWinModifierCBillsFlat"));
        this.AttackerLossModifierCBillsFlatText.setText(this.opValues.getV("AttackerLossModifierCBillsFlat"));
        this.DefenderLossModifierCBillsFlatText.setText(this.opValues.getV("DefenderLossModifierCBillsFlat"));
        this.AttackerWinModifierCBillsPercentText.setText(this.opValues.getV("AttackerWinModifierCBillsPercent"));
        this.DefenderWinModifierCBillsPercentText.setText(this.opValues.getV("DefenderWinModifierCBillsPercent"));
        this.AttackerLossModifierCBillsPercentText.setText(this.opValues.getV("AttackerLossModifierCBillsPercent"));
        this.DefenderLossModifierCBillsPercentText.setText(this.opValues.getV("DefenderLossModifierCBillsPercent"));
        this.AttackerWinModifierInfluenceFlatText.setText(this.opValues.getV("AttackerWinModifierInfluenceFlat"));
        this.DefenderWinModifierInfluenceFlatText.setText(this.opValues.getV("DefenderWinModifierInfluenceFlat"));
        this.AttackerLossModifierInfluenceFlatText.setText(this.opValues.getV("AttackerLossModifierInfluenceFlat"));
        this.DefenderLossModifierInfluenceFlatText.setText(this.opValues.getV("DefenderLossModifierInfluenceFlat"));
        this.AttackerWinModifierInfluencePercentText.setText(this.opValues.getV("AttackerWinModifierInfluencePercent"));
        this.DefenderWinModifierInfluencePercentText.setText(this.opValues.getV("DefenderWinModifierInfluencePercent"));
        this.AttackerLossModifierInfluencePercentText.setText(this.opValues.getV("AttackerLossModifierInfluencePercent"));
        this.DefenderLossModifierInfluencePercentText.setText(this.opValues.getV("DefenderLossModifierInfluencePercent"));
        this.AttackerWinModifierExperienceFlatText.setText(this.opValues.getV("AttackerWinModifierExperienceFlat"));
        this.DefenderWinModifierExperienceFlatText.setText(this.opValues.getV("DefenderWinModifierExperienceFlat"));
        this.AttackerLossModifierExperienceFlatText.setText(this.opValues.getV("AttackerLossModifierExperienceFlat"));
        this.DefenderLossModifierExperienceFlatText.setText(this.opValues.getV("DefenderLossModifierExperienceFlat"));
        this.AttackerWinModifierExperiencePercentText.setText(this.opValues.getV("AttackerWinModifierExperiencePercent"));
        this.DefenderWinModifierExperiencePercentText.setText(this.opValues.getV("DefenderWinModifierExperiencePercent"));
        this.AttackerLossModifierExperiencePercentText.setText(this.opValues.getV("AttackerLossModifierExperiencePercent"));
        this.DefenderLossModifierExperiencePercentText.setText(this.opValues.getV("DefenderLossModifierExperiencePercent"));
        this.RPForLoserText.setText(this.opValues.getV("RPForLoser"));
        this.RPForDefenderText.setText(this.opValues.getV("RPForDefender"));
        this.RPForAttackerText.setText(this.opValues.getV("RPForAttacker"));
        this.RPForWinnerText.setText(this.opValues.getV("RPForWinner"));
        this.OnlyGiveRPtoWinnersCBox.setSelected(Boolean.valueOf(this.opValues.getV("OnlyGiveRPtoWinners")));
        this.WinnerAlwaysSalvagesOwnUnitsCBox.setSelected(Boolean.valueOf(this.opValues.getV("WinnerAlwaysSalvagesOwnUnits")));
        this.BaseAttackerSalvagePercentText.setText(this.opValues.getV("BaseAttackerSalvagePercent"));
        this.BaseDefenderSalvagePercentText.setText(this.opValues.getV("BaseDefenderSalvagePercent"));
        this.AttackerSalvageAdjustmentText.setText(this.opValues.getV("AttackerSalvageAdjustment"));
        this.DefenderSalvageAdjustmentText.setText(this.opValues.getV("DefenderSalvageAdjustment"));
        this.BVToBoostAttackerSalvageCostText.setText(this.opValues.getV("BVToBoostAttackerSalvageCost"));
        this.BVToBoostDefenderSalvageCostText.setText(this.opValues.getV("BVToBoostDefenderSalvageCost"));
        this.AttackerSalvageCostModifierText.setText(this.opValues.getV("AttackerSalvageCostModifier"));
        this.DefenderSalvageCostModifierText.setText(this.opValues.getV("DefenderSalvageCostModifier"));
        this.AllowSOLToUseCBox.setSelected(Boolean.valueOf(this.opValues.getV("AllowSOLToUse")));
        this.AllowAgainstSOLCBox.setSelected(Boolean.valueOf(this.opValues.getV("AllowAgainstSOL")));
        this.AllowNonConqToUseCBox.setSelected(Boolean.valueOf(this.opValues.getV("AllowNonConqToUse")));
        this.AllowAgainstNonConqCBox.setSelected(Boolean.valueOf(this.opValues.getV("AllowAgainstNonConq")));
        this.SOLPilotsGainXPCBox.setSelected(Boolean.valueOf(this.opValues.getV("SOLPilotsGainXP")));
        this.HousePilotsGainXPCBox.setSelected(Boolean.valueOf(this.opValues.getV("HousePilotsGainXP")));
        this.SOLPilotsCheckLevelUpCBox.setSelected(Boolean.valueOf(this.opValues.getV("SOLPilotsCheckLevelUp")));
        this.HousePilotsCheckLevelUpCBox.setSelected(Boolean.valueOf(this.opValues.getV("HousePilotsCheckLevelUp")));
        this.PayAllAsWinnersCBox.setSelected(Boolean.valueOf(this.opValues.getV("PayAllAsWinners")));
        this.NoStatisticsModeCBox.setSelected(Boolean.valueOf(this.opValues.getV("NoStatisticsMode")));
        this.NoDestructionModeCBox.setSelected(Boolean.valueOf(this.opValues.getV("NoDestructionMode")));
        this.CountGameForRankingCBox.setSelected(Boolean.valueOf(this.opValues.getV("CountGameForRanking")));
        this.CountGameForProductionText.setText(this.opValues.getV("CountGameForProduction"));
        this.PayTechsForGameCBox.setSelected(Boolean.valueOf(this.opValues.getV("PayTechsForGame")));
        this.AttackerBaseConquestAmountText.setText(this.opValues.getV("AttackerBaseConquestAmount"));
        this.AttackerConquestBVAdjustmentText.setText(this.opValues.getV("AttackerConquestBVAdjustment"));
        this.AttackerConquestUnitAdjustmentText.setText(this.opValues.getV("AttackerConquestUnitAdjustment"));
        this.DefenderBaseConquestAmountText.setText(this.opValues.getV("DefenderBaseConquestAmount"));
        this.DefenderConquestBVAdjustmentText.setText(this.opValues.getV("DefenderConquestBVAdjustment"));
        this.DefenderConquestUnitAdjustmentText.setText(this.opValues.getV("DefenderConquestUnitAdjustment"));
        this.AttackerBaseDelayAmountText.setText(this.opValues.getV("AttackerBaseDelayAmount"));
        this.AttackerDelayBVAdjustmentText.setText(this.opValues.getV("AttackerDelayBVAdjustment"));
        this.AttackerDelayUnitAdjustmentText.setText(this.opValues.getV("AttackerDelayUnitAdjustment"));
        this.DefenderBaseDelayAmountText.setText(this.opValues.getV("DefenderBaseDelayAmount"));
        this.DefenderDelayBVAdjustmentText.setText(this.opValues.getV("DefenderDelayBVAdjustment"));
        this.DefenderDelayUnitAdjustmentText.setText(this.opValues.getV("DefenderDelayUnitAdjustment"));
        this.AttackerBasePPAmountText.setText(this.opValues.getV("AttackerBasePPAmount"));
        this.AttackerPPBVAdjustmentText.setText(this.opValues.getV("AttackerPPBVAdjustment"));
        this.AttackerPPUnitAdjustmentText.setText(this.opValues.getV("AttackerPPUnitAdjustment"));
        this.DefenderBasePPAmountText.setText(this.opValues.getV("DefenderBasePPAmount"));
        this.DefenderPPBVAdjustmentText.setText(this.opValues.getV("DefenderPPBVAdjustment"));
        this.DefenderPPUnitAdjustmentText.setText(this.opValues.getV("DefenderPPUnitAdjustment"));
        this.AttackerBaseUnitsTakenText.setText(this.opValues.getV("AttackerBaseUnitsTaken"));
        this.AttackerUnitsBVAdjustmentText.setText(this.opValues.getV("AttackerUnitsBVAdjustment"));
        this.AttackerUnitsUnitAdjustmentText.setText(this.opValues.getV("AttackerUnitsUnitAdjustment"));
        this.AttackerTargetOpAdjustmentText.setText(this.opValues.getV("AttackerTargetOpAdjustment"));
        this.DefenderTargetOpAdjustmentText.setText(this.opValues.getV("DefenderTargetOpAdjustment"));
        this.ConquestAmountCapText.setText(this.opValues.getV("ConquestAmountCap"));
        this.DelayAmountCapText.setText(this.opValues.getV("DelayAmountCap"));
        this.PPCapptureCapText.setText(this.opValues.getV("PPCapptureCap"));
        this.UnitCaptureCapText.setText(this.opValues.getV("UnitCaptureCap"));
        this.TimeToNondefensePenaltyText.setText(this.opValues.getV("TimeToNondefensePenalty"));
        this.LeechesToDeactivateText.setText(this.opValues.getV("LeechesToDeactivate"));
        this.FlatRPChickenPenaltyText.setText(this.opValues.getV("FlatRPChickenPenalty"));
        this.FlatExpChickenPenaltyText.setText(this.opValues.getV("FlatExpChickenPenalty"));
        this.FlatInfluenceChickenPenaltyText.setText(this.opValues.getV("FlatInfluenceChickenPenalty"));
        this.FlatCBillChickenPenaltyText.setText(this.opValues.getV("FlatCBillChickenPenalty"));
        this.PercentRPChickenPenaltyText.setText(this.opValues.getV("PercentRPChickenPenalty"));
        this.PercentExpChickenPenaltyText.setText(this.opValues.getV("PercentExpChickenPenalty"));
        this.PercentInfluenceChickenPenaltyText.setText(this.opValues.getV("PercentInfluenceChickenPenalty"));
        this.PercentCBillChickenPenaltyText.setText(this.opValues.getV("PercentCBillChickenPenalty"));
        this.ConquestPerLeechText.setText(this.opValues.getV("ConquestPerLeech"));
        this.DelayPerLeechText.setText(this.opValues.getV("DelayPerLeech"));
        this.ProdPointsPerLeechText.setText(this.opValues.getV("ProdPointsPerLeech"));
        this.UnitsPerLeechText.setText(this.opValues.getV("UnitsPerLeech"));
        this.FailurePenaltyText.setText(this.opValues.getV("FailurePenalty"));
        this.BaseUnitXPText.setText(this.opValues.getV("BaseUnitXP"));
        this.UnitXPUnitsAdjustmentText.setText(this.opValues.getV("UnitXPUnitsAdjustment"));
        this.UnitXPBVAdjustmentText.setText(this.opValues.getV("UnitXPBVAdjustment"));
        this.WinnerBonusUnitXPText.setText(this.opValues.getV("WinnerBonusUnitXP"));
        this.DefenderBonusUnitXPText.setText(this.opValues.getV("DefenderBonusUnitXP"));
        this.KillBonusUnitXPText.setText(this.opValues.getV("KillBonusUnitXP"));
        this.KillBonusXPforBVText.setText(this.opValues.getV("KillBonusXPforBV"));
        this.TotalBuildingsText.setText(this.opValues.getV("TotalBuildings"));
        this.MinBuildingsForOpText.setText(this.opValues.getV("MinBuildingsForOp"));
        this.MinFloorsText.setText(this.opValues.getV("MinFloors"));
        this.MaxFloorsText.setText(this.opValues.getV("MaxFloors"));
        this.MinCFText.setText(this.opValues.getV("MinCF"));
        this.MaxCFText.setText(this.opValues.getV("MaxCF"));
        this.BuildingTypeText.setText(this.opValues.getV("BuildingType"));
        this.DelayPerBuildingText.setText(this.opValues.getV("DelayPerBuilding"));
        this.AttackerExpPerBuildingText.setText(this.opValues.getV("AttackerExpPerBuilding"));
        this.AttackerFluPerBuildingText.setText(this.opValues.getV("AttackerFluPerBuilding"));
        this.AttackerRPPerBuildingText.setText(this.opValues.getV("AttackerRPPerBuilding"));
        this.AttackerMoneyPerBuildingText.setText(this.opValues.getV("AttackerMoneyPerBuilding"));
        this.AttackerMinBuildingsIfAttackerWinsText.setText(this.opValues.getV("AttackerMinBuildingsIfAttackerWins"));
        this.DefenderExpPerBuildingText.setText(this.opValues.getV("DefenderExpPerBuilding"));
        this.DefenderFluPerBuildingText.setText(this.opValues.getV("DefenderFluPerBuilding"));
        this.DefenderRPPerBuildingText.setText(this.opValues.getV("DefenderRPPerBuilding"));
        this.DefenderMoneyPerBuildingText.setText(this.opValues.getV("DefenderMoneyPerBuilding"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackedTreeMap
    extends TreeMap<String, String> {
        private static final long serialVersionUID = 1L;
        DefaultOperation defaults;

        public BackedTreeMap(DefaultOperation dop) {
            this.defaults = dop;
        }

        public String getV(String key) {
            Object toReturn = super.get(key);
            if (toReturn == null) {
                toReturn = this.defaults.getDefault(key);
            }
            return (String)toReturn;
        }
    }
}

