/*
 * Decompiled with CFR 0.152.
 */
package megamek;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import megamek.client.ui.IMegaMekGUI;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.AbstractCommandLineParser;
import megamek.debug.Assert;
import megamek.server.DedicatedServer;

public class MegaMek {
    public static String VERSION = "0.31.1-dev";
    public static long TIMESTAMP = new File(PreferenceManager.getClientPreferences().getLogDirectory() + File.separator + "timestamp").lastModified();
    private static final NumberFormat commafy = NumberFormat.getInstance();
    private static final String INCORRECT_ARGUMENTS_MESSAGE = "Incorrect arguments:";
    private static final String ARGUMENTS_DESCRIPTION_MESSAGE = "Arguments syntax:\n\t MegaMek [-log <logfile>] [(-gui <guiname>)|(-dedicated)] [<args>]";
    private static final String UNKNOWN_GUI_MESSAGE = "Unknown GUI:";
    private static final String GUI_CLASS_NOT_FOUND_MESSAGE = "Couldn't find the GUI Class:";
    private static final String DEFAULT_LOG_FILE_NAME = "megameklog.txt";
    private static String PROPERTIES_FILE = "megamek/MegaMek.properties";

    public static void main(String[] stringArray) {
        String string = DEFAULT_LOG_FILE_NAME;
        CommandLineParser commandLineParser = new CommandLineParser(stringArray);
        try {
            commandLineParser.parse();
            String string2 = commandLineParser.getLogFilename();
            if (string2 != null) {
                string = string2.equals("none") || string2.equals("off") ? null : string2;
            }
            if (string != null) {
                MegaMek.redirectOutput(string);
            }
            MegaMek.showInfo();
            String[] stringArray2 = commandLineParser.getRestArgs();
            if (commandLineParser.dedicatedServer()) {
                MegaMek.startDedicatedServer(stringArray2);
            } else {
                String string3 = commandLineParser.getGuiName();
                if (string3 == null) {
                    string3 = PreferenceManager.getClientPreferences().getGUIName();
                }
                MegaMek.startGUI(string3, stringArray2);
            }
        }
        catch (AbstractCommandLineParser.ParseException parseException) {
            StringBuffer stringBuffer = new StringBuffer(INCORRECT_ARGUMENTS_MESSAGE).append(parseException.getMessage()).append('\n');
            stringBuffer.append(ARGUMENTS_DESCRIPTION_MESSAGE);
            MegaMek.displayMessageAndExit(stringBuffer.toString());
        }
    }

    public static String getMemoryUsed() {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = (l - l2) / 1024L;
        return commafy.format(l3) + " kB";
    }

    private static void redirectOutput(String string) {
        try {
            System.out.println("Redirecting output to " + string);
            String string2 = PreferenceManager.getClientPreferences().getLogDirectory();
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdir();
            }
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(string2 + File.separator + string), 64));
            System.setOut(printStream);
            System.setErr(printStream);
        }
        catch (Exception exception) {
            System.err.println("Unable to redirect output to " + string);
            exception.printStackTrace();
        }
    }

    private static void startDedicatedServer(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("Starting Dedicated Server. ");
        MegaMek.dumpArgs(stringBuffer, stringArray);
        MegaMek.displayMessage(stringBuffer.toString());
        DedicatedServer.start(stringArray);
    }

    private static void startGUI(String string, String[] stringArray) {
        Assert.assertTrue(string != null, "guiName must be non-null");
        Assert.assertTrue(stringArray != null, "args must be non-null");
        IMegaMekGUI iMegaMekGUI = MegaMek.getGui(string);
        if (iMegaMekGUI == null) {
            MegaMek.displayMessageAndExit(UNKNOWN_GUI_MESSAGE + string);
        } else {
            StringBuffer stringBuffer = new StringBuffer("Starting GUI ");
            stringBuffer.append(string).append(". ");
            MegaMek.dumpArgs(stringBuffer, stringArray);
            MegaMek.displayMessage(stringBuffer.toString());
            iMegaMekGUI.start(stringArray);
        }
    }

    private static IMegaMekGUI getGui(String string) {
        Assert.assertTrue(string != null, "guiName must be non-null");
        String string2 = MegaMek.getGUIClassName(string);
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                if (IMegaMekGUI.class.isAssignableFrom(clazz)) {
                    IMegaMekGUI iMegaMekGUI = (IMegaMekGUI)clazz.newInstance();
                    return iMegaMekGUI;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MegaMek.displayMessage(GUI_CLASS_NOT_FOUND_MESSAGE + string2);
        }
        return null;
    }

    private static String getGUIClassName(String string) {
        Assert.assertTrue(string != null, "guiName must be non-null");
        Properties properties = new Properties();
        String string2 = "gui." + string;
        InputStream inputStream = MegaMek.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);
        if (inputStream != null) {
            try {
                properties.load(inputStream);
                return properties.getProperty(string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void dumpArgs(StringBuffer stringBuffer, String[] stringArray) {
        Assert.assertTrue(stringBuffer != null, "buffer must be non-null");
        Assert.assertTrue(stringArray != null, "args must be non-null");
        stringBuffer.append("args: [");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append("]");
    }

    private static void displayMessageAndExit(String string) {
        MegaMek.displayMessage(string);
        System.exit(1);
    }

    private static void displayMessage(String string) {
        System.out.println(string);
        System.out.flush();
    }

    private static void showInfo() {
        System.out.println("Starting MegaMek v" + VERSION + " ...");
        System.out.println("Timestamp " + new Date(TIMESTAMP).toString());
        System.out.println("Java vendor " + System.getProperty("java.vendor"));
        System.out.println("Java version " + System.getProperty("java.version"));
        System.out.println("Platform " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        System.out.println();
    }

    private static class CommandLineParser
    extends AbstractCommandLineParser {
        private String logFilename;
        private String guiName;
        private boolean dedicatedServer = false;
        private String[] restArgs = new String[0];
        private static final String OPTION_DEDICATED = "dedicated";
        private static final String OPTION_GUI = "gui";
        private static final String OPTION_LOG = "log";

        public CommandLineParser(String[] stringArray) {
            super(stringArray);
        }

        public boolean dedicatedServer() {
            return this.dedicatedServer;
        }

        public String getGuiName() {
            return this.guiName;
        }

        public String getLogFilename() {
            return this.logFilename;
        }

        public String[] getRestArgs() {
            return this.restArgs;
        }

        protected void start() throws AbstractCommandLineParser.ParseException {
            if (this.getToken() == 0 && this.getTokenValue().equals(OPTION_LOG)) {
                this.nextToken();
                this.parseLog();
            }
            if (this.getToken() == 0 && this.getTokenValue().equals(OPTION_DEDICATED)) {
                this.nextToken();
                this.dedicatedServer = true;
            } else if (this.getToken() == 0 && this.getTokenValue().equals(OPTION_GUI)) {
                this.nextToken();
                this.parseGUI();
            }
            this.processRestOfInput();
            if (this.getToken() != -1) {
                this.error("unexpected input");
            }
        }

        private void parseLog() throws AbstractCommandLineParser.ParseException {
            if (this.getToken() == 3) {
                this.logFilename = this.getTokenValue();
                this.nextToken();
            } else {
                this.error("log file name expected");
            }
        }

        private void parseGUI() throws AbstractCommandLineParser.ParseException {
            if (this.getToken() == 3) {
                this.guiName = this.getTokenValue();
                this.nextToken();
            } else {
                this.error("GUI name expected");
            }
        }

        private void processRestOfInput() {
            Vector<String> vector = new Vector<String>();
            while (this.getArgValue() != null) {
                vector.addElement(this.getArgValue());
                this.nextArg();
            }
            this.setToken(-1);
            this.setTokenValue(null);
            this.restArgs = vector.toArray(new String[0]);
        }
    }
}

