/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import megamek.client.bot.AttackOption;
import megamek.client.bot.BotClient;
import megamek.client.bot.CEntity;
import megamek.client.bot.ChatProcessor;
import megamek.client.bot.GAAttack;
import megamek.client.bot.GALance;
import megamek.client.bot.MoveOption;
import megamek.client.bot.PhysicalCalculator;
import megamek.client.bot.PhysicalOption;
import megamek.client.bot.Strategy;
import megamek.client.bot.ga.GA;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.Minefield;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.Protomech;
import megamek.common.RoundUpdated;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.event.GamePlayerChatEvent;
import megamek.debug.Assert;

public class TestBot
extends BotClient {
    public LinkedList unit_values = new LinkedList();
    public LinkedList enemy_values = new LinkedList();
    public CEntity.Table centities = new CEntity.Table(this);
    protected PhysicalCalculator pcalc = new PhysicalCalculator();
    protected ChatProcessor chatp = new ChatProcessor();
    public int ignore = this.config.getIgnoreLevel();
    int enemies_moved = 0;
    GALance old_moves = null;
    int my_mechs_moved = 0;

    public TestBot(String string, String string2, int n) {
        super(string, string2, n);
    }

    public void initialize() {
    }

    public PhysicalOption calculatePhysicalTurn() {
        return this.pcalc.calculatePhysicalTurn(this);
    }

    public MovePath calculateMoveTurn() {
        Object object;
        int n;
        Object object2;
        Object object3;
        int n2;
        long l = System.currentTimeMillis();
        int n3 = 0;
        MoveOption moveOption = null;
        System.out.println("beginning movement calculations...");
        Object[] objectArray = this.getEnemyEntities().toArray();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (((Entity)objectArray[n2]).isSelectableThisTurn()) continue;
            ++n3;
        }
        if (n3 == this.enemies_moved && this.old_moves != null) {
            moveOption = this.old_moves.getResult();
            if (moveOption == null || !moveOption.isMoveLegal() || moveOption.isPhysical && this.centities.get((int)moveOption.getPhysicalTargetId()).isPhysicalTarget) {
                this.old_moves = null;
                System.out.println("recalculating moves since the old move was invalid");
                return this.calculateMoveTurn();
            }
        } else {
            this.enemies_moved = n3;
            Vector<MoveOption[]> vector = new Vector<MoveOption[]>();
            object3 = this.game.getEntities();
            while (object3.hasMoreElements()) {
                object2 = (Entity)object3.nextElement();
                if (((Entity)object2).getPosition() == null || ((Entity)object2).isOffBoard()) continue;
                CEntity cEntity = this.centities.get((Entity)object2);
                cEntity.refresh();
                this.firstPass(cEntity);
            }
            object2 = this.getEntitiesOwned().iterator();
            n = 0;
            while (object2.hasNext() && n == 0) {
                object = (Entity)object2.next();
                if (((Entity)object).getPosition() == null || !this.game.getTurn().isValidEntity((Entity)object, this.game)) continue;
                CEntity cEntity = this.centities.get((Entity)object);
                System.out.println("Contemplating movement of " + ((Entity)object).getShortName() + " " + ((Entity)object).getId());
                MoveOption[] moveOptionArray = this.calculateMove((Entity)object);
                if (this.game.getOptions().booleanOption("skip_ineligable_movement") && cEntity.getEntity().isImmobile()) {
                    cEntity.moved = true;
                    continue;
                }
                if (cEntity.moved) continue;
                if (moveOptionArray.length < 6) {
                    moveOption = moveOptionArray.length > 0 ? moveOptionArray[0] : null;
                    n = 1;
                }
                vector.add(moveOptionArray);
            }
            if (n == 0) {
                if (this.getEntitiesOwned().size() > 1) {
                    object = new GALance(this, vector, 50, 80);
                    ((GA)object).evolve();
                    moveOption = ((GALance)object).getResult();
                    this.old_moves = object;
                } else if ((MoveOption[])vector.elementAt(0) != null && ((MoveOption[])vector.elementAt(0)).length > 0) {
                    moveOption = ((MoveOption[])vector.elementAt(0))[0];
                }
            }
        }
        if (moveOption == null) {
            moveOption = new MoveOption(this.game, this.centities.get(this.getFirstEntityNum()));
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            object3 = (Entity)objectArray[n2];
            if (((Entity)object3).getPosition() == null) continue;
            object2 = this.centities.get((Entity)object3);
            n = CEntity.getThreatHitArc(((CEntity)object2).current.getFinalCoords(), ((CEntity)object2).current.getFinalFacing(), moveOption.getFinalCoords());
            object = (MoveOption.DamageInfo)moveOption.damageInfos.get(object2);
            if (object != null) {
                int n4 = n;
                ((CEntity)object2).expected_damage[n4] = ((CEntity)object2).expected_damage[n4] + ((MoveOption.DamageInfo)object).min_damage;
            }
            if (!(((CEntity)object2).expected_damage[n] > 0.0)) continue;
            ((CEntity)object2).hasTakenDamage = true;
        }
        if (moveOption.isPhysical) {
            this.centities.get((int)moveOption.getPhysicalTargetId()).isPhysicalTarget = true;
        }
        System.out.println(moveOption);
        moveOption.getCEntity().current = moveOption;
        moveOption.getCEntity().last = moveOption;
        ++this.my_mechs_moved;
        moveOption.getCEntity().moved = true;
        long l2 = System.currentTimeMillis();
        System.out.println("move turn took " + (l2 - l) + " ms");
        if (moveOption != null && moveOption.getLastStep() != null && moveOption.getCEntity().entity.canUnjamRAC() && (moveOption.getLastStep().getMovementType() == 1 || moveOption.getLastStep().getMovementType() == 4 || moveOption.getLastStep().getMovementType() == 0)) {
            moveOption.addStep(15);
        }
        return moveOption;
    }

    public void firstPass(CEntity cEntity) {
        ArrayList arrayList = this.getEnemyEntities();
        Object[] objectArray = cEntity.getEntity().isSelectableThisTurn() && !cEntity.moved ? cEntity.getAllMoves().values().toArray() : new Object[]{cEntity.current};
        for (int i = 0; i < objectArray.length; ++i) {
            MoveOption moveOption = (MoveOption)objectArray[i];
            moveOption.setState();
            for (int j = 0; j < arrayList.size(); ++j) {
                CEntity cEntity2;
                int[] nArray;
                Entity entity = (Entity)arrayList.get(j);
                if (entity.getPosition() == null || (nArray = moveOption.getModifiers((cEntity2 = this.centities.get(entity)).getEntity()))[1] == Integer.MAX_VALUE && nArray[0] == Integer.MAX_VALUE) continue;
                int n = CEntity.getThreatHitArc(cEntity2.current.getFinalCoords(), cEntity2.current.getFinalFacing(), moveOption.getFinalCoords());
                int n2 = CEntity.getThreatHitArc(moveOption.getFinalCoords(), moveOption.getFinalFacing(), cEntity2.current.getFinalCoords());
                if (!cEntity2.getEntity().isImmobile() && nArray[1] != Integer.MAX_VALUE) {
                    cEntity.engaged = true;
                    int n3 = nArray[1];
                    double d = moveOption.getMaxModifiedDamage(cEntity2.current, n3, nArray[3]);
                    if (entity.isSelectableThisTurn()) {
                        cEntity2.current.addStep(4);
                        d = Math.max(moveOption.getMaxModifiedDamage(cEntity2.current, n3 + 1, nArray[3]), d);
                        cEntity2.current.removeLastStep();
                        cEntity2.current.addStep(3);
                        d = Math.max(moveOption.getMaxModifiedDamage(cEntity2.current, n3 + 1, nArray[3]), d);
                        cEntity2.current.removeLastStep();
                    }
                    d = cEntity.getThreatUtility(d, n2);
                    if (cEntity2.getEntity().isProne()) {
                        d *= cEntity2.base_psr_odds;
                    }
                    MoveOption.DamageInfo damageInfo = moveOption.getDamageInfo(cEntity2, true);
                    damageInfo.threat = d;
                    damageInfo.max_threat = d;
                    moveOption.threat += d;
                    moveOption.tv.add(d + " Threat " + j + "\n");
                }
                if (!moveOption.isPhysical) {
                    if (nArray[0] == Integer.MAX_VALUE) continue;
                    cEntity.engaged = true;
                    double d = cEntity2.current.getMaxModifiedDamage(moveOption, nArray[0], nArray[2]);
                    d = cEntity2.getThreatUtility(d, n);
                    MoveOption.DamageInfo damageInfo = moveOption.getDamageInfo(cEntity2, true);
                    damageInfo.damage = d;
                    damageInfo.min_damage = d;
                    moveOption.tv.add(d + " Damage " + j + "\n");
                    moveOption.damage = Math.max(d, moveOption.damage);
                    continue;
                }
                CEntity cEntity3 = this.centities.get(moveOption.getPhysicalTargetId());
                try {
                    if (cEntity3.getEntity().getId() != cEntity2.getEntity().getId()) continue;
                    if (!cEntity3.isPhysicalTarget) {
                        ToHitData toHitData = null;
                        double d = 0.0;
                        double d2 = 0.0;
                        if (moveOption.isJumping()) {
                            cEntity.current.setState();
                            toHitData = DfaAttackAction.toHit(this.game, moveOption.getEntity().getId(), (Targetable)cEntity3.getEntity(), moveOption);
                            d2 = 2 * DfaAttackAction.getDamageFor(moveOption.getEntity());
                            d = moveOption.getCEntity().getThreatUtility(DfaAttackAction.getDamageTakenBy(moveOption.getEntity()), 1) * Compute.oddsAbove(toHitData.getValue()) / 100.0;
                            d += moveOption.getCEntity().getThreatUtility(0.1 * (double)cEntity.getEntity().getWeight(), 1);
                            d *= (double)(100.0f / moveOption.getCEntity().getEntity().getWeight());
                        } else {
                            cEntity.current.setState();
                            toHitData = new ChargeAttackAction(moveOption.getEntity(), cEntity3.getEntity()).toHit(this.game, moveOption);
                            d2 = ChargeAttackAction.getDamageFor(moveOption.getEntity(), moveOption.getHexesMoved());
                            d = moveOption.getCEntity().getThreatUtility(ChargeAttackAction.getDamageTakenBy(moveOption.getEntity(), cEntity3.getEntity()), 0) * (Compute.oddsAbove(toHitData.getValue()) / 100.0);
                            moveOption.setState();
                        }
                        d2 = cEntity3.getThreatUtility(d2, toHitData.getSideTable()) * Compute.oddsAbove(toHitData.getValue()) / 100.0;
                        if (!moveOption.isJumping()) {
                            d2 *= Math.sqrt((double)cEntity2.bv / (double)cEntity.bv);
                        }
                        if (toHitData.getValue() > 10) {
                            d2 = 0.0;
                        }
                        if (toHitData.getValue() < 8) {
                            d2 *= 1.5;
                        }
                        if (cEntity.range_damages[0] < 5.0) {
                            d2 *= 2.0;
                        }
                        MoveOption.DamageInfo damageInfo = moveOption.getDamageInfo(cEntity2, true);
                        damageInfo.damage = d2;
                        damageInfo.min_damage = d2;
                        moveOption.damage = d2;
                        moveOption.movement_threat += d;
                        continue;
                    }
                    moveOption.threat += 2.147483647E9;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    moveOption.threat += 2.147483647E9;
                }
            }
            cEntity.current.setState();
        }
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(1.0, 1.0), 100);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(0.5, 1.0), 100);
    }

    public MoveOption[] calculateMove(Entity entity) {
        int n;
        Object object;
        Object object2;
        Serializable serializable22;
        int n2;
        Vector vector = this.game.getValidTargets(entity);
        Vector vector2 = this.game.getEntitiesVector();
        CEntity cEntity = this.centities.get(entity);
        int n3 = vector2.size() - vector.size();
        Object[] objectArray = cEntity.pass.values().toArray();
        cEntity.pass.clear();
        for (n2 = 0; n2 < objectArray.length && n3 > 2; ++n2) {
            serializable22 = (MoveOption)objectArray[n2];
            for (int i = 0; i < vector.size(); ++i) {
                object2 = (Object[])vector.elementAt(i);
                CEntity cEntity2 = this.centities.get((Entity)object2);
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Entity)enumeration.nextElement();
                    if (((Entity)object).isEnemyOf(cEntity.entity)) continue;
                    MoveOption moveOption = this.centities.get((Entity)object).current;
                    double d = 1.0;
                    MoveOption.DamageInfo damageInfo = ((MoveOption)serializable22).getDamageInfo(cEntity2, true);
                    if (moveOption.getDamageInfo(cEntity2, false) != null) {
                        ((MoveOption)serializable22).damage = ((MoveOption)serializable22).damage + (cEntity2.canMove() ? 0.1 : 0.2) * damageInfo.damage;
                        d += moveOption.getCEntity().canMove() ? 0.4 : 0.6;
                    }
                    ((MoveOption)serializable22).threat -= damageInfo.threat;
                    damageInfo.threat /= d;
                    ((MoveOption)serializable22).threat += damageInfo.threat;
                }
            }
        }
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(1.0, 1.0), 50);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(0.5, 1.0), 50);
        objectArray = cEntity.pass.values().toArray();
        cEntity.pass.clear();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            int n4;
            Object object3;
            serializable22 = (MoveOption)objectArray[n2];
            ((MoveOption)serializable22).setState();
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < vector.size(); ++i) {
                Entity entity2 = (Entity)vector.elementAt(i);
                object3 = this.centities.get(entity2);
                int n5 = cEntity.current.getFinalCoords().distance(((CEntity)object3).current.getFinalCoords());
                n4 = ((MovePath)serializable22).getFinalCoords().distance(((CEntity)object3).current.getFinalCoords());
                if (n4 > cEntity.long_range) {
                    d2 += (n4 >= ((CEntity)object3).long_range ? 0.5 : 1.0) * (1.0 + cEntity.range_damages[cEntity.range]) * Math.max((double)(n4 - cEntity.long_range) - 0.5 * Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP), 0.0);
                }
                if (cEntity.range == 0 && (n5 > 5 || n4 > 9) || cEntity.range_damages[0] < 4.0 && n5 > 10) {
                    d2 += (((CEntity)object3).range > 0 ? 0.5 : 1.0) * Math.max(1.0 + cEntity.range_damages[0], 5.0) * Math.max((double)n4 - 0.5 * Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP), 0.0);
                } else if (cEntity.range == 1) {
                    d2 += (n5 < 6 || n5 > 12 ? 1.0 : 0.25) * (((CEntity)object3).range > 0 ? 0.5 : 1.0) * (1.0 + cEntity.range_damages[1]) * Math.abs((double)n4 - 0.5 * Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP));
                } else if (((MoveOption)serializable22).damage < 0.25 * cEntity.range_damages[2]) {
                    d2 += (n4 < 10 ? 0.25 : 1.0) * Math.max(1.0 + cEntity.range_damages[2], 3.0) * (1.0 / (1.0 + ((MoveOption)serializable22).threat));
                }
                d += Math.sqrt(d2 * (double)((CEntity)object3).bv / (double)cEntity.bv);
                if (((CEntity)object3).getEntity().isProne() || ((CEntity)object3).getEntity().isImmobile() || CEntity.getThreatHitArc(((MovePath)serializable22).getFinalCoords(), ((MovePath)serializable22).getFinalFacing(), ((CEntity)object3).getEntity().getPosition()) == 0 || (n = CEntity.getFiringAngle(((MovePath)serializable22).getFinalCoords(), ((MovePath)serializable22).getFinalFacing(), ((CEntity)object3).getEntity().getPosition())) <= 90 || n >= 270) continue;
                int n6 = ((MovePath)serializable22).getFinalCoords().distance(((CEntity)object3).current.getFinalCoords());
                double d3 = 1.0;
                if (n > 130 && n < 240) {
                    d3 = 2.0;
                }
                ((MoveOption)serializable22).self_threat += (d3 *= (double)(Math.max((double)cEntity.jumpMP, 0.8 * (double)cEntity.runMP) < 5.0 ? 2 : 1) * ((double)cEntity.bv / 50.0) * Math.sqrt((double)cEntity.bv / (double)((CEntity)object3).bv) / ((double)n6 / 6.0 + 1.0));
                ((MoveOption)serializable22).tv.add(d3 + " " + n + " Back to enemy\n");
            }
            d *= cEntity.overall_armor_percent * cEntity.strategy.attack / (double)vector.size();
            object = this.game.getBoard().getHex(((MovePath)serializable22).getFinalCoords());
            if (object.containsTerrain(4) && object.surface() > cEntity.getEntity().getElevation() + (((MovePath)serializable22).getFinalProne() ? 0 : 1)) {
                double d4 = cEntity.getEntity().heat + ((MoveOption)serializable22).getMovementheatBuildup() <= 7 ? 100.0 : 30.0;
                d += (double)cEntity.bv / d4;
            }
            if (cEntity.range > 0) {
                int n7 = this.game.getBoard().getHex(((MovePath)serializable22).getFinalCoords()).getElevation() - this.game.getBoard().getHex(cEntity.current.getFinalCoords()).getElevation();
                d -= (double)(Math.max(n7, 0) + 1) * ((double)Compute.getTargetTerrainModifier(this.game, ((MovePath)serializable22).getEntity()).getValue() + 1.0);
            }
            if (((MoveOption)serializable22).damage < 0.25 * cEntity.range_damages[cEntity.range] && d < cEntity.range_damages[cEntity.range]) {
                for (int i = 0; i < vector.size(); ++i) {
                    object3 = (Entity)vector.elementAt(i);
                    CEntity cEntity3 = this.centities.get((Entity)object3);
                    n4 = ((MovePath)serializable22).getFinalCoords().distance(cEntity3.current.getFinalCoords());
                    if (n4 <= 5) continue;
                    d += Math.pow(cEntity.overall_armor_percent, 2.0) * Math.sqrt((double)(n4 - 4) * (double)cEntity3.bv / (double)cEntity.bv) / (double)vector.size();
                }
            }
            if (((MoveOption)serializable22).damage < 0.25 * (1.0 + cEntity.range_damages[cEntity.range])) {
                ((MoveOption)serializable22).self_threat += 2.0 * d;
            } else if (((MoveOption)serializable22).damage < 0.5 * (1.0 + cEntity.range_damages[cEntity.range])) {
                ((MoveOption)serializable22).self_threat += d;
            }
            ((MoveOption)serializable22).tv.add(((MoveOption)serializable22).self_threat + " Initial Damage Adjustment " + "\n");
        }
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(1.0, 1.0), 30);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(0.5, 1.0), 30);
        for (Serializable serializable22 : cEntity.pass.values()) {
            ((MoveOption)serializable22).setState();
            ((MoveOption)serializable22).self_damage *= 0.5;
            ((MoveOption)serializable22).self_threat *= 0.5;
            double d = 2.0 * (double)Compute.getTargetTerrainModifier(this.game, ((MovePath)serializable22).getEntity()).getValue();
            ((MoveOption)serializable22).tv.add(d + " Terrain Adjusment " + "\n");
            ((MoveOption)serializable22).self_threat -= d;
        }
        objectArray = cEntity.pass.values().toArray();
        cEntity.pass.clear();
        for (int i = 0; i < vector.size(); ++i) {
            serializable22 = (Entity)vector.elementAt(i);
            CEntity cEntity4 = this.centities.get((Entity)serializable22);
            if (cEntity4.canMove()) {
                object2 = cEntity4.pass.values().toArray();
                Vector<Object> vector3 = new Vector<Object>();
                for (int j = 0; j < objectArray.length; ++j) {
                    object = null;
                    vector3.clear();
                    object = (MoveOption)objectArray[j];
                    ((MoveOption)object).setState();
                    Vector<Coords> vector4 = new Vector<Coords>();
                    Coords coords = ((MovePath)object).getFinalCoords().translated((((MovePath)object).getFinalFacing() + 3) % 6);
                    vector4.add(coords);
                    vector4.add(coords.translated((((MovePath)object).getFinalFacing() + 2) % 6));
                    vector4.add(coords.translated((((MovePath)object).getFinalFacing() + 4) % 6));
                    vector4.add(((MovePath)object).getFinalCoords().translated(((MovePath)object).getFinalFacing()));
                    vector4.add(((MovePath)object).getFinalCoords().translated((((MovePath)object).getFinalFacing() + 1) % 6));
                    vector4.add(((MovePath)object).getFinalCoords().translated((((MovePath)object).getFinalFacing() + 2) % 6));
                    vector4.add(((MovePath)object).getFinalCoords().translated((((MovePath)object).getFinalFacing() + 4) % 6));
                    vector4.add(((MovePath)object).getFinalCoords().translated((((MovePath)object).getFinalFacing() + 5) % 6));
                    for (Coords coords2 : vector4) {
                        ArrayList arrayList = cEntity4.findMoves(coords2);
                        if (arrayList.size() == 0) continue;
                        vector3.addAll(arrayList);
                    }
                    int n8 = ((MovePath)object).getFinalCoords().distance(cEntity4.current.getFinalCoords());
                    n = 0;
                    if (cEntity4.long_range > n8 - Math.max(cEntity4.jumpMP, cEntity4.runMP)) {
                        n = 30;
                    } else if (cEntity4.long_range > n8) {
                        n = 10;
                    }
                    double d = this.enemies_moved / this.getEnemyEntities().size();
                    n = (int)((double)n * (1.0 + d));
                    for (int k = 0; k <= n && k < ((Object)object2).length; ++k) {
                        if (((Object)object2).length < n) {
                            vector3.add(object2[k]);
                            continue;
                        }
                        int n9 = Compute.randomInt(((Object)object2).length);
                        if (n9 % 2 == 1) {
                            vector3.add(object2[n9]);
                            continue;
                        }
                        vector3.add(object2[k]);
                    }
                    for (MoveOption moveOption : vector3) {
                        int[] nArray;
                        double d5 = 0.0;
                        double d6 = 0.0;
                        moveOption.setState();
                        int n10 = CEntity.getThreatHitArc(moveOption.getFinalCoords(), moveOption.getFinalFacing(), ((MovePath)object).getFinalCoords());
                        int n11 = CEntity.getThreatHitArc(moveOption.getFinalCoords(), moveOption.getFinalFacing(), ((MovePath)object).getFinalCoords());
                        if (moveOption.isJumping()) {
                            n10 = 1;
                        }
                        if ((nArray = ((MoveOption)object).getModifiers(moveOption.getEntity()))[1] != Integer.MAX_VALUE) {
                            cEntity.engaged = true;
                            d5 = !moveOption.isJumping() ? ((MoveOption)object).getMaxModifiedDamage(moveOption, nArray[1], nArray[3]) : 0.8 * cEntity4.getModifiedDamage(nArray[3] == 1 ? 4 : 0, moveOption.getFinalCoords().distance(((MovePath)object).getFinalCoords()), nArray[1]);
                            d5 = cEntity.getThreatUtility(d5, n11);
                        }
                        if (nArray[0] != Integer.MAX_VALUE) {
                            cEntity.engaged = true;
                            d6 = moveOption.getMaxModifiedDamage((MoveOption)object, nArray[0], nArray[2]);
                            d6 = cEntity4.getThreatUtility(d6, n10);
                            if (((MoveOption)object).isPhysical) {
                                d6 = this.centities.get(((MoveOption)object).getPhysicalTargetId()).getEntity().getId() == cEntity4.getEntity().getId() ? ((MoveOption)object).getDamage(cEntity4) : 0.0;
                            }
                        }
                        MoveOption.DamageInfo damageInfo = ((MoveOption)object).getDamageInfo(cEntity4, true);
                        damageInfo.max_threat = Math.max(d5, damageInfo.max_threat);
                        damageInfo.min_damage = Math.min(damageInfo.min_damage, d6);
                        if (!(d5 - d6 > damageInfo.threat - damageInfo.damage)) continue;
                        damageInfo.threat = d5;
                        damageInfo.damage = d6;
                        ((MoveOption)object).tv.add(d5 + " Spec Threat " + i + "\n");
                        ((MoveOption)object).tv.add(d6 + " Spec Damage " + i + "\n");
                    }
                    ((MoveOption)object).damage = 0.0;
                    ((MoveOption)object).threat = 0.0;
                    for (CEntity cEntity5 : ((MoveOption)object).damageInfos.keySet()) {
                        MoveOption.DamageInfo damageInfo = ((MoveOption)object).getDamageInfo(cEntity5, true);
                        damageInfo.min_damage /= cEntity5.strategy.target;
                        damageInfo.damage /= cEntity5.strategy.target;
                        ((MoveOption)object).damage += (damageInfo.min_damage + damageInfo.damage) / 2.0;
                        ((MoveOption)object).threat = Math.max(((MoveOption)object).threat, damageInfo.max_threat + damageInfo.threat) / 2.0;
                        damageInfo.threat = (damageInfo.max_threat + 2.0 * damageInfo.threat) / 3.0;
                    }
                }
                cEntity4.current.setState();
            }
            cEntity.current.setState();
        }
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(1.0, 1.0), 20);
        this.filterMoves(objectArray, cEntity.pass, new MoveOption.WeightedComparator(0.5, 1.0), 20);
        for (Serializable serializable22 : cEntity.pass.values()) {
            ((MoveOption)serializable22).self_threat *= 0.5;
            ((MoveOption)serializable22).self_damage *= 0.5;
        }
        objectArray = cEntity.pass.values().toArray();
        cEntity.pass.clear();
        if (cEntity.engaged) {
            for (int i = 0; i < objectArray.length; ++i) {
                serializable22 = (MoveOption)objectArray[i];
                ((MoveOption)serializable22).setState();
                GAAttack gAAttack = this.bestAttack((MoveOption)serializable22);
                ((MoveOption)serializable22).damage = gAAttack != null ? (((MoveOption)serializable22).damage + gAAttack.getFittestChromosomesFitness()) / 2.0 : (((MoveOption)serializable22).damage /= 2.0);
                for (int j = 0; j < vector.size(); ++j) {
                    Entity entity3 = (Entity)vector.elementAt(j);
                    CEntity cEntity6 = this.centities.get(entity3);
                    if (!cEntity6.canMove()) {
                        ((MoveOption)serializable22).setThreat(cEntity6, (((MoveOption)serializable22).getThreat(cEntity6) + this.attackUtility(cEntity6.current, cEntity)) / 2.0);
                        ((MoveOption)serializable22).tv.add(((MoveOption)serializable22).getThreat(cEntity6) + " Revised Threat " + j + " \n");
                        if (((MoveOption)serializable22).isPhysical) continue;
                        if (gAAttack != null) {
                            ((MoveOption)serializable22).setDamage(cEntity6, (((MoveOption)serializable22).getDamage(cEntity6) + gAAttack.getDamageUtility(cEntity6)) / 2.0);
                        } else {
                            ((MoveOption)serializable22).setDamage(cEntity6, ((MoveOption)serializable22).getMinDamage(cEntity6));
                        }
                        ((MoveOption)serializable22).tv.add(((MoveOption)serializable22).getDamage(cEntity6) + " Revised Damage " + j + " \n");
                        if (((MovePath)serializable22).getFinalCoords().distance(cEntity6.current.getFinalCoords()) != 1) continue;
                        object = this.pcalc.getBestPhysicalAttack(((MovePath)serializable22).getEntity(), cEntity6.getEntity(), this.game);
                        if (object != null) {
                            ((MoveOption)serializable22).setDamage(cEntity6, ((MoveOption)serializable22).getDamage(cEntity6) + ((PhysicalOption)object).expectedDmg);
                            ((MoveOption)serializable22).tv.add(((PhysicalOption)object).expectedDmg + " Physical Damage " + j + " \n");
                        }
                        if ((object = this.pcalc.getBestPhysicalAttack(cEntity6.getEntity(), ((MovePath)serializable22).getEntity(), this.game)) == null) continue;
                        ((MoveOption)serializable22).setThreat(cEntity6, ((MoveOption)serializable22).getThreat(cEntity6) + 0.5 * ((PhysicalOption)object).expectedDmg);
                        ((MoveOption)serializable22).tv.add(0.5 * ((PhysicalOption)object).expectedDmg + " Physical Threat " + j + " \n");
                        continue;
                    }
                    if (!((MoveOption)serializable22).isPhysical) {
                        if (gAAttack != null) {
                            ((MoveOption)serializable22).setDamage(cEntity6, (2.0 * ((MoveOption)serializable22).getDamage(cEntity6) + gAAttack.getDamageUtility(cEntity6)) / 3.0);
                            continue;
                        }
                        ((MoveOption)serializable22).setDamage(cEntity6, ((MoveOption)serializable22).getMinDamage(cEntity6));
                        continue;
                    }
                    ((MoveOption)serializable22).setDamage(cEntity6, ((MoveOption)serializable22).getDamage(cEntity6) / Math.sqrt((double)cEntity6.bv / (double)cEntity.bv));
                    ((MoveOption)serializable22).damage = ((MoveOption)serializable22).getDamage(cEntity6);
                }
                ((MoveOption)serializable22).threat = 0.0;
                object2 = ((MoveOption)serializable22).damageInfos.values().iterator();
                while (object2.hasNext()) {
                    ((MoveOption)serializable22).threat += ((MoveOption.DamageInfo)object2.next()).threat;
                }
                ((MoveOption)serializable22).tv.add(((MoveOption)serializable22).threat + " Revised Threat Utility\n");
                ((MoveOption)serializable22).tv.add(((MoveOption)serializable22).damage + " Revised Damage Utility\n");
            }
        }
        Arrays.sort(objectArray, new MoveOption.WeightedComparator(1.0, 1.0));
        cEntity.current.setState();
        MoveOption[] moveOptionArray = new MoveOption[Math.min(objectArray.length, 20)];
        int n12 = 0;
        for (int i = 0; i < Math.min(objectArray.length, 20); ++i) {
            object2 = (MoveOption)objectArray[i];
            if (((MoveOption)object2).isPhysical && cEntity.range_damages[0] > 5.0 && ((MoveOption)object2).doomed && n12 + 20 < objectArray.length) {
                object2 = (MoveOption)objectArray[n12 + 20];
                ++n12;
            }
            moveOptionArray[i] = object2;
        }
        return moveOptionArray;
    }

    private void filterMoves(Object[] objectArray, MoveOption.Table table, MoveOption.WeightedComparator weightedComparator, int n) {
        Arrays.sort(objectArray, weightedComparator);
        for (int i = 0; i < n && i < objectArray.length; ++i) {
            table.put((MoveOption)objectArray[i]);
        }
    }

    protected void initFiring() {
        CEntity cEntity;
        Vector vector = this.game.getEntitiesVector();
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            cEntity = this.centities.get(entity);
            cEntity.reset();
            cEntity.enemy_num = n++;
        }
        for (Entity entity : this.getEnemyEntities()) {
            cEntity = this.centities.get(entity);
            if (!entity.isMakingDfa() && !entity.isCharging()) continue;
            cEntity.strategy.target = 2.5;
        }
    }

    protected Vector calculateWeaponAttacks(Entity entity, Mounted mounted, boolean bl) {
        int n = entity.getId();
        int n2 = entity.getEquipmentNum(mounted);
        int n3 = 0;
        Vector<AttackOption> vector = new Vector<AttackOption>();
        Enumeration enumeration = this.game.getValidTargets(entity).elements();
        AttackOption attackOption = null;
        AttackOption attackOption2 = new AttackOption(null, null, 0.0, null);
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            CEntity cEntity = this.centities.get(entity2);
            ToHitData toHitData = WeaponAttackAction.toHit(this.game, n, entity2, n2);
            if (toHitData.getValue() == Integer.MAX_VALUE || toHitData.getValue() >= 13) continue;
            WeaponAttackAction weaponAttackAction = new WeaponAttackAction(n, entity2.getId(), n2);
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34 || weaponType.getAmmoType() == 23) {
                n3 = Compute.spinUpCannon(this.game, weaponAttackAction);
                super.sendModeChange(n, n2, n3);
            }
            double d = Compute.getAmmoAdjDamage(this.game, weaponAttackAction);
            attackOption = new AttackOption(cEntity, mounted, d, toHitData);
            if (attackOption.value > attackOption2.value) {
                if (bl) {
                    attackOption2 = attackOption;
                    continue;
                }
                vector.add(0, attackOption);
                continue;
            }
            vector.add(attackOption);
        }
        if (bl && attackOption2.target != null) {
            vector.add(attackOption2);
        }
        if (vector.size() > 0) {
            vector.add(new AttackOption(null, mounted, 0.0, null));
        }
        return vector;
    }

    public GAAttack bestAttack(MoveOption moveOption) {
        return this.bestAttack(moveOption, null, 2);
    }

    public GAAttack bestAttack(MoveOption moveOption, CEntity cEntity, int n) {
        Entity entity = moveOption.getEntity();
        int[] nArray = new int[4];
        Vector vector = new Vector();
        Vector<Vector> vector2 = new Vector<Vector>();
        Vector<Vector> vector3 = new Vector<Vector>();
        Vector<Vector> vector4 = new Vector<Vector>();
        Vector<Vector> vector5 = new Vector<Vector>();
        GAAttack gAAttack = null;
        int n2 = entity.getFacing();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        PhysicalCalculator physicalCalculator = new PhysicalCalculator();
        PhysicalOption physicalOption = new PhysicalOption(entity);
        PhysicalOption physicalOption2 = new PhysicalOption(entity);
        PhysicalOption physicalOption3 = new PhysicalOption(entity);
        Object object = entity.getWeapons();
        while (object.hasMoreElements()) {
            Mounted mounted = (Mounted)object.nextElement();
            vector = this.calculateWeaponAttacks(entity, mounted, true);
            physicalOption = physicalCalculator.getBestPhysical(entity, this.game);
            if (physicalOption != null && entity instanceof Mech) {
                if ((physicalOption.type == 10 || physicalOption.type == 12) && mounted.getLocation() == 5 || (physicalOption.type == 11 || physicalOption.type == 12) && mounted.getLocation() == 4) continue;
                if ((physicalOption.type == 1 || physicalOption.type == 3) && mounted.getLocation() == 5 && vector.size() > 0) {
                    d += ((AttackOption)vector.elementAt((int)(vector.size() - 2))).value;
                }
                if ((physicalOption.type == 2 || physicalOption.type == 3) && mounted.getLocation() == 4 && vector.size() > 0) {
                    d2 += ((AttackOption)vector.elementAt((int)(vector.size() - 2))).value;
                }
                if (physicalOption.type == 8 && (mounted.getLocation() == 5 || mounted.getLocation() == 4)) continue;
            }
            if (vector.size() > 0) {
                vector2.add(vector);
                nArray[0] = Math.max(nArray[0], vector.size());
            }
            if (!moveOption.getFinalProne() && entity.canChangeSecondaryFacing()) {
                entity.setSecondaryFacing((n2 + 5) % 6);
                vector = this.calculateWeaponAttacks(entity, mounted, true);
                if (vector.size() > 0) {
                    physicalOption2 = physicalCalculator.getBestPhysical(entity, this.game);
                    if (physicalOption2 != null && entity instanceof Mech) {
                        if ((physicalOption2.type == 1 || physicalOption2.type == 3) && mounted.getLocation() == 5) {
                            d3 += ((AttackOption)vector.elementAt((int)(vector.size() - 2))).value;
                        }
                        if ((physicalOption2.type == 2 || physicalOption2.type == 3) && mounted.getLocation() == 4) {
                            d4 += ((AttackOption)vector.elementAt((int)(vector.size() - 2))).value;
                        }
                    }
                    vector3.add(vector);
                    nArray[1] = Math.max(nArray[1], vector.size());
                }
                entity.setSecondaryFacing((n2 + 1) % 6);
                vector = this.calculateWeaponAttacks(entity, mounted, true);
                if (vector.size() > 0) {
                    physicalOption3 = physicalCalculator.getBestPhysical(entity, this.game);
                    if (physicalOption3 != null && entity instanceof Mech) {
                        if ((physicalOption3.type == 1 || physicalOption3.type == 3) && mounted.getLocation() == 5) {
                            d5 += ((AttackOption)vector.elementAt((int)(vector.size() - 2))).value;
                        }
                        if ((physicalOption3.type == 2 || physicalOption3.type == 3) && mounted.getLocation() == 4) {
                            d6 += ((AttackOption)vector.elementAt((int)(vector.size() - 2))).value;
                        }
                    }
                    vector4.add(vector);
                    nArray[2] = Math.max(nArray[2], vector.size());
                }
                entity.setSecondaryFacing((n2 + 3) % 6);
                vector = this.calculateWeaponAttacks(entity, mounted, true);
                if (vector.size() > 0) {
                    vector5.add(vector);
                    nArray[1] = Math.max(nArray[3], vector.size());
                }
            } else {
                nArray[1] = 0;
                nArray[2] = 0;
            }
            entity.setSecondaryFacing(n2);
        }
        if (physicalOption != null && entity instanceof Mech) {
            if (physicalOption.type == 1 && d < physicalOption.expectedDmg && vector2.size() > 0) {
                for (int i = 0; i < vector2.size(); ++i) {
                    vector = (Vector)vector2.elementAt(i);
                    for (int j = 0; j < vector.size(); ++j) {
                        if (((AttackOption)vector.elementAt((int)j)).weapon.getLocation() != 5) continue;
                        ((AttackOption)vector.elementAt((int)j)).expected = 0.0;
                        ((AttackOption)vector.elementAt((int)j)).primary_expected = 0.0;
                    }
                }
            }
            if (physicalOption.type == 2 && d2 < physicalOption.expectedDmg && vector2.size() > 0) {
                for (int i = 0; i < vector2.size(); ++i) {
                    vector = (Vector)vector2.elementAt(i);
                    for (int j = 0; j < vector.size(); ++j) {
                        if (((AttackOption)vector.elementAt((int)j)).weapon.getLocation() != 4) continue;
                        ((AttackOption)vector.elementAt((int)j)).expected = 0.0;
                        ((AttackOption)vector.elementAt((int)j)).primary_expected = 0.0;
                    }
                }
            }
            if (physicalOption.type == 3 && d + d2 < physicalOption.expectedDmg && vector2.size() > 0) {
                for (int i = 0; i < vector2.size(); ++i) {
                    vector = (Vector)vector2.elementAt(i);
                    for (int j = 0; j < vector.size(); ++j) {
                        if (((AttackOption)vector.elementAt((int)j)).weapon.getLocation() == 5) {
                            ((AttackOption)vector.elementAt((int)j)).expected = 0.0;
                            ((AttackOption)vector.elementAt((int)j)).primary_expected = 0.0;
                        }
                        if (((AttackOption)vector.elementAt((int)j)).weapon.getLocation() != 4) continue;
                        ((AttackOption)vector.elementAt((int)j)).expected = 0.0;
                        ((AttackOption)vector.elementAt((int)j)).primary_expected = 0.0;
                    }
                }
            }
        }
        object = new Vector();
        ((Vector)object).add(vector2);
        if (!moveOption.getFinalProne() && entity.canChangeSecondaryFacing()) {
            int n3;
            if (physicalOption2 != null && entity instanceof Mech) {
                if (physicalOption2.type == 1 && d3 < physicalOption2.expectedDmg && vector3.size() > 0) {
                    for (int i = 0; i < vector3.size(); ++i) {
                        vector = (Vector)vector3.elementAt(i);
                        for (n3 = 0; n3 < vector.size(); ++n3) {
                            if (((AttackOption)vector.elementAt((int)n3)).weapon.getLocation() != 5) continue;
                            ((AttackOption)vector.elementAt((int)n3)).expected = 0.0;
                            ((AttackOption)vector.elementAt((int)n3)).primary_expected = 0.0;
                        }
                    }
                }
                if (physicalOption2.type == 2 && d4 < physicalOption2.expectedDmg && vector3.size() > 0) {
                    for (int i = 0; i < vector3.size(); ++i) {
                        vector = (Vector)vector3.elementAt(i);
                        for (n3 = 0; n3 < vector.size(); ++n3) {
                            if (((AttackOption)vector.elementAt((int)n3)).weapon.getLocation() != 4) continue;
                            ((AttackOption)vector.elementAt((int)n3)).expected = 0.0;
                            ((AttackOption)vector.elementAt((int)n3)).primary_expected = 0.0;
                        }
                    }
                }
                if (physicalOption2.type == 3 && d3 + d4 < physicalOption2.expectedDmg && vector3.size() > 0) {
                    for (int i = 0; i < vector3.size(); ++i) {
                        vector = (Vector)vector3.elementAt(i);
                        for (n3 = 0; n3 < vector.size(); ++n3) {
                            if (((AttackOption)vector.elementAt((int)n3)).weapon.getLocation() == 5) {
                                ((AttackOption)vector.elementAt((int)n3)).expected = 0.0;
                                ((AttackOption)vector.elementAt((int)n3)).primary_expected = 0.0;
                            }
                            if (((AttackOption)vector.elementAt((int)n3)).weapon.getLocation() != 4) continue;
                            ((AttackOption)vector.elementAt((int)n3)).expected = 0.0;
                            ((AttackOption)vector.elementAt((int)n3)).primary_expected = 0.0;
                        }
                    }
                }
            }
            ((Vector)object).add(vector3);
            if (physicalOption3 != null && entity instanceof Mech) {
                if (physicalOption3.type == 1 && d5 < physicalOption3.expectedDmg && vector4.size() > 0) {
                    for (int i = 0; i < vector4.size(); ++i) {
                        vector = (Vector)vector4.elementAt(i);
                        for (n3 = 0; n3 < vector.size(); ++n3) {
                            if (((AttackOption)vector.elementAt((int)n3)).weapon.getLocation() != 5) continue;
                            ((AttackOption)vector.elementAt((int)n3)).expected = 0.0;
                            ((AttackOption)vector.elementAt((int)n3)).primary_expected = 0.0;
                        }
                    }
                }
                if (physicalOption3.type == 2 && d6 < physicalOption3.expectedDmg && vector4.size() > 0) {
                    for (int i = 0; i < vector4.size(); ++i) {
                        vector = (Vector)vector4.elementAt(i);
                        for (n3 = 0; n3 < vector.size(); ++n3) {
                            if (((AttackOption)vector.elementAt((int)n3)).weapon.getLocation() != 4) continue;
                            ((AttackOption)vector.elementAt((int)n3)).expected = 0.0;
                            ((AttackOption)vector.elementAt((int)n3)).primary_expected = 0.0;
                        }
                    }
                }
                if (physicalOption3.type == 3 && d5 + d6 < physicalOption3.expectedDmg && vector4.size() > 0) {
                    for (int i = 0; i < vector4.size(); ++i) {
                        vector = (Vector)vector4.elementAt(i);
                        for (n3 = 0; n3 < vector.size(); ++n3) {
                            if (((AttackOption)vector.elementAt((int)n3)).weapon.getLocation() == 5) {
                                ((AttackOption)vector.elementAt((int)n3)).expected = 0.0;
                                ((AttackOption)vector.elementAt((int)n3)).primary_expected = 0.0;
                            }
                            if (((AttackOption)vector.elementAt((int)n3)).weapon.getLocation() != 4) continue;
                            ((AttackOption)vector.elementAt((int)n3)).expected = 0.0;
                            ((AttackOption)vector.elementAt((int)n3)).primary_expected = 0.0;
                        }
                    }
                }
            }
            ((Vector)object).add(vector4);
            if (!(entity instanceof Mech) && !(entity instanceof Protomech)) {
                ((Vector)object).add(vector5);
            }
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Vector vector6 = (Vector)((Vector)object).elementAt(i);
            if (vector6.size() <= 0) continue;
            GAAttack gAAttack2 = new GAAttack(this, this.centities.get(entity), vector6, Math.max((vector6.size() + nArray[i]) * n, 20 * n), 30 * n, entity.isEnemyOf((Entity)this.getEntitiesOwned().get(0)));
            gAAttack2.setFiringArc(i);
            gAAttack2.evolve();
            if (cEntity != null) {
                if (gAAttack != null && !(gAAttack2.getDamageUtility(cEntity) > gAAttack.getDamageUtility(cEntity))) continue;
                gAAttack = gAAttack2;
                continue;
            }
            if (gAAttack != null && !(gAAttack2.getFittestChromosomesFitness() > gAAttack.getFittestChromosomesFitness())) continue;
            gAAttack = gAAttack2;
        }
        return gAAttack;
    }

    public double attackUtility(MoveOption moveOption, CEntity cEntity) {
        GAAttack gAAttack = this.bestAttack(moveOption, cEntity, 1);
        if (gAAttack == null) {
            return 0.0;
        }
        return gAAttack.getFittestChromosomesFitness();
    }

    public void calculateFiringTurn() {
        Object object;
        Object object2;
        Serializable serializable;
        int n;
        int n2 = n = this.game.getFirstEntityNum();
        int n3 = n;
        int n4 = 0;
        double d = Double.MIN_VALUE;
        int[] nArray = null;
        Vector vector = null;
        int n5 = 0;
        if (n2 == -1) {
            return;
        }
        do {
            serializable = this.game.getEntity(n2);
            object2 = this.centities.get((Entity)serializable);
            object = this.bestAttack(((CEntity)object2).current, null, 3);
            if (object == null || !(((GA)object).getFittestChromosomesFitness() > d)) continue;
            d = ((GA)object).getFittestChromosomesFitness();
            nArray = ((GAAttack)object).getResultChromosome();
            n5 = ((GAAttack)object).getFiringArc();
            n3 = n2;
            vector = ((GAAttack)object).getAttack();
        } while ((n2 = this.game.getNextEntityNum(n2)) != n && n2 != -1);
        serializable = new Vector();
        object2 = this.game.getEntity(n3);
        if (nArray != null) {
            object = (Entity)this.game.getEntitiesVector().elementAt(nArray[nArray.length - 1]);
            TreeMap<AttackOption, AttackOption> treeMap = new TreeMap<AttackOption, AttackOption>(new AttackOption.Sorter(this.centities.get((Entity)object)));
            for (int i = 0; i < nArray.length - 1; ++i) {
                AttackOption attackOption = (AttackOption)((Vector)vector.elementAt(i)).elementAt(nArray[i]);
                if (attackOption.target == null) continue;
                int n6 = attackOption.toHit.getSideTable();
                attackOption.target.expected_damage[n6] = attackOption.target.expected_damage[n6] + attackOption.value;
                attackOption.target.hasTakenDamage = true;
                treeMap.put(attackOption, attackOption);
            }
            for (AttackOption attackOption : treeMap.values()) {
                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(((Entity)object2).getId(), attackOption.target.getEntity().getId(), ((Entity)object2).getEquipmentNum(attackOption.weapon));
                if (((Entity)object2).getEquipment(weaponAttackAction.getWeaponId()).getLinked() != null) {
                    WeaponType weaponType = (WeaponType)attackOption.weapon.getType();
                    if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34 || weaponType.getAmmoType() == 23) {
                        n4 = Compute.spinUpCannon(this.game, weaponAttackAction);
                        super.sendModeChange(((Entity)object2).getId(), ((Entity)object2).getEquipmentNum(attackOption.weapon), n4);
                    }
                    Mounted mounted = ((Entity)object2).getEquipment(weaponAttackAction.getWeaponId()).getLinked();
                    weaponAttackAction.setAmmoId(((Entity)object2).getEquipmentNum(mounted));
                    Compute.getAmmoAdjDamage(this.game, weaponAttackAction);
                }
                ((Vector)serializable).addElement(weaponAttackAction);
            }
        }
        switch (n5) {
            case 1: {
                ((Vector)serializable).insertElementAt(new TorsoTwistAction(((Entity)object2).getId(), (((Entity)object2).getFacing() + 5) % 6), 0);
                break;
            }
            case 2: {
                ((Vector)serializable).insertElementAt(new TorsoTwistAction(((Entity)object2).getId(), (((Entity)object2).getFacing() + 1) % 6), 0);
                break;
            }
            case 3: {
                ((Vector)serializable).insertElementAt(new TorsoTwistAction(((Entity)object2).getId(), (((Entity)object2).getFacing() + 3) % 6), 0);
            }
        }
        this.sendAttackData(n3, (Vector)serializable);
    }

    protected void initMovement() {
        double d;
        Object object;
        this.my_mechs_moved = 0;
        this.old_moves = null;
        this.enemies_moved = 0;
        double d2 = 1.4;
        Vector vector = this.game.getEntitiesVector();
        double d3 = Math.sqrt(vector.size()) / 100.0;
        Vector<CEntity> vector2 = new Vector<CEntity>();
        Vector<CEntity> vector3 = new Vector<CEntity>();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        CEntity cEntity = null;
        for (int i = 0; i < vector.size(); ++i) {
            object = (Entity)vector.elementAt(i);
            CEntity cEntity2 = this.centities.get((Entity)object);
            cEntity2.enemy_num = i;
            d = (double)cEntity2.bv * (cEntity2.overall_armor_percent + 1.0);
            cEntity2.reset();
            double d7 = (double)cEntity2.bv * (cEntity2.overall_armor_percent + 1.0);
            double d8 = 1.0 + (d7 - d) / d;
            if (((Entity)object).getOwner().equals(this.getLocalPlayer())) {
                vector2.add(cEntity2);
                d4 += d7;
                if (d8 < 0.85) {
                    cEntity2.strategy.attack = 0.85;
                    continue;
                }
                if (d8 < 0.95) {
                    cEntity2.strategy.attack = 1.0;
                    continue;
                }
                if (!(d8 <= 1.0) || !(cEntity2.strategy.attack < d2)) continue;
                if (d8 == 1.0) {
                    if (cEntity2.strategy.attack < 1.0) {
                        cEntity2.strategy.attack = Math.min(1.4 * cEntity2.strategy.attack, 1.0);
                        continue;
                    }
                    cEntity2.strategy.attack *= 1.0 + d3;
                    continue;
                }
                cEntity2.strategy.attack *= 1.0 + 2.0 * d3;
                continue;
            }
            if (!((Entity)object).getOwner().isEnemyOf(this.getLocalPlayer())) {
                d4 += d7;
                continue;
            }
            vector3.add(cEntity2);
            d5 += d7;
            if (d7 > d6) {
                d6 = d7;
                cEntity = cEntity2;
            }
            if (this.getEntitiesOwned().size() <= 2) continue;
            if (cEntity2.strategy.target > 2.0) {
                cEntity2.strategy.target = 1.0 + 0.5 * (cEntity2.strategy.target - 2.0);
            }
            if (d8 < 0.85 && cEntity2.strategy.target < d2) {
                cEntity2.strategy.target *= 1.0 + 6.0 * d3;
            } else if (d8 < 0.95 && cEntity2.strategy.target < d2) {
                cEntity2.strategy.target *= 1.0 + 4.0 * d3;
            } else if (d8 <= 1.0) {
                cEntity2.strategy.target = d8 == 1.0 ? (cEntity2.strategy.target /= 1.0 + 2.0 * d3) : (cEntity2.strategy.target /= 1.0 + d3);
            }
            if (!(cEntity2.strategy.target < 1.0)) continue;
            cEntity2.strategy.target = 1.0;
        }
        System.out.println("Us " + d4 + " Them " + d5);
        if (this.unit_values.size() == 0) {
            this.unit_values.add(new Double(d4));
            this.enemy_values.add(new Double(d5));
            return;
        }
        Iterator iterator = vector3.iterator();
        if (vector2.size() > 1) {
            if (Strategy.MainTarget == null || null == this.game.getEntity(Strategy.MainTarget.getEntity().getId())) {
                Strategy.MainTarget = cEntity;
            }
            if (null == Strategy.MainTarget) {
                System.err.println("TestBot#initMovement() - no main target for bot");
            } else if (null == Strategy.MainTarget.strategy) {
                System.err.println("TestBot#initMovement() - no strategy for main target");
            } else {
                Strategy.MainTarget.strategy.target += 0.2;
                while (iterator.hasNext()) {
                    object = (CEntity)iterator.next();
                    if (d4 - d5 >= 0.9 * ((Double)this.unit_values.getLast() - (Double)this.enemy_values.getLast())) {
                        if (Compute.randomInt(2) == 1) {
                            ((CEntity)object).strategy.target += 0.3;
                        }
                    } else if (d4 > 0.9 * d5) {
                        ((CEntity)object).strategy.target += 0.15;
                    } else if (((CEntity)object).strategy.target < 2.0) {
                        ((CEntity)object).strategy.target += 0.3;
                    }
                    System.out.println(((CEntity)object).getEntity().getShortName() + " " + ((CEntity)object).strategy.target);
                }
            }
        }
        double d9 = d4 / d5;
        d = 1.0;
        if (d9 < 0.9) {
            d = 0.95;
        } else if (!(d9 < 1.0)) {
            d = 1.0 + d3;
        }
        for (CEntity cEntity3 : vector2) {
            if (d < 1.0 && cEntity3.strategy.attack < 0.6 || d > 1.0 && cEntity3.strategy.attack >= d2) continue;
            cEntity3.strategy.attack *= d;
        }
        System.gc();
    }

    protected void processChat(GamePlayerChatEvent gamePlayerChatEvent) {
        this.chatp.processChat(gamePlayerChatEvent, this);
    }

    protected void calculateDeployment() {
        EquipmentType equipmentType;
        RoundUpdated roundUpdated;
        Coords coords = new Coords();
        int n = this.game.getFirstDeployableEntityNum();
        Coords[] coordsArray = this.getStartingCoordsArray();
        Coords coords2 = this.getCoordsAround(this.getEntity(n), coordsArray);
        double d = 0.0;
        int n2 = 0;
        Enumeration enumeration = this.getEntity(n).getWeapons();
        while (enumeration.hasMoreElements()) {
            roundUpdated = (Mounted)enumeration.nextElement();
            equipmentType = (WeaponType)((Mounted)roundUpdated).getType();
            if (equipmentType.getName() == "ATM 3" || equipmentType.getName() == "ATM 6" || equipmentType.getName() == "ATM 9" || equipmentType.getName() == "ATM 12") continue;
            d = this.getEntity(n).getC3Master() != null ? (d += (double)((WeaponType)equipmentType).getLongRange() * 1.25) : (d += (double)((WeaponType)equipmentType).getLongRange());
            ++n2;
        }
        Enumeration enumeration2 = this.getEntity(n).getAmmo();
        while (enumeration2.hasMoreElements()) {
            roundUpdated = (Mounted)enumeration2.nextElement();
            equipmentType = (AmmoType)((Mounted)roundUpdated).getType();
            if (((AmmoType)equipmentType).getAmmoType() != 29) continue;
            ++n2;
            d += 15.0;
            if (((AmmoType)equipmentType).getAmmoType() == 29 && ((AmmoType)equipmentType).getMunitionType() == 64L) {
                d -= 6.0;
            }
            if (((AmmoType)equipmentType).getAmmoType() != 29 || ((AmmoType)equipmentType).getMunitionType() != 32L) continue;
            d += 12.0;
        }
        d /= (double)n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration3 = this.game.getEntities();
        while (enumeration3.hasMoreElements()) {
            Entity entity = (Entity)enumeration3.nextElement();
            if (!entity.isDeployed() || !entity.isVisibleToEnemy() || coords2.distance(entity.getPosition()) > (int)d) continue;
            ++n3;
            n4 += entity.getPosition().x;
            n5 += entity.getPosition().y;
        }
        coords = n3 != 0 ? new Coords(n4 / n3, n5 / n3) : new Coords(this.game.getBoard().getWidth() / 2, this.game.getBoard().getHeight() / 2);
        int n6 = coords2.direction(coords);
        if (this.getEntity(n) instanceof Mech && this.getEntity(n).getArmorType() == 8) {
            Enumeration enumeration4 = this.getEntity(n).getMisc();
            while (enumeration4.hasMoreElements()) {
                roundUpdated = (Mounted)enumeration4.nextElement();
                equipmentType = (MiscType)((Mounted)roundUpdated).getType();
                if (!"Mek Stealth".equals(equipmentType.getInternalName()) || ((Mounted)roundUpdated).curMode().getName() == "On") continue;
                ((Mounted)roundUpdated).setMode("On");
                super.sendModeChange(n, this.getEntity(n).getEquipmentNum((Mounted)roundUpdated), 1);
            }
        }
        Assert.assertTrue(!((Entity)(roundUpdated = this.game.getEntity(n))).isHexProhibited(this.game.getBoard().getHex(coords2)));
        this.deploy(n, coords2, n6);
    }

    protected MovePath continueMovementFor(Entity entity) {
        return new MovePath(this.game, entity);
    }

    protected Vector calculateMinefieldDeployment() {
        Vector vector = new Vector();
        vector = this.deployMinefields(vector, this.getLocalPlayer().getNbrMFConventional(), 0);
        vector = this.deployMinefields(vector, this.getLocalPlayer().getNbrMFCommand(), 1);
        vector = this.deployMinefields(vector, this.getLocalPlayer().getNbrMFVibra(), 2);
        return vector;
    }

    protected Vector calculateArtyAutoHitHexes() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.insertElementAt(new Integer(this.getLocalPlayer().getId()), 0);
        return vector;
    }

    protected Vector deployMinefields(Vector vector, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            Minefield minefield;
            Coords coords = new Coords(Compute.randomInt(this.game.getBoard().getWidth()), Compute.randomInt(this.game.getBoard().getHeight()));
            if (this.game.containsMinefield(coords)) {
                minefield = (Minefield)this.game.getMinefields(coords).elementAt(0);
                if (minefield.getPlayerId() != this.getLocalPlayer().getId()) continue;
                --i;
                continue;
            }
            minefield = null;
            if (n2 == 0) {
                minefield = Minefield.createConventionalMF(coords, this.getLocalPlayer().getId());
            } else if (n2 == 1) {
                minefield = Minefield.createCommandDetonatedMF(coords, this.getLocalPlayer().getId());
            } else if (n2 == 2) {
                minefield = Minefield.createVibrabombMF(coords, this.getLocalPlayer().getId(), 20);
            }
            vector.addElement(minefield);
        }
        return vector;
    }
}

