/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.BattleArmorMapSet;
import megamek.client.ui.AWT.widget.DisplayMapSet;
import megamek.client.ui.AWT.widget.InfantryMapSet;
import megamek.client.ui.AWT.widget.MechMapSet;
import megamek.client.ui.AWT.widget.PicMap;
import megamek.client.ui.AWT.widget.ProtomechMapSet;
import megamek.client.ui.AWT.widget.QuadMapSet;
import megamek.client.ui.AWT.widget.TankMapSet;
import megamek.client.ui.AWT.widget.VTOLMapSet;
import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;
import megamek.common.VTOL;

class ArmorPanel
extends PicMap {
    private TankMapSet tank;
    private MechMapSet mech;
    private InfantryMapSet infantry;
    private BattleArmorMapSet battleArmor;
    private ProtomechMapSet proto;
    private VTOLMapSet vtol;
    private QuadMapSet quad;
    private int minTopMargin = 0;
    private int minLeftMargin = 0;
    private int minBottomMargin = 0;
    private int minRightMargin = 0;
    private static final int minTankTopMargin = 8;
    private static final int minTankLeftMargin = 8;
    private static final int minVTOLTopMargin = 8;
    private static final int minVTOLLeftMargin = 8;
    private static final int minMechTopMargin = 18;
    private static final int minMechLeftMargin = 7;
    private static final int minMechBottomMargin = 0;
    private static final int minMechRightMargin = 0;
    private static final int minInfTopMargin = 8;
    private static final int minInfLeftMargin = 8;

    ArmorPanel() {
    }

    public void addNotify() {
        super.addNotify();
        this.tank = new TankMapSet(this);
        this.mech = new MechMapSet(this);
        this.infantry = new InfantryMapSet(this);
        this.battleArmor = new BattleArmorMapSet(this);
        this.proto = new ProtomechMapSet(this);
        this.vtol = new VTOLMapSet(this);
        this.quad = new QuadMapSet(this);
    }

    public void onResize() {
        Rectangle rectangle = this.getContentBounds();
        if (rectangle == null) {
            return;
        }
        int n = Math.round((this.getSize().width - rectangle.width) / 2);
        int n2 = Math.round((this.getSize().height - rectangle.height) / 2);
        int n3 = n < this.minLeftMargin ? this.minLeftMargin : n;
        int n4 = n2 < this.minTopMargin ? this.minTopMargin : n2;
        this.setContentMargins(n3, n4, this.minRightMargin, this.minBottomMargin);
    }

    public void displayMech(Entity entity) {
        if (null == entity) {
            return;
        }
        DisplayMapSet displayMapSet = this.mech;
        this.removeAll();
        if (entity instanceof QuadMech) {
            displayMapSet = this.quad;
            this.minLeftMargin = 7;
            this.minTopMargin = 18;
            this.minBottomMargin = 0;
            this.minRightMargin = 0;
        } else if (entity instanceof Mech) {
            displayMapSet = this.mech;
            this.minLeftMargin = 7;
            this.minTopMargin = 18;
            this.minBottomMargin = 0;
            this.minRightMargin = 0;
        } else if (entity instanceof VTOL) {
            displayMapSet = this.vtol;
            this.minLeftMargin = 8;
            this.minTopMargin = 8;
            this.minBottomMargin = 8;
            this.minRightMargin = 8;
        } else if (entity instanceof Tank) {
            displayMapSet = this.tank;
            this.minLeftMargin = 8;
            this.minTopMargin = 8;
            this.minBottomMargin = 8;
            this.minRightMargin = 8;
        } else if (entity instanceof BattleArmor) {
            displayMapSet = this.battleArmor;
            this.minLeftMargin = 8;
            this.minTopMargin = 8;
            this.minBottomMargin = 8;
            this.minRightMargin = 8;
        } else if (entity instanceof Infantry) {
            displayMapSet = this.infantry;
            this.minLeftMargin = 8;
            this.minTopMargin = 8;
            this.minBottomMargin = 8;
            this.minRightMargin = 8;
        } else if (entity instanceof Protomech) {
            displayMapSet = this.proto;
            this.minLeftMargin = 8;
            this.minTopMargin = 8;
            this.minBottomMargin = 8;
            this.minRightMargin = 8;
        }
        if (null == displayMapSet) {
            System.err.println("The armor panel is null.");
            return;
        }
        displayMapSet.setEntity(entity);
        this.addElement(displayMapSet.getContentGroup());
        Vector vector = displayMapSet.getBackgroundDrawers();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addBgDrawer((BackGroundDrawer)enumeration.nextElement());
        }
        this.onResize();
        this.update();
    }
}

