/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.event.MechDisplayEvent;
import megamek.client.event.MechDisplayListener;
import megamek.client.ui.AWT.ArmorPanel;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.ExtraPanel;
import megamek.client.ui.AWT.MovementPanel;
import megamek.client.ui.AWT.SystemPanel;
import megamek.client.ui.AWT.WeaponPanel;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.client.ui.AWT.widget.MechPanelTabStrip;
import megamek.common.Entity;

public class MechDisplay
extends BufferedPanel {
    MechPanelTabStrip tabStrip;
    public BufferedPanel displayP;
    public MovementPanel mPan;
    public ArmorPanel aPan;
    public WeaponPanel wPan;
    public SystemPanel sPan;
    public ExtraPanel ePan;
    private ClientGUI clientgui;
    private Client client;
    private Entity currentlyDisplaying = null;
    private Vector eventListeners = new Vector();

    public MechDisplay(ClientGUI clientGUI) {
        super(new GridBagLayout());
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.tabStrip = new MechPanelTabStrip(this);
        this.displayP = new BufferedPanel(new CardLayout());
        this.mPan = new MovementPanel();
        this.displayP.add("movement", this.mPan);
        this.aPan = new ArmorPanel();
        this.displayP.add("armor", this.aPan);
        this.wPan = new WeaponPanel(clientGUI, this);
        this.displayP.add("weapons", this.wPan);
        this.sPan = new SystemPanel(clientGUI);
        this.displayP.add("systems", this.sPan);
        this.ePan = new ExtraPanel(clientGUI);
        this.displayP.add("extras", this.ePan);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 1, 0, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.tabStrip, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        gridBagConstraints.weighty = 1.0;
        this.addBag(this.displayP, gridBagConstraints);
        ((CardLayout)this.displayP.getLayout()).show(this.displayP, "movement");
        clientGUI.mechW.addKeyListener(clientGUI.menuBar);
    }

    public void addBag(Component component, GridBagConstraints gridBagConstraints) {
        ((GridBagLayout)this.getLayout()).setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void displayEntity(Entity entity) {
        this.clientgui.mechW.setTitle(entity.getShortName());
        this.currentlyDisplaying = entity;
        this.mPan.displayMech(entity);
        this.aPan.displayMech(entity);
        this.wPan.displayMech(entity);
        this.sPan.displayMech(entity);
        this.ePan.displayMech(entity);
    }

    public Entity getCurrentEntity() {
        return this.currentlyDisplaying;
    }

    public void showPanel(String string) {
        ((CardLayout)this.displayP.getLayout()).show(this.displayP, string);
        if (string == "movement") {
            this.tabStrip.setTab(0);
        } else if (string == "armor") {
            this.tabStrip.setTab(1);
        } else if (string == "weapons") {
            this.tabStrip.setTab(3);
        } else if (string == "systems") {
            this.tabStrip.setTab(2);
        } else if (string == "extras") {
            this.tabStrip.setTab(4);
        }
    }

    public void addMechDisplayListener(MechDisplayListener mechDisplayListener) {
        this.eventListeners.addElement(mechDisplayListener);
    }

    public void removeMechDisplayListener(MechDisplayListener mechDisplayListener) {
        this.eventListeners.removeElement(mechDisplayListener);
    }

    public void processMechDisplayEvent(MechDisplayEvent mechDisplayEvent) {
        block3: for (int i = 0; i < this.eventListeners.size(); ++i) {
            MechDisplayListener mechDisplayListener = (MechDisplayListener)this.eventListeners.elementAt(i);
            switch (mechDisplayEvent.getType()) {
                case 0: {
                    mechDisplayListener.WeaponSelected(mechDisplayEvent);
                    continue block3;
                }
                default: {
                    System.err.println("unknown event " + mechDisplayEvent.getType() + " in processMechDisplayEvent");
                }
            }
        }
    }
}

