/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.List;
import java.awt.TextArea;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.event.MechDisplayEvent;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.FiringDisplay;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.MechDisplay;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.TargetingPhaseDisplay;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.TransparentLabel;
import megamek.common.AmmoType;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.WeaponType;

class WeaponPanel
extends BufferedPanel
implements ItemListener {
    private static final String IMAGE_DIR = "data/images/widgets";
    public List weaponList;
    public Choice m_chAmmo;
    public TransparentLabel wAmmo;
    public TransparentLabel wNameL;
    public TransparentLabel wHeatL;
    public TransparentLabel wDamL;
    public TransparentLabel wMinL;
    public TransparentLabel wShortL;
    public TransparentLabel wMedL;
    public TransparentLabel wLongL;
    public TransparentLabel wExtL;
    public TransparentLabel wNameR;
    public TransparentLabel wHeatR;
    public TransparentLabel wDamR;
    public TransparentLabel wMinR;
    public TransparentLabel wShortR;
    public TransparentLabel wMedR;
    public TransparentLabel wLongR;
    public TransparentLabel wExtR;
    public TransparentLabel currentHeatBuildupL;
    public TransparentLabel currentHeatBuildupR;
    public TransparentLabel wTargetL;
    public TransparentLabel wRangeL;
    public TransparentLabel wToHitL;
    public TransparentLabel wTargetR;
    public TransparentLabel wRangeR;
    public TransparentLabel wToHitR;
    public TextArea toHitText;
    private Vector weapons;
    private Vector vAmmo;
    private Entity entity;
    private ClientGUI client;
    private MechDisplay owner;
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayMediumFontSize"));

    public WeaponPanel(ClientGUI clientGUI, MechDisplay mechDisplay) {
        super(new GridBagLayout());
        this.client = clientGUI;
        this.owner = mechDisplay;
        FontMetrics fontMetrics = this.getFontMetrics(FONT_VALUE);
        Color color = Color.white;
        this.weaponList = new List(4, false);
        this.weaponList.addItemListener(this);
        this.weaponList.addKeyListener(clientGUI.menuBar);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(15, 9, 1, 9);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.weaponList, gridBagConstraints);
        this.add(this.weaponList);
        this.wAmmo = new TransparentLabel(Messages.getString("MechDisplay.Ammo"), fontMetrics, color, -1);
        this.m_chAmmo = new Choice();
        this.m_chAmmo.addItemListener(this);
        this.m_chAmmo.addKeyListener(clientGUI.menuBar);
        gridBagConstraints.insets = new Insets(1, 9, 1, 1);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wAmmo, gridBagConstraints);
        this.add(this.wAmmo);
        gridBagConstraints.insets = new Insets(1, 1, 1, 9);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)this.getLayout()).setConstraints(this.m_chAmmo, gridBagConstraints);
        this.add(this.m_chAmmo);
        this.currentHeatBuildupL = new TransparentLabel(Messages.getString("MechDisplay.HeatBuildup"), fontMetrics, color, 1);
        this.currentHeatBuildupR = new TransparentLabel("--", fontMetrics, color, -1);
        gridBagConstraints.insets = new Insets(2, 9, 2, 1);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        ((GridBagLayout)this.getLayout()).setConstraints(this.currentHeatBuildupL, gridBagConstraints);
        this.add(this.currentHeatBuildupL);
        gridBagConstraints.insets = new Insets(2, 1, 2, 9);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        ((GridBagLayout)this.getLayout()).setConstraints(this.currentHeatBuildupR, gridBagConstraints);
        this.add(this.currentHeatBuildupR);
        this.wNameL = new TransparentLabel(Messages.getString("MechDisplay.Name"), fontMetrics, color, 0);
        this.wHeatL = new TransparentLabel(Messages.getString("MechDisplay.Heat"), fontMetrics, color, 0);
        this.wDamL = new TransparentLabel(Messages.getString("MechDisplay.Damage"), fontMetrics, color, 0);
        this.wNameR = new TransparentLabel("", fontMetrics, color, 0);
        this.wHeatR = new TransparentLabel("--", fontMetrics, color, 0);
        this.wDamR = new TransparentLabel("--", fontMetrics, color, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 9, 1, 1);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wNameL, gridBagConstraints);
        this.add(this.wNameL);
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wHeatL, gridBagConstraints);
        this.add(this.wHeatL);
        gridBagConstraints.insets = new Insets(2, 1, 1, 9);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 3;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wDamL, gridBagConstraints);
        this.add(this.wDamL);
        gridBagConstraints.insets = new Insets(1, 9, 2, 1);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wNameR, gridBagConstraints);
        this.add(this.wNameR);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wHeatR, gridBagConstraints);
        this.add(this.wHeatR);
        gridBagConstraints.insets = new Insets(1, 1, 2, 9);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wDamR, gridBagConstraints);
        this.add(this.wDamR);
        this.wMinL = new TransparentLabel(Messages.getString("MechDisplay.Min"), fontMetrics, color, 0);
        this.wShortL = new TransparentLabel(Messages.getString("MechDisplay.Short"), fontMetrics, color, 0);
        this.wMedL = new TransparentLabel(Messages.getString("MechDisplay.Med"), fontMetrics, color, 0);
        this.wLongL = new TransparentLabel(Messages.getString("MechDisplay.Long"), fontMetrics, color, 0);
        this.wExtL = new TransparentLabel(Messages.getString("MechDisplay.Ext"), fontMetrics, color, 0);
        this.wMinR = new TransparentLabel("---", fontMetrics, color, 0);
        this.wShortR = new TransparentLabel("---", fontMetrics, color, 0);
        this.wMedR = new TransparentLabel("---", fontMetrics, color, 0);
        this.wLongR = new TransparentLabel("---", fontMetrics, color, 0);
        this.wExtR = new TransparentLabel("---", fontMetrics, color, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 9, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wMinL, gridBagConstraints);
        this.add(this.wMinL);
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wShortL, gridBagConstraints);
        this.add(this.wShortL);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wMedL, gridBagConstraints);
        this.add(this.wMedL);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wLongL, gridBagConstraints);
        this.add(this.wLongL);
        gridBagConstraints.insets = new Insets(2, 1, 1, 9);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wExtL, gridBagConstraints);
        this.add(this.wExtL);
        gridBagConstraints.insets = new Insets(1, 9, 2, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wMinR, gridBagConstraints);
        this.add(this.wMinR);
        gridBagConstraints.insets = new Insets(1, 1, 2, 1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wShortR, gridBagConstraints);
        this.add(this.wShortR);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wMedR, gridBagConstraints);
        this.add(this.wMedR);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wLongR, gridBagConstraints);
        this.add(this.wLongR);
        gridBagConstraints.insets = new Insets(1, 1, 2, 9);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wExtR, gridBagConstraints);
        this.add(this.wExtR);
        this.wTargetL = new TransparentLabel(Messages.getString("MechDisplay.Target"), fontMetrics, color, 0);
        this.wRangeL = new TransparentLabel(Messages.getString("MechDisplay.Range"), fontMetrics, color, 0);
        this.wToHitL = new TransparentLabel(Messages.getString("MechDisplay.ToHit"), fontMetrics, color, 0);
        this.wTargetR = new TransparentLabel("---", fontMetrics, color, 0);
        this.wRangeR = new TransparentLabel("---", fontMetrics, color, 0);
        this.wToHitR = new TransparentLabel("---", fontMetrics, color, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(2, 9, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wTargetL, gridBagConstraints);
        this.add(this.wTargetL);
        gridBagConstraints.insets = new Insets(2, 1, 1, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wTargetR, gridBagConstraints);
        this.add(this.wTargetR);
        gridBagConstraints.insets = new Insets(1, 9, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wRangeL, gridBagConstraints);
        this.add(this.wRangeL);
        gridBagConstraints.insets = new Insets(1, 1, 1, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wRangeR, gridBagConstraints);
        this.add(this.wRangeR);
        gridBagConstraints.insets = new Insets(1, 9, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wToHitL, gridBagConstraints);
        this.add(this.wToHitL);
        gridBagConstraints.insets = new Insets(1, 1, 1, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.wToHitR, gridBagConstraints);
        this.add(this.wToHitR);
        this.toHitText = new TextArea("", 2, 20, 1);
        this.toHitText.setEditable(false);
        this.toHitText.addKeyListener(clientGUI.menuBar);
        gridBagConstraints.insets = new Insets(1, 9, 15, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.toHitText, gridBagConstraints);
        this.add(this.toHitText);
        this.setBackGround();
    }

    private void setBackGround() {
        Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this);
        int n = 8;
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 20;
        image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 68;
        image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 258;
        image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 273;
        image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 321;
        image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this);
        this.addBgDrawer(new BackGroundDrawer(image, n));
    }

    public void displayMech(Entity entity) {
        CharSequence charSequence;
        Object object;
        int n;
        IGame iGame = this.client.getClient().game;
        this.weapons = entity.getWeaponList();
        this.entity = entity;
        int n2 = entity.heat + entity.getEngineCritHeat() + entity.heatBuildup;
        if (entity instanceof Mech) {
            if (entity.infernos.isStillBurning()) {
                n2 += entity.infernos.getHeat();
            }
            if (!((Mech)entity).hasLaserHeatSinks()) {
                n2 = iGame.getOptions().intOption("temperature") > 0 ? (n2 += iGame.getTemperatureDifference()) : (n2 -= iGame.getTemperatureDifference());
            }
        }
        Coords coords = this.entity.getPosition();
        if (!entity.isOffBoard() && coords != null) {
            IHex iHex = iGame.getBoard().getHex(coords);
            if (iHex.terrainLevel(7) == 2) {
                n2 += 5;
            }
            if (iHex.terrainLevel(24) == 1) {
                n2 += 5;
            } else if (iHex.terrainLevel(24) == 2) {
                n2 += 10;
            }
        }
        if (entity instanceof Mech && entity.isStealthActive()) {
            n2 += 10;
        }
        this.weaponList.removeAll();
        this.m_chAmmo.removeAll();
        this.m_chAmmo.setEnabled(false);
        for (n = 0; n < this.weapons.size(); ++n) {
            Mounted mounted = (Mounted)this.weapons.elementAt(n);
            object = (WeaponType)mounted.getType();
            charSequence = new StringBuffer(mounted.getDesc());
            ((StringBuffer)charSequence).append(" [");
            ((StringBuffer)charSequence).append(entity.getLocationAbbr(mounted.getLocation()));
            ((StringBuffer)charSequence).append("]");
            if (((WeaponType)object).getAmmoType() != -1 && !((EquipmentType)object).hasFlag(32768)) {
                int n3 = 0;
                if (mounted.getLinked() != null && !mounted.getLinked().isDumping()) {
                    n3 = mounted.getLinked().getShotsLeft();
                }
                EquipmentType equipmentType = null;
                if (null != mounted.getLinked()) {
                    equipmentType = mounted.getLinked().getType();
                }
                int n4 = this.entity.getTotalMunitionsOfType(equipmentType);
                ((StringBuffer)charSequence).append(" (");
                ((StringBuffer)charSequence).append(n3);
                ((StringBuffer)charSequence).append("/");
                ((StringBuffer)charSequence).append(n4);
                ((StringBuffer)charSequence).append(")");
            }
            if (mounted.isRapidfire()) {
                ((StringBuffer)charSequence).append(Messages.getString("MechDisplay.rapidFire"));
            }
            if (((EquipmentType)object).hasModes()) {
                ((StringBuffer)charSequence).append(" ");
                ((StringBuffer)charSequence).append(mounted.curMode().getDisplayableName());
            }
            this.weaponList.add(((StringBuffer)charSequence).toString());
            if (!mounted.isUsedThisRound() || iGame.getPhase() != mounted.usedInPhase() || iGame.getPhase() != 12) continue;
            n2 += ((WeaponType)object).getHeat() * mounted.howManyShots();
        }
        n = entity.getHeatCapacity();
        int n5 = entity.getHeatCapacityWithWater();
        object = Integer.toString(n);
        if (n < n5) {
            object = n + " [" + n5 + "]";
        }
        charSequence = Integer.toString(n2);
        if (n2 > entity.getHeatCapacityWithWater()) {
            charSequence = (String)charSequence + "*";
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.currentHeatBuildupR.setText((String)charSequence + " (" + (String)object + ")");
        if (iGame.getOptions().booleanOption("maxtech_range")) {
            this.wExtL.setVisible(true);
            this.wExtR.setVisible(true);
        } else {
            this.wExtL.setVisible(false);
            this.wExtR.setVisible(false);
        }
    }

    public void selectWeapon(int n) {
        if (n == -1) {
            this.weaponList.select(-1);
            return;
        }
        int n2 = this.weapons.indexOf(this.entity.getEquipment(n));
        this.weaponList.select(n2);
        this.displaySelected();
    }

    public int getSelectedWeaponNum() {
        int n = this.weaponList.getSelectedIndex();
        if (n == -1) {
            return -1;
        }
        return this.entity.getEquipmentNum((Mounted)this.weapons.elementAt(n));
    }

    public void displaySelected() {
        if (this.weaponList.getSelectedIndex() == -1) {
            this.m_chAmmo.removeAll();
            this.m_chAmmo.setEnabled(false);
            this.wNameR.setText("");
            this.wHeatR.setText("--");
            this.wDamR.setText("--");
            this.wMinR.setText("---");
            this.wShortR.setText("---");
            this.wMedR.setText("---");
            this.wLongR.setText("---");
            this.wExtR.setText("---");
            return;
        }
        Mounted mounted = (Mounted)this.weapons.elementAt(this.weaponList.getSelectedIndex());
        WeaponType weaponType = (WeaponType)mounted.getType();
        this.wNameR.setText(mounted.getDesc());
        this.wHeatR.setText(weaponType.getHeat() + "");
        if (weaponType.getDamage() == -2) {
            this.wDamR.setText(Messages.getString("MechDisplay.Missile"));
        } else if (weaponType.getDamage() == -3) {
            this.wDamR.setText(Messages.getString("MechDisplay.Variable"));
        } else if (weaponType.getDamage() == -4) {
            this.wDamR.setText(Messages.getString("MechDisplay.Special"));
        } else if (weaponType.getDamage() == -5) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Integer.toString(weaponType.getRackSize())).append('/').append(Integer.toString(weaponType.getRackSize() / 2));
            this.wDamR.setText(stringBuffer.toString());
        } else {
            this.wDamR.setText(Integer.toString(weaponType.getDamage()));
        }
        int n = weaponType.getShortRange();
        int n2 = weaponType.getMediumRange();
        int n3 = weaponType.getLongRange();
        int n4 = weaponType.getExtremeRange();
        if (2 == this.entity.getLocationStatus(mounted.getLocation()) || n3 == 0) {
            n = weaponType.getWShortRange();
            n2 = weaponType.getWMediumRange();
            n3 = weaponType.getWLongRange();
            n4 = weaponType.getWExtremeRange();
        }
        if (weaponType.getMinimumRange() > 0) {
            this.wMinR.setText(Integer.toString(weaponType.getMinimumRange()));
        } else {
            this.wMinR.setText("---");
        }
        if (n > 1) {
            this.wShortR.setText("1 - " + n);
        } else {
            this.wShortR.setText("" + n);
        }
        if (n2 - n > 1) {
            this.wMedR.setText(n + 1 + " - " + n2);
        } else {
            this.wMedR.setText("" + n2);
        }
        if (n3 - n2 > 1) {
            this.wLongR.setText(n2 + 1 + " - " + n3);
        } else {
            this.wLongR.setText("" + n3);
        }
        if (n4 - n3 > 1) {
            this.wExtR.setText(n3 + 1 + " - " + n4);
        } else {
            this.wExtR.setText("" + n4);
        }
        if (null != mounted.getLinked()) {
            AmmoType ammoType = (AmmoType)mounted.getLinked().getType();
            this.updateRangeDisplayForAmmo(ammoType);
        }
        boolean bl = this.client.getClient().getLocalPlayer() == this.entity.getOwner();
        this.m_chAmmo.removeAll();
        if (weaponType.getAmmoType() == -1 || !bl) {
            this.m_chAmmo.setEnabled(false);
        } else if (weaponType.hasFlag(32768)) {
            if (mounted.getLinked().getShotsLeft() == 1) {
                this.m_chAmmo.add(this.formatAmmo(mounted.getLinked()));
                this.m_chAmmo.setEnabled(true);
            } else {
                this.m_chAmmo.setEnabled(false);
            }
        } else {
            this.m_chAmmo.setEnabled(true);
            this.vAmmo = new Vector();
            int n5 = -1;
            int n6 = 0;
            Enumeration enumeration = this.entity.getAmmo();
            while (enumeration.hasMoreElements()) {
                Mounted mounted2 = (Mounted)enumeration.nextElement();
                AmmoType ammoType = (AmmoType)mounted2.getType();
                if (!mounted2.isAmmoUsable() || ammoType.getAmmoType() != weaponType.getAmmoType() || ammoType.getRackSize() != weaponType.getRackSize()) continue;
                this.vAmmo.addElement(mounted2);
                this.m_chAmmo.add(this.formatAmmo(mounted2));
                if (mounted.getLinked() == mounted2) {
                    n5 = n6;
                }
                ++n6;
            }
            if (n5 != -1) {
                this.m_chAmmo.select(n5);
            }
        }
        this.owner.processMechDisplayEvent(new MechDisplayEvent(this, this.entity, mounted));
    }

    private String formatAmmo(Mounted mounted) {
        StringBuffer stringBuffer = new StringBuffer(64);
        int n = mounted.getDesc().indexOf(Messages.getString("MechDisplay.0"));
        int n2 = mounted.getLocation();
        if (n2 != -1) {
            stringBuffer.append("[").append(this.entity.getLocationAbbr(n2)).append("] ");
        }
        if (n == -1) {
            stringBuffer.append(mounted.getDesc());
        } else {
            stringBuffer.append(mounted.getDesc().substring(0, n));
            stringBuffer.append(mounted.getDesc().substring(n + 4));
        }
        return stringBuffer.toString();
    }

    private void updateRangeDisplayForAmmo(AmmoType ammoType) {
        if (29 == ammoType.getAmmoType()) {
            if (ammoType.getAmmoType() == 29 && ammoType.getMunitionType() == 32L) {
                this.wMinR.setText("4");
                this.wShortR.setText("1 - 9");
                this.wMedR.setText("10 - 18");
                this.wLongR.setText("19 - 27");
                this.wExtR.setText("28 - 36");
            } else if (ammoType.getAmmoType() == 29 && ammoType.getMunitionType() == 64L) {
                this.wMinR.setText("---");
                this.wShortR.setText("1 - 3");
                this.wMedR.setText("4 - 6");
                this.wLongR.setText("7 - 9");
                this.wExtR.setText("10 - 12");
            } else {
                this.wMinR.setText("4");
                this.wShortR.setText("1 - 5");
                this.wMedR.setText("6 - 10");
                this.wLongR.setText("11 - 15");
                this.wExtR.setText("16 - 20");
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.weaponList) {
            this.displaySelected();
        } else if (itemEvent.getItemSelectable() == this.m_chAmmo) {
            int n = this.weaponList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            Mounted mounted = (Mounted)this.weapons.elementAt(n);
            Mounted mounted2 = (Mounted)this.vAmmo.elementAt(this.m_chAmmo.getSelectedIndex());
            this.entity.loadWeapon(mounted, mounted2);
            AmmoType ammoType = (AmmoType)mounted2.getType();
            this.updateRangeDisplayForAmmo(ammoType);
            if (this.client.curPanel instanceof FiringDisplay) {
                ((FiringDisplay)this.client.curPanel).updateTarget();
            } else if (this.client.curPanel instanceof TargetingPhaseDisplay) {
                ((TargetingPhaseDisplay)this.client.curPanel).updateTarget();
            }
            this.client.getClient().sendAmmoChange(this.entity.getId(), this.entity.getEquipmentNum(mounted), this.entity.getEquipmentNum(mounted2));
        }
    }
}

