/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Shape;
import megamek.client.ui.AWT.widget.SizedButton;

public class ImageButton
extends SizedButton {
    private Image image = null;
    private Dimension imageSize = new Dimension();
    private MediaTracker tracker = new MediaTracker(this);
    public static final int EDGE = 4;

    public ImageButton() {
    }

    public ImageButton(Image image) {
        if (null != image) {
            this.setImage(image);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public synchronized void setImage(Image image) {
        this.image = image;
        this.repaint();
        if (null == this.image) {
            return;
        }
        this.tracker.addImage(this.image, 0);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (null != this.image) {
            try {
                if (!this.tracker.checkID(0)) {
                    this.tracker.waitForID(0);
                    this.imageSize.width = this.image.getWidth(this);
                    this.imageSize.height = this.image.getHeight(this);
                    this.setPreferredSize(this.imageSize);
                }
                Dimension dimension = this.getSize();
                Point point = new Point(0, 0);
                if (dimension.width > this.imageSize.width) {
                    point.x = (dimension.width - this.imageSize.width) / 2;
                }
                if (dimension.height > this.imageSize.height) {
                    point.y = (dimension.height - this.imageSize.height) / 2;
                }
                Shape shape = graphics.getClip();
                graphics.setClip(4, 4, dimension.width - 8, dimension.height - 8);
                graphics.drawImage(this.image, point.x, point.y, this.imageSize.width, this.imageSize.height, this);
                graphics.setClip(shape);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Could not load image:");
                System.err.println(interruptedException.getMessage());
                this.image = null;
            }
        }
    }
}

