/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.StringUtil;

public class GameLog {
    public static final String LOG_DIR = PreferenceManager.getClientPreferences().getLogDirectory();
    public static final String LOG_FILE = "gamelog.txt";
    private File logfile;
    Writer writer;

    public GameLog(String string) {
        try {
            File file = new File(LOG_DIR);
            if (!file.exists()) {
                file.mkdir();
            }
            this.logfile = new File(LOG_DIR + File.separator + string);
            if (PreferenceManager.getClientPreferences().stampFilenames()) {
                string = StringUtil.addDateTimeStamp(string);
            }
            this.writer = new BufferedWriter(new FileWriter(LOG_DIR + File.separator + string));
            this.append("Log file opened " + new Date().toString());
        }
        catch (IOException iOException) {
            this.writer = null;
            System.err.println("GameLog:" + iOException.getMessage());
        }
    }

    public void append(String string) {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.write(string);
            this.writer.write("\r\n");
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.writer = null;
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

