/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Coords;
import megamek.common.IBoard;
import megamek.common.Messages;
import megamek.common.Targetable;

public class HexTarget
implements Targetable {
    private Coords m_coords;
    private boolean m_bIgnite;
    private int m_elev;
    private int m_type;

    public HexTarget(Coords coords, IBoard iBoard, int n) {
        this.m_coords = coords;
        this.m_elev = iBoard.getHex(this.m_coords).getElevation();
        this.m_type = n;
        this.m_bIgnite = n == 2;
    }

    public int getTargetType() {
        return this.m_type;
    }

    public int getTargetId() {
        return HexTarget.coordsToId(this.m_coords);
    }

    public Coords getPosition() {
        return this.m_coords;
    }

    public int absHeight() {
        return this.getHeight() + this.getElevation();
    }

    public int getHeight() {
        return 0;
    }

    public int getElevation() {
        return this.m_elev;
    }

    public boolean isImmobile() {
        return this.m_type != 6 && this.m_type != 14;
    }

    public String getDisplayName() {
        String string = "";
        switch (this.m_type) {
            case 13: {
                string = Messages.getString("HexTarget.DeliverFlare");
                break;
            }
            case 6: {
                string = Messages.getString("HexTarget.DeliverMinefield");
                break;
            }
            case 14: {
                string = Messages.getString("HexTarget.Bomb");
                break;
            }
            case 1: {
                string = Messages.getString("HexTarget.Clear");
                break;
            }
            case 2: {
                string = Messages.getString("HexTarget.Ignite");
                break;
            }
            case 7: {
                string = Messages.getString("HexTarget.Artillery");
                break;
            }
            case 8: {
                string = " (FASCAM)";
                break;
            }
            case 9: {
                string = " (Inferno IV)";
                break;
            }
            case 10: {
                string = " (Vibrabomb IV)";
            }
        }
        return "Hex: " + this.m_coords.getBoardNum() + string;
    }

    public boolean isIgniting() {
        return this.m_bIgnite;
    }

    public static int coordsToId(Coords coords) {
        return coords.y * 100000 + coords.x;
    }

    public static Coords idToCoords(int n) {
        int n2 = n / 100000;
        return new Coords(n - n2 * 100000, n2);
    }

    public int sideTable(Coords coords) {
        return 0;
    }
}

