/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.Coords;

public class Minefield
implements Serializable,
Cloneable {
    public static final int TYPE_CONVENTIONAL = 0;
    public static final int TYPE_COMMAND_DETONATED = 1;
    public static final int TYPE_VIBRABOMB = 2;
    public static final int TYPE_THUNDER = 3;
    public static final int TYPE_THUNDER_INFERNO = 4;
    public static final int TYPE_THUNDER_ACTIVE = 5;
    public static final int TYPE_THUNDER_VIBRABOMB = 6;
    public static final int TRIGGER_NONE = 0;
    public static final int CLEAR_NUMBER_WEAPON = 5;
    public static final int CLEAR_NUMBER_INFANTRY = 10;
    public static final int CLEAR_NUMBER_INFANTRY_ACCIDENT = 5;
    public static final int CLEAR_NUMBER_SWEEPER = 6;
    public static final int CLEAR_NUMBER_SWEEPER_ACCIDENT = 2;
    public static final int TO_HIT_SIDE = 0;
    public static final int TO_HIT_TABLE = 2;
    public static final int MAX_DAMAGE = 20;
    public static final String IMAGE_FILE = "data/images/hexes/minefieldsign.gif";
    private static String[] names = new String[]{"Conventional", "Command-detonated", "Vibrabomb", "Thunder", "Thunder-Inferno", "Thunder-Active", "Thunder-Vibrabomb"};
    private Coords coords = null;
    private int playerId = -1;
    private int damage = 0;
    private int secondaryDamage = 0;
    private int setting = 0;
    private int trigger = 0;
    private int type = -1;
    private boolean areaEffect = false;
    private boolean oneUse = false;

    private Minefield() {
    }

    public static Minefield createConventionalMF(Coords coords, int n) {
        Minefield minefield = new Minefield();
        minefield.damage = 6;
        minefield.type = 0;
        minefield.trigger = 7;
        minefield.coords = coords;
        minefield.playerId = n;
        return minefield;
    }

    public static Minefield createCommandDetonatedMF(Coords coords, int n) {
        Minefield minefield = new Minefield();
        minefield.damage = 10;
        minefield.secondaryDamage = 4;
        minefield.areaEffect = true;
        minefield.oneUse = true;
        minefield.type = 1;
        minefield.coords = coords;
        minefield.playerId = n;
        return minefield;
    }

    public static Minefield createVibrabombMF(Coords coords, int n, int n2) {
        Minefield minefield = new Minefield();
        minefield.damage = 10;
        minefield.areaEffect = true;
        minefield.oneUse = true;
        minefield.setting = n2;
        minefield.type = 2;
        minefield.coords = coords;
        minefield.playerId = n;
        return minefield;
    }

    public static Minefield createThunderVibrabombMF(Coords coords, int n, int n2, int n3) {
        Minefield minefield = new Minefield();
        minefield.damage = n2;
        minefield.areaEffect = true;
        minefield.oneUse = true;
        minefield.setting = n3;
        minefield.type = 2;
        minefield.coords = coords;
        minefield.playerId = n;
        return minefield;
    }

    public static Minefield createThunderMF(Coords coords, int n, int n2) {
        Minefield minefield = new Minefield();
        minefield.damage = n2;
        minefield.type = 3;
        minefield.trigger = 7;
        minefield.coords = coords;
        minefield.playerId = n;
        return minefield;
    }

    public static Minefield createThunderInfernoMF(Coords coords, int n, int n2) {
        Minefield minefield = new Minefield();
        minefield.damage = n2;
        minefield.type = 4;
        minefield.trigger = 7;
        minefield.coords = coords;
        minefield.playerId = n;
        return minefield;
    }

    public static Minefield createThunderActiveMF(Coords coords, int n, int n2) {
        Minefield minefield = new Minefield();
        minefield.damage = n2;
        minefield.type = 5;
        minefield.trigger = 7;
        minefield.coords = coords;
        minefield.playerId = n;
        return minefield;
    }

    public Object clone() {
        Minefield minefield = new Minefield();
        minefield.playerId = this.playerId;
        minefield.coords = this.coords;
        minefield.damage = this.damage;
        minefield.secondaryDamage = this.secondaryDamage;
        minefield.areaEffect = this.areaEffect;
        minefield.oneUse = this.oneUse;
        minefield.setting = this.setting;
        minefield.type = this.type;
        return minefield;
    }

    public boolean equals(Object object) {
        Minefield minefield;
        try {
            minefield = (Minefield)object;
        }
        catch (Exception exception) {
            return false;
        }
        return minefield.playerId == this.playerId && minefield.coords.equals(this.coords) && minefield.type == this.type;
    }

    public void setDamage(int n) {
        this.damage = n;
    }

    public Coords getCoords() {
        return this.coords;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getSecondaryDamage() {
        return this.secondaryDamage;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public boolean isAreaEffect() {
        return this.areaEffect;
    }

    public boolean isOneUse() {
        return this.oneUse;
    }

    public int getSetting() {
        return this.setting;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return names[this.getType()];
    }

    public int getPlayerId() {
        return this.playerId;
    }
}

