/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.MoveStep;
import megamek.common.QuadMech;
import megamek.common.Targetable;
import megamek.common.preference.PreferenceManager;

public class MovePath
implements Cloneable,
Serializable {
    public static final int STEP_FORWARDS = 1;
    public static final int STEP_BACKWARDS = 2;
    public static final int STEP_TURN_LEFT = 3;
    public static final int STEP_TURN_RIGHT = 4;
    public static final int STEP_GET_UP = 5;
    public static final int STEP_GO_PRONE = 6;
    public static final int STEP_START_JUMP = 7;
    public static final int STEP_CHARGE = 8;
    public static final int STEP_DFA = 9;
    public static final int STEP_FLEE = 10;
    public static final int STEP_LATERAL_LEFT = 11;
    public static final int STEP_LATERAL_RIGHT = 12;
    public static final int STEP_LATERAL_LEFT_BACKWARDS = 13;
    public static final int STEP_LATERAL_RIGHT_BACKWARDS = 14;
    public static final int STEP_UNJAM_RAC = 15;
    public static final int STEP_LOAD = 16;
    public static final int STEP_UNLOAD = 17;
    public static final int STEP_EJECT = 18;
    public static final int STEP_CLEAR_MINEFIELD = 19;
    public static final int STEP_UP = 20;
    public static final int STEP_DOWN = 21;
    public static final int STEP_SEARCHLIGHT = 22;
    public static final int STEP_LAY_MINE = 23;
    public static final int STEP_HULL_DOWN = 24;
    protected Vector steps = new Vector();
    protected transient IGame game;
    protected transient Entity entity;
    public static final int DEFAULT_PATHFINDER_TIME_LIMIT = 2000;

    public MovePath(IGame iGame, Entity entity) {
        this.entity = entity;
        this.game = iGame;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Key getKey() {
        return new Key(this.getFinalCoords(), this.getFinalFacing(), this.getFinalProne() ? 0 : (this.isJumping() ? 1 : 2));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.steps.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.steps.size();
    }

    public MovePath addStep(int n) {
        return this.addStep(new MoveStep(this, n));
    }

    public MovePath addStep(int n, Targetable targetable) {
        return this.addStep(new MoveStep(this, n, targetable));
    }

    public MovePath addStep(int n, int n2) {
        return this.addStep(new MoveStep(this, n, n2));
    }

    public boolean canShift() {
        return (this.entity instanceof QuadMech || this.entity.isUsingManAce()) && !this.isJumping();
    }

    protected MovePath addStep(MoveStep moveStep) {
        this.steps.addElement(moveStep);
        if (this.canShift()) {
            this.transformLateralShift();
        }
        MoveStep moveStep2 = this.getStep(this.steps.size() - 2);
        try {
            moveStep.compile(this.game, this.entity, moveStep2);
        }
        catch (RuntimeException runtimeException) {
            moveStep.setMovementType(-1);
        }
        Coords coords = this.entity.getPosition();
        Coords coords2 = moveStep.getPosition();
        int n = coords.distance(coords2);
        if (this.isJumping() && moveStep.getMpUsed() > n) {
            moveStep.setMovementType(-1);
        }
        if (moveStep.isLegal() && null != moveStep2 && !coords2.equals(moveStep2.getPosition())) {
            for (int i = this.steps.size() - 2; i >= 0 && this.getStep(i).setEndPos(false); --i) {
            }
        }
        return this;
    }

    public void compile(IGame iGame, Entity entity) {
        this.game = iGame;
        this.entity = entity;
        Vector vector = (Vector)this.steps.clone();
        this.steps.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            MoveStep moveStep = (MoveStep)vector.elementAt(i);
            moveStep = moveStep.getTarget(this.game) != null ? new MoveStep(this, moveStep.getType(), moveStep.getTarget(this.game)) : (moveStep.getMineToLay() != -1 ? new MoveStep(this, moveStep.getType(), moveStep.getMineToLay()) : new MoveStep(this, moveStep.getType()));
            this.addStep(moveStep);
        }
        this.clipToPossible();
    }

    public void removeLastStep() {
        if (this.steps.size() > 0) {
            this.steps.removeElementAt(this.steps.size() - 1);
        }
        for (int i = this.steps.size() - 1; i >= 0 && this.getStep(i).setEndPos(true) && !this.getStep(i).isLegal(); --i) {
        }
    }

    public void clear() {
        this.steps.removeAllElements();
    }

    public Enumeration getSteps() {
        return this.steps.elements();
    }

    public MoveStep getStep(int n) {
        if (n < 0 || n >= this.steps.size()) {
            return null;
        }
        return (MoveStep)this.steps.elementAt(n);
    }

    public boolean contains(int n) {
        Enumeration enumeration = this.getSteps();
        while (enumeration.hasMoreElements()) {
            MoveStep moveStep = (MoveStep)enumeration.nextElement();
            if (moveStep.getType() != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveMASC() {
        Enumeration enumeration = this.getSteps();
        while (enumeration.hasMoreElements()) {
            MoveStep moveStep = (MoveStep)enumeration.nextElement();
            if (!moveStep.isUsingMASC()) continue;
            return true;
        }
        return false;
    }

    public Coords getFinalCoords() {
        if (this.getLastStep() != null) {
            return this.getLastStep().getPosition();
        }
        return this.entity.getPosition();
    }

    public int getFinalFacing() {
        if (this.getLastStep() != null) {
            return this.getLastStep().getFacing();
        }
        return this.entity.getFacing();
    }

    public boolean getFinalProne() {
        if (this.getLastStep() != null) {
            return this.getLastStep().isProne();
        }
        if (this.entity == null) {
            return false;
        }
        return this.entity.isProne();
    }

    public boolean getFinalHullDown() {
        if (this.getLastStep() != null) {
            return this.getLastStep().isHullDown();
        }
        if (this.entity == null) {
            return false;
        }
        return this.entity.isHullDown();
    }

    public int getFinalElevation() {
        if (this.getLastStep() != null) {
            return this.getLastStep().getElevation();
        }
        return this.entity.getElevation();
    }

    public int getLastStepMovementType() {
        if (this.getLastStep() == null) {
            return 0;
        }
        return this.getLastStep().getMovementType();
    }

    public MoveStep getLastStep() {
        return this.getStep(this.steps.size() - 1);
    }

    public void printAllSteps() {
        System.out.println("*Steps*");
        for (int i = 0; i < this.steps.size(); ++i) {
            System.out.println("  " + i + ": " + this.getStep(i) + ", " + this.getStep(i).getMovementType());
        }
    }

    public void clipToPossible() {
        Vector<MoveStep> vector = new Vector<MoveStep>();
        Enumeration enumeration = this.steps.elements();
        while (enumeration.hasMoreElements()) {
            MoveStep moveStep = (MoveStep)enumeration.nextElement();
            if (moveStep.getMovementType() == -1) continue;
            vector.addElement(moveStep);
        }
        this.steps = vector;
    }

    private void transformLateralShift() {
        if (this.steps.size() < 3) {
            return;
        }
        int n = this.steps.size() - 3;
        MoveStep moveStep = this.getStep(n);
        MoveStep moveStep2 = this.getStep(n + 1);
        MoveStep moveStep3 = this.getStep(n + 2);
        if (moveStep.oppositeTurn(moveStep3) && (moveStep2.getType() == 2 || moveStep2.getType() == 1)) {
            int n2 = moveStep.getType();
            int n3 = moveStep2.getType();
            this.steps.removeElementAt(n);
            this.steps.removeElementAt(n);
            this.steps.removeElementAt(n);
            MoveStep moveStep4 = new MoveStep(this, MovePath.lateralShiftForTurn(n2, n3));
            this.addStep(moveStep4);
        }
    }

    public static int lateralShiftForTurn(int n, int n2) {
        if (n2 == 1) {
            switch (n) {
                case 3: {
                    return 11;
                }
                case 4: {
                    return 12;
                }
            }
            return n;
        }
        switch (n) {
            case 3: {
                return 13;
            }
            case 4: {
                return 14;
            }
        }
        return n;
    }

    static int turnForLateralShift(int n) {
        switch (n) {
            case 11: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 3;
            }
            case 14: {
                return 4;
            }
        }
        return n;
    }

    public static int getDirection(int n, int n2) {
        int n3 = (n2 + (6 - n)) % 6;
        return n3 >= 3 ? 3 : 4;
    }

    public static int getAdjustedFacing(int n, int n2) {
        if (n2 == 4) {
            return (n + 1) % 6;
        }
        if (n2 == 3) {
            return (n + 5) % 6;
        }
        return n;
    }

    public int getMpUsed() {
        if (this.getLastStep() != null) {
            return this.getLastStep().getMpUsed();
        }
        return 0;
    }

    public int getHexesMoved() {
        if (this.getLastStep() == null) {
            return 0;
        }
        return this.getLastStep().getDistance();
    }

    public boolean isJumping() {
        if (this.steps.size() > 0) {
            return this.getStep(0).getType() == 7;
        }
        return false;
    }

    public void findPathTo(Coords coords, int n) {
        int n2 = PreferenceManager.getClientPreferences().getMaxPathfinderTime();
        if (n2 >= 5000) {
            System.out.print("WARNING!!!  Settings allow up to ");
            System.out.print(n2);
            System.out.println(" milliseconds to find the optimum path!");
        }
        this.notSoLazyPathfinder(coords, n, n2);
    }

    public boolean isMoveLegal() {
        if (!this.game.getBoard().contains(this.getFinalCoords())) {
            return false;
        }
        if (this.getLastStep() == null) {
            return true;
        }
        return this.getLastStep().isLegal();
    }

    private void notSoLazyPathfinder(Coords coords, int n, int n2) {
        long l = System.currentTimeMillis() + (long)n2;
        int n3 = n;
        if (n3 != 2) {
            n3 = 1;
        }
        MovePathComparator movePathComparator = new MovePathComparator(coords, n3 == 2);
        MovePath movePath = (MovePath)this.clone();
        HashMap<Key, MovePath> hashMap = new HashMap<Key, MovePath>();
        hashMap.put(movePath.getKey(), movePath);
        ArrayList<MovePath> arrayList = new ArrayList<MovePath>();
        arrayList.add(movePath);
        boolean bl = this.getFinalCoords().distance(coords) > 1;
        int n4 = 0;
        while (arrayList.size() > 0 && bl) {
            MovePath movePath22;
            MovePath movePath3 = (MovePath)arrayList.remove(0);
            Coords coords2 = movePath3.getFinalCoords();
            if (movePath3.getFinalCoords().distance(coords) == 1) {
                movePath = movePath3;
                bl = false;
                break;
            }
            for (MovePath movePath22 : movePath3.getNextMoves(n3 == 2, n3 == 1)) {
                MovePath movePath4;
                if (!movePath22.getLastStep().isMovementPossible(this.game, coords2) || (movePath4 = (MovePath)hashMap.get(movePath22.getKey())) != null && movePathComparator.compare(movePath4, movePath22) <= 0) continue;
                int n5 = Collections.binarySearch(arrayList, movePath22, movePathComparator);
                if (n5 < 0) {
                    n5 = -n5 - 1;
                }
                arrayList.add(n5, movePath22);
                hashMap.put(movePath22.getKey(), movePath22);
                if (arrayList.size() <= 100) continue;
                arrayList.remove(arrayList.size() - 1);
            }
            if (++n4 % 256 != 0 || !bl || arrayList.size() <= 0) continue;
            movePath22 = (MovePath)arrayList.get(0);
            if (movePath22.getFinalCoords().distance(coords) < movePath.getFinalCoords().distance(coords)) {
                movePath = movePath22;
                bl = System.currentTimeMillis() < l;
                continue;
            }
            bl = false;
        }
        if (this.getFinalCoords().distance(coords) > movePath.getFinalCoords().distance(coords)) {
            this.steps = movePath.steps;
        }
        if (!this.getFinalCoords().equals(coords)) {
            this.lazyPathfinder(coords, n);
        }
    }

    private void lazyPathfinder(Coords coords, int n) {
        int n2 = 1;
        if (n == 2) {
            n2 = 2;
        }
        Coords coords2 = coords;
        if (!coords.equals(this.getFinalCoords())) {
            coords2 = coords.translated(coords.direction(this.getFinalCoords()));
        }
        while (!this.getFinalCoords().equals(coords2)) {
            this.rotatePathfinder((this.getFinalCoords().direction(coords2) + (n2 == 2 ? 3 : 0)) % 6);
            this.addStep(n2);
        }
        this.rotatePathfinder((this.getFinalCoords().direction(coords) + (n2 == 2 ? 3 : 0)) % 6);
        if (!coords.equals(this.getFinalCoords())) {
            this.addStep(n);
        }
    }

    public List getNextMoves(boolean bl, boolean bl2) {
        ArrayList<MovePath> arrayList = new ArrayList<MovePath>();
        MoveStep moveStep = this.getLastStep();
        if (this.isJumping()) {
            MovePath movePath = (MovePath)this.clone();
            MovePath movePath2 = (MovePath)this.clone();
            arrayList.add(((MovePath)this.clone()).addStep(1));
            for (int i = 0; i < 2; ++i) {
                movePath.addStep(3);
                movePath2.addStep(4);
                arrayList.add(((MovePath)movePath.clone()).addStep(1));
                arrayList.add(((MovePath)movePath2.clone()).addStep(1));
            }
            movePath2.addStep(4);
            arrayList.add(movePath2.addStep(1));
            return arrayList;
        }
        if (this.getFinalProne() || this.getFinalHullDown()) {
            if (moveStep != null && moveStep.getType() != 4) {
                arrayList.add(((MovePath)this.clone()).addStep(3));
            }
            if (moveStep != null && moveStep.getType() != 3) {
                arrayList.add(((MovePath)this.clone()).addStep(4));
            }
            arrayList.add(((MovePath)this.clone()).addStep(5));
            return arrayList;
        }
        if (this.canShift()) {
            if (bl2 && (!bl || moveStep == null || moveStep.getType() != 11)) {
                arrayList.add(((MovePath)this.clone()).addStep(12));
            }
            if (bl2 && (!bl || moveStep == null || moveStep.getType() != 12)) {
                arrayList.add(((MovePath)this.clone()).addStep(11));
            }
            if (bl && (!bl2 || moveStep == null || moveStep.getType() != 13)) {
                arrayList.add(((MovePath)this.clone()).addStep(14));
            }
            if (bl && (!bl2 || moveStep == null || moveStep.getType() != 14)) {
                arrayList.add(((MovePath)this.clone()).addStep(13));
            }
        }
        if (bl2 && (!bl || moveStep == null || moveStep.getType() != 2)) {
            arrayList.add(((MovePath)this.clone()).addStep(1));
        }
        if (moveStep == null || moveStep.getType() != 3) {
            arrayList.add(((MovePath)this.clone()).addStep(4));
        }
        if (moveStep == null || moveStep.getType() != 4) {
            arrayList.add(((MovePath)this.clone()).addStep(3));
        }
        if (bl && (!bl2 || moveStep == null || moveStep.getType() != 1)) {
            arrayList.add(((MovePath)this.clone()).addStep(2));
        }
        return arrayList;
    }

    public Object clone() {
        MovePath movePath = new MovePath(this.game, this.entity);
        movePath.steps = (Vector)this.steps.clone();
        return movePath;
    }

    public void rotatePathfinder(int n) {
        while (this.getFinalFacing() != n) {
            int n2 = MovePath.getDirection(this.getFinalFacing(), n);
            this.addStep(n2);
        }
    }

    protected static class MovePathComparator
    implements Comparator {
        private Coords destination;
        boolean backward;

        public MovePathComparator(Coords coords, boolean bl) {
            this.destination = coords;
            this.backward = bl;
        }

        public int compare(Object object, Object object2) {
            MovePath movePath = (MovePath)object;
            MovePath movePath2 = (MovePath)object2;
            int n = movePath.getMpUsed() + movePath.getFinalCoords().distance(this.destination) + this.getFacingDiff(movePath);
            int n2 = movePath2.getMpUsed() + movePath2.getFinalCoords().distance(this.destination) + this.getFacingDiff(movePath2);
            return n - n2;
        }

        private int getFacingDiff(MovePath movePath) {
            if (movePath.isJumping()) {
                return 0;
            }
            int n = Math.abs((movePath.getFinalCoords().direction(this.destination) + (this.backward ? 3 : 0)) % 6 - movePath.getFinalFacing());
            if (n > 3) {
                n = 6 - n;
            }
            if (movePath.canShift()) {
                n = Math.max(0, n - 1);
            }
            return n;
        }
    }

    public static class Key {
        private Coords coords;
        private int facing;
        private int type;

        public Key(Coords coords, int n, int n2) {
            this.coords = coords;
            this.facing = n;
            this.type = n2;
        }

        public boolean equals(Object object) {
            Key key = (Key)object;
            if (key != null) {
                return this.type == this.type && this.facing == key.facing && this.coords.equals(key.coords);
            }
            return false;
        }

        public int hashCode() {
            return this.type + 7 * (this.facing + 31 * this.coords.hashCode());
        }
    }
}

