/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.IGame;
import megamek.common.InitiativeRoll;
import megamek.common.TurnVectors;

public abstract class TurnOrdered
implements Serializable {
    private InitiativeRoll initiative = new InitiativeRoll();
    private transient int turns_other = 0;
    private transient int turns_even = 0;
    private transient int turns_multi = 0;

    public int getNormalTurns(IGame iGame) {
        return this.getMultiTurns(iGame) + this.getOtherTurns();
    }

    public int getOtherTurns() {
        return this.turns_other;
    }

    public int getEvenTurns() {
        return this.turns_even;
    }

    public int getMultiTurns(IGame iGame) {
        return (int)Math.ceil((double)this.turns_multi / (double)iGame.getOptions().intOption("inf_proto_move_multi"));
    }

    public void incrementOtherTurns() {
        ++this.turns_other;
    }

    public void incrementEvenTurns() {
        ++this.turns_even;
    }

    public void incrementMultiTurns() {
        ++this.turns_multi;
    }

    public void resetOtherTurns() {
        this.turns_other = 0;
    }

    public void resetEvenTurns() {
        this.turns_even = 0;
    }

    public void resetMultiTurns() {
        this.turns_multi = 0;
    }

    public InitiativeRoll getInitiative() {
        return this.initiative;
    }

    public void clearInitiative() {
        this.getInitiative().clear();
    }

    public static void rollInitiative(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TurnOrdered turnOrdered = (TurnOrdered)enumeration.nextElement();
            turnOrdered.clearInitiative();
        }
        TurnOrdered.rollInitAndResolveTies(vector, null);
    }

    public static void rollInitAndResolveTies(Vector vector, Vector vector2) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = vector.elements();
        block0: while (object4.hasMoreElements()) {
            object3 = (TurnOrdered)object4.nextElement();
            if (vector2 == null) {
                ((TurnOrdered)object3).getInitiative().addRoll();
                continue;
            }
            object2 = vector2.elements();
            while (object2.hasMoreElements()) {
                object = (TurnOrdered)object2.nextElement();
                if (object3 != object) continue;
                ((TurnOrdered)object3).getInitiative().replaceRoll();
                continue block0;
            }
        }
        object4 = new Vector();
        object3 = vector.elements();
        while (object3.hasMoreElements()) {
            object2 = (TurnOrdered)object3.nextElement();
            ((Vector)object4).removeAllElements();
            ((Vector)object4).addElement(object2);
            object = vector.elements();
            while (object.hasMoreElements()) {
                TurnOrdered turnOrdered = (TurnOrdered)object.nextElement();
                if (object2 == turnOrdered || !((TurnOrdered)object2).getInitiative().equals(turnOrdered.getInitiative())) continue;
                ((Vector)object4).addElement(turnOrdered);
            }
            if (((Vector)object4).size() <= 1) continue;
            TurnOrdered.rollInitAndResolveTies((Vector)object4, null);
        }
    }

    public static TurnVectors generateTurnOrder(Vector vector, IGame iGame) {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[vector.size()];
        int[] nArray2 = new int[vector.size()];
        int n4 = 0;
        int n5 = 0;
        TurnOrdered[] turnOrderedArray = new TurnOrdered[vector.size()];
        int n6 = 0;
        ArrayList arrayList = new ArrayList(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            arrayList.add(object);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((TurnOrdered)object).getInitiative().compareTo(((TurnOrdered)object2).getInitiative());
            }
        });
        for (Object object : arrayList) {
            turnOrderedArray[n6] = object;
            nArray2[n6] = ((TurnOrdered)object).getNormalTurns(iGame);
            nArray[n6] = ((TurnOrdered)object).getEvenTurns();
            n4 += nArray[n6];
            n5 += nArray2[n6];
            ++n6;
        }
        int n7 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n6; ++n3) {
            if (nArray2[n3] == 0 || nArray2[n3] >= n7) continue;
            n7 = nArray2[n3];
        }
        TurnVectors turnVectors = new TurnVectors(n5, n4, n7);
        int n8 = n5;
        while (n8 > 0) {
            for (n3 = 0; n3 < n6; ++n3) {
                if (nArray2[n3] == 0) continue;
                n2 = nArray2[n3] / n7;
                for (n = 0; n < n2; ++n) {
                    turnVectors.addNormal(turnOrderedArray[n3]);
                    int n9 = n3;
                    nArray2[n9] = nArray2[n9] - 1;
                    --n8;
                }
            }
            --n7;
        }
        if (n4 > 0) {
            n7 = Integer.MAX_VALUE;
            for (n3 = 0; n3 < n6; ++n3) {
                if (nArray[n3] == 0 || nArray[n3] >= n7) continue;
                n7 = nArray[n3];
            }
            n8 = n4;
            while (n8 > 0) {
                for (n3 = 0; n3 < n6; ++n3) {
                    if (nArray[n3] == 0) continue;
                    n2 = nArray[n3] / n7;
                    for (n = 0; n < n2; ++n) {
                        turnVectors.addEven(turnOrderedArray[n3]);
                        int n10 = n3;
                        nArray[n10] = nArray[n10] - 1;
                        --n8;
                    }
                }
                --n7;
            }
        }
        return turnVectors;
    }
}

