/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.util.Enumeration;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.AbstractAttackAction;

public class KickAttackAction
extends AbstractAttackAction {
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int LEFTMULE = 3;
    public static final int RIGHTMULE = 4;
    private int leg;

    public KickAttackAction(int n, int n2, int n3) {
        super(n, n2);
        this.leg = n3;
    }

    public KickAttackAction(int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.leg = n4;
    }

    public int getLeg() {
        return this.leg;
    }

    public void setLeg(int n) {
        this.leg = n;
    }

    public static int getDamageFor(Entity entity, int n) {
        int[] nArray = new int[2];
        if (entity.entityIsQuad()) {
            nArray[0] = 4;
            nArray[1] = 5;
        } else {
            nArray[0] = 6;
            nArray[1] = 7;
        }
        int n2 = n == 2 ? nArray[0] : nArray[1];
        int n3 = (int)Math.floor((double)entity.getWeight() / 5.0);
        float f = 1.0f;
        if (!entity.hasWorkingSystem(12, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(13, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(11, n2)) {
            n3 = 0;
        }
        if (entity.heat >= 9 && ((Mech)entity).hasTSM()) {
            f *= 2.0f;
        }
        int n4 = (int)Math.floor((float)n3 * f) + entity.getCrew().modifyPhysicalDamagaForMeleeSpecialist();
        if (entity.getLocationStatus(n2) == 2) {
            n4 = (int)Math.ceil((float)n4 * 0.5f);
        }
        return n4;
    }

    public ToHitData toHit(IGame iGame) {
        return KickAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getLeg());
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2) {
        int n3;
        Entity entity = iGame.getEntity(n);
        int n4 = -1;
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n4 = targetable.getTargetId();
        }
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (entity2 == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target a null entity!");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(entity2.getPosition());
        int n5 = entity.getElevation() + iHex.getElevation();
        int n6 = n5 + entity.height();
        int n7 = targetable.getElevation() + iHex2.getElevation();
        int n8 = n7 + targetable.getHeight();
        boolean bl = Compute.isInBuilding(iGame, entity2);
        Building building = null;
        if (bl) {
            building = iGame.getBoard().getBuildingAt(entity2.getPosition());
        }
        int n9 = 0;
        boolean bl2 = iGame.getOptions().booleanOption("maxtech_mulekicks");
        int[] nArray = new int[2];
        if (entity.entityIsQuad()) {
            if (bl2 && (n2 == 3 || n2 == 4)) {
                nArray[0] = 6;
                nArray[1] = 7;
                n9 = 1;
            } else {
                nArray[0] = 4;
                nArray[1] = 5;
            }
        } else {
            nArray[0] = 6;
            nArray[1] = 7;
        }
        int n10 = n3 = n2 == 4 || n2 == 2 ? nArray[0] : nArray[1];
        if (n2 != 2 && n2 != 1) {
            if (!iGame.getOptions().booleanOption("maxtech_mulekicks")) {
                throw new IllegalArgumentException("Leg must be LEFT or RIGHT");
            }
            if (n2 != 4 && n2 != 3) {
                throw new IllegalArgumentException("Leg must be one of LEFT, RIGHT, LEFTMULE, or RIGHTMULE");
            }
        }
        if (entity == null || targetable == null) {
            throw new IllegalArgumentException("Attacker or target not valid");
        }
        if (entity.equals(entity2)) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target yourself");
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't kick");
        }
        if (entity.isSpotting()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is spotting this turn");
        }
        if (entity2 != null && -1 != entity2.getTransportId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is a passenger.");
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is swarming a Mek.");
        }
        if (entity.isLocationBad(nArray[0]) || entity.isLocationBad(nArray[1])) {
            return new ToHitData(Integer.MAX_VALUE, "Leg missing");
        }
        if (!entity.hasWorkingSystem(11, nArray[0]) || !entity.hasWorkingSystem(11, nArray[1])) {
            return new ToHitData(Integer.MAX_VALUE, "Hip destroyed");
        }
        Enumeration enumeration = entity.getWeapons();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.isUsedThisRound() || mounted.getLocation() != n3) continue;
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from leg this turn");
        }
        int n11 = entity.getPosition().distance(targetable.getPosition());
        if (n11 > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (entity2 instanceof Infantry && 1 == n11) {
            return new ToHitData(Integer.MAX_VALUE, "Can only stomp Infantry in same hex");
        }
        if (n5 < n7 || n5 > n8) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (entity2 != null && entity2.isMakingDfa()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a DFA attack");
        }
        if (0 != n11 && n9 != 1 && !Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 1)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (!(0 == n11 || n9 != 1 || Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 4) || Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 5) || Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 6))) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (0 != n11 && bl) {
            if (!Compute.isInBuilding(iGame, entity)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside building");
            }
            if (!iGame.getBoard().getBuildingAt(entity.getPosition()).equals(building)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside differnt building");
            }
        }
        if (targetable.getTargetType() == 3) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        if (targetable.getTargetType() == 4 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return new ToHitData(Integer.MAX_VALUE, "Invalid attack");
        }
        int n12 = 3;
        if (iGame.getOptions().booleanOption("maxtech_physical_BTH")) {
            n12 = entity.getCrew().getPiloting() - 2;
        }
        ToHitData toHitData = new ToHitData(n12, "base");
        if (entity2 instanceof Infantry) {
            toHitData.addModifier(3, "Stomping Infantry");
        }
        if (entity2 instanceof BattleArmor) {
            toHitData.addModifier(1, "battle armor target");
        }
        toHitData.append(Compute.getAttackerMovementModifier(iGame, n));
        toHitData.append(Compute.getTargetMovementModifier(iGame, n4));
        toHitData.append(Compute.getAttackerTerrainModifier(iGame, n));
        toHitData.append(Compute.getTargetTerrainModifier(iGame, entity2));
        if (bl2 && n9 != 0) {
            toHitData.addModifier(n9, "Quad Mek making a mule kick");
        }
        if (!entity.hasWorkingSystem(12, n3)) {
            toHitData.addModifier(2, "Upper leg actuator destroyed");
        }
        if (!entity.hasWorkingSystem(13, n3)) {
            toHitData.addModifier(2, "Lower leg actuator destroyed");
        }
        if (!entity.hasWorkingSystem(14, n3)) {
            toHitData.addModifier(1, "Foot actuator destroyed");
        }
        if (entity2.isProne()) {
            toHitData.addModifier(-2, "target prone and adjacent");
        }
        if (entity2.height() > 0 && entity2.getElevation() == -1 && iHex2.terrainLevel(4) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        toHitData.append(KickAttackAction.nightModifiers(iGame, targetable, null, entity));
        toHitData.append(Compute.getImmobileMod(entity2));
        Compute.modifyPhysicalBTHForAdvantages(entity, entity2, toHitData, iGame);
        if (n5 < n8) {
            toHitData.setHitTable(2);
        } else if (entity2.height() > 0) {
            toHitData.setHitTable(1);
        } else {
            toHitData.setHitTable(0);
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, entity2));
        if (0 == n11 && entity2 instanceof Tank) {
            toHitData.setSideTable(4);
        }
        return toHitData;
    }
}

