/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Protomech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.AbstractAttackAction;

public class ProtomechPhysicalAttackAction
extends AbstractAttackAction {
    public ProtomechPhysicalAttackAction(int n, int n2) {
        super(n, n2);
    }

    public ProtomechPhysicalAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public static int getDamageFor(Entity entity) {
        int n = entity.getWeight() >= 2.0f && entity.getWeight() < 6.0f ? 1 : 2;
        if (entity.getLocationStatus(1) == 2) {
            n = (int)Math.ceil((float)n * 0.5f);
        }
        return n;
    }

    public ToHitData toHit(IGame iGame) {
        return ProtomechPhysicalAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable) {
        Entity entity = iGame.getEntity(n);
        int n2 = -1;
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n2 = targetable.getTargetId();
        }
        int n3 = entity.getElevation();
        int n4 = targetable.absHeight();
        int n5 = targetable.getElevation();
        boolean bl = Compute.isInBuilding(iGame, entity2);
        Building building = null;
        if (bl) {
            building = iGame.getBoard().getBuildingAt(entity2.getPosition());
        }
        if (entity == null || targetable == null) {
            throw new IllegalArgumentException("Attacker or target not valid");
        }
        if (entity.equals(entity2)) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target yourself");
        }
        if (!(entity instanceof Protomech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-protos can't make proto-physicalattacks");
        }
        if (entity.isSpotting()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is spotting this turn");
        }
        if (entity2 != null && -1 != entity2.getTransportId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is a passenger.");
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is swarming a Mek.");
        }
        int n6 = entity.getPosition().distance(targetable.getPosition());
        if (n6 > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (n3 < n5 || n3 > n4) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (entity2 != null && entity2.isMakingDfa()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a DFA attack");
        }
        if (n6 == 0) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in adjacent hex");
        }
        if (0 != n6 && !Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 1)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (0 != n6 && bl) {
            if (!Compute.isInBuilding(iGame, entity)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside building");
            }
            if (!iGame.getBoard().getBuildingAt(entity.getPosition()).equals(building)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside differnt building");
            }
        }
        if (targetable.getTargetType() == 3) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        if (targetable.getTargetType() == 4 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return new ToHitData(Integer.MAX_VALUE, "Invalid attack");
        }
        int n7 = 4;
        ToHitData toHitData = new ToHitData(n7, "base");
        toHitData.append(Compute.getAttackerMovementModifier(iGame, n));
        toHitData.append(Compute.getTargetMovementModifier(iGame, n2));
        toHitData.append(Compute.getAttackerTerrainModifier(iGame, n));
        toHitData.append(Compute.getTargetTerrainModifier(iGame, entity2));
        if (entity2.isProne()) {
            toHitData.addModifier(-2, "target prone and adjacent");
        }
        IHex iHex = iGame.getBoard().getHex(entity2.getPosition());
        if (entity2.height() > 0 && entity2.getElevation() == -1 && iHex.terrainLevel(4) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        toHitData.append(Compute.getImmobileMod(entity2));
        toHitData.append(ProtomechPhysicalAttackAction.nightModifiers(iGame, targetable, null, entity));
        Compute.modifyPhysicalBTHForAdvantages(entity, entity2, toHitData, iGame);
        if (n3 < n4) {
            toHitData.setHitTable(2);
        } else if (entity2.height() > 0) {
            toHitData.setHitTable(1);
        } else {
            toHitData.setHitTable(0);
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, entity2));
        return toHitData;
    }
}

