/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.LosEffects;
import megamek.common.Report;
import megamek.common.Targetable;
import megamek.common.actions.AbstractAttackAction;

public class SearchlightAttackAction
extends AbstractAttackAction {
    public SearchlightAttackAction(int n, int n2) {
        super(n, n2);
    }

    public SearchlightAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public boolean isPossible(IGame iGame) {
        return SearchlightAttackAction.isPossible(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this);
    }

    public static boolean isPossible(IGame iGame, int n, Targetable targetable, SearchlightAttackAction searchlightAttackAction) {
        Entity entity = iGame.getEntity(n);
        if (entity == null || !entity.isUsingSpotlight()) {
            return false;
        }
        if (!Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), 1)) {
            return false;
        }
        Object object = iGame.getActions();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            if (!(e instanceof SearchlightAttackAction)) continue;
            SearchlightAttackAction searchlightAttackAction2 = (SearchlightAttackAction)e;
            if (searchlightAttackAction2 == searchlightAttackAction) break;
            if (searchlightAttackAction2.getEntityId() != n) continue;
            return false;
        }
        object = LosEffects.calculateLos(iGame, n, targetable);
        return ((LosEffects)object).canSee();
    }

    public Vector resolveAction(IGame iGame) {
        Vector<Report> vector = new Vector<Report>();
        if (!this.isPossible(iGame)) {
            Report report = new Report(3445);
            report.subject = this.getEntityId();
            report.newlines = 1;
            vector.addElement(report);
            return vector;
        }
        Entity entity = this.getEntity(iGame);
        Coords coords = entity.getPosition();
        Targetable targetable = this.getTarget(iGame);
        Coords coords2 = targetable.getPosition();
        if (entity.usedSearchlight()) {
            Report report = new Report(3450);
            report.subject = this.getEntityId();
            report.add(entity.getDisplayName());
            report.newlines = 1;
            vector.addElement(report);
            return vector;
        }
        entity.setUsedSearchlight(true);
        Coords[] coordsArray = Coords.intervening(coords, coords2);
        for (int i = 0; i < coordsArray.length; ++i) {
            Enumeration enumeration = iGame.getEntities(coordsArray[i]);
            while (enumeration.hasMoreElements()) {
                Entity entity2 = (Entity)enumeration.nextElement();
                LosEffects losEffects = LosEffects.calculateLos(iGame, this.getEntityId(), entity2);
                if (!losEffects.canSee()) continue;
                entity2.setIlluminated(true);
                Report report = new Report(3455);
                report.subject = this.getEntityId();
                report.newlines = 1;
                report.add(entity2.getDisplayName());
                report.add(entity.getDisplayName());
                vector.addElement(report);
            }
        }
        return vector;
    }

    public boolean willIlluminate(IGame iGame, Entity entity) {
        if (!this.isPossible(iGame)) {
            return false;
        }
        Entity entity2 = this.getEntity(iGame);
        Coords coords = entity2.getPosition();
        Targetable targetable = this.getTarget(iGame);
        Coords coords2 = targetable.getPosition();
        Coords[] coordsArray = Coords.intervening(coords, coords2);
        for (int i = 0; i < coordsArray.length; ++i) {
            Enumeration enumeration = iGame.getEntities(coordsArray[i]);
            while (enumeration.hasMoreElements()) {
                Entity entity3 = (Entity)enumeration.nextElement();
                LosEffects losEffects = LosEffects.calculateLos(iGame, this.getEntityId(), entity3);
                if (!losEffects.canSee() || !entity3.equals(entity)) continue;
                return true;
            }
        }
        return false;
    }
}

