/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.Entity;
import megamek.common.Tank;
import megamek.common.TroopSpace;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKTankFile
extends BLKFile
implements IMechLoader {
    private static final String[] MOVES = new String[]{"", "", "", "Tracked", "Wheeled", "Hover", "", "Naval", "Hydrofoil", "Submarine"};

    public BLKTankFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        int n;
        Tank tank = new Tank();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        tank.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            tank.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            tank.setModel("");
        }
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        tank.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find type block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (tank.getYear() == 3025) {
                tank.setTechLevel(0);
            } else {
                tank.setTechLevel(1);
            }
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 1")) {
            tank.setTechLevel(0);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 2")) {
            tank.setTechLevel(1);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 3")) {
            tank.setTechLevel(5);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan")) {
            tank.setTechLevel(2);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan Level 3")) {
            tank.setTechLevel(6);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (IS Chassis)")) {
            tank.setTechLevel(5);
            tank.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (Clan Chassis)")) {
            tank.setTechLevel(6);
            tank.setMixedTech(true);
        } else {
            if (this.dataFile.getDataAsString("type")[0].equals("Mixed")) {
                throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
            }
            throw new EntityLoadingException("Unsupported tech level: " + this.dataFile.getDataAsString("type")[0]);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        tank.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n2 = -1;
        for (n = 0; n < MOVES.length; ++n) {
            if (!string.equals(MOVES[n])) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new EntityLoadingException("Invalid movment type: " + string);
        }
        tank.setMovementMode(n2);
        if (this.dataFile.exists("transporters")) {
            String[] stringArray = this.dataFile.getDataAsString("transporters");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("TroopSpace:", 0)) continue;
                Double d = new Double(stringArray[i].substring(11));
                int n3 = d.intValue();
                tank.addTransporter(new TroopSpace(n3));
            }
        }
        if (this.dataFile.exists("engine_type")) {
            n = this.dataFile.getDataAsInt("engine_type")[0];
            if (n == 1) {
                n = 0;
            } else if (n == 0) {
                n = 1;
            }
            tank.setEngineType(n);
        }
        if (this.dataFile.exists("armor_type")) {
            tank.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("armor_tech")) {
            tank.setArmorTechLevel(this.dataFile.getDataAsInt("armor_tech")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            tank.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        tank.setOriginalWalkMP(this.dataFile.getDataAsInt("cruiseMP")[0]);
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length < 4 || nArray.length > 5) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        tank.setHasNoTurret(nArray.length == 4);
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = 0;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        for (int i = 0; i < nArray2.length; ++i) {
            tank.initializeArmor(nArray2[i], i);
        }
        tank.autoSetInternal();
        this.loadEquipment(tank, "Front", 1);
        this.loadEquipment(tank, "Right", 2);
        this.loadEquipment(tank, "Left", 3);
        this.loadEquipment(tank, "Rear", 4);
        if (!tank.hasNoTurret()) {
            this.loadEquipment(tank, "Turret", 5);
        }
        this.loadEquipment(tank, "Body", 0);
        return tank;
    }
}

