/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Tank;
import megamek.common.TroopSpace;
import megamek.common.VTOL;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.HMVArmorType;
import megamek.common.loaders.HMVEngineType;
import megamek.common.loaders.HMVMovementType;
import megamek.common.loaders.HMVTechType;
import megamek.common.loaders.HMVWeaponLocation;
import megamek.common.loaders.IMechLoader;

public class HmvFile
implements IMechLoader {
    private String name;
    private String model;
    private HMVMovementType movementType;
    private int rulesLevel;
    private int year;
    private boolean isOmni = false;
    private HMVTechType techType;
    private int engineRating;
    private HMVEngineType engineType;
    private int cruiseMP;
    private int jumpMP;
    private int heatSinks;
    private HMVArmorType armorType;
    private int roundedInternalStructure;
    private int turretArmor;
    private int frontArmor;
    private int leftArmor;
    private int rightArmor;
    private int rearArmor;
    private Hashtable equipment = new Hashtable();
    private int troopSpace = 0;
    private static final Hashtable EQUIPMENT = new Hashtable();
    private static final Hashtable AMMO = new Hashtable();

    public HmvFile(InputStream inputStream) throws EntityLoadingException {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[5];
            dataInputStream.read(byArray);
            String string = new String(byArray);
            dataInputStream.skipBytes(2);
            int n5 = this.readUnsignedShort(dataInputStream);
            this.movementType = HMVMovementType.getType(n5);
            if (null == this.movementType) {
                throw new EntityLoadingException("Could not locate movement type for " + n5 + ".");
            }
            dataInputStream.skipBytes(12);
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.name = new String(byArray);
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.model = new String(byArray);
            this.rulesLevel = this.readUnsignedShort(dataInputStream);
            this.year = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(32);
            int n6 = this.readUnsignedShort(dataInputStream);
            byte[] byArray2 = new byte[n6];
            dataInputStream.read(byArray2);
            this.isOmni = this.containsOmni(byArray2);
            this.techType = HMVTechType.getType(this.readUnsignedShort(dataInputStream));
            dataInputStream.skipBytes(4);
            this.engineRating = this.readUnsignedShort(dataInputStream);
            this.engineType = HMVEngineType.getType(this.readUnsignedShort(dataInputStream));
            this.cruiseMP = this.readUnsignedShort(dataInputStream);
            this.jumpMP = this.readUnsignedShort(dataInputStream);
            this.heatSinks = this.readUnsignedShort(dataInputStream);
            this.armorType = HMVArmorType.getType(this.readUnsignedShort(dataInputStream));
            this.roundedInternalStructure = this.readUnsignedShort(dataInputStream);
            this.turretArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(2);
            this.frontArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(2);
            this.leftArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(2);
            this.rightArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(2);
            this.rearArmor = this.readUnsignedShort(dataInputStream);
            if (this.isOmni) {
                dataInputStream.skipBytes(12);
                n4 = this.readUnsignedShort(dataInputStream);
                if (n4 == 2) {
                    dataInputStream.skipBytes(12);
                }
            } else {
                dataInputStream.skipBytes(14);
            }
            n4 = this.readUnsignedShort(dataInputStream);
            for (n3 = 1; n3 <= n4; ++n3) {
                n2 = this.readUnsignedShort(dataInputStream);
                n = this.readUnsignedShort(dataInputStream);
                dataInputStream.skipBytes(this.readUnsignedShort(dataInputStream));
                HMVWeaponLocation hMVWeaponLocation = HMVWeaponLocation.getType(this.readUnsignedShort(dataInputStream));
                int n7 = this.readUnsignedShort(dataInputStream);
                EquipmentType equipmentType = this.getEquipmentType(n, this.techType);
                if (equipmentType != null) {
                    AmmoType ammoType;
                    this.addEquipmentType(equipmentType, n2, hMVWeaponLocation);
                    if (n7 > 0 && (ammoType = this.getAmmoType(n, this.techType)) != null) {
                        if (n7 < ammoType.getShots() || n7 % ammoType.getShots() > 0) {
                            switch (ammoType.getAmmoType()) {
                                case 3: {
                                    if (ammoType.getTechLevel() == 0) {
                                        ammoType = (AmmoType)EquipmentType.get("ISMG Ammo (100)");
                                        break;
                                    }
                                    ammoType = (AmmoType)EquipmentType.get("CLMG Ammo (100)");
                                    break;
                                }
                                case 5: {
                                    ammoType = (AmmoType)EquipmentType.get("CLLightMG Ammo (100)");
                                    break;
                                }
                                case 4: {
                                    ammoType = (AmmoType)EquipmentType.get("CLHeavyMG Ammo (50)");
                                    break;
                                }
                                default: {
                                    throw new EntityLoadingException(ammoType.getName() + " has " + ammoType.getShots() + " shots per ton, but " + this.name + " " + this.model + " wants " + n7 + " shots.");
                                }
                            }
                        }
                        this.addEquipmentType(ammoType, n7 / ammoType.getShots(), HMVWeaponLocation.BODY);
                    }
                }
                dataInputStream.skipBytes(4);
            }
            n3 = this.readUnsignedShort(dataInputStream);
            block17: for (n2 = 0; n2 < n3; ++n2) {
                dataInputStream.skipBytes(2);
                n = this.readUnsignedShort(dataInputStream);
                dataInputStream.skipBytes(this.readUnsignedShort(dataInputStream));
                switch (n) {
                    case 16256: 
                    case 16416: {
                        ++this.troopSpace;
                        continue block17;
                    }
                    case 16448: 
                    case 16480: {
                        this.troopSpace += 3;
                        continue block17;
                    }
                    case 16512: {
                        this.troopSpace += 4;
                        continue block17;
                    }
                    case 16544: {
                        this.troopSpace += 5;
                        continue block17;
                    }
                    case 16576: {
                        this.troopSpace += 6;
                        continue block17;
                    }
                    case 16624: {
                        this.troopSpace += 7;
                        continue block17;
                    }
                    case 16640: {
                        this.troopSpace += 8;
                    }
                }
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new EntityLoadingException("I/O Error reading file");
        }
    }

    private short readUnsignedByte(DataInputStream dataInputStream) throws IOException {
        short s;
        s = (short)(s + ((s = (short)dataInputStream.readByte()) < 0 ? 256 : 0));
        return s;
    }

    private int readUnsignedShort(DataInputStream dataInputStream) throws IOException {
        short s = this.readUnsignedByte(dataInputStream);
        int n = this.readUnsignedByte(dataInputStream);
        return (n <<= 8) + s;
    }

    private boolean containsOmni(byte[] byArray) {
        for (int i = byArray.length - 4; i >= 0; --i) {
            if (111 != byArray[i] || 109 != byArray[i + 1] || 110 != byArray[i + 2] || 105 != byArray[i + 3]) continue;
            return true;
        }
        return false;
    }

    public Entity getEntity() throws EntityLoadingException {
        try {
            Tank tank = null;
            if (this.movementType == HMVMovementType.TRACKED || this.movementType == HMVMovementType.WHEELED || this.movementType == HMVMovementType.HOVER || this.movementType == HMVMovementType.DISPLACEMENT_HULL || this.movementType == HMVMovementType.HYDROFOIL) {
                Tank tank2;
                tank = tank2 = new Tank();
                tank2.setChassis(this.name);
                tank2.setModel(this.model);
                tank2.setYear(this.year);
                tank2.setOmni(this.isOmni);
                tank2.setEngineType(this.engineType.getId());
                int n = 5;
                if (this.rulesLevel == 1) {
                    n = 0;
                } else if (this.rulesLevel == 2) {
                    n = this.techType == HMVTechType.CLAN ? 2 : 1;
                } else if (this.techType == HMVTechType.CLAN) {
                    n = 6;
                }
                tank2.setTechLevel(n);
                int n2 = HmvFile.getSuspensionFactor(this.roundedInternalStructure, this.movementType);
                tank2.setWeight((this.engineRating + n2) / this.cruiseMP);
                tank2.setMovementMode(this.movementType == HMVMovementType.DISPLACEMENT_HULL ? 7 : (this.movementType == HMVMovementType.HYDROFOIL ? 8 : (this.movementType == HMVMovementType.HOVER ? 5 : (this.movementType == HMVMovementType.WHEELED ? 4 : 3))));
                tank2.setOriginalWalkMP(this.cruiseMP);
                tank2.setOriginalJumpMP(this.jumpMP);
                tank2.setHasNoTurret(this.turretArmor == 0);
                tank2.autoSetInternal();
                tank2.setArmorType(this.armorType.getId());
                tank2.initializeArmor(this.frontArmor, 1);
                tank2.initializeArmor(this.leftArmor, 3);
                tank2.initializeArmor(this.rightArmor, 2);
                tank2.initializeArmor(this.rearArmor, 4);
                if (!tank2.hasNoTurret()) {
                    tank2.initializeArmor(this.turretArmor, 5);
                }
                this.addEquipment(tank2, HMVWeaponLocation.FRONT, 1);
                this.addEquipment(tank2, HMVWeaponLocation.LEFT, 3);
                this.addEquipment(tank2, HMVWeaponLocation.RIGHT, 2);
                this.addEquipment(tank2, HMVWeaponLocation.REAR, 4);
                if (!tank2.hasNoTurret()) {
                    this.addEquipment(tank2, HMVWeaponLocation.TURRET, 5);
                }
                this.addEquipment(tank2, HMVWeaponLocation.BODY, 0);
                if (this.troopSpace > 0) {
                    tank.addTransporter(new TroopSpace(this.troopSpace));
                }
            } else if (this.movementType == HMVMovementType.VTOL) {
                VTOL vTOL = new VTOL();
                tank = vTOL;
                tank.setChassis(this.name);
                tank.setModel(this.model);
                tank.setYear(this.year);
                tank.setOmni(this.isOmni);
                int n = this.rulesLevel == 1 ? 0 : (this.techType == HMVTechType.CLAN ? 2 : 1);
                tank.setTechLevel(n);
                int n3 = HmvFile.getSuspensionFactor(this.roundedInternalStructure, this.movementType);
                tank.setWeight((this.engineRating + n3) / this.cruiseMP);
                tank.setMovementMode(6);
                tank.setOriginalWalkMP(this.cruiseMP);
                tank.setOriginalJumpMP(this.jumpMP);
                vTOL.setHasNoTurret(this.turretArmor == 0);
                ((Entity)tank).autoSetInternal();
                tank.initializeArmor(this.frontArmor, 1);
                tank.initializeArmor(this.leftArmor, 3);
                tank.initializeArmor(this.rightArmor, 2);
                tank.initializeArmor(this.rearArmor, 4);
                tank.initializeArmor(this.turretArmor, 5);
                this.addEquipment(vTOL, HMVWeaponLocation.FRONT, 1);
                this.addEquipment(vTOL, HMVWeaponLocation.LEFT, 3);
                this.addEquipment(vTOL, HMVWeaponLocation.RIGHT, 2);
                this.addEquipment(vTOL, HMVWeaponLocation.REAR, 4);
                if (!vTOL.hasNoTurret()) {
                    this.addEquipment(vTOL, HMVWeaponLocation.TURRET, 5);
                }
                this.addEquipment(vTOL, HMVWeaponLocation.BODY, 0);
                if (this.troopSpace > 0) {
                    tank.addTransporter(new TroopSpace(this.troopSpace));
                }
            } else {
                throw new EntityLoadingException("Unsupported vehicle movement type:" + this.movementType);
            }
            return tank;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EntityLoadingException(exception.getMessage());
        }
    }

    private void addEquipmentType(EquipmentType equipmentType, int n, HMVWeaponLocation hMVWeaponLocation) {
        Integer n2;
        Hashtable<EquipmentType, Integer> hashtable = (Hashtable<EquipmentType, Integer>)this.equipment.get(hMVWeaponLocation);
        if (hashtable == null) {
            hashtable = new Hashtable<EquipmentType, Integer>();
            this.equipment.put(hMVWeaponLocation, hashtable);
        }
        if (null != (n2 = (Integer)hashtable.get(equipmentType))) {
            n += n2.intValue();
        }
        hashtable.put(equipmentType, new Integer(n));
    }

    private void addEquipment(Tank tank, HMVWeaponLocation hMVWeaponLocation, int n) throws Exception {
        Hashtable hashtable = (Hashtable)this.equipment.get(hMVWeaponLocation);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                EquipmentType equipmentType = (EquipmentType)enumeration.nextElement();
                Integer n2 = (Integer)hashtable.get(equipmentType);
                for (int i = 0; i < n2; ++i) {
                    tank.addEquipment(equipmentType, n);
                }
            }
        }
    }

    private static int getSuspensionFactor(int n, HMVMovementType hMVMovementType) {
        int n2 = 0;
        if (hMVMovementType == HMVMovementType.WHEELED) {
            n2 = 20;
        } else if (hMVMovementType == HMVMovementType.DISPLACEMENT_HULL || hMVMovementType == HMVMovementType.SUBMARINE) {
            n2 = 30;
        } else if (hMVMovementType == HMVMovementType.VTOL) {
            switch (n) {
                case 1: {
                    n2 = 50;
                    break;
                }
                case 2: {
                    n2 = 95;
                    break;
                }
                case 3: {
                    n2 = 140;
                }
            }
        } else if (hMVMovementType == HMVMovementType.HOVER) {
            switch (n) {
                case 1: {
                    n2 = 40;
                    break;
                }
                case 2: {
                    n2 = 85;
                    break;
                }
                case 3: {
                    n2 = 130;
                    break;
                }
                case 4: {
                    n2 = 175;
                    break;
                }
                case 5: {
                    n2 = 235;
                }
            }
        } else if (hMVMovementType == HMVMovementType.HYDROFOIL) {
            switch (n) {
                case 1: {
                    n2 = 60;
                    break;
                }
                case 2: {
                    n2 = 105;
                    break;
                }
                case 3: {
                    n2 = 150;
                    break;
                }
                case 4: {
                    n2 = 195;
                    break;
                }
                case 5: {
                    n2 = 255;
                    break;
                }
                case 6: {
                    n2 = 300;
                    break;
                }
                case 7: {
                    n2 = 345;
                    break;
                }
                case 8: {
                    n2 = 390;
                    break;
                }
                case 9: {
                    n2 = 435;
                    break;
                }
                case 10: {
                    n2 = 480;
                }
            }
        }
        return n2;
    }

    private String getEquipmentName(long l, HMVTechType hMVTechType) {
        return this.getEquipmentName(new Long(l), hMVTechType);
    }

    private String getEquipmentName(Long l, HMVTechType hMVTechType) {
        Hashtable hashtable;
        if (l > 32767L) {
            l = new Long((long)(l & 0xFFFFL));
        }
        long l2 = l;
        String string = (String)EQUIPMENT.get(l);
        if (string == null && (hashtable = (Hashtable)EQUIPMENT.get(hMVTechType)) != null) {
            string = (String)hashtable.get(l);
        }
        if (string == null && l2 != 0L && l2 != 7L && l2 != 8L && l2 != 15L) {
            System.out.print("unknown critical: 0x");
            System.out.print(Integer.toHexString(l.intValue()).toUpperCase());
            System.out.print(" (");
            System.out.print(hMVTechType);
            System.out.println(")");
        }
        return string;
    }

    private EquipmentType getEquipmentType(long l, HMVTechType hMVTechType) {
        EquipmentType equipmentType = null;
        String string = this.getEquipmentName(l, hMVTechType);
        if (string != null) {
            equipmentType = EquipmentType.get(string);
        }
        return equipmentType;
    }

    private String getAmmoName(long l, HMVTechType hMVTechType) {
        return this.getAmmoName(new Long(l), hMVTechType);
    }

    private String getAmmoName(Long l, HMVTechType hMVTechType) {
        Hashtable hashtable;
        if (l > 32767L) {
            l = new Long((long)(l & 0xFFFFL));
        }
        long l2 = l;
        String string = (String)AMMO.get(this.equipment);
        if (string == null && (hashtable = (Hashtable)AMMO.get(hMVTechType)) != null) {
            string = (String)hashtable.get(l);
        }
        if (string == null && l2 != 0L) {
            System.out.print("unknown critical: 0x");
            System.out.print(Integer.toHexString(l.intValue()).toUpperCase());
            System.out.print(" (");
            System.out.print(hMVTechType);
            System.out.println(")");
        }
        return string;
    }

    private AmmoType getAmmoType(long l, HMVTechType hMVTechType) {
        AmmoType ammoType = null;
        String string = this.getAmmoName(l, hMVTechType);
        if (string != null) {
            ammoType = (AmmoType)EquipmentType.get(string);
        }
        return ammoType;
    }

    static {
        Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
        EQUIPMENT.put(HMVTechType.INNER_SPHERE, hashtable);
        hashtable.put(new Long(10L), "ISDouble Heat Sink");
        hashtable.put(new Long(18L), "ISTargeting Computer");
        hashtable.put(new Long(20L), "Endo Steel");
        hashtable.put(new Long(21L), "Ferro-Fibrous");
        hashtable.put(new Long(23L), "ISMASC");
        hashtable.put(new Long(24L), "ISArtemisIV");
        hashtable.put(new Long(25L), "ISCASE");
        hashtable.put(new Long(51L), "ISERLargeLaser");
        hashtable.put(new Long(52L), "ISERPPC");
        hashtable.put(new Long(53L), "ISFlamer");
        hashtable.put(new Long(57L), "ISSmallLaser");
        hashtable.put(new Long(55L), "ISLargeLaser");
        hashtable.put(new Long(56L), "ISMediumLaser");
        hashtable.put(new Long(58L), "ISPPC");
        hashtable.put(new Long(59L), "ISLargePulseLaser");
        hashtable.put(new Long(60L), "ISMediumPulseLaser");
        hashtable.put(new Long(61L), "ISSmallPulseLaser");
        hashtable.put(new Long(62L), "ISAC2");
        hashtable.put(new Long(63L), "ISAC5");
        hashtable.put(new Long(64L), "ISAC10");
        hashtable.put(new Long(65L), "ISAC20");
        hashtable.put(new Long(66L), "ISAntiMissileSystem");
        hashtable.put(new Long(70L), "ISLightGaussRifle");
        hashtable.put(new Long(71L), "ISGaussRifle");
        hashtable.put(new Long(75L), "ISLBXAC2");
        hashtable.put(new Long(76L), "ISLBXAC5");
        hashtable.put(new Long(77L), "ISLBXAC10");
        hashtable.put(new Long(78L), "ISLBXAC20");
        hashtable.put(new Long(79L), "ISMachine Gun");
        hashtable.put(new Long(80L), "ISLAC2");
        hashtable.put(new Long(81L), "ISLAC5");
        hashtable.put(new Long(82L), "ISHeavyFlamer");
        hashtable.put(new Long(84L), "ISUltraAC2");
        hashtable.put(new Long(85L), "ISUltraAC5");
        hashtable.put(new Long(86L), "ISUltraAC10");
        hashtable.put(new Long(87L), "ISUltraAC20");
        hashtable.put(new Long(90L), "ISERMediumLaser");
        hashtable.put(new Long(91L), "ISERSmallLaser");
        hashtable.put(new Long(92L), "ISAntiPersonnelPod");
        hashtable.put(new Long(96L), "ISLRM5");
        hashtable.put(new Long(97L), "ISLRM10");
        hashtable.put(new Long(98L), "ISLRM15");
        hashtable.put(new Long(99L), "ISLRM20");
        hashtable.put(new Long(102L), "ISImprovedNarc");
        hashtable.put(new Long(103L), "ISSRM2");
        hashtable.put(new Long(104L), "ISSRM4");
        hashtable.put(new Long(105L), "ISSRM6");
        hashtable.put(new Long(106L), "ISStreakSRM2");
        hashtable.put(new Long(107L), "ISStreakSRM4");
        hashtable.put(new Long(108L), "ISStreakSRM6");
        hashtable.put(new Long(113L), "ISArrowIVSystem");
        hashtable.put(new Long(114L), "ISAngelECMSuite");
        hashtable.put(new Long(115L), "ISBeagleActiveProbe");
        hashtable.put(new Long(116L), "ISBloodhoundActiveProbe");
        hashtable.put(new Long(117L), "ISC3MasterComputer");
        hashtable.put(new Long(118L), "ISC3SlaveUnit");
        hashtable.put(new Long(119L), "ISImprovedC3CPU");
        hashtable.put(new Long(120L), "ISGuardianECM");
        hashtable.put(new Long(121L), "ISNarcBeacon");
        hashtable.put(new Long(122L), "ISTAG");
        hashtable.put(new Long(123L), "ISLRM5 (OS)");
        hashtable.put(new Long(124L), "ISLRM10 (OS)");
        hashtable.put(new Long(125L), "ISLRM15 (OS)");
        hashtable.put(new Long(126L), "ISLRM20 (OS)");
        hashtable.put(new Long(127L), "ISSRM2 (OS)");
        hashtable.put(new Long(128L), "ISSRM4 (OS)");
        hashtable.put(new Long(129L), "ISSRM6 (OS)");
        hashtable.put(new Long(130L), "ISStreakSRM2 (OS)");
        hashtable.put(new Long(131L), "ISStreakSRM4 (OS)");
        hashtable.put(new Long(132L), "ISStreakSRM6 (OS)");
        hashtable.put(new Long(133L), "ISFlamer (Vehicle)");
        hashtable.put(new Long(135L), "ISSniperArtillery");
        hashtable.put(new Long(136L), "ISThumperArtillery");
        hashtable.put(new Long(137L), "ISMRM10");
        hashtable.put(new Long(138L), "ISMRM20");
        hashtable.put(new Long(139L), "ISMRM30");
        hashtable.put(new Long(140L), "ISMRM40");
        hashtable.put(new Long(142L), "ISMRM10 (OS)");
        hashtable.put(new Long(143L), "ISMRM20 (OS)");
        hashtable.put(new Long(144L), "ISMRM30 (OS)");
        hashtable.put(new Long(145L), "ISMRM40 (OS)");
        hashtable.put(new Long(146L), "ISLRTorpedo5");
        hashtable.put(new Long(147L), "ISLRTorpedo10");
        hashtable.put(new Long(148L), "ISLRTorpedo15");
        hashtable.put(new Long(149L), "ISLRTorpedo20");
        hashtable.put(new Long(150L), "ISSRTorpedo2");
        hashtable.put(new Long(151L), "ISSRTorpedo4");
        hashtable.put(new Long(152L), "ISSRTorpedo6");
        hashtable.put(new Long(264L), "ISTHBLBXAC2");
        hashtable.put(new Long(265L), "ISTHBLBXAC5");
        hashtable.put(new Long(266L), "ISTHBLBXAC20");
        hashtable.put(new Long(267L), "ISUltraAC2 (THB)");
        hashtable.put(new Long(268L), "ISUltraAC10 (THB)");
        hashtable.put(new Long(269L), "ISUltraAC20 (THB)");
        hashtable.put(new Long(286L), "ISTHBBloodhoundActiveProbe");
        hashtable.put(new Long(289L), "ISRotaryAC2");
        hashtable.put(new Long(290L), "ISRotaryAC5");
        hashtable.put(new Long(291L), "ISHeavyGaussRifle");
        hashtable.put(new Long(299L), "ISRocketLauncher10");
        hashtable.put(new Long(300L), "ISRocketLauncher15");
        hashtable.put(new Long(301L), "ISRocketLauncher20");
        hashtable.put(new Long(462L), "ISAC2 Ammo");
        hashtable.put(new Long(463L), "ISAC5 Ammo");
        hashtable.put(new Long(464L), "ISAC10 Ammo");
        hashtable.put(new Long(465L), "ISAC20 Ammo");
        hashtable.put(new Long(466L), "ISAMS Ammo");
        hashtable.put(new Long(470L), "ISLightGauss Ammo");
        hashtable.put(new Long(471L), "ISGauss Ammo");
        hashtable.put(new Long(475L), "ISLBXAC2 Ammo");
        hashtable.put(new Long(476L), "ISLBXAC5 Ammo");
        hashtable.put(new Long(477L), "ISLBXAC10 Ammo");
        hashtable.put(new Long(478L), "ISLBXAC20 Ammo");
        hashtable.put(new Long(479L), "ISMG Ammo (200)");
        hashtable.put(new Long(480L), "ISLAC2 Ammo");
        hashtable.put(new Long(481L), "ISLAC5 Ammo");
        hashtable.put(new Long(482L), "ISHeavyFlamer Ammo");
        hashtable.put(new Long(484L), "ISUltraAC2 Ammo");
        hashtable.put(new Long(485L), "ISUltraAC5 Ammo");
        hashtable.put(new Long(486L), "ISUltraAC10 Ammo");
        hashtable.put(new Long(487L), "ISUltraAC20 Ammo");
        hashtable.put(new Long(496L), "ISLRM5 Ammo");
        hashtable.put(new Long(497L), "ISLRM10 Ammo");
        hashtable.put(new Long(498L), "ISLRM15 Ammo");
        hashtable.put(new Long(499L), "ISLRM20 Ammo");
        hashtable.put(new Long(502L), "ISiNarc Pods");
        hashtable.put(new Long(506L), "ISStreakSRM2 Ammo");
        hashtable.put(new Long(507L), "ISStreakSRM4 Ammo");
        hashtable.put(new Long(508L), "ISStreakSRM6 Ammo");
        hashtable.put(new Long(513L), "ISArrowIV Ammo");
        hashtable.put(new Long(521L), "ISNarc Pods");
        hashtable.put(new Long(533L), "ISVehicleFlamer Ammo");
        hashtable.put(new Long(535L), "ISSniper Ammo");
        hashtable.put(new Long(536L), "ISThumper Ammo");
        hashtable.put(new Long(537L), "ISMRM10 Ammo");
        hashtable.put(new Long(538L), "ISMRM20 Ammo");
        hashtable.put(new Long(539L), "ISMRM30 Ammo");
        hashtable.put(new Long(540L), "ISMRM40 Ammo");
        hashtable.put(new Long(689L), "ISRotaryAC2 Ammo");
        hashtable.put(new Long(690L), "ISRotaryAC5 Ammo");
        hashtable.put(new Long(691L), "ISHeavyGauss Ammo");
        hashtable.put(new Long(503L), "ISSRM2 Ammo");
        hashtable.put(new Long(504L), "ISSRM4 Ammo");
        hashtable.put(new Long(505L), "ISSRM6 Ammo");
        hashtable.put(new Long(548L), "ISLRTorpedo15 Ammo");
        hashtable.put(new Long(549L), "ISLRTorpedo20 Ammo");
        hashtable.put(new Long(546L), "ISLRTorpedo5 Ammo");
        hashtable.put(new Long(547L), "ISLRTorpedo10 Ammo");
        hashtable.put(new Long(551L), "ISSRTorpedo4 Ammo");
        hashtable.put(new Long(550L), "ISSRTorpedo2 Ammo");
        hashtable.put(new Long(552L), "ISSRTorpedo6 Ammo");
        hashtable.put(new Long(664L), "ISLBXAC2 Ammo (THB)");
        hashtable.put(new Long(665L), "ISLBXAC5 Ammo (THB)");
        hashtable.put(new Long(666L), "ISLBXAC20 Ammo (THB)");
        hashtable.put(new Long(667L), "IS Ultra AC/2 Ammo (THB)");
        hashtable.put(new Long(668L), "IS Ultra AC/10 Ammo (THB)");
        hashtable.put(new Long(669L), "IS Ultra AC/20 Ammo (THB)");
        Hashtable<Long, String> hashtable2 = new Hashtable<Long, String>();
        AMMO.put(HMVTechType.INNER_SPHERE, hashtable2);
        hashtable2.put(new Long(96L), "ISLRM5 Ammo");
        hashtable2.put(new Long(97L), "ISLRM10 Ammo");
        hashtable2.put(new Long(98L), "ISLRM15 Ammo");
        hashtable2.put(new Long(99L), "ISLRM20 Ammo");
        hashtable2.put(new Long(62L), "ISAC2 Ammo");
        hashtable2.put(new Long(63L), "ISAC5 Ammo");
        hashtable2.put(new Long(64L), "ISAC10 Ammo");
        hashtable2.put(new Long(65L), "ISAC20 Ammo");
        hashtable2.put(new Long(66L), "ISAMS Ammo");
        hashtable2.put(new Long(70L), "ISLightGauss Ammo");
        hashtable2.put(new Long(71L), "ISGauss Ammo");
        hashtable2.put(new Long(291L), "ISHeavyGauss Ammo");
        hashtable2.put(new Long(75L), "ISLBXAC2 Ammo");
        hashtable2.put(new Long(76L), "ISLBXAC5 Ammo");
        hashtable2.put(new Long(77L), "ISLBXAC10 Ammo");
        hashtable2.put(new Long(78L), "ISLBXAC20 Ammo");
        hashtable2.put(new Long(79L), "ISMG Ammo (200)");
        hashtable2.put(new Long(84L), "ISUltraAC2 Ammo");
        hashtable2.put(new Long(85L), "ISUltraAC5 Ammo");
        hashtable2.put(new Long(86L), "ISUltraAC10 Ammo");
        hashtable2.put(new Long(87L), "ISUltraAC20 Ammo");
        hashtable2.put(new Long(102L), "ISiNarc Pods");
        hashtable2.put(new Long(106L), "ISStreakSRM2 Ammo");
        hashtable2.put(new Long(107L), "ISStreakSRM4 Ammo");
        hashtable2.put(new Long(108L), "ISStreakSRM6 Ammo");
        hashtable2.put(new Long(113L), "ISArrowIV Ammo");
        hashtable2.put(new Long(121L), "ISNarc Pods");
        hashtable2.put(new Long(53L), "ISVehicleFlamer Ammo");
        hashtable2.put(new Long(135L), "ISSniper Ammo");
        hashtable2.put(new Long(136L), "ISThumper Ammo");
        hashtable2.put(new Long(137L), "ISMRM10 Ammo");
        hashtable2.put(new Long(138L), "ISMRM20 Ammo");
        hashtable2.put(new Long(139L), "ISMRM30 Ammo");
        hashtable2.put(new Long(140L), "ISMRM40 Ammo");
        hashtable2.put(new Long(289L), "ISRotaryAC2 Ammo");
        hashtable2.put(new Long(290L), "ISRotaryAC5 Ammo");
        hashtable2.put(new Long(103L), "ISSRM2 Ammo");
        hashtable2.put(new Long(104L), "ISSRM4 Ammo");
        hashtable2.put(new Long(105L), "ISSRM6 Ammo");
        hashtable2.put(new Long(146L), "ISLRTorpedo5 Ammo");
        hashtable2.put(new Long(147L), "ISLRTorpedo10 Ammo");
        hashtable2.put(new Long(148L), "ISLRTorpedo15 Ammo");
        hashtable2.put(new Long(149L), "ISLRTorpedo20 Ammo");
        hashtable2.put(new Long(150L), "ISSRTorpedo4 Ammo");
        hashtable2.put(new Long(151L), "ISSRTorpedo2 Ammo");
        hashtable2.put(new Long(152L), "ISSRTorpedo6 Ammo");
        Hashtable<Long, String> hashtable3 = new Hashtable<Long, String>();
        EQUIPMENT.put(HMVTechType.CLAN, hashtable3);
        hashtable3.put(new Long(10L), "CLDouble Heat Sink");
        hashtable3.put(new Long(18L), "CLTargeting Computer");
        hashtable3.put(new Long(20L), "Endo Steel");
        hashtable3.put(new Long(21L), "Ferro-Fibrous");
        hashtable3.put(new Long(23L), "CLMASC");
        hashtable3.put(new Long(24L), "CLArtemisIV");
        hashtable3.put(new Long(51L), "CLERLargeLaser");
        hashtable3.put(new Long(52L), "CLERMediumLaser");
        hashtable3.put(new Long(53L), "CLERSmallLaser");
        hashtable3.put(new Long(54L), "CLERPPC");
        hashtable3.put(new Long(57L), "CLSmallLaser");
        hashtable3.put(new Long(55L), "CLFlamer");
        hashtable3.put(new Long(56L), "CLMediumLaser");
        hashtable3.put(new Long(58L), "CLPPC");
        hashtable3.put(new Long(60L), "CLLargePulseLaser");
        hashtable3.put(new Long(61L), "CLMediumPulseLaser");
        hashtable3.put(new Long(62L), "CLSmallPulseLaser");
        hashtable3.put(new Long(63L), "CLAngelECMSuite");
        hashtable3.put(new Long(64L), "CLAntiMissileSystem");
        hashtable3.put(new Long(65L), "CLGaussRifle");
        hashtable3.put(new Long(66L), "CLLBXAC2");
        hashtable3.put(new Long(67L), "CLLBXAC5");
        hashtable3.put(new Long(68L), "CLLBXAC10");
        hashtable3.put(new Long(69L), "CLLBXAC20");
        hashtable3.put(new Long(70L), "CLMG");
        hashtable3.put(new Long(71L), "CLUltraAC2");
        hashtable3.put(new Long(72L), "CLUltraAC5");
        hashtable3.put(new Long(73L), "CLUltraAC10");
        hashtable3.put(new Long(74L), "CLUltraAC20");
        hashtable3.put(new Long(75L), "CLLRM5");
        hashtable3.put(new Long(76L), "CLLRM10");
        hashtable3.put(new Long(77L), "CLLRM15");
        hashtable3.put(new Long(78L), "CLLRM20");
        hashtable3.put(new Long(79L), "CLSRM2");
        hashtable3.put(new Long(80L), "CLSRM4");
        hashtable3.put(new Long(81L), "CLSRM6");
        hashtable3.put(new Long(82L), "CLStreakSRM2");
        hashtable3.put(new Long(83L), "CLStreakSRM4");
        hashtable3.put(new Long(84L), "CLStreakSRM6");
        hashtable3.put(new Long(85L), "CLArrowIVSystem");
        hashtable3.put(new Long(86L), "CLAntiPersonnelPod");
        hashtable3.put(new Long(87L), "CLActiveProbe");
        hashtable3.put(new Long(88L), "CLECMSuite");
        hashtable3.put(new Long(89L), "CLNarcBeacon");
        hashtable3.put(new Long(90L), "CLTAG");
        hashtable3.put(new Long(91L), "CLERMicroLaser");
        hashtable3.put(new Long(92L), "CLLRM5 (OS)");
        hashtable3.put(new Long(93L), "CLLRM10 (OS)");
        hashtable3.put(new Long(94L), "CLLRM15 (OS)");
        hashtable3.put(new Long(95L), "CLLRM20 (OS)");
        hashtable3.put(new Long(96L), "CLSRM2 (OS)");
        hashtable3.put(new Long(97L), "CLSRM4 (OS)");
        hashtable3.put(new Long(98L), "CLSRM6 (OS)");
        hashtable3.put(new Long(99L), "CLStreakSRM2 (OS)");
        hashtable3.put(new Long(100L), "CLStreakSRM4 (OS)");
        hashtable3.put(new Long(101L), "CLStreakSRM6 (OS)");
        hashtable3.put(new Long(102L), "CLVehicleFlamer");
        hashtable3.put(new Long(103L), "CLSRM2");
        hashtable3.put(new Long(104L), "CLSniperArtillery");
        hashtable3.put(new Long(105L), "CLThumperArtillery");
        hashtable3.put(new Long(106L), "CLLRTorpedo5");
        hashtable3.put(new Long(107L), "CLLRTorpedo10");
        hashtable3.put(new Long(108L), "CLLRTorpedo15");
        hashtable3.put(new Long(109L), "CLLRTorpedo20");
        hashtable3.put(new Long(110L), "CLSRTorpedo2");
        hashtable3.put(new Long(111L), "CLSRTorpedo4");
        hashtable3.put(new Long(112L), "CLSRTorpedo6");
        hashtable3.put(new Long(123L), "CLLRM5 (OS)");
        hashtable3.put(new Long(124L), "CLLRM10 (OS)");
        hashtable3.put(new Long(125L), "CLLRM15 (OS)");
        hashtable3.put(new Long(126L), "CLLRM20 (OS)");
        hashtable3.put(new Long(127L), "CLSRM2 (OS)");
        hashtable3.put(new Long(128L), "CLHeavyLargeLaser");
        hashtable3.put(new Long(129L), "CLHeavyMediumLaser");
        hashtable3.put(new Long(130L), "CLHeavySmallLaser");
        hashtable3.put(new Long(133L), "CLFlamer (Vehicle)");
        hashtable3.put(new Long(146L), "CLLRTorpedo5");
        hashtable3.put(new Long(147L), "CLLRTorpedo10");
        hashtable3.put(new Long(148L), "CLLRTorpedo15");
        hashtable3.put(new Long(149L), "CLLRTorpedo20");
        hashtable3.put(new Long(150L), "CLSRTorpedo2");
        hashtable3.put(new Long(151L), "CLSRTorpedo4");
        hashtable3.put(new Long(152L), "CLSRTorpedo6");
        hashtable3.put(new Long(168L), "CLMicroPulseLaser");
        hashtable3.put(new Long(173L), "CLLightMG");
        hashtable3.put(new Long(174L), "CLHeavyMG");
        hashtable3.put(new Long(175L), "CLLightActiveProbe");
        hashtable3.put(new Long(180L), "CLLightTAG");
        hashtable3.put(new Long(252L), "CLATM3");
        hashtable3.put(new Long(253L), "CLATM6");
        hashtable3.put(new Long(254L), "CLATM9");
        hashtable3.put(new Long(255L), "CLATM12");
        hashtable3.put(new Long(496L), "CLLRM5 Ammo");
        hashtable3.put(new Long(497L), "CLLRM10 Ammo");
        hashtable3.put(new Long(498L), "CLLRM15 Ammo");
        hashtable3.put(new Long(499L), "CLLRM20 Ammo");
        hashtable3.put(new Long(462L), "CLAC2 Ammo");
        hashtable3.put(new Long(464L), "CLAMS Ammo");
        hashtable3.put(new Long(463L), "CLAC5 Ammo");
        hashtable3.put(new Long(465L), "CLGauss Ammo");
        hashtable3.put(new Long(466L), "CLLBXAC2 Ammo");
        hashtable3.put(new Long(467L), "CLLBXAC5 Ammo");
        hashtable3.put(new Long(468L), "CLLBXAC10 Ammo");
        hashtable3.put(new Long(469L), "CLLBXAC20 Ammo");
        hashtable3.put(new Long(470L), "CLMG Ammo (200)");
        hashtable3.put(new Long(471L), "CLUltraAC2 Ammo");
        hashtable3.put(new Long(472L), "CLUltraAC5 Ammo");
        hashtable3.put(new Long(473L), "CLUltraAC10 Ammo");
        hashtable3.put(new Long(474L), "CLUltraAC20 Ammo");
        hashtable3.put(new Long(475L), "CLLRM5 Ammo");
        hashtable3.put(new Long(476L), "CLLRM10 Ammo");
        hashtable3.put(new Long(477L), "CLLRM15 Ammo");
        hashtable3.put(new Long(478L), "CLLRM20 Ammo");
        hashtable3.put(new Long(479L), "CLSRM2 Ammo");
        hashtable3.put(new Long(480L), "CLSRM4 Ammo");
        hashtable3.put(new Long(481L), "CLSRM6 Ammo");
        hashtable3.put(new Long(482L), "CLStreakSRM2 Ammo");
        hashtable3.put(new Long(483L), "CLStreakSRM4 Ammo");
        hashtable3.put(new Long(484L), "CLStreakSRM6 Ammo");
        hashtable3.put(new Long(485L), "CLArrowIV Ammo");
        hashtable3.put(new Long(489L), "CLNarc Pods");
        hashtable3.put(new Long(533L), "CLFlamer Ammo");
        hashtable3.put(new Long(573L), "CLLightMG Ammo (200)");
        hashtable3.put(new Long(574L), "CLHeavyMG Ammo (100)");
        hashtable3.put(new Long(502L), "CLFlamer (Vehicle) Ammo");
        hashtable3.put(new Long(503L), "CLSRM2 Ammo");
        hashtable3.put(new Long(504L), "CLSniper Ammo");
        hashtable3.put(new Long(505L), "CLThumper Ammo");
        hashtable3.put(new Long(506L), "CLLRTorpedo5 Ammo");
        hashtable3.put(new Long(507L), "CLLRTorpedo10 Ammo");
        hashtable3.put(new Long(508L), "CLLRTorpedo15 Ammo");
        hashtable3.put(new Long(509L), "CLLRTorpedo20 Ammo");
        hashtable3.put(new Long(510L), "CLSRTorpedo2 Ammo");
        hashtable3.put(new Long(511L), "CLSRTorpedo4 Ammo");
        hashtable3.put(new Long(512L), "CLSRTorpedo6 Ammo");
        hashtable3.put(new Long(548L), "CLLRTorpedo15 Ammo");
        hashtable3.put(new Long(549L), "CLLRTorpedo20 Ammo");
        hashtable3.put(new Long(546L), "CLLRTorpedo5 Ammo");
        hashtable3.put(new Long(547L), "CLLRTorpedo10 Ammo");
        hashtable3.put(new Long(551L), "CLSRTorpedo4 Ammo");
        hashtable3.put(new Long(550L), "CLSRTorpedo2 Ammo");
        hashtable3.put(new Long(552L), "CLSRTorpedo6 Ammo");
        hashtable3.put(new Long(652L), "CLATM3 Ammo");
        hashtable3.put(new Long(653L), "CLATM6 Ammo");
        hashtable3.put(new Long(654L), "CLATM9 Ammo");
        hashtable3.put(new Long(655L), "CLATM12 Ammo");
        Hashtable<Long, String> hashtable4 = new Hashtable<Long, String>();
        AMMO.put(HMVTechType.CLAN, hashtable4);
        hashtable4.put(new Long(64L), "CLAMS Ammo");
        hashtable4.put(new Long(65L), "CLGauss Ammo");
        hashtable4.put(new Long(66L), "CLLBXAC2 Ammo Ammo");
        hashtable4.put(new Long(67L), "CLLBXAC5 Ammo");
        hashtable4.put(new Long(68L), "CLLBXAC10 Ammo");
        hashtable4.put(new Long(69L), "CLLBXAC20 Ammo");
        hashtable4.put(new Long(70L), "CLMG Ammo (200)");
        hashtable4.put(new Long(71L), "CLUltraAC2 Ammo");
        hashtable4.put(new Long(72L), "CLUltraAC5 Ammo");
        hashtable4.put(new Long(73L), "CLUltraAC10 Ammo");
        hashtable4.put(new Long(74L), "CLUltraAC20 Ammo");
        hashtable4.put(new Long(75L), "CLLRM5 Ammo");
        hashtable4.put(new Long(76L), "CLLRM10 Ammo");
        hashtable4.put(new Long(77L), "CLLRM15 Ammo");
        hashtable4.put(new Long(78L), "CLLRM20 Ammo");
        hashtable4.put(new Long(79L), "CLSRM2 Ammo");
        hashtable4.put(new Long(80L), "CLSRM4 Ammo");
        hashtable4.put(new Long(81L), "CLSRM6 Ammo");
        hashtable4.put(new Long(82L), "CLStreakSRM2 Ammo");
        hashtable4.put(new Long(83L), "CLStreakSRM4 Ammo");
        hashtable4.put(new Long(84L), "CLStreakSRM6 Ammo");
        hashtable4.put(new Long(85L), "CLArrowIVSystem Ammo");
        hashtable4.put(new Long(102L), "CLVehicleFlamer Ammo");
        hashtable4.put(new Long(103L), "CLSRM2 Ammo");
        hashtable4.put(new Long(104L), "CLSniperArtillery Ammo");
        hashtable4.put(new Long(105L), "CLThumperArtillery Ammo");
        hashtable4.put(new Long(106L), "CLTorpedoLRM5 Ammo");
        hashtable4.put(new Long(107L), "CLTorpedoLRM10 Ammo");
        hashtable4.put(new Long(108L), "CLTorpedoLRM15 Ammo");
        hashtable4.put(new Long(109L), "CLTorpedoLRM20 Ammo");
        hashtable4.put(new Long(110L), "CLTorpedoSRM2 Ammo");
        hashtable4.put(new Long(111L), "CLTorpedoSRM4 Ammo");
        hashtable4.put(new Long(112L), "CLTorpedoSRM6 Ammo");
        hashtable4.put(new Long(133L), "CLVehicleFlamer Ammo");
        hashtable4.put(new Long(146L), "CLTorpedoLRM5 Ammo");
        hashtable4.put(new Long(147L), "CLTorpedoLRM10 Ammo");
        hashtable4.put(new Long(148L), "CLTorpedoLRM15 Ammo");
        hashtable4.put(new Long(149L), "CLTorpedoLRM20 Ammo");
        hashtable4.put(new Long(150L), "CLTorpedoSRM2 Ammo");
        hashtable4.put(new Long(151L), "CLTorpedoSRM4 Ammo");
        hashtable4.put(new Long(152L), "CLTorpedoSRM6 Ammo");
        hashtable4.put(new Long(173L), "CLLightMG Ammo (200)");
        hashtable4.put(new Long(174L), "CLHeavyMG Ammo (100)");
        hashtable4.put(new Long(252L), "CLATM3 Ammo");
        hashtable4.put(new Long(253L), "CLATM6 Ammo");
        hashtable4.put(new Long(254L), "CLATM9 Ammo");
        hashtable4.put(new Long(255L), "CLATM12 Ammo");
    }
}

