/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.BipedMech;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;

public class MtfFile
implements IMechLoader {
    String version;
    String name;
    String model;
    String chassisConfig;
    String techBase;
    String techYear;
    String rulesLevel;
    String tonnage;
    String engine;
    String internalType;
    String myomerType;
    String gyroType;
    String cockpitType;
    String heatSinks;
    String walkMP;
    String jumpMP;
    String armorType;
    String larmArmor;
    String rarmArmor;
    String ltArmor;
    String rtArmor;
    String ctArmor;
    String headArmor;
    String llegArmor;
    String rlegArmor;
    String ltrArmor;
    String rtrArmor;
    String ctrArmor;
    String weaponCount;
    String[] weaponData;
    String[][] critData;
    Hashtable hSharedEquip = new Hashtable();
    Vector vSplitWeapons = new Vector();

    public MtfFile(InputStream inputStream) throws EntityLoadingException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.version = bufferedReader.readLine();
            this.name = bufferedReader.readLine();
            this.model = bufferedReader.readLine();
            bufferedReader.readLine();
            this.chassisConfig = bufferedReader.readLine();
            this.techBase = bufferedReader.readLine();
            this.techYear = bufferedReader.readLine();
            this.rulesLevel = bufferedReader.readLine();
            bufferedReader.readLine();
            String string = bufferedReader.readLine();
            while (string != null && string.length() > 0) {
                if (string.startsWith("Cockpit:")) {
                    this.cockpitType = string;
                } else if (string.startsWith("Gyro:")) {
                    this.gyroType = string;
                } else if (string.startsWith("Mass:")) {
                    this.tonnage = string;
                } else if (string.startsWith("Engine:")) {
                    this.engine = string;
                } else if (string.startsWith("Structure:")) {
                    this.internalType = string;
                } else if (string.startsWith("Myomer:")) {
                    this.myomerType = string;
                }
                string = bufferedReader.readLine();
            }
            this.heatSinks = bufferedReader.readLine();
            this.walkMP = bufferedReader.readLine();
            this.jumpMP = bufferedReader.readLine();
            bufferedReader.readLine();
            this.armorType = bufferedReader.readLine();
            this.larmArmor = bufferedReader.readLine();
            this.rarmArmor = bufferedReader.readLine();
            this.ltArmor = bufferedReader.readLine();
            this.rtArmor = bufferedReader.readLine();
            this.ctArmor = bufferedReader.readLine();
            this.headArmor = bufferedReader.readLine();
            this.llegArmor = bufferedReader.readLine();
            this.rlegArmor = bufferedReader.readLine();
            this.ltrArmor = bufferedReader.readLine();
            this.rtrArmor = bufferedReader.readLine();
            this.ctrArmor = bufferedReader.readLine();
            bufferedReader.readLine();
            this.weaponCount = bufferedReader.readLine();
            int n = Integer.parseInt(this.weaponCount.substring(8));
            this.weaponData = new String[n];
            for (int i = 0; i < n; ++i) {
                this.weaponData[i] = bufferedReader.readLine();
            }
            this.critData = new String[8][12];
            this.readCrits(bufferedReader, 5);
            this.readCrits(bufferedReader, 4);
            this.readCrits(bufferedReader, 3);
            this.readCrits(bufferedReader, 2);
            this.readCrits(bufferedReader, 1);
            this.readCrits(bufferedReader, 0);
            this.readCrits(bufferedReader, 7);
            this.readCrits(bufferedReader, 6);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new EntityLoadingException("I/O Error reading file");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringIndexOutOfBoundsException.printStackTrace();
            throw new EntityLoadingException("StringIndexOutOfBoundsException reading file (format error)");
        }
        catch (NumberFormatException numberFormatException) {
            throw new EntityLoadingException("NumberFormatException reading file (format error)");
        }
    }

    private void readCrits(BufferedReader bufferedReader, int n) throws IOException {
        bufferedReader.readLine();
        bufferedReader.readLine();
        for (int i = 0; i < 12; ++i) {
            this.critData[n][i] = bufferedReader.readLine();
        }
    }

    public Entity getEntity() throws EntityLoadingException {
        try {
            Mech mech;
            block35: {
                block36: {
                    block34: {
                        int n = 0;
                        try {
                            n = Mech.getGyroTypeForString(this.gyroType.substring(5));
                            if (n == -1) {
                                n = 0;
                            }
                        }
                        catch (Exception exception) {
                            n = 0;
                        }
                        int n2 = 0;
                        try {
                            n2 = Mech.getCockpitTypeForString(this.cockpitType.substring(8));
                            if (n2 == -1) {
                                n2 = 0;
                            }
                        }
                        catch (Exception exception) {
                            n2 = 0;
                        }
                        mech = this.chassisConfig.indexOf("Quad") != -1 ? new QuadMech(n, n2) : new BipedMech(n, n2);
                        if (!this.version.trim().equalsIgnoreCase("Version:1.0")) {
                            throw new EntityLoadingException("Wrong MTF file version.");
                        }
                        int n3 = this.name.indexOf("(");
                        if (n3 == -1) {
                            mech.setChassis(this.name.trim());
                        } else {
                            mech.setChassis(this.name.substring(0, n3 - 1).trim());
                        }
                        mech.setModel(this.model.trim());
                        mech.setYear(Integer.parseInt(this.techYear.substring(4).trim()));
                        if (this.chassisConfig.indexOf("Omni") != -1) {
                            mech.setOmni(true);
                        }
                        if (!this.techBase.substring(9).trim().equals("Inner Sphere")) break block34;
                        switch (Integer.parseInt(this.rulesLevel.substring(12).trim())) {
                            case 1: {
                                mech.setTechLevel(0);
                                break block35;
                            }
                            case 2: {
                                mech.setTechLevel(1);
                                break block35;
                            }
                            case 3: {
                                mech.setTechLevel(5);
                                break block35;
                            }
                            default: {
                                throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel.substring(12).trim());
                            }
                        }
                    }
                    if (!this.techBase.substring(9).trim().equals("Clan")) break block36;
                    switch (Integer.parseInt(this.rulesLevel.substring(12).trim())) {
                        case 2: {
                            mech.setTechLevel(2);
                            break block35;
                        }
                        case 3: {
                            mech.setTechLevel(6);
                            break block35;
                        }
                        default: {
                            throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel.substring(12).trim());
                        }
                    }
                }
                if (this.techBase.substring(9).trim().equals("Mixed (IS Chassis)")) {
                    mech.setTechLevel(5);
                    mech.setMixedTech(true);
                } else if (this.techBase.substring(9).trim().equals("Mixed (Clan Chassis)")) {
                    mech.setTechLevel(6);
                    mech.setMixedTech(true);
                } else {
                    if (this.techBase.substring(9).trim().equals("Mixed")) {
                        throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
                    }
                    throw new EntityLoadingException("Unsupported tech base: " + this.techBase.substring(9).trim());
                }
            }
            mech.setWeight(Integer.parseInt(this.tonnage.substring(5)));
            mech.setOriginalWalkMP(Integer.parseInt(this.walkMP.substring(8)));
            mech.setOriginalJumpMP(Integer.parseInt(this.jumpMP.substring(8)));
            boolean bl = this.heatSinks.substring(14).equalsIgnoreCase("Double") || this.heatSinks.substring(14).equalsIgnoreCase("Laser");
            int n = Integer.parseInt(this.heatSinks.substring(11, 14).trim());
            String string = this.internalType.substring(this.internalType.indexOf(58) + 1);
            if (string.length() > 0) {
                mech.setStructureType(string);
            } else {
                mech.setStructureType(0);
            }
            mech.autoSetInternal();
            String string2 = this.armorType.substring(this.armorType.indexOf(58) + 1);
            if (string2.length() > 0) {
                mech.setArmorType(string2);
            } else {
                mech.setArmorType(0);
            }
            mech.initializeArmor(Integer.parseInt(this.larmArmor.substring(9)), 5);
            mech.initializeArmor(Integer.parseInt(this.rarmArmor.substring(9)), 4);
            mech.initializeArmor(Integer.parseInt(this.ltArmor.substring(9)), 3);
            mech.initializeArmor(Integer.parseInt(this.rtArmor.substring(9)), 2);
            mech.initializeArmor(Integer.parseInt(this.ctArmor.substring(9)), 1);
            mech.initializeArmor(Integer.parseInt(this.headArmor.substring(9)), 0);
            mech.initializeArmor(Integer.parseInt(this.llegArmor.substring(9)), 7);
            mech.initializeArmor(Integer.parseInt(this.rlegArmor.substring(9)), 6);
            mech.initializeRearArmor(Integer.parseInt(this.ltrArmor.substring(10)), 3);
            mech.initializeRearArmor(Integer.parseInt(this.rtrArmor.substring(10)), 2);
            mech.initializeRearArmor(Integer.parseInt(this.ctrArmor.substring(10)), 1);
            this.compactCriticals(mech);
            for (int i = mech.locations() - 1; i >= 0; --i) {
                this.parseCrits(mech, i);
            }
            if (mech.isClan()) {
                mech.addClanCase();
            }
            mech.addEngineSinks(n - mech.heatSinks(), bl);
            return mech;
        }
        catch (NumberFormatException numberFormatException) {
            throw new EntityLoadingException("NumberFormatException parsing file");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new EntityLoadingException("NullPointerException parsing file");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new EntityLoadingException("StringIndexOutOfBoundsException parsing file");
        }
    }

    private void parseCrits(Mech mech, int n) throws EntityLoadingException {
        if (!(mech instanceof QuadMech || n != 5 && n != 4)) {
            if (!this.critData[n][3].equals("Hand Actuator")) {
                mech.setCritical(n, 3, null);
            }
            if (!this.critData[n][2].equals("Lower Arm Actuator")) {
                mech.setCritical(n, 2, null);
            }
        }
        for (int i = 0; i < mech.getNumberOfCriticals(n); ++i) {
            if (mech.getCritical(n, i) != null) continue;
            String string = this.critData[n][i];
            boolean bl = false;
            boolean bl2 = false;
            if (string.equalsIgnoreCase("Fusion Engine")) {
                mech.setCritical(n, i, new CriticalSlot(0, 3));
                continue;
            }
            if (string.endsWith("(R)")) {
                bl = true;
                string = string.substring(0, string.length() - 3).trim();
            }
            if (string.endsWith("(Split)")) {
                bl2 = true;
                string = string.substring(0, string.length() - 7).trim();
            }
            if (string.equalsIgnoreCase("Armored Cowl")) {
                mech.setCowl(5);
            }
            try {
                EquipmentType equipmentType = EquipmentType.get(string);
                if (equipmentType != null) {
                    Mounted mounted;
                    if (equipmentType.isSpreadable()) {
                        mounted = (Mounted)this.hSharedEquip.get(equipmentType);
                        if (mounted != null) {
                            mech.addCritical(n, new CriticalSlot(1, mech.getEquipmentNum(mounted), equipmentType.isHittable()));
                            continue;
                        }
                        mounted = mech.addEquipment(equipmentType, n, bl);
                        this.hSharedEquip.put(equipmentType, mounted);
                        continue;
                    }
                    if (bl2) {
                        mounted = null;
                        boolean bl3 = false;
                        int n2 = this.vSplitWeapons.size();
                        for (int j = 0; j < n2; ++j) {
                            mounted = (Mounted)this.vSplitWeapons.elementAt(j);
                            int n3 = mounted.getLocation();
                            if (n3 != n && n != Mech.getInnerLocation(n3) || mounted.getType() != equipmentType) continue;
                            bl3 = true;
                            break;
                        }
                        if (bl3) {
                            mounted.setFoundCrits(mounted.getFoundCrits() + 1);
                            if (mounted.getFoundCrits() >= equipmentType.getCriticals(mech)) {
                                this.vSplitWeapons.removeElement(mounted);
                            }
                            mounted.setLocation(Mech.mostRestrictiveLoc(n, mounted.getLocation()));
                        } else {
                            mounted = new Mounted(mech, equipmentType);
                            mounted.setSplit(true);
                            mounted.setFoundCrits(1);
                            this.vSplitWeapons.addElement(mounted);
                        }
                        mech.addEquipment(mounted, n, bl);
                        continue;
                    }
                    mech.addEquipment(equipmentType, n, bl);
                    continue;
                }
                if (string.equals("-Empty-")) continue;
                mech.addFailedEquipment(string);
                this.critData[n][i] = "-Empty-";
                this.compactCriticals(mech, n);
                --i;
                continue;
            }
            catch (LocationFullException locationFullException) {
                throw new EntityLoadingException(locationFullException.getMessage());
            }
        }
    }

    private void compactCriticals(Mech mech) {
        for (int i = 0; i < mech.locations(); ++i) {
            this.compactCriticals(mech, i);
        }
    }

    private void compactCriticals(Mech mech, int n) {
        if (n == 0) {
            return;
        }
        int n2 = -1;
        for (int i = 0; i < mech.getNumberOfCriticals(n); ++i) {
            if (this.critData[n][i].equals("-Empty-")) {
                n2 = i;
            }
            if (n2 == -1 || this.critData[n][i].equals("-Empty-")) continue;
            this.critData[n][n2] = this.critData[n][i];
            this.critData[n][i] = "-Empty-";
            i = n2;
            n2 = -1;
        }
    }
}

