/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.util.Enumeration;
import megamek.common.BattleArmor;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.util.StringUtil;

public abstract class UnitStatusFormatter {
    public static String format(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("=============================================================").append("\r\n");
        stringBuffer.append(UnitStatusFormatter.formatHeader(entity));
        stringBuffer.append("--- Armor: ").append(entity.getTotalArmor()).append("/").append(entity.getTotalOArmor()).append("-------------------------------------------").append("\r\n");
        stringBuffer.append("--- Internal: ").append(entity.getTotalInternal()).append("/").append(entity.getTotalOInternal()).append("----------------------------------------").append("\r\n");
        stringBuffer.append(UnitStatusFormatter.formatArmor(entity));
        if (entity instanceof Mech || entity instanceof Protomech) {
            stringBuffer.append("-------------------------------------------------------------").append("\r\n");
            stringBuffer.append(UnitStatusFormatter.formatCrits(entity));
        }
        stringBuffer.append("-------------------------------------------------------------").append("\r\n");
        stringBuffer.append(UnitStatusFormatter.formatAmmo(entity));
        stringBuffer.append("=============================================================").append("\r\n");
        return stringBuffer.toString();
    }

    private static String formatHeader(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("Model: ").append(entity.getChassis()).append(" - ").append(entity.getModel()).append("\r\n");
        stringBuffer.append("Pilot: ").append(entity.crew.getName());
        stringBuffer.append(" (").append(entity.crew.getGunnery()).append("/");
        stringBuffer.append(entity.crew.getPiloting()).append(")").append("\r\n");
        if (entity.isCaptured()) {
            stringBuffer.append("  *** CAPTURED BY THE ENEMY ***");
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    private static String formatAmmo(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        Enumeration enumeration = entity.getAmmo();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            stringBuffer.append(mounted.getName());
            stringBuffer.append(": ").append(mounted.getShotsLeft()).append("\r\n");
        }
        return stringBuffer.toString();
    }

    private static String formatCrits(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < entity.locations(); ++i) {
            stringBuffer.append(StringUtil.makeLength(entity.getLocationName(i), 12)).append(": ");
            int n = 0;
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                CriticalSlot criticalSlot = entity.getCritical(i, j);
                if (criticalSlot == null) continue;
                if (++n == 7) {
                    stringBuffer.append("\r\n");
                    stringBuffer.append("              ");
                } else if (n > 1) {
                    stringBuffer.append(",");
                }
                if (criticalSlot.getType() == 0) {
                    if (criticalSlot.isHit() || criticalSlot.isDestroyed() || criticalSlot.isMissing()) {
                        stringBuffer.append("*");
                    }
                    if (entity instanceof Mech) {
                        stringBuffer.append(((Mech)entity).getSystemName(criticalSlot.getIndex()));
                        continue;
                    }
                    if (!(entity instanceof Protomech)) continue;
                    stringBuffer.append(Protomech.systemNames[criticalSlot.getIndex()]);
                    continue;
                }
                if (criticalSlot.getType() != 1) continue;
                Mounted mounted = entity.getEquipment(criticalSlot.getIndex());
                stringBuffer.append(criticalSlot.isDestroyed() ? "*" : "").append(criticalSlot.isBreached() ? "x" : "").append(mounted.getDesc());
            }
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    private static String formatArmor(Entity entity) {
        if (entity instanceof Mech) {
            return UnitStatusFormatter.formatArmorMech((Mech)entity);
        }
        if (entity instanceof Tank) {
            return UnitStatusFormatter.formatArmorTank((Tank)entity);
        }
        if (entity instanceof BattleArmor) {
            return UnitStatusFormatter.formatArmorBattleArmor((BattleArmor)entity);
        }
        if (entity instanceof Infantry) {
            return UnitStatusFormatter.formatArmorInfantry((Infantry)entity);
        }
        if (entity instanceof Protomech) {
            return UnitStatusFormatter.formatArmorProtomech((Protomech)entity);
        }
        return "";
    }

    private static String formatArmorTank(Tank tank) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("      ARMOR               INTERNAL").append("\r\n").append("    __________           __________").append("\r\n").append("    |\\      /|           |\\      /|").append("\r\n");
        stringBuffer.append("    | \\ ").append(UnitStatusFormatter.renderArmor(tank.getArmor(1))).append(" / |           | \\ ");
        stringBuffer.append(UnitStatusFormatter.renderArmor(tank.getInternal(1))).append(" / |").append("\r\n").append("    |  \\__/  |           |  \\__/  |").append("\r\n");
        stringBuffer.append("    |").append(UnitStatusFormatter.renderArmor(tank.getArmor(3))).append("/");
        if (!tank.hasNoTurret()) {
            stringBuffer.append(UnitStatusFormatter.renderArmor(tank.getArmor(5))).append("\\");
        } else {
            stringBuffer.append("  \\");
        }
        stringBuffer.append(UnitStatusFormatter.renderArmor(tank.getArmor(2))).append("|           |");
        stringBuffer.append(UnitStatusFormatter.renderArmor(tank.getInternal(3))).append("/");
        if (tank.hasNoTurret()) {
            stringBuffer.append(UnitStatusFormatter.renderArmor(tank.getInternal(5))).append("\\");
        } else {
            stringBuffer.append("  \\");
        }
        stringBuffer.append(UnitStatusFormatter.renderArmor(tank.getInternal(2))).append("|").append("\r\n");
        stringBuffer.append("    | /____\\ |           | /____\\ |").append("\r\n").append("    | / ").append(UnitStatusFormatter.renderArmor(tank.getArmor(4))).append(" \\ |           | / ");
        stringBuffer.append(UnitStatusFormatter.renderArmor(tank.getInternal(4))).append(" \\ |").append("\r\n").append("    |/______\\|           |/______\\|").append("\r\n");
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    private static String formatArmorMech(Mech mech) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("         FRONT                REAR                INTERNAL");
        stringBuffer.append("\r\n");
        if (mech.getWeight() < 70.0f) {
            stringBuffer.append("         (").append(UnitStatusFormatter.renderArmor(mech.getArmor(0))).append(")                 (**)                  (");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(0))).append(")");
            stringBuffer.append("\r\n");
            stringBuffer.append("      /").append(UnitStatusFormatter.renderArmor(mech.getArmor(3))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(1))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(2))).append("\\           /");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(3, true))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(1, true))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(2, true))).append("\\            /");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(3))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(1))).append("|");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(2))).append("\\");
            stringBuffer.append("\r\n");
            stringBuffer.append("     (").append(UnitStatusFormatter.renderArmor(mech.getArmor(5)));
            stringBuffer.append("/ || \\").append(UnitStatusFormatter.renderArmor(mech.getArmor(4)));
            stringBuffer.append(")         (   |  |   )          (");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(5))).append("/ || \\");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(4))).append(")");
            stringBuffer.append("\r\n");
            stringBuffer.append("       /  /\\  \\               /  \\                /  /\\  \\");
            stringBuffer.append("\r\n");
            stringBuffer.append("      (").append(UnitStatusFormatter.renderArmor(mech.getArmor(7)));
            stringBuffer.append("/  \\").append(UnitStatusFormatter.renderArmor(mech.getArmor(6)));
            stringBuffer.append(")             /    \\              (");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(7)));
            stringBuffer.append("/  \\").append(UnitStatusFormatter.renderArmor(mech.getInternal(6))).append(")");
            stringBuffer.append("\r\n");
        } else {
            stringBuffer.append("      .../").append(UnitStatusFormatter.renderArmor(mech.getArmor(0))).append("\\...           .../**\\...            .../");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(0))).append("\\...");
            stringBuffer.append("\r\n");
            stringBuffer.append("     /").append(UnitStatusFormatter.renderArmor(mech.getArmor(3))).append("| ");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(1))).append(" |");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(2))).append("\\         /");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(3, true))).append("| ");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(1, true))).append(" |");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getArmor(2, true))).append("\\          /");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(3))).append("| ");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(1))).append(" |");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(2))).append("\\");
            stringBuffer.append("\r\n");
            stringBuffer.append("    (").append(UnitStatusFormatter.renderArmor(mech.getArmor(5)));
            stringBuffer.append("). -- .(").append(UnitStatusFormatter.renderArmor(mech.getArmor(4)));
            stringBuffer.append(")       (   |    |   )        (");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(5))).append("). -- .(");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(4))).append(")");
            stringBuffer.append("\r\n");
            stringBuffer.append("       /  /\\  \\             /      \\              /  /\\  \\");
            stringBuffer.append("\r\n");
            stringBuffer.append("      /").append(UnitStatusFormatter.renderArmor(mech.getArmor(7)));
            stringBuffer.append(".\\/.").append(UnitStatusFormatter.renderArmor(mech.getArmor(6)));
            stringBuffer.append("\\           /        \\            /");
            stringBuffer.append(UnitStatusFormatter.renderArmor(mech.getInternal(7)));
            stringBuffer.append(".\\/.").append(UnitStatusFormatter.renderArmor(mech.getInternal(6))).append("\\");
            stringBuffer.append("\r\n");
        }
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    private static String formatArmorInfantry(Infantry infantry) {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("Surviving troopers: ").append(UnitStatusFormatter.renderArmor(infantry.getInternal(0))).append("\r\n");
        return stringBuffer.toString();
    }

    private static String formatArmorBattleArmor(BattleArmor battleArmor) {
        StringBuffer stringBuffer = new StringBuffer(32);
        for (int i = 1; i < battleArmor.locations(); ++i) {
            stringBuffer.append("Trooper ").append(i).append(": ").append(UnitStatusFormatter.renderArmor(battleArmor.getArmor(i))).append(" / ").append(UnitStatusFormatter.renderArmor(battleArmor.getInternal(i)));
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    private static String formatArmorProtomech(Protomech protomech) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("         FRONT                INTERNAL");
        stringBuffer.append("\r\n");
        stringBuffer.append("        ");
        if (protomech.hasMainGun()) {
            stringBuffer.append(UnitStatusFormatter.renderArmor(protomech.getArmor(5), 1));
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(" (").append(UnitStatusFormatter.renderArmor(protomech.getArmor(0), 1)).append(")                  ");
        if (protomech.hasMainGun()) {
            stringBuffer.append(UnitStatusFormatter.renderArmor(protomech.getInternal(5), 1));
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(" (");
        stringBuffer.append(UnitStatusFormatter.renderArmor(protomech.getInternal(0), 1)).append(")");
        stringBuffer.append("\r\n");
        if (protomech.hasMainGun()) {
            stringBuffer.append("         \\/ \\                   \\/ \\");
            stringBuffer.append("\r\n");
        } else {
            stringBuffer.append("          / \\                    / \\");
            stringBuffer.append("\r\n");
        }
        stringBuffer.append("      (").append(UnitStatusFormatter.renderArmor(protomech.getArmor(3), 1));
        stringBuffer.append(" /").append(UnitStatusFormatter.renderArmor(protomech.getArmor(1))).append(" \\").append(UnitStatusFormatter.renderArmor(protomech.getArmor(2)));
        stringBuffer.append(")            (");
        stringBuffer.append(UnitStatusFormatter.renderArmor(protomech.getInternal(3), 1)).append(" /").append(UnitStatusFormatter.renderArmor(protomech.getInternal(1))).append(" \\");
        stringBuffer.append(UnitStatusFormatter.renderArmor(protomech.getInternal(2))).append(")");
        stringBuffer.append("\r\n");
        stringBuffer.append("         | | |                  | | |");
        stringBuffer.append("\r\n");
        stringBuffer.append("        ( ").append(UnitStatusFormatter.renderArmor(protomech.getArmor(4)));
        stringBuffer.append("  )                ( ");
        stringBuffer.append(UnitStatusFormatter.renderArmor(protomech.getInternal(4))).append("  )");
        stringBuffer.append("\r\n");
        stringBuffer.append("");
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    private static String renderArmor(int n) {
        return UnitStatusFormatter.renderArmor(n, 2);
    }

    private static String renderArmor(int n, int n2) {
        if (n <= 0) {
            if (1 == n2) {
                return "x";
            }
            return "xx";
        }
        return StringUtil.makeLength(String.valueOf(n), n2, true);
    }

    public static void main(String[] stringArray) throws Exception {
        MechSummary mechSummary = MechSummaryCache.getInstance().getMech(stringArray[0]);
        Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
        System.out.println(UnitStatusFormatter.format(entity));
    }
}

