/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.MemoryStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cache
implements Cloneable,
Serializable {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$Cache == null ? (class$net$sf$ehcache$Cache = Cache.class$("net.sf.ehcache.Cache")) : class$net$sf$ehcache$Cache).getName());
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final int STATUS_UNINITIALISED = 1;
    public static final int STATUS_ALIVE = 2;
    public static final int STATUS_DISPOSED = 3;
    private String name;
    private DiskStore diskStore;
    private int status;
    private final int maxElementsInMemory;
    private final boolean overflowToDisk;
    private final boolean eternal;
    private final long timeToLiveSeconds;
    private final long timeToIdleSeconds;
    private int hitCount;
    private int memoryStoreHitCount;
    private int diskStoreHitCount;
    private int missCountNotFound;
    private int missCountExpired;
    private MemoryStore memoryStore;
    static /* synthetic */ Class class$net$sf$ehcache$Cache;

    public Cache(String name, int maximumSize, boolean overflowToDisk, boolean eternal, long timeToLive, long timeToIdle) {
        this.name = name;
        this.maxElementsInMemory = maximumSize;
        this.overflowToDisk = overflowToDisk;
        this.eternal = eternal;
        this.timeToLiveSeconds = timeToLive;
        this.timeToIdleSeconds = timeToIdle;
        this.status = 1;
    }

    synchronized void initialise(Configuration configuration) {
        if (this.status != 1) {
            throw new IllegalStateException("Cannot initialise the " + this.name + " cache because its status is not STATUS_UNINITIALISED");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Cannot intialise caches without a configuration");
        }
        if (this.overflowToDisk) {
            this.diskStore = new DiskStore(this, configuration.getDiskCachePath());
        }
        this.memoryStore = new MemoryStore(this, this.diskStore);
        this.status = 2;
    }

    public synchronized void put(Element element) throws IllegalArgumentException, IllegalStateException {
        this.checkStatus();
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        element.resetAccessStatistics();
        this.memoryStore.put(element);
    }

    public synchronized Element get(Serializable key) throws IllegalStateException, CacheException {
        this.checkStatus();
        Element element = null;
        element = this.searchInMemoryStore(key);
        if (element == null && this.overflowToDisk) {
            try {
                element = this.searchInDiskStore(key);
            }
            catch (IOException e) {
                throw new CacheException(e.getMessage());
            }
        }
        if (element == null) {
            ++this.missCountNotFound;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.name + " cache - Miss"));
            }
            return null;
        }
        ++this.hitCount;
        return element;
    }

    public synchronized List getKeys() {
        ArrayList<Object> allKeys = new ArrayList<Object>();
        List<Object> memoryKeySet = Arrays.asList(this.memoryStore.getKeyArray());
        allKeys.addAll(memoryKeySet);
        if (this.overflowToDisk) {
            List<Object> diskKeySet = Arrays.asList(this.diskStore.getKeyArray());
            allKeys.addAll(diskKeySet);
        }
        return allKeys;
    }

    private Element searchInMemoryStore(Serializable key) {
        Element element = this.memoryStore.get(key);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + " Memory cache hit, but element expired"));
                }
                ++this.missCountExpired;
                this.remove(key);
                element = null;
            } else {
                ++this.memoryStoreHitCount;
            }
        }
        return element;
    }

    private Element searchInDiskStore(Serializable key) throws IOException {
        Element element = this.diskStore.get(key);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + " cache - Disk Store hit, but element expired"));
                }
                ++this.missCountExpired;
                this.remove(key);
                element = null;
            } else {
                ++this.diskStoreHitCount;
                this.memoryStore.put(element);
            }
        }
        return element;
    }

    public synchronized boolean remove(Serializable key) throws IllegalStateException {
        this.checkStatus();
        boolean removedFromMemory = false;
        removedFromMemory = this.memoryStore.remove(key);
        boolean removedFromDisk = false;
        if (this.overflowToDisk) {
            try {
                removedFromDisk = this.diskStore.remove(key);
                if (LOG.isDebugEnabled() && removedFromDisk) {
                    LOG.debug((Object)("Removing " + key + " from diskStore"));
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failure removing from Disk Cache", (Throwable)e);
            }
        }
        return removedFromMemory || removedFromDisk;
    }

    public synchronized void removeAll() throws IllegalStateException, IOException {
        this.checkStatus();
        this.memoryStore.removeAll();
        if (this.overflowToDisk) {
            this.diskStore.removeAll();
        }
    }

    synchronized void dispose() throws IllegalStateException {
        this.checkStatus();
        try {
            this.removeAll();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        this.memoryStore.dispose();
        this.memoryStore = null;
        if (this.overflowToDisk) {
            this.diskStore.dispose();
            this.diskStore = null;
        }
        this.status = 3;
    }

    public synchronized int getSize() throws IllegalStateException {
        this.checkStatus();
        int size = 0;
        int memorySize = this.memoryStore.getSize();
        size += memorySize;
        int diskStoreSize = 0;
        if (this.overflowToDisk) {
            diskStoreSize = this.diskStore.getSize();
            size += diskStoreSize;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Total Size: " + size + " Memory Size: " + memorySize + " Disk Size: " + diskStoreSize));
        }
        return size;
    }

    public int getMemoryStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore.getSize();
    }

    public int getDiskStoreSize() throws IllegalStateException {
        this.checkStatus();
        if (this.overflowToDisk) {
            return this.diskStore.getSize();
        }
        return 0;
    }

    public int getStatus() {
        return this.status;
    }

    private void checkStatus() {
        if (this.status != 2) {
            throw new IllegalStateException("The " + this.name + " Cache is not alive.");
        }
    }

    public int getHitCount() throws IllegalStateException {
        this.checkStatus();
        return this.hitCount;
    }

    public int getMemoryStoreHitCount() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStoreHitCount;
    }

    public int getDiskStoreHitCount() throws IllegalStateException {
        this.checkStatus();
        return this.diskStoreHitCount;
    }

    public int getMissCountNotFound() throws IllegalStateException {
        this.checkStatus();
        return this.missCountNotFound;
    }

    public int getMissCountExpired() throws IllegalStateException {
        this.checkStatus();
        return this.missCountExpired;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[ ").append(" name = ").append(this.name).append(" status = ").append(this.status).append(" eternal = ").append(this.eternal).append(" overflowToDisk = ").append(this.overflowToDisk).append(" maxElementsInMemory = ").append(this.maxElementsInMemory).append(", timeToLiveSeconds = ").append(this.timeToLiveSeconds).append(" timeToIdleSeconds = ").append(this.timeToIdleSeconds).append(" hitCount = ").append(this.hitCount).append(" memoryStoreHitCount = ").append(this.memoryStoreHitCount).append(" diskStoreHitCount = ").append(this.diskStoreHitCount).append(" missCountNotFound = ").append(this.missCountNotFound).append(" missCountExpired = ").append(this.missCountExpired).append(" ]");
        return dump.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        Element element2 = element;
        synchronized (element2) {
            boolean expired;
            if (element.getValue() == null) {
                expired = true;
            }
            if (!this.eternal) {
                long now = System.currentTimeMillis();
                long ageLived = now - element.getCreationTime();
                long ageToLive = this.timeToLiveSeconds * 1000L;
                long ageIdled = now - Math.max(element.getCreationTime(), element.getLastAccessTime());
                long ageToIdle = this.timeToIdleSeconds * 1000L;
                if (ageLived > ageToLive) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("timeToLiveSeconds exceeded : " + element.getKey()));
                    }
                    expired = true;
                } else if (ageIdled > ageToIdle) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("timeToIdleSeconds exceeded : " + element.getKey()));
                    }
                    expired = true;
                } else {
                    expired = false;
                }
            } else {
                expired = false;
            }
            return expired;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.memoryStore != null || this.diskStore != null) {
            throw new CloneNotSupportedException("Cannot clone an initialized cache.");
        }
        return (Cache)super.clone();
    }

    DiskStore getDiskStore() throws IllegalStateException {
        this.checkStatus();
        return this.diskStore;
    }

    MemoryStore getMemoryStore() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

