/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.accesslayer.sql.SqlQueryStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQuery;
import org.apache.ojb.broker.util.logging.Logger;

public class SqlSelectStatement
extends SqlQueryStatement {
    public SqlSelectStatement(Platform pf, ClassDescriptor cld, Query query, Logger logger) {
        super(pf, cld, query, logger);
    }

    public SqlSelectStatement(SqlQueryStatement parent, Platform pf, ClassDescriptor cld, Query query, Logger logger) {
        super(parent, pf, cld, query, logger);
    }

    protected List appendListOfColumnsForSelect(ClassDescriptor cld, StringBuffer buf) {
        FieldDescriptor[] fieldDescriptors = cld.getRepository().getFieldDescriptorsForMultiMappedTable(cld);
        int fieldDescriptorLength = fieldDescriptors.length;
        ArrayList<String> columnList = new ArrayList<String>();
        int i = 0;
        if (fieldDescriptors != null) {
            FieldDescriptor field = null;
            for (int j = 0; j < fieldDescriptorLength; ++j) {
                field = fieldDescriptors[j];
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.getSearchTable().alias);
                buf.append(".");
                buf.append(field.getColumnName());
                columnList.add(field.getAttributeName());
                ++i;
            }
        }
        return columnList;
    }

    protected List appendListOfColumns(String[] columns, StringBuffer buf) {
        ArrayList<String> columnList = new ArrayList<String>();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            this.appendColName(columns[i], false, null, buf);
            columnList.add(columns[i]);
        }
        return columnList;
    }

    public String getStatement() {
        StringBuffer stmt = new StringBuffer(1024);
        QueryByCriteria query = this.getQuery();
        boolean first = true;
        List orderByFields = null;
        int[] orderByColumnNumbers = null;
        String[] attributes = null;
        String[] joinAttributes = null;
        Iterator it = this.getJoinTreeToCriteria().entrySet().iterator();
        if (query instanceof ReportQuery) {
            attributes = ((ReportQuery)((Object)query)).getAttributes();
            joinAttributes = ((ReportQuery)((Object)query)).getJoinAttributes();
        }
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Criteria whereCrit = (Criteria)entry.getValue();
            Criteria havingCrit = query.getHavingCriteria();
            StringBuffer where = new StringBuffer();
            StringBuffer having = new StringBuffer();
            List groupByFields = null;
            this.setRoot((SqlQueryStatement.TableAlias)entry.getKey());
            if (whereCrit != null && whereCrit.isEmpty()) {
                whereCrit = null;
            }
            if (havingCrit != null && havingCrit.isEmpty()) {
                havingCrit = null;
            }
            if (first) {
                first = false;
            } else {
                stmt.append(" UNION ");
            }
            stmt.append("SELECT ");
            if (query.isDistinct()) {
                stmt.append("DISTINCT ");
            }
            List columnList = attributes == null || attributes.length == 0 ? this.appendListOfColumnsForSelect(this.getSearchClassDescriptor(), stmt) : this.appendListOfColumns(attributes, stmt);
            if (joinAttributes != null && joinAttributes.length > 0) {
                for (int i = 0; i < joinAttributes.length; ++i) {
                    this.getAttributeInfo(joinAttributes[i], false, null, this.getQuery().getPathClasses());
                }
            }
            if ((groupByFields = query.getGroupBy()) != null && !groupByFields.isEmpty()) {
                this.ensureColumns(groupByFields, columnList, stmt);
            }
            if ((orderByFields = query.getOrderBy()) != null && !orderByFields.isEmpty()) {
                orderByColumnNumbers = this.ensureColumns(orderByFields, columnList, stmt);
            }
            ClassDescriptor cld = super.getBaseClassDescriptor();
            ClassDescriptor cldSuper = null;
            if (cld.getSuperClass() != null) {
                cldSuper = cld.getRepository().getDescriptorFor(cld.getSuperClass());
                this.appendSuperClassColumns(cld, cldSuper, stmt);
            }
            stmt.append(" FROM ");
            this.appendTableWithJoins(this.getRoot(), where, stmt);
            if (cld.getSuperClass() != null) {
                this.appendSuperClassJoin(cld, cldSuper, stmt, where);
            }
            this.appendWhereClause(where, whereCrit, stmt);
            this.appendGroupByClause(groupByFields, stmt);
            this.appendHavingClause(having, havingCrit, stmt);
        }
        this.appendOrderByClause(orderByFields, orderByColumnNumbers, stmt);
        return stmt.toString();
    }

    private void appendSuperClassJoin(ClassDescriptor cld, ClassDescriptor cldSuper, StringBuffer stmt, StringBuffer where) {
        stmt.append(",").append(cldSuper.getFullTableName());
        if (where != null && where.length() > 0) {
            where.append(" AND ");
        }
        int superFieldRef = cld.getSuperClassFieldRef();
        FieldDescriptor refField = cld.getFieldDescriptorByIndex(superFieldRef);
        where.append(cldSuper.getFullTableName()).append(".").append(cldSuper.getAutoIncrementFields()[0].getColumnName());
        where.append(" = ");
        where.append(cld.getFullTableName()).append(".").append(refField.getColumnName());
    }

    private void appendSuperClassColumns(ClassDescriptor cldSub, ClassDescriptor cldSuper, StringBuffer buf) {
        FieldDescriptor[] fields = cldSuper.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor field = fields[i];
            if (i > 0) {
                buf.append(",");
            }
            buf.append(cldSuper.getFullTableName());
            buf.append(".");
            buf.append(field.getColumnName());
        }
    }
}

