/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.Properties;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.CacheDistributor;
import org.apache.ojb.broker.cache.CacheFilter;
import org.apache.ojb.broker.cache.CacheFilterRegistry;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.factory.ConfigurableFactory;

public class ObjectCacheFactory
extends ConfigurableFactory {
    private static ObjectCacheFactory singleton = new ObjectCacheFactory();
    static /* synthetic */ Class class$org$apache$ojb$broker$PersistenceBroker;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCache;

    public static ObjectCacheFactory getInstance() {
        return singleton;
    }

    public ObjectCache createObjectCache(PersistenceBroker broker) {
        ObjectCache objectCache;
        ObjectCache defaultCache = null;
        try {
            this.getLogger().info("Start creating new ObjectCache instance");
            objectCache = defaultCache = (ObjectCache)this.createNewInstance(new Class[]{class$org$apache$ojb$broker$PersistenceBroker == null ? (class$org$apache$ojb$broker$PersistenceBroker = ObjectCacheFactory.class$("org.apache.ojb.broker.PersistenceBroker")) : class$org$apache$ojb$broker$PersistenceBroker, class$java$util$Properties == null ? (class$java$util$Properties = ObjectCacheFactory.class$("java.util.Properties")) : class$java$util$Properties}, new Object[]{broker, null});
            this.getLogger().info("Default ObjectCache class was " + objectCache.getClass().getName());
            objectCache = new CacheDistributor(broker, objectCache);
            this.getLogger().info("Instantiate new " + objectCache.getClass().getName() + " class object");
            if (this.useCacheFilter()) {
                this.getLogger().info("Enable CacheFilters");
                CacheFilterRegistry filterCache = new CacheFilterRegistry(objectCache);
                String[] filters = this.getFiltersFromConfiguration();
                for (int i = 0; i < filters.length; ++i) {
                    this.getLogger().info("Create CacheFilter: " + (filters[i] != null ? filters[i].getClass().getName() : null));
                    filterCache.addCacheFilter((CacheFilter)ClassHelper.newInstance(filters[i], new Class[]{class$org$apache$ojb$broker$PersistenceBroker == null ? ObjectCacheFactory.class$("org.apache.ojb.broker.PersistenceBroker") : class$org$apache$ojb$broker$PersistenceBroker, class$org$apache$ojb$broker$cache$ObjectCache == null ? ObjectCacheFactory.class$("org.apache.ojb.broker.cache.ObjectCache") : class$org$apache$ojb$broker$cache$ObjectCache}, new Object[]{broker, objectCache}));
                }
                objectCache = filterCache;
            }
            this.getLogger().debug("Object cache created, using cache:" + objectCache);
        }
        catch (Exception e) {
            this.getLogger().error("Error while ObjectCache initiation, please check your configuration files and the used implementation class - use default cache " + defaultCache + "instead", e);
            objectCache = defaultCache;
        }
        this.getLogger().info("New ObjectCache instance was created");
        return objectCache;
    }

    protected String getConfigurationKey() {
        return "ObjectCacheClass";
    }

    private boolean useCacheFilter() {
        return this.getFiltersFromConfiguration() != null;
    }

    private String[] getFiltersFromConfiguration() {
        return ((PersistenceBrokerConfiguration)((Object)OjbConfigurator.getInstance().getConfigurationFor(null))).getCacheFilters();
    }

    protected ObjectCache createNewCacheInstance(Class target, PersistenceBroker broker, Properties prop) throws Exception {
        ObjectCache newCache = null;
        try {
            newCache = (ObjectCache)ClassHelper.newInstance(target, new Class[]{class$org$apache$ojb$broker$PersistenceBroker == null ? (class$org$apache$ojb$broker$PersistenceBroker = ObjectCacheFactory.class$("org.apache.ojb.broker.PersistenceBroker")) : class$org$apache$ojb$broker$PersistenceBroker, class$java$util$Properties == null ? (class$java$util$Properties = ObjectCacheFactory.class$("java.util.Properties")) : class$java$util$Properties}, new Object[]{broker, prop});
        }
        catch (Exception e) {
            this.getLogger().error("Can not create ObjectCache instance using class " + target, e);
            throw e;
        }
        return newCache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

