/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;

public final class ArgumentDescriptor
extends DescriptorBase
implements XmlCapable,
Serializable {
    private static final long serialVersionUID = 5205304260023247711L;
    private static final int SOURCE_NULL = 0;
    private static final int SOURCE_FIELD = 1;
    private static final int SOURCE_VALUE = 2;
    private int fieldSource = 0;
    private String constantValue = null;
    private String fieldRefName = null;
    private boolean returnedByProcedure = false;
    private ProcedureDescriptor procedureDescriptor;

    public ArgumentDescriptor(ProcedureDescriptor procedureDescriptor) {
        this.procedureDescriptor = procedureDescriptor;
        this.setValue();
    }

    public void setValue() {
        this.fieldSource = 0;
        this.fieldRefName = null;
        this.returnedByProcedure = false;
        this.constantValue = null;
    }

    public void setValue(String fieldRefName, boolean returnedByProcedure) {
        this.fieldSource = 1;
        this.fieldRefName = fieldRefName;
        this.returnedByProcedure = returnedByProcedure;
        this.constantValue = null;
        if (this.getFieldRef() == null) {
            this.returnedByProcedure = false;
        }
        if (this.getFieldRef() == null) {
            this.returnedByProcedure = false;
        }
    }

    public void setValue(String constantValue) {
        this.fieldSource = 2;
        this.fieldRefName = null;
        this.returnedByProcedure = false;
        this.constantValue = constantValue;
    }

    public boolean getIsReturnedByProcedure() {
        return this.returnedByProcedure;
    }

    public Object getValue(Object objekt) {
        switch (this.fieldSource) {
            case 1: {
                if (objekt == null) {
                    return null;
                }
                FieldDescriptor fd = this.getFieldRef();
                Object value = null;
                FieldConversion conversion = null;
                if (fd != null) {
                    conversion = fd.getFieldConversion();
                    value = fd.getPersistentField().get(objekt);
                    if (conversion != null) {
                        value = conversion.javaToSql(value);
                    }
                }
                return value;
            }
            case 2: {
                return this.constantValue;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    public void saveValue(Object objekt, Object value) {
        if (this.fieldSource == 1 && this.returnedByProcedure) {
            FieldDescriptor fd = this.getFieldRef();
            FieldConversion conversion = null;
            if (fd != null) {
                conversion = fd.getFieldConversion();
                if (conversion == null) {
                    fd.getPersistentField().set(objekt, value);
                } else {
                    fd.getPersistentField().set(objekt, conversion.sqlToJava(value));
                }
            }
        }
    }

    public final FieldDescriptor getFieldRef() {
        if (this.fieldSource == 1) {
            return this.getProcedureDescriptor().getClassDescriptor().getFieldDescriptorByName(this.fieldRefName);
        }
        return null;
    }

    public final int getJdbcType() {
        switch (this.fieldSource) {
            case 1: {
                return this.getFieldRef().getJdbcType().getType();
            }
            case 0: {
                return 0;
            }
            case 2: {
                return 12;
            }
        }
        return 0;
    }

    public final ProcedureDescriptor getProcedureDescriptor() {
        return this.procedureDescriptor;
    }

    public String toXML() {
        String eol = System.getProperty("line.separator");
        RepositoryTags tags = RepositoryTags.getInstance();
        String result = "     ";
        switch (this.fieldSource) {
            case 1: {
                result = result + " " + tags.getOpeningTagNonClosingById(107);
                result = result + " " + tags.getAttribute(84, this.fieldRefName);
                result = result + " " + tags.getAttribute(111, String.valueOf(this.returnedByProcedure));
                result = result + "/>";
                break;
            }
            case 2: {
                result = result + " " + tags.getOpeningTagNonClosingById(106);
                result = result + " " + tags.getAttribute(112, this.constantValue);
                result = result + "/>";
                break;
            }
            case 0: {
                result = result + " " + tags.getOpeningTagNonClosingById(107);
                result = result + "/>";
                break;
            }
        }
        return result + eol;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        switch (this.fieldSource) {
            case 1: {
                buf.append("fieldRefName", (Object)this.fieldRefName);
                buf.append("returnedByProcedure", this.returnedByProcedure);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                buf.append("constantValue", (Object)this.constantValue);
            }
        }
        return buf.toString();
    }
}

