/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.metadata.AttributeContainer;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;

public class ObjectCacheDescriptor
implements Serializable,
XmlCapable,
AttributeContainer {
    private static final long serialVersionUID = 2583853027407750053L;
    private Class objectCache;
    private Properties configurationProperties;

    public ObjectCacheDescriptor() {
        this.configurationProperties = new Properties();
    }

    public ObjectCacheDescriptor(Class objectCacheClass) {
        this.objectCache = objectCacheClass;
    }

    public Class getObjectCache() {
        return this.objectCache;
    }

    public void setObjectCache(Class objectCache) {
        this.objectCache = objectCache;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        this.configurationProperties.setProperty(attributeName, attributeValue);
    }

    public String getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String result = this.configurationProperties.getProperty(attributeName);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        buf.append("ObjectCache", (Object)this.getObjectCache()).append("Properties", (Object)this.getConfigurationProperties());
        return buf.toString();
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer buf = new StringBuffer(1024);
        buf.append("      ");
        buf.append(tags.getOpeningTagNonClosingById(113));
        buf.append(eol);
        buf.append("         ");
        buf.append(tags.getAttribute(13, "" + this.getObjectCache() != null ? this.getObjectCache().getName() : ""));
        buf.append("      >");
        buf.append(eol);
        buf.append("         <!-- ");
        buf.append(eol);
        buf.append("         Add proprietary ObjectCache implementation properties here, using custom attributes");
        buf.append(eol);
        buf.append("         e.g. <attribute attribute-name=\"timeout\" attribute-value=\"2000\"/>");
        buf.append(eol);
        buf.append("         -->");
        buf.append(eol);
        buf.append(this.buildAttributes());
        buf.append("      ");
        buf.append(tags.getClosingTagById(113));
        buf.append(eol);
        return buf.toString();
    }

    private String buildAttributes() {
        String eol = SystemUtils.LINE_SEPARATOR;
        Properties prop = this.getConfigurationProperties();
        if (prop == null || prop.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer(1024);
        Enumeration<Object> enumeration = prop.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = prop.getProperty(key);
            buf.append("         <attribute attribute-name=\"");
            buf.append(key);
            buf.append("\" attribute-value=\"");
            buf.append(value);
            buf.append("\"/>");
            buf.append(eol);
        }
        return buf.toString();
    }
}

