/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;

public class UpdateProcedureDescriptor
extends ProcedureDescriptor
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = 1319547080310130251L;
    private boolean includeAllFields;

    public UpdateProcedureDescriptor(ClassDescriptor classDescriptor, String name, boolean includeAllFields) {
        super(classDescriptor, name);
        this.includeAllFields = includeAllFields;
        if (this.includeAllFields) {
            this.addArguments(this.getClassDescriptor().getFieldDescriptions());
        }
    }

    public boolean getIncludeAllFields() {
        return this.includeAllFields;
    }

    public final void addArgument(ArgumentDescriptor argument) {
        if (!this.getIncludeAllFields()) {
            super.addArgument(argument);
        }
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(1024);
        result.append(eol);
        result.append("   ");
        result.append(" ");
        result.append(tags.getOpeningTagNonClosingById(104));
        result.append(" ");
        result.append(tags.getAttribute(97, this.getName()));
        if (this.hasReturnValue()) {
            result.append(" ");
            result.append(tags.getAttribute(108, this.getReturnValueFieldRefName()));
        }
        result.append(" ");
        result.append(tags.getAttribute(109, String.valueOf(this.getIncludeAllFields())));
        result.append(">");
        result.append(eol);
        if (!this.getIncludeAllFields()) {
            Iterator args = this.getArguments().iterator();
            while (args.hasNext()) {
                result.append(((ArgumentDescriptor)args.next()).toXML());
            }
        }
        result.append("    ");
        result.append(tags.getClosingTagById(104));
        result.append(eol);
        return result.toString();
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        buf.append("name", (Object)this.getName());
        buf.append("includeAllFields", this.getIncludeAllFields());
        if (this.hasReturnValue()) {
            buf.append("returnFieldRefName", (Object)this.getReturnValueFieldRefName());
        }
        return buf.toString();
    }
}

