/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import org.apache.ojb.broker.platforms.BlobWrapper;
import org.apache.ojb.broker.platforms.ClobWrapper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class Oracle9iLobHandler {
    protected static Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$platforms$Oracle9iLobHandler == null ? (class$org$apache$ojb$broker$platforms$Oracle9iLobHandler = Oracle9iLobHandler.class$("org.apache.ojb.broker.platforms.Oracle9iLobHandler")) : class$org$apache$ojb$broker$platforms$Oracle9iLobHandler);
    static /* synthetic */ Class class$org$apache$ojb$broker$platforms$Oracle9iLobHandler;

    private static ClobWrapper createTempCLOB(Connection connection, ClobWrapper clob) {
        if (clob == null) {
            return null;
        }
        ClobWrapper tempClob = null;
        try {
            int bytesread;
            tempClob = ClobWrapper.createTemporary(connection, true, ClobWrapper.getDurationSessionValue());
            clob.open(ClobWrapper.getModeReadOnlyValue());
            tempClob.open(ClobWrapper.getModeReadWriteValue());
            Reader clobReader = clob.getCharacterStream();
            Writer tempClobWriter = tempClob.getCharacterOutputStream();
            char[] charbuffer = new char[clob.getBufferSize()];
            while ((bytesread = clobReader.read(charbuffer)) != -1) {
                tempClobWriter.write(charbuffer, 0, bytesread);
            }
            tempClobWriter.flush();
            tempClobWriter.close();
            clobReader.close();
            clob.close();
            tempClob.close();
        }
        catch (Exception e) {
            logger.error("Error during temporary CLOB write", e);
            Oracle9iLobHandler.freeTempLOB(tempClob, null);
        }
        return tempClob;
    }

    public static String convertCLOBtoString(Connection connection, Object nativeclob) {
        ClobWrapper temp = new ClobWrapper();
        temp.setClob(nativeclob);
        ClobWrapper clob = Oracle9iLobHandler.createTempCLOB(connection, temp);
        if (clob == null) {
            return null;
        }
        String retval = null;
        StringBuffer clobdata = new StringBuffer();
        int bytesread = 0;
        try {
            clob.open(ClobWrapper.getModeReadOnlyValue());
            Reader clobReader = clob.getCharacterStream();
            char[] charbuffer = new char[clob.getBufferSize()];
            while ((bytesread = clobReader.read(charbuffer)) != -1) {
                clobdata.append(charbuffer, 0, bytesread);
            }
            clobReader.close();
            clob.close();
            retval = clobdata.toString();
            clobdata = null;
        }
        catch (Exception e) {
            logger.error("Error during CLOB read", e);
            Oracle9iLobHandler.freeTempLOB(clob, null);
        }
        return retval;
    }

    public static Object createCLOBFromString(Connection conn, String clobData) {
        if (clobData == null) {
            return null;
        }
        ClobWrapper clob = null;
        try {
            clob = ClobWrapper.createTemporary(conn, true, ClobWrapper.getDurationSessionValue());
            if (clob != null) {
                clob.open(ClobWrapper.getModeReadWriteValue());
                clob.trim(0L);
                Writer tempClobWriter = clob.getCharacterOutputStream();
                if (tempClobWriter != null) {
                    tempClobWriter.write(clobData);
                    tempClobWriter.flush();
                    tempClobWriter.close();
                }
                clob.close();
            }
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            Oracle9iLobHandler.freeTempLOB(clob, null);
            if (t instanceof UnsatisfiedLinkError) {
                logger.error("Oracle JDBC-driver version does not match installed OCI-driver");
            } else {
                logger.error("Error during temporary CLOB write", t);
            }
        }
        catch (Exception e) {
            logger.error("Error during temporary CLOB write", e);
            Oracle9iLobHandler.freeTempLOB(clob, null);
        }
        return clob == null ? null : clob.getClob();
    }

    private static BlobWrapper createTempBLOB(Connection connection, BlobWrapper blob) {
        if (blob == null) {
            return null;
        }
        BlobWrapper tempBlob = null;
        try {
            int bytesread;
            tempBlob = BlobWrapper.createTemporary(connection, true, BlobWrapper.getDurationSessionValue());
            blob.open(BlobWrapper.getModeReadOnlyValue());
            tempBlob.open(BlobWrapper.getModeReadWriteValue());
            InputStream blobInputStream = blob.getBinaryStream();
            OutputStream tempBlobOutputStream = tempBlob.getBinaryOutputStream();
            byte[] bytebuffer = new byte[blob.getBufferSize()];
            while ((bytesread = blobInputStream.read(bytebuffer)) != -1) {
                tempBlobOutputStream.write(bytebuffer, 0, bytesread);
            }
            tempBlobOutputStream.flush();
            tempBlobOutputStream.close();
            blobInputStream.close();
            blob.close();
            tempBlob.close();
        }
        catch (Exception e) {
            logger.error("Error during temporary BLOB write", e);
            Oracle9iLobHandler.freeTempLOB(null, tempBlob);
        }
        return tempBlob;
    }

    public static byte[] convertBLOBtoByteArray(Connection connection, Object nativeblob) {
        BlobWrapper temp = new BlobWrapper();
        temp.setBlob(nativeblob);
        BlobWrapper blob = Oracle9iLobHandler.createTempBLOB(connection, temp);
        if (blob == null) {
            return null;
        }
        byte[] retval = null;
        ByteArrayOutputStream blobdata = new ByteArrayOutputStream();
        int bytesread = 0;
        try {
            blob.open(BlobWrapper.getModeReadOnlyValue());
            InputStream blobInputStream = blob.getBinaryStream();
            byte[] bytebuffer = new byte[blob.getBufferSize()];
            while ((bytesread = blobInputStream.read(bytebuffer)) != -1) {
                blobdata.write(bytebuffer, 0, bytesread);
            }
            blobInputStream.close();
            blobdata.flush();
            blobdata.close();
            blob.close();
            retval = blobdata.toByteArray();
            blobdata = null;
        }
        catch (Exception e) {
            logger.error("Error during BLOB read", e);
            Oracle9iLobHandler.freeTempLOB(null, blob);
        }
        return retval;
    }

    public static Object createBLOBFromByteArray(Connection conn, byte[] blobData) {
        if (blobData == null) {
            return null;
        }
        BlobWrapper blob = null;
        try {
            blob = BlobWrapper.createTemporary(conn, true, BlobWrapper.getDurationSessionValue());
            blob.open(BlobWrapper.getModeReadWriteValue());
            blob.trim(0L);
            OutputStream tempBlobOutputStream = blob.getBinaryOutputStream();
            tempBlobOutputStream.write(blobData);
            tempBlobOutputStream.flush();
            tempBlobOutputStream.close();
            blob.close();
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            Oracle9iLobHandler.freeTempLOB(null, blob);
            if (t instanceof UnsatisfiedLinkError) {
                logger.error("Oracle JDBC-driver version does not match installed OCI-driver");
            } else {
                logger.error("Error during temporary BLOB write", t);
            }
        }
        catch (Exception e) {
            logger.error("Error during temporary BLOB write", e);
            Oracle9iLobHandler.freeTempLOB(null, blob);
        }
        return blob == null ? null : blob.getBlob();
    }

    private static void freeTempLOB(ClobWrapper clob, BlobWrapper blob) {
        try {
            if (clob != null) {
                if (clob.isOpen()) {
                    clob.close();
                }
                clob.freeTemporary();
            }
            if (blob != null) {
                if (blob.isOpen()) {
                    blob.close();
                }
                blob.freeTemporary();
            }
        }
        catch (Exception e) {
            logger.error("Error during temporary LOB release", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

