/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.configuration.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class ConfigurationAbstractImpl
implements Configuration {
    private Logger logger = LoggerFactory.getBootLogger();
    protected String filename;
    protected Properties properties;
    private String[] trueValues = new String[]{"true", "yes", "1"};
    private String[] falseValues = new String[]{"false", "no", "0"};

    public ConfigurationAbstractImpl() {
        this.load();
    }

    public String getString(String key, String defaultValue) {
        String ret = this.properties.getProperty(key);
        if (ret == null) {
            if (defaultValue == null) {
                this.logger.info("No value for key '" + key + "'");
            } else {
                this.logger.debug("No value for key \"" + key + "\", using default \"" + defaultValue + "\".");
                this.properties.put(key, defaultValue);
            }
            ret = defaultValue;
        }
        return ret;
    }

    public String[] getStrings(String key, String defaultValue, String seperators) {
        StringTokenizer st = new StringTokenizer(this.getString(key, defaultValue), seperators);
        String[] ret = new String[st.countTokens()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = st.nextToken();
        }
        return ret;
    }

    public String[] getStrings(String key, String defaultValue) {
        return this.getStrings(key, defaultValue, ";");
    }

    public int getInteger(String key, int defaultValue) {
        int ret;
        try {
            String tmp = this.properties.getProperty(key);
            if (tmp == null) {
                this.properties.put(key, String.valueOf(defaultValue));
                this.logger.debug("No value for key \"" + key + "\", using default " + defaultValue + ".");
                return defaultValue;
            }
            ret = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            Object wrongValue = this.properties.put(key, String.valueOf(defaultValue));
            this.logger.warn("Value \"" + wrongValue + "\" is illegal for key \"" + key + "\" (should be an integer, using default value " + defaultValue + ")");
            ret = defaultValue;
        }
        return ret;
    }

    public long getLong(String key, long defaultValue) {
        long ret;
        try {
            String tmp = this.properties.getProperty(key);
            if (tmp == null) {
                this.properties.put(key, String.valueOf(defaultValue));
                this.logger.debug("No value for key \"" + key + "\", using default " + defaultValue + ".");
                return defaultValue;
            }
            ret = Long.parseLong(tmp);
        }
        catch (NumberFormatException e) {
            Object wrongValue = this.properties.put(key, String.valueOf(defaultValue));
            this.logger.warn("Value \"" + wrongValue + "\" is illegal for key \"" + key + "\" (should be an integer, using default value " + defaultValue + ")");
            ret = defaultValue;
        }
        return ret;
    }

    public byte getByte(String key, byte defaultValue) {
        byte ret;
        try {
            String tmp = this.properties.getProperty(key);
            if (tmp == null) {
                this.properties.put(key, String.valueOf(defaultValue));
                this.logger.debug("No value for key \"" + key + "\", using default " + defaultValue + ".");
                return defaultValue;
            }
            ret = Byte.parseByte(tmp);
        }
        catch (NumberFormatException e) {
            Object wrongValue = this.properties.put(key, String.valueOf(defaultValue));
            this.logger.warn("Value \"" + wrongValue + "\" is illegal for key \"" + key + "\" (should be an integer, using default value " + defaultValue + ")");
            ret = defaultValue;
        }
        return ret;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        int i;
        String tmp = this.properties.getProperty(key);
        if (tmp == null) {
            this.logger.debug("No value for key \"" + key + "\", using default " + defaultValue + ".");
            this.properties.put(key, String.valueOf(defaultValue));
            return defaultValue;
        }
        for (i = 0; i < this.trueValues.length; ++i) {
            if (!tmp.equalsIgnoreCase(this.trueValues[i])) continue;
            return true;
        }
        for (i = 0; i < this.falseValues.length; ++i) {
            if (!tmp.equalsIgnoreCase(this.falseValues[i])) continue;
            return false;
        }
        this.logger.warn("Value \"" + tmp + "\" is illegal for key \"" + key + "\" (should be a boolean, using default value " + defaultValue + ")");
        return defaultValue;
    }

    public Class getClass(String key, Class defaultValue, Class[] assignables) {
        String className = this.properties.getProperty(key);
        if (className == null) {
            if (defaultValue == null) {
                this.logger.info("No value for key '" + key + "'");
                return null;
            }
            className = defaultValue.getName();
            this.properties.put(key, className);
            this.logger.debug("No value for key \"" + key + "\", using default " + className + ".");
            return defaultValue;
        }
        Class clazz = null;
        try {
            clazz = ClassHelper.getClass(className);
        }
        catch (ClassNotFoundException e) {
            clazz = defaultValue;
            this.logger.warn("Value \"" + className + "\" is illegal for key \"" + key + "\" (should be a class, using default value " + defaultValue + ")");
        }
        for (int i = 0; i < assignables.length; ++i) {
            Class assignable = assignables[i];
            if (assignable.isAssignableFrom(clazz)) continue;
            String extendsOrImplements = assignable.isInterface() ? "implement the interface " : "extend the class ";
            this.logger.error("The specified class \"" + className + "\" does not " + extendsOrImplements + assignables[i].getName() + ", which is a requirement for the key \"" + key + "\". Using default class " + defaultValue);
            clazz = defaultValue;
        }
        return clazz;
    }

    public Class getClass(String key, Class defaultValue, Class assignable) {
        return this.getClass(key, defaultValue, new Class[]{assignable});
    }

    public Class getClass(String key, Class defaultValue) {
        return this.getClass(key, defaultValue, new Class[0]);
    }

    protected void load() {
        this.properties = new Properties();
        String filename = this.getFilename();
        try {
            URL url = ClassHelper.getResource(filename);
            if (url == null) {
                url = new File(filename).toURL();
            }
            this.logger.info("Loading OJB's properties from file " + url);
            InputStream strIn = url.openStream();
            this.properties.load(strIn);
            strIn.close();
        }
        catch (FileNotFoundException ex) {
            if (filename == null || filename.length() == 0) {
                this.logger.info("Starting OJB without a properties file. OJB is using default settings instead.");
            } else {
                this.logger.warn("Could not load properties file '" + filename + "'. Using default settings!", ex);
            }
        }
        catch (Exception ex) {
            throw new MetadataException("An error happend while loading the properties file '" + filename + "'", ex);
        }
    }

    private String getFilename() {
        if (this.filename == null) {
            this.filename = this.getClass().getName() + ".properties";
        }
        return this.filename;
    }

    protected void setFilename(String name) {
        this.filename = name;
    }

    public void setLogger(Logger loggerInstance) {
        this.logger = loggerInstance;
    }
}

